/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml.attributes;

import com.tridium.saml.SAMLConfigurationException;
import com.tridium.saml.SAMLException;
import com.tridium.saml.attributes.BISAMLUserPropertyInfo;
import com.tridium.saml.attributes.BSAMLExpirationInfo;
import com.tridium.saml.attributes.BSAMLUserProperty;
import com.tridium.saml.attributes.BSAMLUserPropertyType;
import com.tridium.saml.authnScheme.BSAMLAuthenticationScheme;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperty(name="info", type="BSAMLExpirationInfo", defaultValue="new BSAMLExpirationInfo()")
public class BSAMLExpirationUserProperty
extends BSAMLUserProperty {
    @Generated
    public static final Property info = BSAMLExpirationUserProperty.newProperty((int)0, (BValue)new BSAMLExpirationInfo(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSAMLExpirationUserProperty.class);
    private static final String INCORRECT_ATTR_FORMAT = "saml.exception.incorrectExpirationFormat";

    @Generated
    public BSAMLExpirationInfo getInfo() {
        return (BSAMLExpirationInfo)this.get(info);
    }

    @Generated
    public void setInfo(BSAMLExpirationInfo v) {
        this.set(info, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public Optional<BISAMLUserPropertyInfo> getAttributeInfo() {
        return Optional.of(this.getInfo());
    }

    @Override
    public void setAttributeInfo(BISAMLUserPropertyInfo info) {
        if (!(info instanceof BSAMLExpirationInfo)) {
            throw new IllegalArgumentException("Argument 'info' must be of type BSAMLExpirationInfo");
        }
        this.getInfo().setFormat(((BSAMLExpirationInfo)info).getFormat());
        this.getInfo().setZone(((BSAMLExpirationInfo)info).getZone());
    }

    @Override
    public BSAMLUserPropertyType getUserPropertyType() {
        return BSAMLUserPropertyType.expiration;
    }

    @Override
    public void setUserPropertyType(BSAMLUserPropertyType v) {
    }

    @Override
    public BValue makeBValueFromAttribute(List<String> attributeValues, BSAMLAuthenticationScheme samlScheme) throws SAMLException {
        try {
            SimpleDateFormat format = new SimpleDateFormat(this.getInfo().getFormat());
            format.setTimeZone(TimeZone.getTimeZone(this.getInfo().getZone().getId()));
            Date date = format.parse(attributeValues.get(0));
            return BAbsTime.make((long)date.getTime());
        }
        catch (ParseException e) {
            throw new SAMLConfigurationException(Lexicon.make((String)"saml").get(INCORRECT_ATTR_FORMAT), e);
        }
    }
}

