/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.edgeIo.ui.point;

import com.tridium.driver.util.DrUtil;
import com.tridium.edgeIo.datatypes.BEdgeIoPointDiscoverParams;
import com.tridium.edgeIo.point.BEdgeIoPointDeviceExt;
import com.tridium.edgeIo.point.BEdgeIoProxyExt;
import com.tridium.edgeIo.ui.point.EdgeIoPointLearn;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.data.BIDataValue;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.units.BUnit;
import javax.baja.util.BUnrestrictedFolder;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"edgeIo:EdgeIoPointDeviceExt", "edgeIo:EdgeIoPointFolder"})})
public class BEdgeIoPointManager
extends BPointManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BEdgeIoPointManager.class);
    public static BWbEditor facEditor = null;
    public static BWbEditor dfEditor = null;
    static Lexicon lex = Lexicon.make(BEdgeIoPointManager.class);
    private static final BString NO_VALUE = BString.make((String)"No value");
    private static final BUnit OHM = BUnit.getUnit((String)"ohm");
    private static final BUnit MILLIAMP = BUnit.getUnit((String)"milliampere");
    private static final BUnit KOHM = BUnit.getUnit((String)"kilohm");
    private static final BUnit VOLT = BUnit.getUnit((String)"volt");
    private static final BUnit CELSIUS = BUnit.getUnit((String)"celsius");
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type(3);
    MgrColumn colToString = new MgrColumn.ToString("Out", 0);
    MgrColumn colFallback = new DefaultCol("Fallback", 1);
    MgrColumn colPointLabel = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BEdgeIoProxyExt.pointLabel}, 5);
    MgrColumn colPointType = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BEdgeIoProxyExt.pointType}, 7);
    MgrColumn colPointId = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BEdgeIoProxyExt.pointId}, 7);
    MgrColumn colPointMode = new ModeCol(new Property[]{BControlPoint.proxyExt, BEdgeIoProxyExt.pointMode}, 1);
    MgrColumn colEnabled = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BEdgeIoProxyExt.enabled}, 3);
    MgrColumn colFacets = new FacetsCol(new Property[]{BControlPoint.facets}, 3);
    MgrColumn colTuning = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BEdgeIoProxyExt.tuningPolicyName}, 3);
    MgrColumn colDeviceFacets = new DevFacetsCol(new Property[]{BControlPoint.proxyExt, BEdgeIoProxyExt.deviceFacets}, 3);
    MgrColumn colConversion = new ConversionCol(new Property[]{BControlPoint.proxyExt, BEdgeIoProxyExt.conversion}, 3);
    MgrColumn colFaultCause = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BEdgeIoProxyExt.faultCause}, 0);
    MgrColumn colReadValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BEdgeIoProxyExt.readValue}, 2);
    MgrColumn colWriteValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BEdgeIoProxyExt.writeValue}, 2);
    MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colType, this.colToString, this.colFallback, this.colPointLabel, this.colPointType, this.colPointId, this.colPointMode, this.colEnabled, this.colFacets, this.colTuning, this.colDeviceFacets, this.colConversion, this.colFaultCause, this.colReadValue, this.colWriteValue};

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected void init() {
        super.init();
        this.getPointDeviceExt().lease(Integer.MAX_VALUE);
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrLearn makeLearn() {
        return new EdgeIoPointLearn((BAbstractManager)this);
    }

    protected MgrController makeController() {
        return new PointController(this){

            public CommandArtifact doDiscover(Context cx) throws Exception {
                super.doDiscover(cx);
                BEdgeIoPointManager mgr = (BEdgeIoPointManager)this.getManager();
                mgr.getLearn().setJob(BEdgeIoPointManager.this.getPointDeviceExt().discover());
                return null;
            }

            protected MgrController.IMgrCommand[] makeCommands() {
                return new MgrController.IMgrCommand[]{this.newFolder, this.allDescendants, this.edit, this.learnMode, this.discover, this.cancel, this.add, this.quickAdd, this.templateMode};
            }
        };
    }

    public void handleComponentEvent(BComponentEvent event) {
        int id = event.getId();
        switch (id) {
            case 5: {
                if (event.getSlot() != BEdgeIoPointDeviceExt.discoveredPoints) break;
                BUnrestrictedFolder fldr = (BUnrestrictedFolder)event.getValue();
                Object[] pnts = (BEdgeIoPointDiscoverParams[])fldr.getChildren(BEdgeIoPointDiscoverParams.class);
                this.getLearn().updateRoots(pnts);
            }
        }
        super.handleComponentEvent(event);
    }

    public BEdgeIoPointDeviceExt getPointDeviceExt() {
        BComponent comp = this.getTarget();
        if (!(comp instanceof BEdgeIoPointDeviceExt)) {
            comp = DrUtil.getParent((BComplex)comp, (Type)BEdgeIoPointDeviceExt.TYPE);
        }
        return (BEdgeIoPointDeviceExt)comp;
    }

    protected static BUnit getUnitsForMode(String mode) {
        BUnit dfUnit = BUnit.NULL;
        if (mode.contains("resistance")) {
            dfUnit = KOHM;
        } else if (mode.contains("voltage")) {
            dfUnit = VOLT;
        } else if (mode.contains("current")) {
            dfUnit = MILLIAMP;
        }
        return dfUnit;
    }

    public static class DefaultCol
    extends MgrColumn {
        public DefaultCol(String displayName, int flags) {
            super(displayName, flags);
        }

        public Object get(Object row) {
            BComponent c = (BComponent)row;
            if (c instanceof BNumericWritable) {
                return ((BNumericWritable)c).getFallback().newCopy(true);
            }
            if (c instanceof BBooleanWritable) {
                return ((BBooleanWritable)c).getFallback().newCopy(true);
            }
            return NO_VALUE;
        }

        public boolean isCellValid(MgrEditRow row) {
            return !this.get(row.getTarget()).equals(NO_VALUE);
        }

        public BValue load(MgrEditRow row) {
            return (BValue)this.get(row.getTarget());
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BStatusBoolean old;
            BComponent c = row.getTarget();
            if (c instanceof BNumericWritable) {
                BStatusNumeric old2 = ((BNumericWritable)c).getFallback();
                if (!old2.equivalent((Object)value)) {
                    ((BNumericWritable)c).setFallback((BStatusNumeric)value);
                }
            } else if (c instanceof BBooleanWritable && !(old = ((BBooleanWritable)c).getFallback()).equivalent((Object)value)) {
                ((BBooleanWritable)c).setFallback((BStatusBoolean)value);
            }
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) throws Exception {
            BValue val = (BValue)this.get(rows[0].getTarget());
            if (val == null) {
                return null;
            }
            for (int i = 1; i < rows.length; ++i) {
                BValue v = (BValue)this.get(rows[i].getTarget());
                if (v != null && v.getClass() == val.getClass()) continue;
                return null;
            }
            Context cx = rows[0].getManager().getCurrentContext();
            BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)val);
            editor.loadValue((BObject)val, cx);
            return editor;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            if (!(editor instanceof BWbFieldEditor)) {
                throw new Exception("editor is not instance of BWbFieldEditor");
            }
            BWbFieldEditor fe = (BWbFieldEditor)editor;
            BValue val = (BValue)fe.saveValue();
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCell(colIndex, val);
            }
        }
    }

    public class FacetsCol
    extends MgrColumn.PropPath {
        public FacetsCol(Property[] props, int flags) {
            super(props, flags);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            BWbEditor ed;
            facEditor = ed = super.toEditor(rows, colIndex, currentEditor);
            return ed;
        }
    }

    public class DevFacetsCol
    extends MgrColumn.PropPath {
        public DevFacetsCol(Property[] props, int flags) {
            super(props, flags);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            BWbEditor ed;
            dfEditor = ed = super.toEditor(rows, colIndex, currentEditor);
            return ed;
        }
    }

    public class ModeCol
    extends MgrColumn.PropPath {
        public ModeCol(Property[] props, int flags) {
            super(props, flags);
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            ModeCol.fromFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)editor, (Property[])this.props);
            for (MgrEditRow row : rows) {
                BObject modEnum = editor.getCurrentValue();
                String mode = ((BDynamicEnum)editor.getCurrentValue()).getTag();
                BUnit dfUnit = BEdgeIoPointManager.getUnitsForMode(mode);
                BFacets f = (BFacets)row.getCell(BEdgeIoPointManager.this.colDeviceFacets);
                f = BFacets.make((BFacets)f, (BFacets)BFacets.make((String)"units", (BIDataValue)dfUnit));
                row.setCell(BEdgeIoPointManager.this.colDeviceFacets, (BValue)f);
                if (dfEditor == null) continue;
                dfEditor.loadValue((BObject)f);
            }
        }
    }

    public class ConversionCol
    extends MgrColumn.PropPath {
        public ConversionCol(Property[] props, int flags) {
            super(props, flags);
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            ConversionCol.fromFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)editor, (Property[])this.props);
            for (MgrEditRow row : rows) {
                BUnit facUnit = BUnit.NULL;
                String conversion = editor.getCurrentValue().getClass().getName();
                if (conversion.contains("Thermistor")) {
                    facUnit = CELSIUS;
                } else if (conversion.contains("Shunt")) {
                    // empty if block
                }
                BFacets f = (BFacets)row.getCell(BEdgeIoPointManager.this.colFacets);
                f = BFacets.make((BFacets)f, (BFacets)BFacets.make((String)"units", (BIDataValue)facUnit));
                row.setCell(BEdgeIoPointManager.this.colFacets, (BValue)f);
                if (facEditor == null) continue;
                facEditor.loadValue((BObject)f);
            }
        }
    }

    static class Controller
    extends PointController {
        Controller(BPointManager mgr) {
            super(mgr);
        }
    }

    class Model
    extends PointModel {
        Model(BPointManager manager) {
            super(manager);
        }

        public void load(BComponent target) {
            super.load(target);
            if (!(target instanceof BEdgeIoPointDeviceExt)) {
                this.getManager().registerForComponentEvents((BComponent)BEdgeIoPointManager.this.getPointDeviceExt());
            }
        }

        protected MgrColumn[] makeColumns() {
            return BEdgeIoPointManager.this.cols;
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            return type.newInstance();
        }
    }
}

