/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.edgeIo.ui.device;

import com.tridium.edgeIo.BEdgeIoDevice;
import javax.baja.driver.BDevice;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrModel;

@NiagaraType(agent={@AgentOn(types={"edgeIo:EdgeIoNetwork"})})
public class BEdgeIoDeviceManager
extends BAbstractManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BEdgeIoDeviceManager.class);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colExts = new DeviceExtsColumn((BDevice)new BEdgeIoDevice());
    MgrColumn colStatus = new MgrColumn.Prop(BDevice.status);
    MgrColumn colEnable = new MgrColumn.Prop(BDevice.enabled, 3);
    MgrColumn colHealth = new MgrColumn.Prop(BDevice.health, 2);

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    static class Controller
    extends MgrController {
        public Controller(BAbstractManager manager) {
            super(manager);
        }

        public void updateCommands() {
            super.updateCommands();
            this.edit.setEnabled(false);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[0];
        }

        public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
            MgrColumn mgrCol = table.columnIndexToMgrColumn(col);
            if (mgrCol instanceof DeviceExtsColumn) {
                BComponent component = table.getComponentAt(row);
                BWbShell shell = table.getManager().getWbShell();
                if (shell != null) {
                    BOrd ord = BOrd.make((String)(component.getNavOrd().toString() + "/points"));
                    shell.hyperlink(new HyperlinkInfo(ord, (BInputEvent)event));
                }
            } else {
                super.cellDoubleClicked(table, event, row, col);
            }
        }
    }

    class Model
    extends MgrModel {
        Model(BAbstractManager manager) {
            super(manager);
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BEdgeIoDevice.TYPE};
        }

        public Type getBaseNewType() {
            return BEdgeIoDevice.TYPE;
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{BEdgeIoDeviceManager.this.colName, BEdgeIoDeviceManager.this.colExts, BEdgeIoDeviceManager.this.colStatus, BEdgeIoDeviceManager.this.colEnable, BEdgeIoDeviceManager.this.colHealth};
        }
    }
}

