/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet.pdf;

import com.tridium.pdf.BIPdfWidget;
import com.tridium.pdf.gx.PdfGraphics;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.WsPrinting;
import com.tridium.wiresheet.pdf.BPdfWsTitleBox;
import javax.baja.gx.BColor;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;

@NiagaraType
public class BPdfWsCanvas
extends BWidget
implements BIPdfWidget {
    @Generated
    public static final Type TYPE = Sys.loadType(BPdfWsCanvas.class);
    private BWireSheetPane ws;
    private WsPrinting wsp;
    private BPdfWsTitleBox titleBox;
    private double pagew = 0.0;
    private double pageh = 0.0;
    private double pad = 3.0;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPdfWsCanvas(BWireSheetPane ws, WsPrinting wsp, double width, double height) {
        this.ws = ws;
        this.wsp = wsp;
        this.pagew = width;
        this.pageh = height;
        this.titleBox = new BPdfWsTitleBox();
        this.add("titleBox", (BValue)this.titleBox);
    }

    public BPdfWsTitleBox getTitleBox() {
        return this.titleBox;
    }

    public void computePreferredSize() {
        this.setPreferredSize(this.pagew, this.pageh);
    }

    public void doLayout(BWidget[] kids) {
        double w = this.getWidth();
        double h = this.getHeight();
        this.titleBox.computePreferredSize();
        double bw = this.titleBox.getPreferredWidth();
        double bh = this.titleBox.getPreferredHeight();
        double bx = w - bw;
        double by = h - bh;
        this.titleBox.setBounds(bx, by, bw, bh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        g.push();
        try {
            double w = this.getWidth() - (this.pad + this.pad + 1.0);
            double h = this.getHeight() - (this.pad + this.pad + 1.0);
            if (this.wsp.showTitleBox) {
                h -= this.titleBox.getPreferredHeight();
            }
            g.translate(this.pad, this.pad);
            g.clip(0.0, 0.0, w, h);
            RectGeom r = this.ws.getCanvas().getRootGlyph().getPrintBounds();
            double ww = r.width * 10.0;
            double wh = r.height * 10.0;
            if (ww > w || wh > h) {
                double scale = Math.min(w / ww, h / wh);
                g.transform(BTransform.makeScale((double)scale, (double)scale));
            }
            this.wsp.graphics = g;
            this.wsp.wixel = 10.0;
            this.ws.getCanvas().getRootGlyph().print(this.wsp);
        }
        finally {
            ((PdfGraphics)g).tx = null;
            g.pop();
        }
        g.setBrush(BColor.black.toBrush());
        g.strokeRect(0.0, 0.0, this.getWidth() - 1.0, this.getHeight() - 1.0);
        if (this.wsp.showTitleBox) {
            super.paint(g);
        }
    }

    public void fromWidget(BWidget widget, PdfOp op) {
    }
}

