/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet.commands;

import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.LinkGlyph;
import com.tridium.wiresheet.LinkKnobGlyph;
import com.tridium.wiresheet.LinkLinkGlyph;
import com.tridium.wiresheet.RelationKnobGlyph;
import com.tridium.workbench.util.BRelateTagsPad;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelation;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbShell;

public class EditRelationTagsCommand
extends Command {
    BWireSheetPane ws;

    public EditRelationTagsCommand(BWireSheetPane ws) {
        super((BWidget)(ws.getShell() != null ? ws.getShell() : ws), UiLexicon.bajaui().module, "commands.editRelationTags");
        this.ws = ws;
    }

    public synchronized boolean isEnabled() {
        if (this.ws.selection.getRelations().length != 1) {
            return false;
        }
        return super.isEnabled();
    }

    public CommandArtifact doInvoke() throws Exception {
        LinkGlyph[] glyphs = this.ws.selection.getLinkGlyphs();
        if (glyphs.length != 1) {
            return null;
        }
        BRelation relation = null;
        BLink link = null;
        BComponent target = null;
        if (glyphs[0] instanceof LinkLinkGlyph) {
            relation = ((LinkLinkGlyph)glyphs[0]).relation;
            link = ((LinkLinkGlyph)glyphs[0]).link;
            target = glyphs[0].getTargetComponentGlyph().component;
        } else if (glyphs[0] instanceof LinkKnobGlyph) {
            link = ((LinkKnobGlyph)glyphs[0]).getLink();
        } else if (glyphs[0] instanceof RelationKnobGlyph) {
            relation = ((RelationKnobGlyph)glyphs[0]).getRelation();
        }
        BRelateTagsPad editDialog = null;
        if (link != null) {
            editDialog = new BRelateTagsPad(this.getOwner(), (BRelation)link);
        } else if (relation != null) {
            editDialog = new BRelateTagsPad(this.getOwner(), relation);
        }
        if (editDialog != null) {
            BObject result = editDialog.openInDialog(this.getOwner());
            BWbShell wbShell = BWbShell.getWbShell((BWidget)this.getOwner());
            wbShell.getRefreshCommand().invoke();
        }
        return null;
    }
}

