/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet.commands;

import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.LinkGlyph;
import com.tridium.wiresheet.LinkLinkGlyph;
import com.tridium.wiresheet.RelationKnobGlyph;
import com.tridium.workbench.util.WbUtil;
import javax.baja.nre.util.Array;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.ui.BAccelerator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;

public class DeleteRelationsCommand
extends Command {
    BWireSheetPane ws;

    public DeleteRelationsCommand(BWireSheetPane ws) {
        super((BWidget)(ws.getShell() != null ? ws.getShell() : ws), UiLexicon.bajaui().module, "commands.deleteRelations");
        this.accelerator = BAccelerator.make((String)"Ctrl+Delete");
        this.ws = ws;
    }

    public CommandArtifact doInvoke() throws Exception {
        LinkGlyph[] glyphs = this.ws.selection.getLinkGlyphs();
        if (glyphs.length == 0) {
            return null;
        }
        Array linkArray = new Array(BRelation.class);
        for (int i = 0; i < glyphs.length; ++i) {
            BRelation relation = null;
            BLink link = null;
            if (glyphs[i] instanceof LinkLinkGlyph) {
                relation = ((LinkLinkGlyph)glyphs[i]).relation;
                link = ((LinkLinkGlyph)glyphs[i]).link;
            } else if (glyphs[0] instanceof RelationKnobGlyph) {
                relation = ((RelationKnobGlyph)glyphs[0]).getRelation();
            } else if (glyphs[i] instanceof RelationKnobGlyph) {
                relation = ((RelationKnobGlyph)glyphs[i]).getRelation();
            }
            if (link != null) {
                linkArray.add((Object)link);
            } else {
                if (relation == null) continue;
                linkArray.add((Object)relation);
            }
            this.ws.grid.set(glyphs[i].getMinP(), glyphs[i].getMinQ(), glyphs[i].getMaxP(), glyphs[i].getMaxQ(), 0);
        }
        BRelation[] relations = (BRelation[])linkArray.trim();
        if (WbUtil.compositeDeletionWarning((BWidget)this.ws, (BComplex[])relations) == 2) {
            return null;
        }
        Artifact art = new Artifact(relations);
        art.redo();
        return art;
    }

    class Artifact
    implements CommandArtifact {
        BComponent[] parents;
        BRelation[] relations;
        boolean undone;

        Artifact(BRelation[] relations) {
            this.relations = relations;
        }

        public void redo() throws Exception {
            if (this.undone) {
                throw new Exception("Cannot redo delete relations command");
            }
            this.parents = new BComponent[this.relations.length];
            BComponent comp = DeleteRelationsCommand.this.ws.controller.container;
            Context tx = Transaction.start((BComponent)comp, null);
            for (int i = 0; i < this.relations.length; ++i) {
                this.parents[i] = this.relations[i].getParent().asComponent();
                this.parents[i].remove(this.relations[i].getPropertyInParent(), tx);
            }
            Transaction.end((BComponent)comp, (Context)tx);
        }

        public void undo() throws Exception {
            BComponent comp = DeleteRelationsCommand.this.ws.controller.container;
            Context tx = Transaction.start((BComponent)comp, null);
            for (int i = 0; i < this.relations.length; ++i) {
                this.parents[i].add(null, (BValue)this.relations[i], tx);
            }
            Transaction.end((BComponent)comp, (Context)tx);
            this.undone = true;
        }
    }
}

