/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet.commands;

import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.ComponentGlyph;
import javax.baja.sys.BValue;
import javax.baja.ui.BDialog;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;

public class ArrangeCommand
extends Command {
    BWireSheetPane ws;
    ComponentGlyph[] glyphs;
    int[] pOld;
    int[] qOld;
    int[] pNew;
    int[] qNew;
    Artifact artifact;

    public ArrangeCommand(BWireSheetPane ws) {
        super((BWidget)(ws.getShell() != null ? ws.getShell() : ws), UiLexicon.bajaui().module, "commands.arrange");
        this.ws = ws;
    }

    public CommandArtifact doInvoke() throws Exception {
        UiLexicon lex = UiLexicon.bajaui();
        BGridPane pane = new BGridPane(1);
        pane.setHalign(BHalign.left);
        ToggleCommandGroup group = new ToggleCommandGroup();
        BRadioButton all = new BRadioButton(group, lex.getText("arrange.all"), true);
        BRadioButton sel = new BRadioButton(group, lex.getText("arrange.selection"), true);
        pane.add(null, (BValue)all);
        pane.add(null, (BValue)sel);
        int r = BDialog.open((BWidget)this.getOwner(), (String)this.getLabel(), (Object)pane, (int)3);
        if (r != 1) {
            return null;
        }
        this.glyphs = all.isSelected() ? this.ws.controller.getAllComponentGlyphs() : this.ws.selection.getComponentGlyphs();
        this.pOld = new int[this.glyphs.length];
        this.qOld = new int[this.glyphs.length];
        this.pNew = new int[this.glyphs.length];
        this.qNew = new int[this.glyphs.length];
        int p = 1;
        int q = 1;
        int maxw = 0;
        for (int i = 0; i < this.glyphs.length; ++i) {
            ComponentGlyph g = this.glyphs[i];
            this.pOld[i] = g.p;
            this.qOld[i] = g.q;
            int w = g.ww;
            int h = g.wh;
            this.ws.grid.set(g.p, g.q, g.ww, g.wh, 0);
            if ((double)(q + h) < this.ws.getCanvas().getHeight() / (double)this.ws.grid.wixel) {
                this.pNew[i] = p;
                this.qNew[i] = q;
                maxw = Math.max(maxw, w);
            } else {
                if ((double)((p = p + maxw + 1) + 6) > this.ws.getCanvas().getWidth() / (double)this.ws.grid.wixel) {
                    p = 1;
                }
                this.pNew[i] = p;
                q = 1;
                this.qNew[i] = 1;
                maxw = w;
            }
            q += h + 1;
        }
        this.ws.grid.clearLinks();
        this.artifact = new Artifact();
        this.artifact.redo();
        return this.artifact;
    }

    void swap() {
        int[] temp = this.pOld;
        this.pOld = this.pNew;
        this.pNew = temp;
        temp = this.qOld;
        this.qOld = this.qNew;
        this.qNew = temp;
    }

    class Artifact
    implements CommandArtifact {
        Artifact() {
        }

        public void redo() throws Exception {
            for (int i = 0; i < ArrangeCommand.this.glyphs.length; ++i) {
                ComponentGlyph g = ArrangeCommand.this.glyphs[i];
                g.setWixelBounds(ArrangeCommand.this.pNew[i], ArrangeCommand.this.qNew[i], g.ww, g.wh);
            }
            ArrangeCommand.this.ws.controller.saveAnnotations(ArrangeCommand.this.glyphs);
        }

        public void undo() throws Exception {
            ArrangeCommand.this.swap();
            this.redo();
            ArrangeCommand.this.swap();
        }
    }
}

