/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.WiresheetTheme;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsOptions;
import com.tridium.wiresheet.ComponentGlyph;
import com.tridium.wiresheet.FooterBarGlyph;
import com.tridium.wiresheet.Glyph;
import com.tridium.wiresheet.LinkGlyph;
import com.tridium.wiresheet.PropertyBarGlyph;
import com.tridium.wiresheet.RelationBarGlyph;
import com.tridium.wiresheet.RelationFooterBarGlyph;
import com.tridium.wiresheet.RelationKnobBarGlyph;
import com.tridium.wiresheet.ResizeZone;
import com.tridium.wiresheet.SlotBarGlyph;
import com.tridium.wiresheet.TitleBarGlyph;
import com.tridium.wiresheet.WsPrinting;
import com.tridium.wiresheet.WsSelectedState;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelation;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Flags;
import javax.baja.sys.Knob;
import javax.baja.sys.RelationKnob;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.style.IStylable;
import javax.baja.util.BWsAnnotation;
import javax.baja.wiresheet.BWireSheet;

public class StdComponentGlyph
extends ComponentGlyph {
    private static final Comparator<LinkGlyph> LINK_ORDER = (link1, link2) -> {
        StdComponentGlyph source2;
        StdComponentGlyph source1 = link1.getSourceComponentGlyph();
        int nullComparison = StdComponentGlyph.compareWithNullChecks(source1, source2 = link2.getSourceComponentGlyph());
        if (StdComponentGlyph.validComparisonResult(nullComparison)) {
            return nullComparison;
        }
        int result = StdComponentGlyph.compareNames(source1, source2);
        if (result == 0) {
            SlotBarGlyph link2Bar;
            Slot[] slots = source1.component.getSlotsArray();
            SlotBarGlyph link1Bar = link1.getSourceSlotGlyph();
            int linkNullComparison = StdComponentGlyph.compareWithNullChecks(link1Bar, link2Bar = link2.getSourceSlotGlyph());
            if (StdComponentGlyph.validComparisonResult(linkNullComparison)) {
                return linkNullComparison;
            }
            return StdComponentGlyph.indexOf(slots, link1Bar.slot) - StdComponentGlyph.indexOf(slots, link2Bar.slot);
        }
        return result;
    };
    final TitleBarGlyph titleBar;
    final FooterBarGlyph footerBar;
    private static final int SLOT_BARS_INITIAL_CAPACITY = 21;
    private HashMap<String, SlotBarGlyph> slotBars = new HashMap(21);
    private boolean autoCalcWixelWidth = false;
    private int selectionIndex = -1;
    private static final boolean AUTO_SIZE_WIRESHEET_COMPONENTS = AccessController.doPrivileged(() -> System.getProperty("nsedona.autoSizeWiresheetComponents", "true")).equals("true");

    public StdComponentGlyph(BWireSheetPane ws, BComponent component, BWsAnnotation anno) {
        super(ws, component, anno);
        this.titleBar = new TitleBarGlyph(ws, component);
        this.add(this.titleBar);
        if (BWsOptions.make().getShowRelations()) {
            this.footerBar = new RelationFooterBarGlyph(ws, component);
            this.add(this.footerBar);
        } else {
            this.footerBar = new FooterBarGlyph(ws, component);
            this.add(this.footerBar);
        }
        Slot[] slots = this.getPotentialSlots(true);
        for (int i = 0; i < slots.length; ++i) {
            this.addSlotBar(slots[i]);
        }
        try {
            if (AUTO_SIZE_WIRESHEET_COMPONENTS) {
                this.autoCalcWixelWidth = component.getType().is(Sys.getType((String)"nsedona:SedonaComponent"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Slot[] getPotentialSlots(boolean includeLinks) {
        ArrayList<Slot> list = new ArrayList<Slot>();
        SlotCursor c = this.component.loadSlots().getSlots();
        while (c.next()) {
            BValue v;
            Slot slot = c.slot();
            if (Flags.isHidden((BComplex)this.component, (Slot)slot) || slot.isProperty() && ((v = c.get()).isComponent() && !(v instanceof BVector) || !includeLinks && v instanceof BLink)) continue;
            list.add(slot);
        }
        return list.toArray(new Slot[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlotBarGlyph addSlotBar(Slot slot) {
        HashMap<String, SlotBarGlyph> hashMap = this.slotBars;
        synchronized (hashMap) {
            SlotBarGlyph bar;
            Type type;
            String key = slot.getName();
            if (slot.isProperty() && !(type = slot.asProperty().getType()).is(BLink.TYPE) && type.is(BRelation.TYPE)) {
                key = ((BRelation)this.component.get(slot.asProperty())).getRelationId();
            }
            if ((bar = this.slotBars.get(key)) == null && (bar = SlotBarGlyph.make(this.ws, this, this.component, slot)) != null) {
                this.slotBars.put(key, bar);
                this.add(bar);
            }
            return bar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlotBarGlyph addSlotBar(RelationKnob knob) {
        HashMap<String, SlotBarGlyph> hashMap = this.slotBars;
        synchronized (hashMap) {
            String key = knob.getRelationId();
            SlotBarGlyph bar = this.slotBars.get(key);
            if (bar == null && (bar = new RelationKnobBarGlyph(this.ws, (ComponentGlyph)this, this.component, key)) != null) {
                this.slotBars.put(key, bar);
                this.add(bar);
            }
            return bar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlotBarGlyph getVisibleSlotBar(String name) {
        HashMap<String, SlotBarGlyph> hashMap = this.slotBars;
        synchronized (hashMap) {
            SlotBarGlyph bar = this.slotBars.get(name);
            if (bar != null) {
                bar.visible = true;
            }
            return bar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlotBarGlyph getVisibleRelationBar(RelationKnob rKnob) {
        HashMap<String, SlotBarGlyph> hashMap = this.slotBars;
        synchronized (hashMap) {
            String name = SlotPath.escape((String)rKnob.getRelationId());
            SlotBarGlyph bar = this.slotBars.get(name);
            if (bar == null) {
                bar = new RelationKnobBarGlyph(this.ws, (ComponentGlyph)this, this.component, name);
                this.slotBars.put(name, bar);
                this.add(bar);
            }
            if (bar != null) {
                bar.visible = true;
            }
            return bar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlotBarGlyph getVisibleRelationBar(BRelation relation, boolean isRelationKnob) {
        HashMap<String, SlotBarGlyph> hashMap = this.slotBars;
        synchronized (hashMap) {
            String name = relation.getRelationId();
            SlotBarGlyph bar = this.slotBars.get(name);
            if (bar == null) {
                bar = isRelationKnob ? new RelationKnobBarGlyph(this.ws, (ComponentGlyph)this, this.component, relation.getRelationId()) : new RelationBarGlyph(this.ws, (ComponentGlyph)this, this.component, relation.getPropertyInParent(), name);
                this.slotBars.put(name, bar);
                this.add(bar);
            }
            if (bar != null) {
                bar.visible = true;
            }
            return bar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlotBarGlyph getVisibleRelationKnobBar(BRelation relation) {
        HashMap<String, SlotBarGlyph> hashMap = this.slotBars;
        synchronized (hashMap) {
            String name = relation.getRelationId();
            SlotBarGlyph bar = this.slotBars.get(name);
            if (bar == null) {
                bar = new RelationBarGlyph(this.ws, (ComponentGlyph)this, this.component, relation.getPropertyInParentComponent(), name);
                this.slotBars.put(name, bar);
                this.add(bar);
            }
            if (bar != null) {
                bar.visible = true;
            }
            return bar;
        }
    }

    @Override
    public void loadLinks() {
        super.loadLinks();
        this.slotBars.values().stream().filter(bar -> bar instanceof PropertyBarGlyph).map(bar -> (PropertyBarGlyph)bar).filter(bar -> bar.isLink && bar.linkGlyph == null).map(bar -> (BLink)this.component.get(bar.property)).map(link -> this.ws.controller.makeLinkGlyph(this, (BLink)link)).sorted(LINK_ORDER).forEach(this.ws.controller::addLinkGlyph);
    }

    @Override
    public void loadRelations() {
        super.loadRelations();
        if (!BWsOptions.make().getShowRelations()) {
            return;
        }
        HashMap<String, SlotBarGlyph> cloneSlotBars = new HashMap<String, SlotBarGlyph>(this.slotBars);
        for (SlotBarGlyph bar : cloneSlotBars.values()) {
            if (!(bar instanceof RelationBarGlyph)) continue;
            RelationBarGlyph propBar = (RelationBarGlyph)bar;
            if (!propBar.isRelation || propBar.relationGlyph != null) continue;
            BRelation relation = (BRelation)this.component.get(propBar.property);
            for (BRelation bRelation : this.component.getComponentRelations()) {
                if (!bRelation.getRelationId().equals(relation.getRelationId())) continue;
                propBar.relationGlyph = this.ws.controller.addRelationLinkGlyph(this, bRelation);
            }
        }
    }

    @Override
    public void loadKnobs() {
        super.loadKnobs();
        for (SlotBarGlyph bar : this.slotBars.values()) {
            if (bar == null || bar.slot == null) continue;
            Knob[] knobs = this.component.getKnobs(bar.slot);
            for (int i = 0; i < knobs.length; ++i) {
                this.ws.controller.addKnobGlyph(this, knobs[i]);
            }
        }
    }

    @Override
    public void loadRelationKnobs() {
        if (!BWsOptions.make().getShowRelations()) {
            return;
        }
        RelationKnob[] rKnobs = this.component.getRelationKnobs();
        for (int i = 0; i < rKnobs.length; ++i) {
            if (rKnobs[i] == null || rKnobs[i].getRelationOrd() == null || rKnobs[i].getRelationOrd().equals((Object)BOrd.NULL)) continue;
            this.ws.controller.addRelationLinkGlyph(this, rKnobs[i]);
        }
    }

    @Override
    public void checkForSubscribe(BWireSheet view, Array<BComponent> toSub) {
        super.checkForSubscribe(view, toSub);
        for (SlotBarGlyph bar : this.slotBars.values()) {
            BComponent kid;
            if (!bar.visible || !(bar instanceof PropertyBarGlyph)) continue;
            PropertyBarGlyph pbar = (PropertyBarGlyph)bar;
            if (!pbar.isComponent || view.isRegisteredForComponentEvents(kid = (BComponent)this.component.get(pbar.property))) continue;
            toSub.add((Object)kid);
        }
    }

    @Override
    public void postSubscribe() {
        for (SlotBarGlyph bar : this.slotBars.values()) {
            if (!bar.visible || !(bar instanceof PropertyBarGlyph)) continue;
            PropertyBarGlyph pbar = (PropertyBarGlyph)bar;
            pbar.updateValueString();
        }
    }

    @Override
    public void changed(String propName) {
        super.changed(propName);
        SlotBarGlyph bar = this.slotBars.get(propName);
        if (bar instanceof PropertyBarGlyph) {
            ((PropertyBarGlyph)bar).updateValueString();
        }
    }

    @Override
    protected void doLayout(Glyph[] kids) {
        if (this.autoCalcWixelWidth) {
            this.autoCalculateWixelWidth();
        }
        int n = 2;
        this.titleBar.setWixelBounds(0, 0, this.ww, 2);
        for (int i = 2; i < kids.length; ++i) {
            SlotBarGlyph bar = (SlotBarGlyph)kids[i];
            if (!bar.visible) continue;
            bar.setWixelBounds(0, n++, this.ww, 1);
        }
        this.footerBar.setWixelBounds(0, n, this.ww, 1);
        ++n;
        if (this.p + this.ww > BWsOptions.make().getMaxWidth()) {
            this.p = BWsOptions.make().getMaxWidth() - this.ww;
        }
        if (this.q + n > BWsOptions.make().getMaxHeight()) {
            this.q = BWsOptions.make().getMaxHeight() - n;
        }
        this.setWixelBounds(this.p, this.q, this.ww, n);
    }

    @Override
    public void paint(Graphics g) {
        WiresheetTheme theme = Theme.wiresheet();
        int w = this.pw;
        int h = this.ph;
        g.setBrush(theme.glyph().getBackground((IStylable)this));
        g.fillRect(1.0, 1.0, (double)(w - 2), (double)(h - 2));
        this.paintChildren(g);
        g.setBrush(theme.glyph().getOutline((IStylable)this));
        g.strokeLine(2.0, 0.0, (double)(w - 3), 0.0);
        g.strokeLine(2.0, (double)(h - 1), (double)(w - 3), (double)(h - 1));
        g.strokeLine(0.0, 2.0, 0.0, (double)(h - 3));
        g.strokeLine((double)(w - 1), 2.0, (double)(w - 1), (double)(h - 3));
        g.strokeLine(0.0, 2.0, 2.0, 0.0);
        g.strokeLine((double)(w - 3), 0.0, (double)(w - 1), 2.0);
        g.strokeLine(0.0, (double)(h - 3), 2.0, (double)(h - 1));
        g.strokeLine((double)(w - 1), (double)(h - 3), (double)(w - 3), (double)(h - 1));
        g.strokeLine(0.0, (double)(h - this.ws.grid.wixel), (double)w, (double)(h - this.ws.grid.wixel));
    }

    @Override
    public ResizeZone getResizeAt(double x, double y) {
        int q = (int)(y / (double)this.ws.grid.wixel);
        if (this.q == q || this.q + 1 == q) {
            if (ResizeZone.onLeft(this, x, y)) {
                return new ResizeZone(this, 4);
            }
            if (ResizeZone.onRight(this, x, y)) {
                return new ResizeZone(this, 8);
            }
        }
        return null;
    }

    @Override
    public void print(WsPrinting p) {
        double w = (double)this.ww * p.wixel;
        double h = (double)this.wh * p.wixel;
        Graphics g = p.graphics;
        g.setBrush(BColor.make((int)0xEEEEEE));
        g.fillRect(0.5, 0.5, w - 1.0, h - 1.0);
        this.printChildren(p);
        g.setBrush(BColor.black.toBrush());
        g.strokeRect(0.0, 0.0, w, h);
    }

    @Override
    public BWsAnnotation toAnnotation() {
        return BWsAnnotation.make((int)this.p, (int)this.q, (int)this.ww);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoCalculateWixelWidth() {
        int newW = (int)Math.floor((this.titleBar.calcWidth() + (double)this.ws.grid.wixel / 2.0) / (double)this.ws.grid.wixel);
        HashMap<String, SlotBarGlyph> hashMap = this.slotBars;
        synchronized (hashMap) {
            for (SlotBarGlyph bar : this.slotBars.values()) {
                int sw;
                if (!bar.visible || (sw = (int)Math.floor((bar.calcWidth() + (double)this.ws.grid.wixel / 2.0) / (double)this.ws.grid.wixel)) <= newW) continue;
                newW = sw;
            }
        }
        if (newW < BWsAnnotation.DEFAULT.wixelWidth) {
            newW = BWsAnnotation.DEFAULT.wixelWidth;
        }
        this.ww = newW;
    }

    @Override
    WsSelectedState saveSelectedState() {
        return new SelectedState(this.getSelectionKey(), this.selectionIndex);
    }

    @Override
    void restoreSelectedState(WsSelectedState state) {
        if (this.selectionIndex != -1) {
            this.ws.selection.unregisterStdSelectionIndex(this.selectionIndex);
        }
        this.selectionIndex = ((SelectedState)state).selectionIndex;
        this.ws.selection.registerStdSelectionIndex(this.selectionIndex);
    }

    @Override
    void setSelected(boolean selected) {
        super.setSelected(selected);
        if (selected) {
            if (this.selectionIndex == -1) {
                this.selectionIndex = this.ws.selection.registerNewStdSelectionIndex();
            }
        } else {
            this.ws.selection.unregisterStdSelectionIndex(this.selectionIndex);
            this.selectionIndex = -1;
        }
    }

    int getSelectionIndex() {
        return this.selectionIndex;
    }

    private static int indexOf(Slot[] slots, Slot slot) {
        int len = slots.length;
        for (int i = 0; i < len; ++i) {
            if (slots[i] != slot) continue;
            return i;
        }
        return -1;
    }

    private static int compareNames(StdComponentGlyph source1, StdComponentGlyph source2) {
        String name2;
        String name1 = source1.component.getName();
        int nullComparison = StdComponentGlyph.compareWithNullChecks(name1, name2 = source2.component.getName());
        if (StdComponentGlyph.validComparisonResult(nullComparison)) {
            return nullComparison;
        }
        return name1.compareTo(name2);
    }

    private static boolean validComparisonResult(int comparisonResult) {
        return comparisonResult >= -1 && comparisonResult <= 1;
    }

    private static int compareWithNullChecks(Object object1, Object object2) {
        if (object1 == null && object2 == null) {
            return 0;
        }
        if (object1 == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        return 2;
    }

    private class SelectedState
    extends WsSelectedState {
        private int selectionIndex;

        protected SelectedState(Object key, int selectionIndex) {
            super(key);
            this.selectionIndex = selectionIndex;
        }

        @Override
        void cancelRestore() {
            if (this.selectionIndex > -1) {
                StdComponentGlyph.this.ws.selection.unregisterStdSelectionIndex(this.selectionIndex);
            }
        }
    }
}

