/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.util.LinkUtil;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.LinkGlyph;
import com.tridium.wiresheet.LinkLinkGlyph;
import com.tridium.wiresheet.SlotBarGlyph;
import com.tridium.wiresheet.StdComponentGlyph;
import com.tridium.wiresheet.WsPrinting;
import com.tridium.wiresheet.commands.DeleteLinksCommand;
import javax.baja.naming.BOrd;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelation;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;

public class LinkStubGlyph
extends LinkLinkGlyph {
    String statusMessage;
    boolean isComposite;

    protected LinkStubGlyph(BWireSheetPane ws, BLink link, StdComponentGlyph targetComp) {
        super(ws, link, targetComp);
        this.isComposite = LinkUtil.isCompositeLink((BLink)link);
    }

    @Override
    BOrd getGotoOrd() {
        return this.link.getSourceOrd();
    }

    @Override
    public void popup(double mx, double my) {
        BMenu menu = new BMenu();
        menu.add(null, (Command)new LinkGlyph.GotoLinkCommand());
        menu.add(null, (Command)new LinkGlyph.GotoCommand());
        if (!this.isComposite) {
            menu.add(null, (Command)new DeleteLinksCommand(this.ws));
        }
        int p = (int)(mx / (double)this.ws.grid.wixel);
        int q = (int)(my / (double)this.ws.grid.wixel);
        this.ws.controller.addLinkSelection(menu, p, q);
        menu.open((BWidget)this.ws.getCanvas(), mx, my);
    }

    @Override
    protected String getGotoLinkSourceHandle() {
        return this.getHandleFromOrd(this.link.getSourceOrd());
    }

    @Override
    protected String getGotoLinkSourceSlotName() {
        return this.link.getSourceSlotName();
    }

    @Override
    protected String getGotoLinkTargetHandle() {
        return this.getHandleFromOrd(this.targetComp.component.getHandleOrd());
    }

    @Override
    protected String getGotoLinkTargetSlotName() {
        return this.link.getTargetSlotName();
    }

    @Override
    public void doubleClicked(BMouseEvent event) {
        new LinkGlyph.GotoLinkCommand().invoke(new CommandEvent((BInputEvent)event));
    }

    @Override
    public StdComponentGlyph getSourceComponentGlyph() {
        return null;
    }

    @Override
    public SlotBarGlyph getSourceSlotGlyph() {
        return null;
    }

    @Override
    public String getStatusMessage() {
        if (this.statusMessage == null) {
            this.statusMessage = LinkUtil.toDisplay((BRelation)this.link) + (this.isComposite ? " (C)" : "");
        }
        return this.statusMessage;
    }

    @Override
    public void findLinks(WsPrinting p) {
        this.linkName = p.addStubLink(LinkUtil.toDisplaySource((BRelation)this.link), LinkUtil.toDisplayTarget((BRelation)this.link));
    }

    @Override
    public LinkGlyph.Tile[] buildTiles() {
        if (this.targetSlot == null) {
            System.out.println("ERROR: LinkStubGlyph.noTargetSlot: " + this.link);
            return new LinkGlyph.Tile[0];
        }
        int p = this.targetSlot.absP() - 1;
        int q = this.targetSlot.absQ();
        return new LinkGlyph.Tile[]{new LinkGlyph.Tile(p, q, 3, this.ws)};
    }
}

