/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.WiresheetTheme;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.WixelGrid;
import com.tridium.wiresheet.WsConst;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.style.IStylable;

@NiagaraType
public class BThumbnail
extends BWidget
implements WsConst {
    @Generated
    public static final Type TYPE = Sys.loadType(BThumbnail.class);
    private BImage buffer;

    @Generated
    public Type getType() {
        return TYPE;
    }

    void postLoad() {
        this.repaintBuffer();
    }

    public synchronized void repaintBuffer() {
        WixelGrid grid = this.getWireSheet().grid;
        WiresheetTheme theme = Theme.wiresheet();
        if (this.buffer != null) {
            this.buffer.dispose();
        }
        this.buffer = BImage.make((double)(this.getWireSheet().grid.getWixelWidth() + 2), (double)(this.getWireSheet().grid.getWixelHeight() + 2));
        Graphics g = this.buffer.getGraphics();
        g.setBrush(theme.thumbnail().getBackground((IStylable)this));
        g.fillRect(1.0, 1.0, (double)this.getWireSheet().grid.getWixelWidth(), (double)this.getWireSheet().grid.getWixelHeight());
        RectGeom rect = this.getWireSheet().getScrollPane().getViewport();
        int vp = (int)rect.x / this.getWireSheet().grid.wixel;
        int vq = (int)rect.y / this.getWireSheet().grid.wixel;
        int vw = (int)rect.width / this.getWireSheet().grid.wixel;
        int vh = (int)rect.height / this.getWireSheet().grid.wixel;
        g.setBrush(theme.thumbnail().getForeground((IStylable)this));
        g.fillRect((double)(1 + vp), (double)(1 + vq), (double)vw, (double)vh);
        for (int p = 0; p < this.getWireSheet().grid.getWixelWidth(); ++p) {
            for (int q = 0; q < this.getWireSheet().grid.getWixelHeight(); ++q) {
                int type = grid.get(p, q);
                if (type == 0) continue;
                BColor c = null;
                c = type == 11 ? BColor.black : (type == 12 ? BColor.gray : BColor.gray);
                if (c == null) continue;
                g.setBrush(c);
                g.fillRect((double)(p + 1), (double)(q + 1), 1.0, 1.0);
            }
        }
        g.setBrush(theme.thumbnail().getOutline((IStylable)this));
        g.strokeRect(0.0, 0.0, (double)(this.getWireSheet().grid.getWixelWidth() + 1), (double)(this.getWireSheet().grid.getWixelHeight() + 1));
        g.dispose();
    }

    public void computePreferredSize() {
        this.setPreferredSize(this.getWireSheet().grid.getWixelWidth() + 2, this.getWireSheet().grid.getWixelHeight() + 2);
    }

    public void doLayout(BWidget[] kids) {
    }

    public void paint(Graphics g) {
        if (this.buffer != null) {
            g.drawImage(this.buffer, 0.0, 0.0);
        }
    }

    public String getStyleSelector() {
        return "wire-sheet thumbnail";
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void focusGained(BFocusEvent event) {
    }

    public void focusLost(BFocusEvent event) {
    }

    public final void keyPressed(BKeyEvent event) {
        this.getWireSheet().controller.keyPressed(event);
    }

    public final void keyReleased(BKeyEvent event) {
        this.getWireSheet().controller.keyReleased(event);
    }

    public final void keyTyped(BKeyEvent event) {
        this.getWireSheet().controller.keyTyped(event);
    }

    private BMouseEvent translateMouseEvent(BMouseEvent event) {
        return new BMouseEvent(event.getId(), event.getWidget(), event.getModifiersEx(), event.getX() + this.getX() + (double)this.getWireSheet().getScrollPane().getHscrollBar().getPosition(), event.getY() + this.getY() + (double)this.getWireSheet().getScrollPane().getVscrollBar().getPosition(), event.getClickCount(), event.isPopupTrigger());
    }

    private BMouseWheelEvent translateMouseEvent(BMouseWheelEvent event) {
        return new BMouseWheelEvent(event.getId(), event.getWidget(), event.getModifiersEx(), event.getX() + this.getX() + (double)this.getWireSheet().getScrollPane().getHscrollBar().getPosition(), event.getY() + this.getY() + (double)this.getWireSheet().getScrollPane().getVscrollBar().getPosition(), event.getClickCount(), event.isPopupTrigger(), event.getWheelRotation());
    }

    public final void mousePressed(BMouseEvent event) {
        this.requestFocus();
        this.getWireSheet().controller.mousePressed(this.translateMouseEvent(event));
    }

    public final void mouseReleased(BMouseEvent event) {
        this.getWireSheet().controller.mouseReleased(this.translateMouseEvent(event));
    }

    public final void mouseEntered(BMouseEvent event) {
        this.getWireSheet().controller.mouseEntered(this.translateMouseEvent(event));
    }

    public final void mouseExited(BMouseEvent event) {
        this.getWireSheet().controller.mouseExited(this.translateMouseEvent(event));
    }

    public final void mouseMoved(BMouseEvent event) {
        this.getWireSheet().controller.mouseMoved(this.translateMouseEvent(event));
    }

    public final void mouseDragged(BMouseEvent event) {
        this.getWireSheet().controller.mouseDragged(this.translateMouseEvent(event));
    }

    public final void mousePulsed(BMouseEvent event) {
        this.getWireSheet().controller.mousePulsed(this.translateMouseEvent(event));
    }

    public final void mouseWheel(BMouseWheelEvent event) {
        this.getWireSheet().controller.mouseWheel(this.translateMouseEvent(event));
    }

    private BWireSheetPane getWireSheet() {
        return (BWireSheetPane)this.getParent();
    }
}

