/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.addons.bacnet.trend;

import com.tridiumemea.addons.bacnet.trend.BCollectionWorker;
import com.tridiumemea.addons.bacnet.trend.BCollectorBatching;
import com.tridiumemea.addons.bacnet.trend.BCollectorMetrics;
import com.tridiumemea.addons.bacnet.trend.CollectorUtil;
import com.tridiumemea.addons.bacnet.util.Log;
import com.tridiumemea.addons.bacnet.util.ParentLegal;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.driver.util.BDescriptor;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.AlreadyParentedException;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="metrics", type="BCollectorMetrics", defaultValue="new BCollectorMetrics()"), @NiagaraProperty(name="batching", type="BCollectorBatching", defaultValue="new BCollectorBatching()"), @NiagaraProperty(name="worker", type="BCollectionWorker", defaultValue="new BCollectionWorker()")})
@NiagaraActions(value={@NiagaraAction(name="collect", flags=8), @NiagaraAction(name="abort", flags=8)})
public class BRoundRobinCollector
extends BComponent {
    public static final Property metrics = BRoundRobinCollector.newProperty((int)0, (BValue)new BCollectorMetrics(), null);
    public static final Property batching = BRoundRobinCollector.newProperty((int)0, (BValue)new BCollectorBatching(), null);
    public static final Property worker = BRoundRobinCollector.newProperty((int)0, (BValue)new BCollectionWorker(), null);
    public static final Action collect = BRoundRobinCollector.newAction((int)8, null);
    public static final Action abort = BRoundRobinCollector.newAction((int)8, null);
    public static final Type TYPE = Sys.loadType(BRoundRobinCollector.class);
    private final Thread collector = new Thread(TYPE.getTypeName()){
        public boolean stopEmptyingLoop;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (BRoundRobinCollector.this.oldCollectorReference != null) {
                    log.info("Interrupting last collection attempt " + BRoundRobinCollector.this.oldCollectorReference);
                    BRoundRobinCollector.this.oldCollectorReference.interrupt();
                }
                BRoundRobinCollector.this.oldCollectorReference = this;
                this.stopEmptyingLoop = false;
                BRoundRobinCollector.this.getMetrics().updateStartTimes();
                if (BRoundRobinCollector.this.getBatching().isBatchingEnabled()) {
                    BRoundRobinCollector.this.getBatching().resetBatchCounterAndTimes(BRoundRobinCollector.this.getMetrics().getLastStartTime());
                }
                ArrayList<ArrayList<BDescriptor>> devQ = CollectorUtil.buildDescriptorArray((BDeviceNetwork)bacnetNetwork);
                BRoundRobinCollector.this.getMetrics().calculateTotalDescriptors(devQ);
                int devIdx = 0;
                boolean importsSeen = false;
                while (devIdx < devQ.size()) {
                    ArrayList<BDescriptor> currentDescriptorArray = devQ.get(devIdx);
                    if (!currentDescriptorArray.isEmpty()) {
                        BHistoryImport hist = (BHistoryImport)currentDescriptorArray.remove(currentDescriptorArray.size() - 1);
                        if (log.isLoggable(Level.FINER)) {
                            log.finer("[" + devIdx + 1 + "] Remaining Descriptors: " + currentDescriptorArray.size() + " [" + hist.getDevice().getName() + ']');
                        }
                        try {
                            CollectorUtil.importHistory(bacnetNetwork.getWorker(), hist);
                        }
                        catch (BajaRuntimeException bre) {
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "Ignoring History " + bre.getMessage(), bre);
                            }
                        }
                        finally {
                            BRoundRobinCollector.this.getMetrics().incrementCurrentIndex();
                            if (BRoundRobinCollector.this.getBatching().isBatchingEnabled()) {
                                BRoundRobinCollector.this.getBatching().executeBatchSleepLogic();
                            }
                        }
                        importsSeen = true;
                    }
                    if (++devIdx == devQ.size() && importsSeen) {
                        importsSeen = false;
                        devIdx = 0;
                        if (log.isLoggable(Level.FINER)) {
                            log.finer(" *** Return to the first device.");
                        }
                    }
                    if (!this.stopEmptyingLoop) continue;
                    log.info("Aborting history collection: stopLoop");
                    break;
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Exception whilst collecting", e);
            }
            finally {
                BRoundRobinCollector.this.getMetrics().updateEndTimes();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Round Robin collection complete (Executed " + BRoundRobinCollector.this.getMetrics().getCurrentIndex() + " of " + BRoundRobinCollector.this.getMetrics().getTargetIndex() + " in " + BRoundRobinCollector.this.getMetrics().getLastTotalDuration() + ')');
                }
                this.stopEmptyingLoop = true;
                BRoundRobinCollector.this.oldCollectorReference = null;
            }
        }

        @Override
        public void interrupt() {
            this.stopEmptyingLoop = true;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ie) {
                log.log(Level.WARNING, "Interrupted " + 1.currentThread().getName(), ie);
            }
            super.interrupt();
        }
    };
    private Thread oldCollectorReference;
    private static BBacnetNetwork bacnetNetwork;
    static final Logger log;

    public BCollectorMetrics getMetrics() {
        return (BCollectorMetrics)this.get(metrics);
    }

    public void setMetrics(BCollectorMetrics v) {
        this.set(metrics, (BValue)v, null);
    }

    public BCollectorBatching getBatching() {
        return (BCollectorBatching)this.get(batching);
    }

    public void setBatching(BCollectorBatching v) {
        this.set(batching, (BValue)v, null);
    }

    public BCollectionWorker getWorker() {
        return (BCollectionWorker)this.get(worker);
    }

    public void setWorker(BCollectionWorker v) {
        this.set(worker, (BValue)v, null);
    }

    public void collect() {
        this.invoke(collect, null, null);
    }

    public void abort() {
        this.invoke(abort, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doCollect() throws LocalizableException {
        if (this.isRunning()) {
            bacnetNetwork = (BBacnetNetwork)Sys.getService((Type)BBacnetNetwork.TYPE);
            CollectorUtil.sanityCheckNetwork(bacnetNetwork);
            this.getWorker().postAsync(this.collector);
        }
    }

    public void doAbort() throws Exception {
        this.stopped();
    }

    public void stopped() throws Exception {
        super.stopped();
        log.info("Stopping " + TYPE.getTypeName());
        if (this.oldCollectorReference != null) {
            this.oldCollectorReference.interrupt();
        }
    }

    public boolean isParentLegal(BComponent parent) {
        BComponent[] children = (BComponent[])parent.getChildren(BRoundRobinCollector.class);
        if (children.length > 0) {
            throw new AlreadyParentedException("BACnet Network already has a Collector");
        }
        return ParentLegal.is((BComplex)this, (BComplex)parent, BBacnetNetwork.TYPE);
    }

    public BIcon getIcon() {
        return BIcon.std((String)"alphabetize.png");
    }

    static {
        log = Log.child("roundRobin");
    }
}

