/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.addons.bacnet.alarmServiceFilter;

import com.tridiumemea.addons.bacnet.alarmServiceFilter.BAbstractAlarmFilter;
import java.util.logging.Level;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="allowedLevel", type="int", defaultValue="0", flags=8, facets={@Facet(name="BFacets.MIN", value="BInteger.make(0)"), @Facet(name="BFacets.MAX", value="BInteger.make(3)")})
public class BEscalationFilter
extends BAbstractAlarmFilter {
    public static final Property allowedLevel = BEscalationFilter.newProperty((int)8, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)), (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.make((int)3))));
    public static final Type TYPE = Sys.loadType(BEscalationFilter.class);
    private BString myLevel;
    private static final String[] LEVELS = new String[]{"level1", "level2", "level3"};

    public int getAllowedLevel() {
        return this.getInt(allowedLevel);
    }

    public void setAllowedLevel(int v) {
        this.setInt(allowedLevel, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void doRouteAlarm(BAlarmRecord record) {
        if (!this.getEnabled()) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.getName() + ": Triggered by record: " + record);
        }
        try {
            BString esc = (BString)record.getAlarmData().get("escalated");
            if (esc == null || esc.toString().isEmpty()) {
                if (this.getAllowedLevel() == 0) {
                    this.fireAlarm(record);
                }
            } else if (esc.equals((Object)this.myLevel)) {
                this.fireAlarm(record);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Escalation Filter", e);
        }
    }

    private void resolveAlarmFilter() {
        String result = LEVELS[this.getAllowedLevel() - 1];
        this.myLevel = BString.make((String)result);
        if (log.isLoggable(Level.FINE)) {
            log.fine("resolveAlarmFilter: " + allowedLevel + " is " + result);
        }
    }

    public void started() {
        this.resolveAlarmFilter();
    }

    public void changed(Property p, Context cx) {
        if (p.equals(allowedLevel)) {
            this.resolveAlarmFilter();
        }
    }
}

