/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.addons.bacnet;

import com.tridiumemea.addons.bacnet.util.Log;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.point.BBacnetPointDeviceExt;
import javax.baja.bacnet.point.BBacnetProxyExt;
import javax.baja.control.BControlPoint;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;

abstract class FilterUtil {
    private static final Set<Integer> FILTER_OBJECT_TYPES;

    FilterUtil() {
    }

    static BBacnetObjectIdentifier resolveBacnetObjectId(BAlarmRecord record) {
        BObject oidField = record.getAlarmFacet("objectId");
        if (!(oidField instanceof BValue)) {
            Log.log.warning("Error decoding BBacnetObjectIdentifier from " + record);
            return null;
        }
        String[] tokens = oidField.toString().split("[:_ ]");
        int objectType = BBacnetObjectType.ordinal((String)tokens[0]);
        int instanceNumber = Integer.parseInt(tokens[1]);
        if (Log.log.isLoggable(Level.FINER)) {
            Log.log.finer("Extracted objectType:" + objectType + " & instanceNumber:" + instanceNumber);
        }
        return BBacnetObjectIdentifier.make((int)objectType, (int)instanceNumber);
    }

    static BControlPoint findPoint(BBacnetPointDeviceExt points, BBacnetObjectIdentifier boi, boolean disableStrictObjectCheck) {
        boolean found;
        BControlPoint[] result = points.findPoints(boi);
        boolean bl = found = result.length > 0;
        if (found && !disableStrictObjectCheck) {
            if (Log.log.isLoggable(Level.FINEST)) {
                Log.log.finest(boi.toString() + " verifying true identity of point for: " + boi);
            }
            BBacnetObjectIdentifier foundPointBoi = ((BBacnetProxyExt)result[0].getProxyExt()).getObjectId();
            found = boi.equals((Object)foundPointBoi);
        }
        if (found && result[0] instanceof BControlPoint) {
            if (Log.log.isLoggable(Level.FINER)) {
                Log.log.finer(boi.toString() + (found ? "" : " not") + " found in this station");
            }
            return result[0];
        }
        throw new UnresolvedException("Point not found in station " + boi);
    }

    static boolean isAlarmSourceUnknown(BBacnetPointDeviceExt points, BBacnetObjectIdentifier boi, boolean filterOnError, boolean strictObjectCheck) {
        boolean alarmUnknown;
        if (boi == null) {
            alarmUnknown = !filterOnError;
        } else if (FilterUtil.isAlarmingObjectFilteredType(boi)) {
            alarmUnknown = false;
        } else {
            try {
                BControlPoint point = FilterUtil.findPoint(points, boi, strictObjectCheck);
                alarmUnknown = point == null;
            }
            catch (UnresolvedException ue) {
                alarmUnknown = true;
            }
        }
        return alarmUnknown;
    }

    static boolean isAlarmingObjectFilteredType(BBacnetObjectIdentifier boi) {
        if (!FILTER_OBJECT_TYPES.contains(boi.getObjectType())) {
            if (Log.log.isLoggable(Level.FINE)) {
                Log.log.fine("Not possible to filter or apply displayName for alarm given object type of: " + boi.toString());
            }
            return true;
        }
        return false;
    }

    static {
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(0);
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        set.add(5);
        set.add(13);
        set.add(14);
        set.add(19);
        set.add(46);
        set.add(12);
        set.add(23);
        set.add(24);
        FILTER_OBJECT_TYPES = Collections.unmodifiableSet(set);
    }
}

