/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.addons.bacnet;

import com.tridiumemea.addons.bacnet.BBacnetAlarmClassReassigner;
import com.tridiumemea.addons.bacnet.util.Log;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.bacnet.alarm.BBacnetEventProcessor;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="reassignerOrd", type="BOrd", defaultValue="BOrd.NULL", flags=261)
public class BCustomBacnetEventProcessor
extends BBacnetEventProcessor {
    public static final Property reassignerOrd = BCustomBacnetEventProcessor.newProperty((int)261, (BValue)BOrd.NULL, null);
    public static final Type TYPE = Sys.loadType(BCustomBacnetEventProcessor.class);
    private BBacnetAlarmClassReassigner reassigner;
    private static final Logger log = Log.child("interceptHook");

    public BOrd getReassignerOrd() {
        return (BOrd)this.get(reassignerOrd);
    }

    public void setReassignerOrd(BOrd v) {
        this.set(reassignerOrd, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void routeAlarm(BAlarmRecord record) {
        if (log.isLoggable(Level.FINE)) {
            String name = this.getName() != null ? this.getName() : "";
            log.fine("BacnetEventProcessor(" + name + ") PID:" + this.getProcessId() + "  --> routeAlarm:" + record);
        }
        if (this.getReassigner() == null) {
            log.warning("No re-assigner to process alarm " + record);
            BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            as.routeAlarm(record);
        } else if (log.isLoggable(Level.FINEST)) {
            log.finest("Routing alarm via re-assigner " + (Object)((Object)this.reassigner));
        }
        this.reassigner.routeAlarm(record);
    }

    private BBacnetAlarmClassReassigner getReassigner() {
        if (this.reassigner == null) {
            try {
                BObject attemptedReassigner = this.getReassignerOrd().get((BObject)this.getParentComponent());
                if (attemptedReassigner instanceof BBacnetAlarmClassReassigner) {
                    this.reassigner = (BBacnetAlarmClassReassigner)attemptedReassigner;
                }
            }
            catch (Throwable e) {
                log.log(Level.WARNING, "Error initialising cache to re-assigner with ord " + this.getReassignerOrd(), e);
                return null;
            }
        }
        return this.reassigner;
    }
}

