/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.util;

import com.tridium.nrio.util.BAbstractThermistorType;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraSingleton
public class BThermistorType3Type
extends BAbstractThermistorType {
    @Generated
    public static final BThermistorType3Type INSTANCE = new BThermistorType3Type();
    @Generated
    public static final Type TYPE = Sys.loadType(BThermistorType3Type.class);
    private static float[] ohms = new float[]{0.0f, 610.0f, 1060.0f, 1690.0f, 2320.0f, 3250.0f, 4620.0f, 6240.0f, 8197.0f, 10000.0f, 12268.0f, 15136.0f, 18787.0f, 23462.0f, 29490.0f, 37316.0f, 47549.0f, 61030.0f, 78930.0f, 100000.0f};
    private static float[] celcius = new float[]{165.0f, 110.0f, 90.0f, 75.0f, 65.0f, 55.0f, 45.0f, 37.0f, 30.0f, 25.0f, 20.0f, 15.0f, 10.0f, 5.0f, 0.0f, -5.0f, -10.0f, -15.0f, -20.0f, -25.0f};

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BThermistorType3Type() {
    }

    @Override
    public float convertValue(float resistance) {
        int band = 0;
        int count = ohms.length;
        if (resistance < ohms[0]) {
            return celcius[0];
        }
        if (resistance >= ohms[count - 1]) {
            return celcius[count - 1];
        }
        for (int i = 0; i < count - 1; ++i) {
            if (!(resistance >= ohms[i]) || !(resistance < ohms[i + 1])) continue;
            band = i;
            break;
        }
        float p1 = ohms[band];
        float p2 = ohms[band + 1];
        float v1 = celcius[band];
        float v2 = celcius[band + 1];
        return v1 - (p1 - resistance) * (v1 - v2) / (p1 - p2);
    }
}

