/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.points;

import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.nrio.BIWritable;
import com.tridium.nrio.BNrio16Module;
import com.tridium.nrio.BNrio34Module;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.components.BINrioIoStatus;
import com.tridium.nrio.enums.BUniversalInputTypeEnum;
import com.tridium.nrio.messages.NrioMessageConst;
import com.tridium.nrio.points.BNrio16ProxyExt;
import com.tridium.nrio.points.BNrioCounterInputProxyExt;
import com.tridium.nrio.points.BNrioPointDeviceExt;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BIPollable;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BEnum;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="uiType", type="BEnum", defaultValue="BUniversalInputTypeEnum.undefined")
public class BUiProxyExt
extends BNrio16ProxyExt
implements BIBasicPollable,
BIWritable,
NrioMessageConst {
    @Generated
    public static final Property uiType = BUiProxyExt.newProperty((int)0, (BValue)BUniversalInputTypeEnum.undefined, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BUiProxyExt.class);
    public static final byte[] ACTIVE_DATA = new byte[]{1};
    public static final byte[] INACTIVE_DATA = new byte[]{0};
    private int undoInstance = -1;

    @Generated
    public BEnum getUiType() {
        return (BEnum)this.get(uiType);
    }

    @Generated
    public void setUiType(BEnum v) {
        this.set(uiType, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (this.isRunning() && Sys.atSteadyState()) {
            BNrioNetwork network = (BNrioNetwork)this.getNetwork();
            BNrio16Module device = (BNrio16Module)this.getDevice();
            device.setUiConfig(this.getInstance(), this.getUiType().getOrdinal());
            int instance = this.undoInstance = this.getInstance();
            BINrioIoStatus ioStatus = (BINrioIoStatus)device.getIoStatus();
            if (device instanceof BNrio34Module && instance > 8) {
                ioStatus = (BINrioIoStatus)((BNrio34Module)device).getIo34Sec().getIoStatus();
                instance -= 8;
            }
            ioStatus.setTotalCounts(instance, 0L);
        }
    }

    @Override
    public void stopped() throws Exception {
        if (this.isRunning()) {
            BNrioNetwork network = (BNrioNetwork)this.getNetwork();
            network.getPollScheduler().unsubscribe((BIPollable)this);
        }
        super.stopped();
    }

    public void atSteadyState() {
        BNrioNetwork network = (BNrioNetwork)this.getNetwork();
        BNrio16Module device = (BNrio16Module)this.getDevice();
        device.setUiConfig(this.getInstance(), this.getUiType().getOrdinal());
        this.undoInstance = this.getInstance();
        if (!(this instanceof BNrioCounterInputProxyExt)) {
            int instance = this.undoInstance;
            BINrioIoStatus ioStatus = (BINrioIoStatus)device.getIoStatus();
            if (device instanceof BNrio34Module && instance > 8) {
                ioStatus = (BINrioIoStatus)((BNrio34Module)device).getIo34Sec().getIoStatus();
                instance -= 8;
            }
            ioStatus.setTotalCounts(instance, 0L);
        }
    }

    @Override
    public boolean requiresPointSubscription() {
        return false;
    }

    @Override
    public Type getDeviceExtType() {
        return BNrioPointDeviceExt.TYPE;
    }

    @Override
    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    public void doReadPoint() {
        this.read();
    }

    @Override
    public void readSubscribed(Context cx) throws Exception {
    }

    @Override
    public void readUnsubscribed(Context cx) throws Exception {
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (this.isRunning() && context != Context.decoding) {
            if (prop.equals(instance)) {
                BControlPoint conflictPoint = this.device().checkForProxyExtConflicts(this.getParentPoint());
                if (this.getInstance() < 1 || this.getInstance() > 8) {
                    this.readFail(this.getLexicon().getText("readFail.invalidInstanceOrData"));
                } else if (conflictPoint != null || this.getInstance() == 0 || this.getInstance() > 8) {
                    this.readFail(this.getLexicon().getText("readFail.pointInstanceConflict") + " " + conflictPoint.getName());
                    this.setInstance(this.undoInstance);
                } else {
                    this.undoInstance = this.getInstance();
                }
                this.device().setUiConfig(this.getInstance(), this.getUiType().getOrdinal());
                this.device().updateProxyValues();
            } else if (prop.equals(enabled)) {
                if (this.getEnabled()) {
                    BControlPoint conflictPoint = this.device().checkForProxyExtConflicts(this.getParentPoint());
                    if (conflictPoint != null) {
                        this.readFail(this.getLexicon().getText("readFail.pointInstanceConflict") + " " + conflictPoint.getName());
                        this.setEnabled(false);
                    } else {
                        this.device().setUiConfig(this.getInstance(), this.getUiType().getOrdinal());
                        this.readOk(this.getReadValue());
                    }
                    this.device().updateProxyValues();
                }
            } else if (prop.equals(uiType)) {
                this.device().setUiConfig(this.getInstance(), this.getUiType().getOrdinal());
            }
        }
    }

    public void poll() {
        BNrioNetwork network = this.network();
        if (network.getLog().isTraceOn()) {
            network.getLog().trace(this + ".poll()");
        }
        this.read();
    }

    private void read() {
        if (this.getParentPoint() instanceof BBooleanWritable) {
            this.readOk(this.getWriteValue());
        } else {
            BINrioIoStatus ioStatus = (BINrioIoStatus)((BNrio16Module)this.getDevice()).getIoStatus();
            if (ioStatus.getIoStatus().length() != 0) {
                this.ioValueChanged();
            } else {
                this.readReset();
            }
        }
    }

    public boolean write(Context cx) throws Exception {
        System.out.println("**** subclass should override writeData *******");
        return false;
    }

    @Override
    public void writeData(BStatusValue out) {
        System.out.println("**** subclass should override writeData *******");
    }

    public void ioValueChanged() {
        System.out.println(" ***********  subclass must override ioValueChanged method ********");
    }

    public String toString(Context cx) {
        return super.toString(cx);
    }

    private BNrio16Module device() {
        return (BNrio16Module)this.getDevice();
    }

    private BNrioNetwork network() {
        return (BNrioNetwork)this.getDevice().getNetwork();
    }

    @Override
    public boolean isBoolean() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusBoolean;
    }

    @Override
    public boolean isEnum() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusEnum;
    }
}

