/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.points;

import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.components.BIoStatus;
import com.tridium.nrio.components.BSdiValueConfig;
import com.tridium.nrio.enums.BSdiEnum;
import com.tridium.nrio.messages.NrioMessageConst;
import com.tridium.nrio.points.BNrio16PointFolder;
import com.tridium.nrio.points.BNrioProxyExt;
import java.util.logging.Logger;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BFaultAlgorithm;
import javax.baja.alarm.ext.BOffnormalAlgorithm;
import javax.baja.alarm.ext.fault.BStatusFaultAlgorithm;
import javax.baja.alarm.ext.offnormal.BBooleanChangeOfStateAlgorithm;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.conv.BReversePolarityConversion;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraAction(name="pushToPoints", flags=4)
public class BNrioPointDeviceExt
extends BPointDeviceExt
implements NrioMessageConst {
    @Generated
    public static final Action pushToPoints = BNrioPointDeviceExt.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNrioPointDeviceExt.class);
    BSdiValueConfig sdiValues;
    long lastPushToPointsTicks = 0L;
    Clock.Ticket ptpTicket = null;
    Logger ptpLog = null;

    @Generated
    public void pushToPoints() {
        this.invoke(pushToPoints, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type getDeviceType() {
        return BNrioDevice.TYPE;
    }

    public Type getProxyExtType() {
        return BNrioProxyExt.TYPE;
    }

    public Type getPointFolderType() {
        return BNrio16PointFolder.TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNrioDevice;
    }

    public void doPushToPoints() {
        long ptpDelta = Clock.ticks() - this.lastPushToPointsTicks;
        if (this.ptpLog == null) {
            this.ptpLog = Logger.getLogger(this.getNrioNetwork().getName() + '.' + this.getNrioDevice().getName() + ".ptp");
        }
        if (ptpDelta < this.getNrioNetwork().getMinPushTime()) {
            if (this.ptpTicket == null || this.ptpTicket.isExpired()) {
                this.ptpTicket = Clock.schedule((BComponent)this.asComponent(), (BRelTime)BRelTime.make((long)(this.getNrioNetwork().getMinPushTime() - ptpDelta)), (Action)pushToPoints, null);
            }
        } else {
            if (this.ptpLog == null) {
                this.ptpLog = Logger.getLogger(this.getNrioNetwork().getName() + '.' + this.getNrioDevice().getName() + ".ptp");
            }
            this.ptpLog.fine("delta: " + (Clock.ticks() - this.lastPushToPointsTicks) + " thread: " + Thread.currentThread().getName());
            this.setDynamicPoints();
            this.getNrioNetwork().setProcessedUnsolicitedMsgCount(this.getNrioNetwork().incUnsolicitedProcessedCount());
            this.lastPushToPointsTicks = Clock.ticks();
        }
    }

    public void setDynamicPoints() {
        BControlPoint[] cps = this.getPoints();
        block11: for (int i = 0; i < cps.length; ++i) {
            int value;
            BNrioProxyExt proxyExt;
            BAbstractProxyExt proxy = cps[i].getProxyExt();
            if (!(proxy instanceof BNrioProxyExt) || !(proxyExt = (BNrioProxyExt)proxy).getEnabled() || this.getDevice().getStatus().isDisabled()) continue;
            int instance = proxyExt.getInstance();
            if (cps[i] instanceof BBooleanPoint && !cps[i].isWritablePoint()) {
                if (proxyExt.getIsSdi()) {
                    value = this.getSdiValue(instance);
                    if (value < 0) {
                        proxyExt.readFail(this.getLexicon().getText("readFail.invalidInstanceOrData"));
                        continue;
                    }
                    BSdiEnum enumValue = this.getSdiEnumValue(value);
                    BStatusBoolean sbValue = (BStatusBoolean)proxyExt.getReadValue().newCopy();
                    String cutText = this.getLexicon().getText("sdi.fault.cut");
                    String shortedText = this.getLexicon().getText("sdi.fault.shorted");
                    switch (enumValue.getOrdinal()) {
                        case 3: {
                            sbValue.setValue(false);
                            sbValue.setStatus(BStatus.make((int)2, (BFacets)BFacets.make((String)cutText, (boolean)true)));
                            break;
                        }
                        case 1: {
                            sbValue.setValue(false);
                            sbValue.setStatus(BStatus.make((int)2, (BFacets)BFacets.make((String)shortedText, (boolean)true)));
                            break;
                        }
                        case 2: {
                            sbValue.setValue(false);
                            sbValue.setStatus(BStatus.ok);
                            break;
                        }
                        case 0: {
                            sbValue.setValue(true);
                            sbValue.setStatus(BStatus.ok);
                        }
                    }
                    proxyExt.readOk((BStatusValue)sbValue);
                    continue;
                }
                value = 0;
                BIoStatus ioStatus = (BIoStatus)this.getNrioDevice().getIoStatus();
                switch (instance) {
                    case 1: {
                        proxyExt.readOk((BStatusValue)new BStatusBoolean(ioStatus.getDi1()));
                        continue block11;
                    }
                    case 2: {
                        proxyExt.readOk((BStatusValue)new BStatusBoolean(ioStatus.getDi2()));
                        continue block11;
                    }
                    case 3: {
                        proxyExt.readOk((BStatusValue)new BStatusBoolean(ioStatus.getDi3()));
                        continue block11;
                    }
                    default: {
                        proxyExt.readFail(this.getLexicon().getText("readFail.invalidInstance"));
                        break;
                    }
                }
                continue;
            }
            value = this.getSdiValue(instance);
            if (value < 0 && !cps[i].isWritablePoint()) {
                proxyExt.readFail(this.getLexicon().getText("readFail.invalidInstanceOrData"));
                continue;
            }
            if (cps[i] instanceof BEnumPoint) {
                proxyExt.readOk((BStatusValue)new BStatusEnum((BEnum)this.getSdiEnumValue(value)));
                continue;
            }
            if (!(cps[i] instanceof BNumericPoint)) continue;
            proxyExt.readOk((BStatusValue)new BStatusNumeric((double)value));
        }
    }

    private BSdiEnum getSdiEnumValue(int value) {
        if (this.sdiValues == null) {
            this.sdiValues = this.getNrioNetwork().getSdiValueConfig();
        }
        return this.sdiValues.getEnumValue(value);
    }

    private int getSdiValue(int instance) {
        BIoStatus ioStatus = (BIoStatus)this.getNrioDevice().getIoStatus();
        switch (instance) {
            case 1: {
                return ioStatus.getSdi1();
            }
            case 2: {
                return ioStatus.getSdi2();
            }
            case 3: {
                return ioStatus.getSdi3();
            }
            case 4: {
                return ioStatus.getSdi4();
            }
            case 5: {
                return ioStatus.getSdi5();
            }
            case 6: {
                return ioStatus.getSdi6();
            }
            case 7: {
                return ioStatus.getSdi7();
            }
            case 8: {
                return ioStatus.getSdi8();
            }
        }
        return -1;
    }

    public BNrioDevice getNrioDevice() {
        return (BNrioDevice)this.getDevice();
    }

    public BNrioNetwork getNrioNetwork() {
        return (BNrioNetwork)this.getNetwork();
    }

    public void addRoPoint(String name, int instance, String trueText, String falseText, boolean isReverse) throws Exception {
        BBooleanWritable point = (BBooleanWritable)this.get(this.add(name, (BValue)new BBooleanWritable()));
        this.initBooleanProxyExt((BBooleanPoint)point, instance, false, false, trueText, falseText, isReverse, false, false, true, "");
        point.getFallback().setValue(false);
        point.getFallback().setStatusNull(false);
    }

    public void addDIPoint(String name, int instance, String trueText, String falseText, boolean isReverse, boolean addAlarm, boolean alarmState) throws Exception {
        BBooleanPoint point = (BBooleanPoint)this.get(this.add(name, (BValue)new BBooleanPoint()));
        this.initBooleanProxyExt(point, instance, false, false, trueText, falseText, isReverse, addAlarm, alarmState, true, "%parent.parent.parent.getDisplayName%.%parent.displayName%");
    }

    public void addSDIPoint(String name, int instance, String trueText, String falseText, boolean isReverse, boolean addAlarm, boolean alarmState) throws Exception {
        BBooleanPoint point = (BBooleanPoint)this.get(this.add(name, (BValue)new BBooleanPoint()));
        this.initBooleanProxyExt(point, instance, false, true, trueText, falseText, isReverse, addAlarm, alarmState, true, "%parent.parent.parent.getDisplayName%.%parent.displayName%");
    }

    public void initBooleanProxyExt(BBooleanPoint point, int instance, boolean isStrike, boolean isSdi, String trueText, String falseText, boolean isReverse, boolean addAlarm, boolean alarmState, boolean isEnabledOnDefault, String sourceName) {
        if (!(point.getProxyExt() instanceof BNrioProxyExt)) {
            BNrioProxyExt proxy = new BNrioProxyExt();
            proxy.setInstance(instance);
            proxy.setIsStrike(isStrike);
            proxy.setIsSdi(isSdi);
            proxy.setReadValue((BStatusValue)new BStatusBoolean());
            proxy.setWriteValue((BStatusValue)new BStatusBoolean());
            if (isReverse) {
                proxy.setConversion((BProxyConversion)BReversePolarityConversion.DEFAULT);
            }
            if (!isEnabledOnDefault) {
                proxy.setEnabled(false);
            }
            point.setProxyExt((BAbstractProxyExt)proxy);
            point.setFacets(BFacets.makeBoolean((String)trueText, (String)falseText));
        }
        if (isSdi) {
            BAlarmSourceExt faultExt = null;
            try {
                faultExt = (BAlarmSourceExt)point.get("FaultExt");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (faultExt == null) {
                faultExt = new BAlarmSourceExt();
                if (!sourceName.equals("")) {
                    faultExt.setSourceName(BFormat.make((String)sourceName));
                }
                BStatusFaultAlgorithm faultAlgo = new BStatusFaultAlgorithm();
                faultAlgo.setFaultValues(BStatus.fault);
                faultExt.setFaultAlgorithm((BFaultAlgorithm)faultAlgo);
                faultExt.setToFaultText(BFormat.make((String)this.getLexicon().getText("sdi.toFaultText")));
                faultExt.setToNormalText(BFormat.make((String)this.getLexicon().getText("sdi.toNormalText")));
                point.add("FaultExt", (BValue)faultExt);
            } else if (!(faultExt.getFaultAlgorithm() instanceof BStatusFaultAlgorithm)) {
                BStatusFaultAlgorithm faultAlgo = new BStatusFaultAlgorithm();
                faultAlgo.setFaultValues(BStatus.fault);
                faultExt.setFaultAlgorithm((BFaultAlgorithm)faultAlgo);
            }
        }
        if (addAlarm) {
            BAlarmSourceExt alarmExt = null;
            try {
                alarmExt = (BAlarmSourceExt)point.get("AlarmExt");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (alarmExt == null) {
                alarmExt = new BAlarmSourceExt();
                alarmExt.setOffnormalAlgorithm((BOffnormalAlgorithm)new BBooleanChangeOfStateAlgorithm());
                ((BBooleanChangeOfStateAlgorithm)alarmExt.getOffnormalAlgorithm()).setAlarmValue(alarmState);
                if (!sourceName.equals("")) {
                    alarmExt.setSourceName(BFormat.make((String)sourceName));
                }
                point.add("AlarmExt", (BValue)alarmExt);
            } else if (((BBooleanChangeOfStateAlgorithm)alarmExt.getOffnormalAlgorithm()).getAlarmValue() != alarmState) {
                ((BBooleanChangeOfStateAlgorithm)alarmExt.getOffnormalAlgorithm()).setAlarmValue(alarmState);
            }
        }
    }
}

