/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.messages;

import com.tridium.nrio.messages.NrioInputStream;

public class NrioDeviceIoStatus {
    protected int[] sdi = new int[8];
    protected int ciData;

    public NrioDeviceIoStatus() {
    }

    public NrioDeviceIoStatus(byte[] data) {
        this.decodeFromBytes(data);
    }

    public void decodeFromBytes(byte[] data) {
        NrioInputStream in = new NrioInputStream(data);
        for (int i = 0; i < 8; ++i) {
            this.sdi[i] = in.readSdi();
        }
        this.ciData = in.readSdi();
    }

    public int getSdi(int index) {
        if (index < 1 || index > 8) {
            return -1;
        }
        return this.sdi[index - 1];
    }

    public boolean getDi(int index) {
        if (index < 1 || index > 16) {
            return false;
        }
        return (this.ciData & 1 << index - 1) != 0;
    }
}

