/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.ext;

import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BPointExtension;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="scale", type="float", defaultValue="1.0f", facets={@Facet(value="BFacets.make(BFacets.PRECISION, BInteger.make(5))")}), @NiagaraProperty(name="offset", type="float", defaultValue="0.0f", facets={@Facet(value="BFacets.make(BFacets.PRECISION, BInteger.make(5))")}), @NiagaraProperty(name="units", type="BUnit", defaultValue="BUnit.DEFAULT"), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3)})
public class BLinearCalibrationExt
extends BPointExtension {
    @Generated
    public static final Property scale = BLinearCalibrationExt.newProperty((int)0, (float)1.0f, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)5)));
    @Generated
    public static final Property offset = BLinearCalibrationExt.newProperty((int)0, (float)0.0f, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)5)));
    @Generated
    public static final Property units = BLinearCalibrationExt.newProperty((int)0, (BValue)BUnit.DEFAULT, null);
    @Generated
    public static final Property faultCause = BLinearCalibrationExt.newProperty((int)3, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLinearCalibrationExt.class);

    @Generated
    public float getScale() {
        return this.getFloat(scale);
    }

    @Generated
    public void setScale(float v) {
        this.setFloat(scale, v, null);
    }

    @Generated
    public float getOffset() {
        return this.getFloat(offset);
    }

    @Generated
    public void setOffset(float v) {
        this.setFloat(offset, v, null);
    }

    @Generated
    public BUnit getUnits() {
        return (BUnit)this.get(units);
    }

    @Generated
    public void setUnits(BUnit v) {
        this.set(units, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BLinearCalibrationExt() {
    }

    public BLinearCalibrationExt(BUnit units) {
        this.setUnits(units);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNumericPoint;
    }

    public void changed(Property p, Context cx) {
        BControlPoint parent;
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if ((p.equals(scale) || p.equals(offset) || p.equals(units)) && (parent = this.getParentPoint()) != null) {
            this.getParentPoint().execute();
        }
    }

    public void onExecute(BStatusValue o, Context cx) {
        BStatusNumeric out = (BStatusNumeric)o;
        BUnit proxyUnit = (BUnit)this.getPointFacets().get("units", (BObject)BUnit.NULL);
        if (proxyUnit.isConvertible(this.getUnits())) {
            double value = out.getValue();
            double calval = proxyUnit.convertTo(this.getUnits(), value);
            calval = (double)this.getFloat(scale) * calval + (double)this.getFloat(offset);
            value = this.getUnits().convertTo(proxyUnit, calval);
            o.setValueValue((BValue)BDouble.make((double)value));
            this.setFaultCause("");
        } else if (proxyUnit.isNull() || this.getUnits().isNull()) {
            double value = out.getValue();
            value = (double)this.getFloat(scale) * value + (double)this.getFloat(offset);
            o.setValueValue((BValue)BDouble.make((double)value));
            this.setFaultCause("");
        } else {
            o.setStatusFault(true);
            this.setFaultCause("Units between point and extension are not convertible.");
        }
    }
}

