/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.components;

import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.enums.BNrioDeviceTypeEnum;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.PermissionException;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="address", type="int", defaultValue="0"), @NiagaraProperty(name="uid", type="BBlob", defaultValue="BBlob.DEFAULT"), @NiagaraProperty(name="deviceType", type="BNrioDeviceTypeEnum", defaultValue="BNrioDeviceTypeEnum.none"), @NiagaraProperty(name="version", type="String", defaultValue=""), @NiagaraProperty(name="usedBy", type="String", defaultValue=""), @NiagaraProperty(name="secAddr", type="String", defaultValue="")})
public class BNrioLearnDeviceEntry
extends BComponent {
    @Generated
    public static final Property address = BNrioLearnDeviceEntry.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property uid = BNrioLearnDeviceEntry.newProperty((int)0, (BValue)BBlob.DEFAULT, null);
    @Generated
    public static final Property deviceType = BNrioLearnDeviceEntry.newProperty((int)0, (BValue)BNrioDeviceTypeEnum.none, null);
    @Generated
    public static final Property version = BNrioLearnDeviceEntry.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property usedBy = BNrioLearnDeviceEntry.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property secAddr = BNrioLearnDeviceEntry.newProperty((int)0, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNrioLearnDeviceEntry.class);
    public static Lexicon lex = Lexicon.make(BNrioLearnDeviceEntry.class);
    private static final int WINK_COUNT = 20;
    private static final long WINK_CYCLE = 500L;
    private BNrioNetwork network;
    private static boolean winkActive = false;
    private int winkValue = 0;

    @Generated
    public int getAddress() {
        return this.getInt(address);
    }

    @Generated
    public void setAddress(int v) {
        this.setInt(address, v, null);
    }

    @Generated
    public BBlob getUid() {
        return (BBlob)this.get(uid);
    }

    @Generated
    public void setUid(BBlob v) {
        this.set(uid, (BValue)v, null);
    }

    @Generated
    public BNrioDeviceTypeEnum getDeviceType() {
        return (BNrioDeviceTypeEnum)this.get(deviceType);
    }

    @Generated
    public void setDeviceType(BNrioDeviceTypeEnum v) {
        this.set(deviceType, (BValue)v, null);
    }

    @Generated
    public String getVersion() {
        return this.getString(version);
    }

    @Generated
    public void setVersion(String v) {
        this.setString(version, v, null);
    }

    @Generated
    public String getUsedBy() {
        return this.getString(usedBy);
    }

    @Generated
    public void setUsedBy(String v) {
        this.setString(usedBy, v, null);
    }

    @Generated
    public String getSecAddr() {
        return this.getString(secAddr);
    }

    @Generated
    public void setSecAddr(String v) {
        this.setString(secAddr, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNrioLearnDeviceEntry(int address, BNrioDeviceTypeEnum type, byte[] uid, String version, String usedBy, int secAddr) {
        this.setAddress(address);
        this.setDeviceType(type);
        this.setUid(BBlob.make((byte[])uid));
        this.setVersion(version);
        this.setUsedBy(usedBy);
        if (secAddr > 0) {
            this.setSecAddr(Integer.toString(secAddr));
        }
    }

    public BNrioLearnDeviceEntry(int address, BNrioDeviceTypeEnum type, byte[] uid, String version, String usedBy) {
        this.setAddress(address);
        this.setDeviceType(type);
        this.setUid(BBlob.make((byte[])uid));
        this.setVersion(version);
        this.setUsedBy(usedBy);
    }

    public BNrioLearnDeviceEntry(int address, BNrioDeviceTypeEnum type, byte[] uid) {
        this.setAddress(address);
        this.setDeviceType(type);
        this.setUid(BBlob.make((byte[])uid));
    }

    public BNrioLearnDeviceEntry() {
    }

    public String getDefaultAddAddress() {
        switch (this.getDeviceType().getOrdinal()) {
            case 4: {
                return this.getDeviceType().getTag() + "_" + this.getAddress();
            }
            case 6: {
                return this.getDeviceType().getTag() + "_" + this.getAddress() + "_" + this.getSecAddr();
            }
        }
        return this.getDeviceType().getTag() + "_" + this.getAddress();
    }

    public boolean isMatchable(BComponent device) {
        if (!(device instanceof BNrioDevice)) {
            return false;
        }
        BNrioDevice dbDevice = (BNrioDevice)device;
        if (!dbDevice.getDeviceType().isMatchable(this.getDeviceType())) {
            return false;
        }
        return dbDevice.isDown() || dbDevice.getAddress() == 0;
    }

    public int getSecAddrInt() {
        String secAddr = this.getSecAddr();
        int addr = -1;
        try {
            addr = Integer.parseInt(secAddr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return addr;
    }

    public boolean isWinkActive() {
        return winkActive;
    }

    public void doWinkDevice(BNrioNetwork network, Context cx) {
        this.network = network;
        if (!winkActive) {
            RunWink winkThread = new RunWink(cx);
            this.winkValue = 1;
            winkActive = true;
            network.invoke(BNrioNetwork.enableWinking, (BValue)this, cx);
            winkThread.start();
            this.set(usedBy, (BValue)BString.make((String)lex.get("winking")), cx);
        } else {
            winkActive = false;
            network.invoke(BNrioNetwork.disableWinking, (BValue)this, cx);
            this.set(usedBy, (BValue)BString.DEFAULT, cx);
        }
    }

    @NiagaraRpc(permissions="W", transports={@Transport(type=TransportType.box)})
    public void doWinkDevice(String networkOrd, Context cx) {
        OrdTarget networkOrdTarget = BOrd.make((String)networkOrd).resolve((BObject)this, cx);
        this.doWinkDevice(networkOrdTarget, cx);
    }

    public void doWinkDevice(OrdTarget networkOrdTarget, Context cx) {
        if (!networkOrdTarget.canInvoke()) {
            throw new PermissionException("can not invoke wink");
        }
        this.doWinkDevice((BNrioNetwork)networkOrdTarget.get(), cx);
    }

    public void stopWink(Context cx) {
        if (winkActive) {
            this.network.invoke(BNrioNetwork.disableWinking, (BValue)this, cx);
        }
        winkActive = false;
        if (this.getUsedBy().equals(lex.get("winking"))) {
            this.set(usedBy, (BValue)BString.DEFAULT, cx);
        }
    }

    private class RunWink
    extends Thread {
        private final Context cx;

        private RunWink(Context cx) {
            this.cx = cx;
        }

        @Override
        public void run() {
            int count = 0;
            while (winkActive) {
                if (BNrioLearnDeviceEntry.this.winkValue == 0) {
                    BNrioLearnDeviceEntry.this.winkValue = 1;
                } else {
                    BNrioLearnDeviceEntry.this.winkValue = 0;
                }
                BNrioLearnDeviceEntry.this.network.invoke(BNrioNetwork.winkDevice, (BValue)BInteger.make((int)(BNrioLearnDeviceEntry.this.getAddress() << 8 | BNrioLearnDeviceEntry.this.winkValue)), this.cx);
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                winkActive = ++count <= 20;
            }
            BNrioLearnDeviceEntry.this.set(usedBy, (BValue)BString.DEFAULT, this.cx);
            BNrioLearnDeviceEntry.this.network.invoke(BNrioNetwork.disableWinking, (BValue)BNrioLearnDeviceEntry.this, this.cx);
        }
    }
}

