/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.intrusionSmartKey.hx.commands;

import com.tridium.hx.ErrorDialog;
import com.tridium.hx.util.HxUtils;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.ToggleCommand;
import com.tridiumx.accessDriver.enums.activity.BIntrusionStatusEnum;
import com.tridiumx.entsec.intrusion.BIntrusionService;
import com.tridiumx.entsec.intrusion.BIntrusionZone;
import com.tridiumx.entsec.intrusion.orion.BIntrusionZoneRec;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.util.Lexicon;

public class ManualOverride
extends ToggleCommand {
    private ManualOverrideDialog dialog;
    Lexicon lex = Lexicon.make(BIntrusionService.class);

    public ManualOverride(BHxView view) {
        super(view);
        this.dialog = new ManualOverrideDialog(this.lex.getText("manualOverride"), (Command)this);
    }

    public String getName(HxOp op) {
        return "manualOverride";
    }

    public BCommandEnablePolicy getEnablePolicy() {
        return BCommandEnablePolicy.always;
    }

    public boolean isSelected(HxOp op) {
        BIntrusionZone[] zones = this.getZones(op);
        return this.anyArmed(zones, op);
    }

    public boolean anyArmed(BIntrusionZone[] zones, HxOp op) {
        boolean armed = false;
        for (int i = 0; i < zones.length; ++i) {
            if (!zones[i].getZoneEnabled().getBoolean()) continue;
            return true;
        }
        return armed;
    }

    public boolean allDisarmed(BIntrusionZone[] zones, HxOp op) {
        for (int i = 0; i < zones.length; ++i) {
            if (!zones[i].getZoneEnabled().getBoolean()) continue;
            return false;
        }
        return true;
    }

    public boolean anyNotDisarmed(BIntrusionZone[] zones, HxOp op) {
        for (int i = 0; i < zones.length; ++i) {
            if (zones[i].getZoneStatus() == BIntrusionStatusEnum.disarmed) continue;
            return true;
        }
        return false;
    }

    public boolean handle(boolean selected, HxOp op) throws Exception {
        if (!this.dialog.isSubmit(op = op.mergeFacets(ErrorDialog.forceDetailsFacets))) {
            this.dialog.open(op);
            return selected;
        }
        String override = op.getFormValue("armed");
        BIntrusionZone[] zones = this.getZones(op);
        String details = "";
        boolean showSuccess = override.equals("armingTest");
        for (int i = 0; i < zones.length; ++i) {
            BIntrusionZone zone = zones[i];
            String zoneDetails = "";
            if (override.equals("arming")) {
                zoneDetails = zone.doArmZone((Context)op).toString();
            } else if (override.equals("forceArm")) {
                zoneDetails = zone.doForceArmZone((Context)op).toString();
            } else if (override.equals("forceArmWithDelay")) {
                zoneDetails = zone.doForceArmZoneWithTimeDelay((Context)op).toString();
            } else if (override.equals("disarm")) {
                zoneDetails = zone.doDisarmZone((Context)op).toString();
            } else if (override.equals("armingTest")) {
                zoneDetails = zone.doArmingTest((Context)op).toString();
            }
            if (zoneDetails.length() <= 0 || zoneDetails.equals(BIntrusionZone.FORCE_ARM_TEXT)) continue;
            if (zones.length > 1) {
                details = details + "~" + zone.getDisplayName((Context)op) + "; ";
            }
            showSuccess = false;
            details = details + zoneDetails;
        }
        if (!showSuccess) {
            details = TextUtil.replace((String)details, (String)"; ", (String)"\n");
            details = TextUtil.replace((String)details, (String)"~", (String)"\n\n");
        }
        op.addCookie("IntrusionZoneOverride", override);
        String zoneForm = "<Multiple Zones>";
        if (zones.length == 1) {
            zoneForm = zones[0].getDisplayName((Context)op);
        }
        HtmlWriter out = op.getHtmlWriter();
        if (details.length() > 0) {
            String title = "";
            String lexEntry = "";
            if (override.equals("disarm")) {
                title = this.lex.getText("disarmingFailed");
                lexEntry = "disarmingFailure";
            } else if (override.equals("forceArm") || override.equals("forceArmWithDelay")) {
                title = this.lex.getText("forceArmingFailed");
                lexEntry = "forceArmingFailure";
            } else {
                title = this.lex.getText("armingFailed");
                lexEntry = "armingFailure";
            }
            details = TextUtil.replace((String)details, (String)"; ", (String)"\n");
            details = TextUtil.replace((String)details, (String)"~", (String)"\n\n");
            new ErrorDialog(title, (Command)this, (Throwable)new Exception(this.lex.getText(lexEntry, new Object[]{zoneForm})), details).open(op);
        } else if (showSuccess) {
            new ErrorDialog.SuccessDialog(this.lex.getText("armingTestSuccess"), (Command)this, this.lex.getText("armingSuccessMessage", new Object[]{zoneForm}), null).open(op);
            return selected;
        }
        this.forceIntrusionUpdate(op);
        return this.isSelected(op);
    }

    public void forceIntrusionUpdate(HxOp op) throws Exception {
        HxUtils.forceUpdate((HxOp)op);
    }

    public BIntrusionZone[] getZones(HxOp op) {
        BObject o = op.get();
        BIntrusionZoneRec rec = (BIntrusionZoneRec)o;
        BIntrusionZone intrusionZone = (BIntrusionZone)rec.getMappedOrd().get();
        return new BIntrusionZone[]{intrusionZone};
    }

    class ManualOverrideDialog
    extends Dialog {
        public ManualOverrideDialog(String title, Command handler) {
            super(title, handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            BIntrusionZone[] zones = ManualOverride.this.getZones(op);
            HtmlWriter out = op.getHtmlWriter();
            String cookie = op.getCookie("IntrusionZoneOverride");
            if (cookie == null) {
                cookie = "";
            }
            String name = op.scope("armed");
            out.w((Object)"<table>");
            out.w((Object)"<tr><td>");
            out.w((Object)"<select name='").w((Object)name).w((Object)"' id='").w((Object)name).w((Object)"'");
            out.w((Object)">");
            if (ManualOverride.this.allDisarmed(zones, op)) {
                out.w((Object)"<option value='arming'");
                if (cookie.equals("arming")) {
                    out.w((Object)"selected");
                }
                out.w((Object)">").safe((Object)ManualOverride.this.lex.getText("armNormallyWithTimeDelay"));
                out.w((Object)"</option>");
                out.w((Object)"<option value='forceArm'");
                if (cookie.equals("forceArm")) {
                    out.w((Object)"selected");
                }
                out.w((Object)">").safe((Object)ManualOverride.this.lex.getText("forceArm"));
                out.w((Object)"</option>");
                out.w((Object)"<option value='forceArmWithDelay'");
                if (cookie.equals("forceArmWithDelay")) {
                    out.w((Object)"selected");
                }
                out.w((Object)">").safe((Object)ManualOverride.this.lex.getText("forceArmWithTimeDelay"));
                out.w((Object)"</option>");
                out.w((Object)"<option value='armingTest'");
                if (cookie.equals("armingTest")) {
                    out.w((Object)"selected");
                }
                out.w((Object)">").safe((Object)ManualOverride.this.lex.getText("armingTest"));
                out.w((Object)"</option>");
            }
            if (ManualOverride.this.anyNotDisarmed(zones, op)) {
                out.w((Object)"<option value='disarm'");
                if (cookie.equals("disarm")) {
                    out.w((Object)"selected");
                }
                out.w((Object)">").safe((Object)ManualOverride.this.lex.getText("disarm"));
                out.w((Object)"</option>");
            }
            out.w((Object)"</select>");
            out.w((Object)"</td></tr>");
            out.w((Object)"</table>");
        }
    }
}

