/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.intrusionSmartKey.hx;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.hx.ErrorDialog;
import com.tridium.nd.BNiagaraStation;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.ConfirmDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.intrusion.BIntrusionZone;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxQueryTableView;
import com.tridiumx.intrusionSmartKey.hx.commands.ManualOverride;
import javax.baja.alarm.BAlarmService;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"entsec:IntrusionZones"}, requiredPermissions="r")})
@NiagaraSingleton
public class BHxIntrusionZonesView
extends BHxQueryTableView {
    @Generated
    public static final BHxIntrusionZonesView INSTANCE = new BHxIntrusionZonesView();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxIntrusionZonesView.class);
    private SmartCommand manualOverride = new MultiManualOverride((BHxView)this);
    protected BHxQueryTableView.RenameSubjectCommand renameSubjectCommand;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxIntrusionZonesView() {
        this.registerEvent((Event)this.manualOverride);
        this.renameSubjectCommand = new BHxQueryTableView.RenameSubjectCommand((BHxView)this);
        this.registerEvent((Event)this.renameSubjectCommand);
        this.deleteCommand = new DeleteZoneCommand((BHxView)this);
        this.registerEvent((Event)this.deleteCommand);
    }

    public boolean supportsAutoRefresh(HxOp op) {
        return true;
    }

    public boolean defaultAutoRefresh(HxOp op) {
        return true;
    }

    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.addCommand, this.manualOverride, this.refreshCommand, this.columnsCommand, this.filterCommand, this.hyperlinkCommand, this.deleteCommand, this.renameSubjectCommand, this.reportCommand, this.exportCommand};
    }

    public BIntrusionZone[] getUngroupedZones(HxOp op) {
        BComplex[] subjects = (BComplex[])BHxIntrusionZonesView.getSubjects((HxOp)op);
        Array zones = new Array(BIntrusionZone.class);
        for (int i = 0; i < subjects.length; ++i) {
            BIntrusionZone zone = (BIntrusionZone)subjects[i];
            if (zone.getValidGroups().length != 0) continue;
            zones.add((Object)zone);
        }
        return (BIntrusionZone[])zones.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRemoteSupervisorZones(Object[] zones, HxOp op) throws Exception {
        StringBuffer b = new StringBuffer();
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        BNiagaraStation[] supervisors = service.getMonitorSysDefSecurity().getSecuritySupervisorStations();
        for (int i = 0; i < supervisors.length; ++i) {
            BFoxSession session = RemoteUtil.getFoxSession((BNiagaraStation)supervisors[i]);
            String interest = TYPE + ".getRemoteSupervisorZones." + BUuid.make().toString();
            try {
                session.engageNoRetry(interest);
            }
            catch (Exception e) {
                return this.getLexicon().getText("deleteZoneButSupervisorIsDown.message");
            }
            try {
                BComponent alarmService = session.getService(BAlarmService.TYPE);
                alarmService.lease(10);
                Object[] remoteZones = alarmService.getChildren(BIntrusionZone.class);
                for (int j = 0; j < remoteZones.length; ++j) {
                    BIntrusionZone remoteZone = (BIntrusionZone)remoteZones[j];
                    for (int k = 0; k < zones.length; ++k) {
                        BIntrusionZone localZone = (BIntrusionZone)zones[k];
                        if (!localZone.getName().equals(remoteZone.getName()) || remoteZone.getValidGroups().length != 0) continue;
                        if (b.length() == 0) {
                            b.append(this.getLexicon().getText("deleteZoneFromJaceDialog.message")).append("\n");
                        }
                        b.append("\n");
                        b.append(remoteZone.getDisplayName((Context)op));
                    }
                }
                continue;
            }
            finally {
                session.disengage(interest);
            }
        }
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRemoteSupervisorZones(Object[] zones, HxOp op) throws Exception {
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        BNiagaraStation[] supervisors = service.getMonitorSysDefSecurity().getSecuritySupervisorStations();
        for (int i = 0; i < supervisors.length; ++i) {
            BFoxSession session = RemoteUtil.getFoxSession((BNiagaraStation)supervisors[i]);
            String interest = TYPE + ".deleteRemoteSupervisorZones." + BUuid.make().toString();
            try {
                session.engageNoRetry(interest);
            }
            catch (Exception e) {
                session.disengage(interest);
                continue;
            }
            try {
                BComponent alarmService = session.getService(BAlarmService.TYPE);
                alarmService.lease(10);
                Object[] remoteZones = alarmService.getChildren(BIntrusionZone.class);
                for (int j = 0; j < remoteZones.length; ++j) {
                    BIntrusionZone remoteZone = (BIntrusionZone)remoteZones[j];
                    for (int k = 0; k < zones.length; ++k) {
                        BIntrusionZone localZone = (BIntrusionZone)zones[k];
                        if (!localZone.getName().equals(remoteZone.getName()) || remoteZone.getValidGroups().length != 0) continue;
                        alarmService.remove((BComplex)remoteZone);
                    }
                }
                continue;
            }
            finally {
                session.disengage(interest);
            }
        }
    }

    private class DeleteZoneDialog
    extends ConfirmDialog {
        private boolean forceOKCancel;

        public DeleteZoneDialog(String title, Command handler) {
            super(title, handler);
            this.forceOKCancel = false;
        }

        public void open(String msg, boolean forceOKCancel, HxOp op) throws Exception {
            this.forceOKCancel = forceOKCancel;
            this.openMessage = msg;
            this.open(op);
            this.openMessage = null;
            forceOKCancel = false;
        }

        public BIcon getQuestionIcon(HxOp op) {
            return BIcon.make((String)Lexicon.make((String)"smartTableHx").get("question.icon"));
        }

        public Command[] getCommands() {
            if (RemoteUtil.isSupervisor() || this.forceOKCancel) {
                return super.getCommands();
            }
            return new Command[]{new YesSubmit(), new NoGroupedDeleteSubmit(), new Dialog.Cancel((Dialog)this)};
        }

        private class NoGroupedDeleteSubmit
        extends Dialog.Submit {
            public NoGroupedDeleteSubmit() {
                super((Dialog)DeleteZoneDialog.this);
            }

            public String getDisplayName(HxOp op) {
                return Lexicon.make(((Object)((Object)this)).getClass()).getText("no");
            }

            public String getInvokeCode(HxOp op) {
                try {
                    StringBuffer b = new StringBuffer();
                    b.append(SmartCommand.getInvokeCodeForSetFormValue((String)op.scope("noGroupedDelete"), (Object)"true", (String)"&quot;", (boolean)true, (HxOp)op));
                    b.append(super.getInvokeCode(op));
                    return b.toString();
                }
                catch (Exception e) {
                    return super.getInvokeCode(op);
                }
            }
        }

        private class YesSubmit
        extends Dialog.Submit {
            public YesSubmit() {
                super((Dialog)DeleteZoneDialog.this);
            }

            public String getDisplayName(HxOp op) {
                return Lexicon.make(((Object)((Object)this)).getClass()).getText("yes");
            }
        }
    }

    public class DeleteZoneCommand
    extends BHxQueryTableView.DeleteCommand {
        private DeleteZoneDialog dialog;

        public DeleteZoneCommand(BHxView view) {
            super(view);
            this.dialog = new DeleteZoneDialog(Lexicon.make(BHxIntrusionZonesView.class).getText("deleteZone"), (Command)this);
        }

        public void handle(HxOp op) throws Exception {
            Object[] zones = BHxQueryTableView.getSubjects((HxOp)op);
            boolean requiresConfirmation = false;
            for (int i = 0; i < zones.length; ++i) {
                BIntrusionZone zone = (BIntrusionZone)zones[i];
                if (zone.getValidGroups().length > 0 || RemoteUtil.isNiagaraStandalone()) continue;
                requiresConfirmation = true;
            }
            boolean forceOKCancel = false;
            String result = "";
            if (requiresConfirmation && RemoteUtil.isSubordinate()) {
                result = BHxIntrusionZonesView.this.getRemoteSupervisorZones(zones, op);
                if (result.length() == 0) {
                    requiresConfirmation = false;
                }
                if (result.equals(BHxIntrusionZonesView.this.getLexicon().getText("deleteZoneButSupervisorIsDown.message"))) {
                    forceOKCancel = true;
                }
            }
            if (!requiresConfirmation) {
                super.handle(op);
                return;
            }
            if (!this.dialog.isSubmit(op)) {
                if (RemoteUtil.isSupervisor()) {
                    result = BHxIntrusionZonesView.this.getLexicon().getText("deleteZoneFromSupervisorDialog.message");
                }
                this.dialog.open(result, forceOKCancel, op);
                return;
            }
            try {
                if (RemoteUtil.isSubordinate() && op.getFormValue("noGroupedDelete") == null) {
                    BHxIntrusionZonesView.this.deleteRemoteSupervisorZones(zones, op);
                }
                super.handle(op);
            }
            catch (Exception e) {
                new ErrorDialog(Lexicon.make(BHxIntrusionZonesView.class).getText("errorDeletingZone"), (Command)this, (Throwable)e).open(op);
            }
        }
    }

    public class MultiManualOverride
    extends ManualOverride {
        public MultiManualOverride(BHxView view) {
            super(view);
        }

        @Override
        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        @Override
        public BIntrusionZone[] getZones(HxOp op) {
            BComplex[] subjects = (BComplex[])BHxQueryTableView.getSubjects((HxOp)op);
            BIntrusionZone[] zones = new BIntrusionZone[subjects.length];
            for (int i = 0; i < zones.length; ++i) {
                zones[i] = (BIntrusionZone)subjects[i];
            }
            return zones;
        }

        @Override
        public void forceIntrusionUpdate(HxOp op) throws Exception {
            ((BHxQueryTableView)this.getView()).reloadTable(op);
        }
    }
}

