/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.isom.validation.validators;

import com.tridiumx.isom.validation.validators.AllowAdditionalFieldsGroupValidator;
import com.tridiumx.isom.validation.validators.BooleanValidator;
import com.tridiumx.isom.validation.validators.DateTimeValidator;
import com.tridiumx.isom.validation.validators.EmailValidator;
import com.tridiumx.isom.validation.validators.GroupValidator;
import com.tridiumx.isom.validation.validators.LongValidator;
import com.tridiumx.isom.validation.validators.OneOfGroupValidator;
import com.tridiumx.isom.validation.validators.RequiredGroupValidator;
import com.tridiumx.isom.validation.validators.StringValidator;
import com.tridiumx.isom.validation.validators.UuidValidator;
import com.tridiumx.isom.validation.validators.Validator;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;

public class ValidatorsManager {
    private static final String SIMPLE = "simple";
    private static final String COMPLEX = "complex";
    private static final String ARRAY = "array";
    private static final String PROPERTY = "property";
    private static final String SIMPLE_PROPERTY_PREFIX = "simple.property";
    private static final String COMPLEX_PROPERTY_PREFIX = "complex.property";
    private static final String COMPLEX_VALIDATION_PREFIX = "complex.validation";
    private static final String ARRAY_PROPERTY_PREFIX = "array.property";
    private static final String VALIDATIONS_PREFIX = "validation";
    private static final String STRING = "string";
    private static final String EMAIL = "email";
    private static final String INTEGER = "integer";
    private static final String BOOLEAN = "boolean";
    private static final String DATE_TIME = "date-time";
    private static final String UUID = "uuid";
    private static final String REQUIRED = "required";
    private static final String ALLOWADDITIONALFIELDS = "allowAdditionalFields";
    private static final String ONEOF = "oneOf";
    private static final List<String> NAMES_TO_ELIMINATE_IN_KEY = new ArrayList<String>();
    private static final List<String> VALID_PROPERTY_TYPES;
    private static final Map<String, Validator> VALIDATORS_MAP_STORE;
    private final Map<String, Validator> jsonObjectValidators = new LinkedHashMap<String, Validator>();
    private final List<GroupValidator> jsonObjectGroupValidators = new ArrayList<GroupValidator>();

    public Map<String, Validator> getValidators() {
        return this.jsonObjectValidators;
    }

    public List<GroupValidator> getGroupValidators() {
        return this.jsonObjectGroupValidators;
    }

    public ValidatorsManager(String propertiesFileLocation) {
        Properties properties = this.getStringFromInputStream(propertiesFileLocation);
        this.loadGroupValidators(properties, VALIDATIONS_PREFIX);
        this.loadFieldValidators(properties);
    }

    private void loadFieldValidators(Properties properties) {
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String[] dataInValue;
            String[] dataInKey = ((String)key).split("\\.");
            String additionalInfo = (dataInValue = ((String)value).split("\\|")).length > 1 ? dataInValue[1] : null;
            String validatorKey = this.getValidatorKey(dataInValue[0], additionalInfo);
            Validator validator = VALIDATORS_MAP_STORE.get(validatorKey);
            if (validator == null) {
                String propertyType = dataInKey[0].concat(".").concat(dataInKey[1]);
                if (VALID_PROPERTY_TYPES.contains(propertyType)) {
                    switch (dataInValue[0]) {
                        case "string": {
                            validator = new StringValidator(additionalInfo);
                            VALIDATORS_MAP_STORE.put(validatorKey, validator);
                            break;
                        }
                        case "email": {
                            validator = new EmailValidator(additionalInfo);
                            VALIDATORS_MAP_STORE.put(validatorKey, new EmailValidator(additionalInfo));
                            break;
                        }
                        case "integer": {
                            validator = new LongValidator();
                            VALIDATORS_MAP_STORE.put(validatorKey, new LongValidator());
                            break;
                        }
                        case "boolean": {
                            validator = new BooleanValidator();
                            VALIDATORS_MAP_STORE.put(validatorKey, new BooleanValidator());
                            break;
                        }
                        case "date-time": {
                            validator = new DateTimeValidator();
                            VALIDATORS_MAP_STORE.put(validatorKey, new DateTimeValidator());
                            break;
                        }
                        case "uuid": {
                            validator = new UuidValidator();
                            VALIDATORS_MAP_STORE.put(validatorKey, new UuidValidator());
                            break;
                        }
                    }
                } else if (((String)key).startsWith(COMPLEX_VALIDATION_PREFIX)) {
                    this.loadGroupValidators(properties, (String)key);
                }
            }
            if (validator != null) {
                this.jsonObjectValidators.put(this.getInputJsonSpecificKey(dataInKey), validator);
            }
        }));
    }

    private String getInputJsonSpecificKey(String[] dataInKey) {
        StringBuilder key = null;
        for (String data : dataInKey) {
            if (NAMES_TO_ELIMINATE_IN_KEY.contains(data)) continue;
            if (key == null) {
                key = new StringBuilder();
            } else {
                key.append(".");
            }
            key.append(data);
        }
        return key.toString();
    }

    private void loadGroupValidators(Properties properties, String validationsPrefix) {
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String[] dataInKey = ((String)key).split("\\.");
            GroupValidator validator = null;
            if (((String)key).startsWith(validationsPrefix)) {
                switch (dataInKey[dataInKey.length - 1]) {
                    case "required": {
                        validator = new RequiredGroupValidator((String)value);
                        break;
                    }
                    case "oneOf": {
                        validator = new OneOfGroupValidator((String)value);
                        break;
                    }
                    case "allowAdditionalFields": {
                        validator = new AllowAdditionalFieldsGroupValidator((String)value, this.getJsonDataSpecificKeys(properties));
                        break;
                    }
                }
            }
            if (validator != null) {
                this.jsonObjectGroupValidators.add(validator);
            }
        }));
    }

    private Set<String> getJsonDataSpecificKeys(Properties properties) {
        HashSet<String> keys = new HashSet<String>();
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String inputJsonSpecificKey = this.getInputJsonSpecificKey(((String)iterator.next()).split("\\."));
            keys.add(inputJsonSpecificKey.split("\\.")[0]);
        }
        return keys;
    }

    private String getValidatorKey(String dataType, String additionalInfo) {
        String validatorKey = dataType;
        if (additionalInfo != null) {
            validatorKey = validatorKey.concat(additionalInfo);
        }
        return validatorKey;
    }

    private Properties getStringFromInputStream(String propertiesFileLocation) {
        Properties props;
        try (BufferedInputStream in = new BufferedInputStream(this.getClass().getResourceAsStream(propertiesFileLocation));){
            props = new Properties();
            props.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception occurred while reading the Properties", e);
        }
        return props;
    }

    static {
        NAMES_TO_ELIMINATE_IN_KEY.add(SIMPLE);
        NAMES_TO_ELIMINATE_IN_KEY.add(COMPLEX);
        NAMES_TO_ELIMINATE_IN_KEY.add(ARRAY);
        NAMES_TO_ELIMINATE_IN_KEY.add(PROPERTY);
        VALID_PROPERTY_TYPES = new ArrayList<String>();
        VALID_PROPERTY_TYPES.add(SIMPLE_PROPERTY_PREFIX);
        VALID_PROPERTY_TYPES.add(COMPLEX_PROPERTY_PREFIX);
        VALID_PROPERTY_TYPES.add(ARRAY_PROPERTY_PREFIX);
        VALIDATORS_MAP_STORE = new HashMap<String, Validator>();
    }
}

