/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.isom.validation.validators;

import com.tridiumx.isom.validation.validators.Validator;
import java.util.function.Predicate;

public class StringValidator
extends Validator {
    private Predicate<Object> lengthCondition;
    private String minMaxLength;

    public StringValidator(String minMaxLength) {
        this.minMaxLength = minMaxLength;
        if (minMaxLength != null) {
            String[] split = minMaxLength.split("-");
            this.lengthCondition = s -> s == null || String.valueOf(s).length() >= Integer.valueOf(split[0]) && String.valueOf(s).length() <= Integer.valueOf(split[1]);
        } else {
            this.lengthCondition = s -> true;
        }
    }

    @Override
    public Predicate<Object> getCondition() {
        return this.lengthCondition;
    }

    @Override
    public String getMessage(String keyName) {
        String msg = lex.getText("validation.string.not.valid.length", new Object[]{keyName});
        StringBuilder sb = new StringBuilder(msg);
        if (this.minMaxLength != null) {
            sb.append(": ").append(this.minMaxLength);
        }
        return sb.toString();
    }
}

