/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.isom.validation.validators;

import com.tridium.json.JSONObject;
import com.tridiumx.isom.InvalidInputDataException;
import com.tridiumx.isom.validation.validators.GroupValidator;

public class OneOfGroupValidator
implements GroupValidator {
    private String oneOfFields;

    public OneOfGroupValidator(String oneOfFields) {
        this.oneOfFields = oneOfFields;
    }

    @Override
    public String getMessage(String info) {
        return lex.getText("validation.oneOf.not.met", new Object[]{info});
    }

    @Override
    public boolean validate(JSONObject jsonObject) throws InvalidInputDataException {
        String[] dataInValue = this.oneOfFields.split("\\|");
        int notNullFields = 0;
        for (String data : dataInValue) {
            if (!jsonObject.isNull(data)) {
                ++notNullFields;
            }
            if (notNullFields > 1) break;
        }
        if (notNullFields == 0 || notNullFields > 1) {
            throw new InvalidInputDataException(this.getMessage(this.oneOfFields.replaceAll("\\|", ", ")));
        }
        return true;
    }
}

