/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nvideo.ui;

import com.tridium.ui.theme.Theme;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.component.table.BComponentTable;
import javax.baja.workbench.component.table.ComponentTableCellRenderer;
import javax.baja.workbench.mgr.BMgrTable;

public class VideoNestedDeviceExtsColumn
extends DeviceExtsColumn {
    static final BImage defaultIcon = BImage.make((String)"module://icons/x16/object.png");
    TableCellRenderer renderer = new CellRenderer();
    BImage[] icons;
    String[] names;
    double prefWidth;

    public VideoNestedDeviceExtsColumn(BDevice protoType) {
        this(protoType, 0);
    }

    public VideoNestedDeviceExtsColumn(BDevice protoType, int flags) {
        super(protoType, flags);
        BDeviceExt[] exts = protoType.getDeviceExts();
        this.icons = new BImage[exts.length];
        this.names = new String[exts.length];
        for (int i = 0; i < exts.length; ++i) {
            BDeviceExt ext = exts[i];
            this.icons[i] = BImage.make((BIcon)ext.getIcon());
            if (this.icons[i] == null || this.icons[i].isNull()) {
                this.icons[i] = defaultIcon;
            }
            this.names[i] = ext.getName();
        }
        this.prefWidth = 4 + this.icons.length * 20 + 4;
    }

    public Object get(Object row) {
        return (BComponent)row;
    }

    public TableCellRenderer getCellRenderer() {
        return this.renderer;
    }

    public void videoCellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
        BWbShell shell;
        RectGeom rect = table.getCellBounds(row, col);
        BComponent component = table.getComponentAt(row);
        if (component instanceof BIDeviceFolder) {
            return;
        }
        int x = (int)(event.getX() - rect.x);
        int index = (x - 4) / 20;
        if (0 <= index && index < this.names.length && (shell = table.getManager().getWbShell()) != null) {
            BOrd ord = BOrd.make((String)(component.getNavOrd().toString() + "/" + this.names[index]));
            shell.hyperlink(new HyperlinkInfo(ord, (BInputEvent)event));
        }
    }

    class CellRenderer
    extends ComponentTableCellRenderer {
        CellRenderer() {
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            if (cell.value instanceof BIDeviceFolder) {
                return Theme.table().getGridBrush();
            }
            return super.getBackground(cell);
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            return VideoNestedDeviceExtsColumn.this.prefWidth;
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            this.paintCellBackground(g, cell);
            if (cell.value instanceof BIDeviceFolder) {
                return;
            }
            for (int i = 0; i < VideoNestedDeviceExtsColumn.this.icons.length; ++i) {
                g.drawImage(VideoNestedDeviceExtsColumn.this.icons[i], (double)(4 + i * 20), (cell.height - 16.0) / 2.0);
            }
        }

        protected BComponentTable getComponentTable() {
            return VideoNestedDeviceExtsColumn.this.getManager().getModel().getTable();
        }
    }
}

