/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.point.actions;

import com.tridiumX.knxnetIp.point.BKnxProxyExt;
import com.tridiumX.knxnetIp.point.actions.BKnxCounterAction;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
public final class BKnxCounterDecrementAction
extends BKnxCounterAction {
    public static final Type TYPE = Sys.loadType(BKnxCounterDecrementAction.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public BFacets getFacets() {
        try {
            BControlPoint pt = (BControlPoint)this.getParent();
            BFacets pointFacets = pt.getSlotFacets((Slot)pt.getOutProperty());
            BUnit realUnits = null;
            int precision = 0;
            if (pointFacets != null) {
                realUnits = (BUnit)pointFacets.getFacet("units");
                if (realUnits != null && realUnits.isNull()) {
                    return BFacets.NULL;
                }
                precision = pointFacets.geti("precision", 0);
            }
            return BFacets.makeNumeric(realUnits, (int)precision);
        }
        catch (Exception e) {
            return BFacets.NULL;
        }
    }

    @Override
    public Type getParameterType() {
        return BDouble.TYPE;
    }

    public BValue invoke(BComponent target, BValue value) throws Exception {
        BNumericPoint pt = (BNumericPoint)this.invokeCheck(target, value);
        BFacets pointFacets = pt.getSlotFacets((Slot)pt.getOutProperty());
        double min = pointFacets.getd("min", Double.NEGATIVE_INFINITY);
        double max = pointFacets.getd("max", Double.POSITIVE_INFINITY);
        double decr = ((BINumeric)value).getNumeric();
        double now = pt.getNumeric();
        if (now - decr < min) {
            BKnxCounterDecrementAction.doCounterPreset((BKnxProxyExt)pt.getProxyExt(), (BValue)BDouble.make((double)min), null);
        } else if (now - decr > max) {
            BKnxCounterDecrementAction.doCounterPreset((BKnxProxyExt)pt.getProxyExt(), (BValue)BDouble.make((double)max), null);
        } else {
            BKnxCounterDecrementAction.doCounterDecrement((BKnxProxyExt)pt.getProxyExt(), value, null);
        }
        return null;
    }
}

