/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.point.actions;

import com.tridiumX.knxnetIp.point.BKnxNumericProxyExt;
import com.tridiumX.knxnetIp.point.BKnxProxyExt;
import com.tridiumX.knxnetIp.point.actions.BKnxAction;
import javax.baja.control.BNumericPoint;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BDouble;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
abstract class BKnxCounterAction
extends BKnxAction {
    public static final Type TYPE = Sys.loadType(BKnxCounterAction.class);

    BKnxCounterAction() {
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public final Type getControlPointType() {
        return BNumericPoint.TYPE;
    }

    protected static void doCounterReset(BKnxProxyExt proxyExt, Context cx) {
        BKnxProxyExt.log.fine("resetCount");
        BStatusNumeric proxyValue = new BStatusNumeric(0.0);
        ((BKnxNumericProxyExt)proxyExt).setWriteValueAndWrite((BStatusValue)proxyValue, true);
    }

    protected static void doCounterPreset(BKnxProxyExt proxyExt, BValue arg, Context cx) {
        BKnxProxyExt.log.fine("presetCount");
        BDouble amount = (BDouble)arg;
        BStatusNumeric proxyValue = new BStatusNumeric(amount.getNumeric());
        ((BKnxNumericProxyExt)proxyExt).setWriteValueAndWrite((BStatusValue)proxyValue, true);
    }

    protected static void doCounterIncrement(BKnxProxyExt proxyExt, BValue arg, Context cx) {
        BKnxProxyExt.log.fine("incrementCount");
        BDouble amount = (BDouble)arg;
        BStatusNumeric proxyValue = (BStatusNumeric)proxyExt.getParentPoint().getOutStatusValue();
        proxyValue = new BStatusNumeric(proxyValue.getNumeric() + amount.getNumeric(), proxyValue.getStatus());
        ((BKnxNumericProxyExt)proxyExt).setWriteValueAndWrite((BStatusValue)proxyValue, true);
    }

    protected static void doCounterDecrement(BKnxProxyExt proxyExt, BValue arg, Context cx) {
        BKnxProxyExt.log.fine("decrementCount");
        BDouble amount = (BDouble)arg;
        BStatusNumeric proxyValue = (BStatusNumeric)proxyExt.getParentPoint().getOutStatusValue();
        proxyValue = new BStatusNumeric(proxyValue.getNumeric() - amount.getNumeric(), proxyValue.getStatus());
        ((BKnxNumericProxyExt)proxyExt).setWriteValueAndWrite((BStatusValue)proxyValue, true);
    }
}

