/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.point;

import com.tridiumX.knxnetIp.comms.cemi.CemiMessageData;
import com.tridiumX.knxnetIp.knxDataDefs.BDataValueTypeDef;
import com.tridiumX.knxnetIp.knxDataDefs.BKnxEncodingFormatEnum;
import com.tridiumX.knxnetIp.point.BKnxProxyExt;
import com.tridiumX.knxnetIp.util.CatchAll;
import javax.baja.control.BNumericPoint;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BMonth;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BKnxNumericProxyExt
extends BKnxProxyExt {
    public static final Type TYPE = Sys.loadType(BKnxNumericProxyExt.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNumericPoint;
    }

    @Override
    public BStatusValue decodeFromBytes(CemiMessageData msgData) {
        byte[] b = msgData.data;
        BDataValueTypeDef def = this.getActingDataValueTypeDef();
        if (def != null) {
            def.checkReservedBitsAreZero(b);
            if (def.isDateTime()) {
                BDataValueTypeDef[] fields;
                if (!def.getEncodingFormat().equals((Object)BKnxEncodingFormatEnum.hHexBytes)) {
                    throw new IllegalArgumentException("decodeFromBytes() of 'DateTime' DataValueType '" + def.getKNX_ID() + "' to '" + this.getParentPoint().getTypeDisplayName(null) + "' is not supported.");
                }
                int year = 1970;
                BMonth month = BMonth.DEFAULT;
                int day = 0;
                int hour = 0;
                int min = 0;
                int sec = 0;
                block14: for (BDataValueTypeDef fieldDef : fields = def.getDataValueTypeFieldDefs()) {
                    fieldDef.loadSlots();
                    switch (fieldDef.getDateTimeField_ID().getOrdinal()) {
                        case 1: 
                        case 7: {
                            BValue value = fieldDef.bytesToBValue(msgData);
                            if (!(value instanceof BInteger)) continue block14;
                            year = ((BInteger)value).getInt();
                            continue block14;
                        }
                        case 2: {
                            BValue value = fieldDef.bytesToBValue(msgData);
                            if (!(value instanceof BInteger)) continue block14;
                            month = BMonth.make((int)((BInteger)value).getInt());
                            continue block14;
                        }
                        case 3: {
                            BValue value = fieldDef.bytesToBValue(msgData);
                            if (!(value instanceof BInteger)) continue block14;
                            day = ((BInteger)value).getInt();
                            continue block14;
                        }
                        case 4: {
                            BValue value = fieldDef.bytesToBValue(msgData);
                            if (!(value instanceof BInteger)) continue block14;
                            hour = ((BInteger)value).getInt();
                            continue block14;
                        }
                        case 5: {
                            BValue value = fieldDef.bytesToBValue(msgData);
                            if (!(value instanceof BInteger)) continue block14;
                            min = ((BInteger)value).getInt();
                            continue block14;
                        }
                        case 6: {
                            BValue value = fieldDef.bytesToBValue(msgData);
                            if (!(value instanceof BInteger)) continue block14;
                            sec = ((BInteger)value).getInt();
                            continue block14;
                        }
                    }
                }
                BAbsTime absTime = BAbsTime.make((int)year, (BMonth)month, (int)day, (int)hour, (int)min, (int)sec, (int)0);
                return new BStatusNumeric((double)absTime.getMillis());
            }
            if (!BKnxNumericProxyExt.isEncodingFormatValid(def)) {
                throw new IllegalArgumentException("decodeFromBytes() of DataValueType '" + def.getKNX_ID() + "' to '" + this.getParentPoint().getTypeDisplayName(null) + "' is not supported.");
            }
            BValue value = def.bytesToBValue(msgData);
            if (value instanceof BBoolean) {
                return new BStatusNumeric((double)((BBoolean)value).getOrdinal());
            }
            if (value instanceof BDouble) {
                return new BStatusNumeric(((BDouble)value).getDouble());
            }
            if (value instanceof BInteger) {
                return new BStatusNumeric(((BInteger)value).getDouble());
            }
            if (value instanceof BLong) {
                return new BStatusNumeric(((BLong)value).getDouble());
            }
            if (value instanceof BString) {
                try {
                    return new BStatusNumeric((double)Long.parseLong(((BString)value).getString(), def.getDefinedFacets().geti("radix", 10)));
                }
                catch (NumberFormatException year) {
                }
                catch (Throwable t) {
                    CatchAll.throwable(t);
                }
                try {
                    return new BStatusNumeric(Double.parseDouble(((BString)value).getString()));
                }
                catch (NumberFormatException t) {
                }
                catch (Throwable t) {
                    CatchAll.throwable(t);
                }
                throw new IllegalArgumentException("data ('" + value + "') cannot be converted to numeric:" + ByteArrayUtil.toHexString((byte[])b, (String)" "));
            }
            throw new IllegalArgumentException("BKnxProxyExt.bytesToBValue() returned an un-expected BValue Type ('" + value.getTypeDisplayName(null) + "') not supported:" + ByteArrayUtil.toHexString((byte[])b, (String)" "));
        }
        throw new IllegalArgumentException("unknown DataValueType in bytesToNumeric(...) (ID = '" + this.getDataValueTypeId() + "') not supported:" + ByteArrayUtil.toHexString((byte[])b, (String)" "));
    }

    @Override
    public CemiMessageData encodeToBytes(BStatusValue statVal) {
        return BKnxNumericProxyExt.encodeToCemiMessageData(this.getActingDataValueTypeDef(), statVal);
    }

    public static CemiMessageData encodeToCemiMessageData(BDataValueTypeDef def, BStatusValue statVal) {
        if (!(statVal instanceof BStatusNumeric)) {
            throw new IllegalArgumentException("unsupported data type");
        }
        if (def == null) {
            throw new NullPointerException("no DataValueType provided");
        }
        BDouble value = (BDouble)statVal.getValueValue();
        BStatus status = statVal.getStatus();
        if (def.isDateTime()) {
            BDataValueTypeDef[] fields;
            if (!def.getEncodingFormat().equals((Object)BKnxEncodingFormatEnum.hHexBytes)) {
                throw new IllegalArgumentException("encodeToCemiMessageData() of 'DateTime' DataValueType '" + def.getKNX_ID() + "' from '" + statVal.getTypeDisplayName(null) + "' is not supported.");
            }
            BAbsTime absTime = BAbsTime.make((long)value.getLong());
            CemiMessageData msgData = null;
            for (BDataValueTypeDef fieldDef : fields = def.getDataValueTypeFieldDefs()) {
                fieldDef.loadSlots();
                CemiMessageData newData = null;
                switch (fieldDef.getDateTimeField_ID().getOrdinal()) {
                    case 1: 
                    case 7: {
                        newData = def.bytesFromBValue((BValue)BInteger.make((int)absTime.getYear()), status);
                        break;
                    }
                    case 2: {
                        newData = def.bytesFromBValue((BValue)BInteger.make((int)absTime.getMonth().getOrdinal()), status);
                        break;
                    }
                    case 3: {
                        newData = def.bytesFromBValue((BValue)BInteger.make((int)absTime.getDay()), status);
                        break;
                    }
                    case 4: {
                        newData = def.bytesFromBValue((BValue)BInteger.make((int)absTime.getHour()), status);
                        break;
                    }
                    case 5: {
                        newData = def.bytesFromBValue((BValue)BInteger.make((int)absTime.getMinute()), status);
                        break;
                    }
                    case 6: {
                        newData = def.bytesFromBValue((BValue)BInteger.make((int)absTime.getSecond()), status);
                        break;
                    }
                }
                if (newData == null) continue;
                if (msgData == null) {
                    msgData = newData;
                    continue;
                }
                if (msgData.data.length != newData.data.length || msgData.shouldOptimize() != newData.shouldOptimize()) continue;
                for (int j = 0; j < msgData.data.length; ++j) {
                    msgData.data[j] = (byte)(msgData.data[j] & ~newData.mask[j] | newData.data[j]);
                    int n = j;
                    msgData.mask[n] = (byte)(msgData.mask[n] | newData.mask[j]);
                }
            }
            return msgData;
        }
        int iSizeInBits = def.getSizeInBits();
        switch (def.getEncodingFormat().getOrdinal()) {
            case 1: {
                try {
                    BString sVal = BString.make((String)Double.toString(value.getDouble()));
                    return def.bytesFromBValue((BValue)sVal, status);
                }
                catch (Throwable t) {
                    CatchAll.throwable(t);
                    throw new IllegalArgumentException("data cannot be converted from numeric: " + value);
                }
            }
            case 3: {
                if (iSizeInBits == 1) {
                    BBoolean bVal = BBoolean.make((value != BDouble.DEFAULT ? 1 : 0) != 0);
                    return def.bytesFromBValue((BValue)bVal, status);
                }
                BLong lngVal = BLong.make((long)value.getLong());
                return def.bytesFromBValue((BValue)lngVal, status);
            }
            case 6: 
            case 11: {
                return def.bytesFromBValue((BValue)value, status);
            }
            case 8: {
                BInteger intVal = BInteger.make((int)value.getInt());
                return def.bytesFromBValue((BValue)intVal, status);
            }
            case 12: {
                BLong lngVal = BLong.make((long)value.getLong());
                return def.bytesFromBValue((BValue)lngVal, status);
            }
            case 13: {
                throw new IllegalArgumentException("TODO - encodeToBytes() of 'Z8' Format Encoding in BKnxNumericProxyExt - NOT YET IMPLEMENTED!");
            }
            case 15: {
                throw new IllegalArgumentException("TODO - encodeToBytes() of 'H' Format Encoding in BKnxNumericProxyExt - NOT YET IMPLEMENTED!");
            }
        }
        throw new IllegalArgumentException("unknown Format Encoding in encodeToBytes() in BKnxNumericProxyExt - Ordinal = " + def.getEncodingFormat().getOrdinal());
    }

    private static boolean isEncodingFormatValid(BDataValueTypeDef def) {
        switch (def.getEncodingFormat().getOrdinal()) {
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                return true;
            }
            case 15: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown Format Encoding in encodeToBytes() in BKnxNumericProxyExt - Ordinal = " + def.getEncodingFormat().getOrdinal());
            }
        }
        return false;
    }

    public boolean setWriteValueAndWrite(BStatusValue proxyValue, boolean convert) {
        if (convert) {
            BStatusNumeric deviceValue = new BStatusNumeric();
            this.convertProxyToDevice(proxyValue, (BStatusValue)deviceValue);
            if (deviceValue.getNumeric() < 0.0) {
                deviceValue = new BStatusNumeric(0.0, deviceValue.getStatus());
            }
            deviceValue = new BStatusNumeric((double)Math.round(deviceValue.getNumeric()), deviceValue.getStatus());
            return this.setWriteValueAndWrite((BStatusValue)deviceValue);
        }
        return this.setWriteValueAndWrite(proxyValue);
    }
}

