/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.driver;

import com.tridium.nre.util.IPAddressUtil;
import com.tridiumX.knxnetIp.addresses.BIndividualDeviceAddress;
import com.tridiumX.knxnetIp.comms.BConnections;
import com.tridiumX.knxnetIp.comms.BGroupDataManager;
import com.tridiumX.knxnetIp.comms.BKnxInstallation;
import com.tridiumX.knxnetIp.comms.BKnxInstallationRef;
import com.tridiumX.knxnetIp.comms.BProxyDeviceRef;
import com.tridiumX.knxnetIp.comms.IHardwareAndServicesDIBs;
import com.tridiumX.knxnetIp.comms.ILDataConnection;
import com.tridiumX.knxnetIp.comms.enums.BConnectionMethods;
import com.tridiumX.knxnetIp.comms.frames.parts.BDescriptionInformationBlocks;
import com.tridiumX.knxnetIp.driver.BKnxDeviceFolder;
import com.tridiumX.knxnetIp.driver.BKnxNetwork;
import com.tridiumX.knxnetIp.driver.BKnxPointDeviceExt;
import com.tridiumX.knxnetIp.enums.BConnectionMethodEnum;
import com.tridiumX.knxnetIp.enums.BKnxDeviceConfigStatus;
import com.tridiumX.knxnetIp.util.BIIncludeInTrace;
import com.tridiumX.knxnetIp.util.CatchAll;
import com.tridiumX.knxnetIp.util.ThreadPriorityUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.BDevice;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="configStatus", type="BKnxDeviceConfigStatus", defaultValue="BKnxDeviceConfigStatus.ok", flags=75), @NiagaraProperty(name="deviceId", type="int", defaultValue="0", flags=65), @NiagaraProperty(name="knxInstallation", type="BKnxInstallationRef", defaultValue="new BKnxInstallationRef()"), @NiagaraProperty(name="ipAddress", type="String", defaultValue="KnxStrings.EMPTY_STRING", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, \"platform:IpHostFE\")")}), @NiagaraProperty(name="controlPortNumber", type="int", defaultValue="Constants.NO_IP_PORT_NUMBER", flags=8, facets={@Facet(value="BFacets.makeInt(null, Constants.NO_IP_PORT_NUMBER, Constants.MAX_IP_PORT_NUMBER, 10)")}), @NiagaraProperty(name="individualDeviceAddress", type="BIndividualDeviceAddress", defaultValue="new BIndividualDeviceAddress()"), @NiagaraProperty(name="macAddress", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=1), @NiagaraProperty(name="friendlyName", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=1), @NiagaraProperty(name="dIBs", type="BDescriptionInformationBlocks", defaultValue="new BDescriptionInformationBlocks()", flags=3), @NiagaraProperty(name="groupDataManager", type="BGroupDataManager", defaultValue="new BGroupDataManager()", flags=1), @NiagaraProperty(name="points", type="BKnxPointDeviceExt", defaultValue="new BKnxPointDeviceExt()"), @NiagaraProperty(name="includeInTrace", type="boolean", defaultValue="true", flags=65540), @NiagaraProperty(name="connectionMethod", type="BDynamicEnum", defaultValue="BConnectionMethods.make(BConnectionMethodEnum.DEFAULT)")})
public final class BKnxDevice
extends BDevice
implements BIIncludeInTrace {
    public static final Property configStatus = BKnxDevice.newProperty((int)75, (BValue)BKnxDeviceConfigStatus.ok, null);
    public static final Property deviceId = BKnxDevice.newProperty((int)65, (int)0, null);
    public static final Property knxInstallation = BKnxDevice.newProperty((int)0, (BValue)new BKnxInstallationRef(), null);
    public static final Property ipAddress = BKnxDevice.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (String)"platform:IpHostFE"));
    public static final Property controlPortNumber = BKnxDevice.newProperty((int)8, (int)-1, (BFacets)BFacets.makeInt(null, (int)-1, (int)65535, (int)10));
    public static final Property individualDeviceAddress = BKnxDevice.newProperty((int)0, (BValue)new BIndividualDeviceAddress(), null);
    public static final Property macAddress = BKnxDevice.newProperty((int)1, (String)"", null);
    public static final Property friendlyName = BKnxDevice.newProperty((int)1, (String)"", null);
    public static final Property dIBs = BKnxDevice.newProperty((int)3, (BValue)new BDescriptionInformationBlocks(), null);
    public static final Property groupDataManager = BKnxDevice.newProperty((int)1, (BValue)new BGroupDataManager(), null);
    public static final Property points = BKnxDevice.newProperty((int)0, (BValue)new BKnxPointDeviceExt(), null);
    public static final Property includeInTrace = BKnxDevice.newProperty((int)65540, (boolean)true, null);
    public static final Property connectionMethod = BKnxDevice.newProperty((int)0, (BValue)BConnectionMethods.make((BEnum)BConnectionMethodEnum.DEFAULT), null);
    public static final Type TYPE = Sys.loadType(BKnxDevice.class);
    private InetAddress deviceInetAddress;
    private static final Logger LOG = Logger.getLogger(TYPE.getModule().getModuleName());
    private static final String START_UP = "Start Up";
    private static final String PROXY_DEVICE_SLOT_NAME = "proxyDevice";
    private static final String COMMS_CONNECTIONS_SLOT_NAME = "commsConnections";

    public BKnxDeviceConfigStatus getConfigStatus() {
        return (BKnxDeviceConfigStatus)this.get(configStatus);
    }

    public void setConfigStatus(BKnxDeviceConfigStatus v) {
        this.set(configStatus, (BValue)v, null);
    }

    public int getDeviceId() {
        return this.getInt(deviceId);
    }

    public void setDeviceId(int v) {
        this.setInt(deviceId, v, null);
    }

    public BKnxInstallationRef getKnxInstallation() {
        return (BKnxInstallationRef)this.get(knxInstallation);
    }

    public void setKnxInstallation(BKnxInstallationRef v) {
        this.set(knxInstallation, (BValue)v, null);
    }

    public String getIpAddress() {
        return this.getString(ipAddress);
    }

    public void setIpAddress(String v) {
        this.setString(ipAddress, v, null);
    }

    public int getControlPortNumber() {
        return this.getInt(controlPortNumber);
    }

    public void setControlPortNumber(int v) {
        this.setInt(controlPortNumber, v, null);
    }

    public BIndividualDeviceAddress getIndividualDeviceAddress() {
        return (BIndividualDeviceAddress)this.get(individualDeviceAddress);
    }

    public void setIndividualDeviceAddress(BIndividualDeviceAddress v) {
        this.set(individualDeviceAddress, (BValue)v, null);
    }

    public String getMacAddress() {
        return this.getString(macAddress);
    }

    public void setMacAddress(String v) {
        this.setString(macAddress, v, null);
    }

    public String getFriendlyName() {
        return this.getString(friendlyName);
    }

    public void setFriendlyName(String v) {
        this.setString(friendlyName, v, null);
    }

    public BDescriptionInformationBlocks getDIBs() {
        return (BDescriptionInformationBlocks)this.get(dIBs);
    }

    public void setDIBs(BDescriptionInformationBlocks v) {
        this.set(dIBs, (BValue)v, null);
    }

    public BGroupDataManager getGroupDataManager() {
        return (BGroupDataManager)this.get(groupDataManager);
    }

    public void setGroupDataManager(BGroupDataManager v) {
        this.set(groupDataManager, (BValue)v, null);
    }

    public BKnxPointDeviceExt getPoints() {
        return (BKnxPointDeviceExt)this.get(points);
    }

    public void setPoints(BKnxPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    @Override
    public boolean getIncludeInTrace() {
        return this.getBoolean(includeInTrace);
    }

    @Override
    public void setIncludeInTrace(boolean v) {
        this.setBoolean(includeInTrace, v, null);
    }

    public BDynamicEnum getConnectionMethod() {
        return (BDynamicEnum)this.get(connectionMethod);
    }

    public void setConnectionMethod(BDynamicEnum v) {
        this.set(connectionMethod, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.updateConfigStatus();
        this.configStatusChanged(null);
        this.checkConnection();
        this.pingFail(START_UP);
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.checkConnections();
        this.checkConnection();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.closeDevice();
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        this.checkConnections();
        this.checkConnection();
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BKnxNetwork || parent instanceof BKnxDeviceFolder;
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if (context != null && !context.equals(Context.decoding) && !context.equals(Context.copying) && property.getName().equals("rxThreadPriority")) {
            ThreadPriorityUtil.slotAdded((BComponent)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (Context.decoding.equals(context) && property.equals(connectionMethod)) {
            this.updateConnectionMethodEnumRange();
        }
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(configStatus)) {
            this.configStatusChanged(context);
        }
        if (property.equals(ipAddress)) {
            if (LOG.isLoggable(Level.FINE)) {
                System.out.println("ipAddress Property changed - " + this.getIpAddress());
            }
            try {
                this.setDeviceInetAddress();
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "invalid ip:" + this.getIpAddress(), ex);
                return;
            }
            finally {
                this.updateConfigStatus();
                this.checkConnections();
                if (this.getKnxNetwork() != null) {
                    this.getKnxNetwork().checkConfigDeviceIps();
                }
            }
        }
        if (property.equals(controlPortNumber)) {
            this.updateConfigStatus();
            this.checkConnections();
        }
        if (property.equals(individualDeviceAddress)) {
            this.updateConfigStatus();
            this.checkConnections();
        }
        if (property.equals(knxInstallation)) {
            this.updateConfigStatus();
            this.checkConnection();
        }
        if (property.equals(connectionMethod)) {
            this.updateConfigStatus();
            this.checkConnection();
        }
        if (property.getName().equals(PROXY_DEVICE_SLOT_NAME)) {
            this.updateConfigStatus();
            this.checkConnection();
        }
    }

    public Type getNetworkType() {
        return BKnxNetwork.TYPE;
    }

    protected IFuture postPing() {
        try {
            this.doPing();
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void doPing() throws Exception {
        if (this.getConfigStatus().equals((Object)BKnxDeviceConfigStatus.ok) && this.getGroupDataManager().isConnected()) {
            this.pingOk();
            return;
        }
        this.checkConnections();
    }

    public String toString(Context context) {
        return super.toString(context) + ": name=" + this.getDisplayName(context);
    }

    public BProxyDeviceRef getProxyDevice() {
        Property slot = this.getProperty(PROXY_DEVICE_SLOT_NAME);
        if (slot != null) {
            return (BProxyDeviceRef)this.get(slot);
        }
        return null;
    }

    public void setProxyDevice(BProxyDeviceRef proxyDevice, Context cx) {
        Property slot = this.getProperty(PROXY_DEVICE_SLOT_NAME);
        if (proxyDevice != null) {
            if (slot == null) {
                this.add(PROXY_DEVICE_SLOT_NAME, (BValue)new BProxyDeviceRef());
                slot = this.getProperty(PROXY_DEVICE_SLOT_NAME);
                this.setDisplayName(slot, BFormat.make((String)"%lexicon(knxnetIp:proxyDeviceId)%"), null);
            }
            if (slot != null) {
                this.set(slot, (BValue)proxyDevice, cx);
            }
        }
    }

    public void updateConfigStatus() {
        BKnxInstallationRef knxInstallationRef;
        int newStatus = this.getConfigStatus().getBits();
        String deviceIpAddressString = this.getIpAddress();
        if (IPAddressUtil.isNumericAddr((String)deviceIpAddressString) && IPAddressUtil.isIpv4Address((String)deviceIpAddressString)) {
            try {
                InetAddress newAddress;
                this.deviceInetAddress = newAddress = InetAddress.getByAddress(IPAddressUtil.numericStringToByteArray((String)deviceIpAddressString));
                newStatus &= 0xFFFFFFEF;
            }
            catch (UnknownHostException ex) {
                this.deviceInetAddress = null;
                newStatus |= 0x10;
            }
        } else {
            this.deviceInetAddress = null;
            newStatus |= 0x10;
        }
        newStatus = this.getIndividualDeviceAddress().getAddress() == 0 ? (newStatus |= 0x2000) : (newStatus &= 0xFFFFDFFF);
        newStatus = (newStatus & 0x2010) == 8208 ? (newStatus |= 0x4000) : (newStatus &= 0xFFFFBFFF);
        BKnxNetwork network = this.getKnxNetwork();
        if (network != null) {
            newStatus = network.isDuplicateDeviceIpAddress(this) ? (newStatus |= 0x20) : (newStatus &= 0xFFFFFFDF);
        }
        if ((knxInstallationRef = this.getKnxInstallation()).getKnxInstallationIdEnum().getOrdinal() == 0) {
            newStatus |= 1;
            newStatus &= 0xFFFFFFB1;
        } else {
            newStatus &= 0xFFFFFFFE;
            if (network != null) {
                BKnxInstallation knxInstallation = this.getKnxInstallationInstance();
                if (knxInstallation == null) {
                    newStatus |= 2;
                    newStatus &= 0xFFFFFFB3;
                } else {
                    newStatus &= 0xFFFFFFFD;
                    newStatus = knxInstallation.getStatus().isDisabled() ? (newStatus |= 4) : (newStatus &= 0xFFFFFFFB);
                    newStatus = knxInstallation.isConfigFault() ? (newStatus |= 8) : (newStatus &= 0xFFFFFFF7);
                    newStatus &= 0xFFFFFFBF;
                }
            } else {
                this.getLogger().severe("Can't find network");
            }
        }
        if (this.getConnectionMethod().getOrdinal() == 1) {
            Property slot = this.getProperty(PROXY_DEVICE_SLOT_NAME);
            if (slot == null) {
                newStatus |= 0x80;
                newStatus &= 0xFFFFE0FF;
            } else {
                newStatus &= 0xFFFFFF7F;
                int proxyDeviceId = ((BProxyDeviceRef)this.get(slot)).getProxyDeviceIdEnum().getOrdinal();
                if (proxyDeviceId == 0) {
                    newStatus |= 0x100;
                    newStatus &= 0xFFFFE1FF;
                } else {
                    newStatus &= 0xFFFFFEFF;
                    BKnxDevice proxyDevice = this.getKnxNetwork().getDeviceById(proxyDeviceId);
                    if (proxyDevice == null) {
                        newStatus |= 0x200;
                        newStatus &= 0xFFFFE3FF;
                    } else {
                        newStatus &= 0xFFFFFDFF;
                        newStatus = proxyDevice.getStatus().isDisabled() ? (newStatus |= 0x400) : (newStatus &= 0xFFFFFBFF);
                        newStatus = proxyDevice.isConfigFault() ? (newStatus |= 0x800) : (newStatus &= 0xFFFFF7FF);
                        newStatus = proxyDevice.getStatus().isDown() ? (newStatus |= 0x1000) : (newStatus &= 0xFFFFEFFF);
                    }
                }
            }
        } else {
            newStatus &= 0xFFFFE07F;
        }
        this.setConfigStatus(new BKnxDeviceConfigStatus(newStatus));
    }

    private void configStatusChanged(Context context) {
        if (!this.getConfigStatus().isConfigFault()) {
            this.configOk();
            if (!this.getConfigStatus().equals((Object)BKnxDeviceConfigStatus.ok)) {
                this.pingFail(this.getConfigStatus().toString(context));
            }
        } else {
            this.configFail(this.getConfigStatus().toString(context));
        }
    }

    public boolean isConfigFault() {
        return this.getConfigStatus().isConfigFault();
    }

    private void updateConnectionMethodEnumRange() {
        this.setConnectionMethod(BConnectionMethods.make((BEnum)this.getConnectionMethod()));
    }

    private void checkConnection() {
        switch (this.getConnectionMethod().getOrdinal()) {
            case 0: {
                Property slot = this.getProperty(PROXY_DEVICE_SLOT_NAME);
                if (slot != null) {
                    this.remove(slot);
                }
                if ((slot = this.getProperty(COMMS_CONNECTIONS_SLOT_NAME)) != null) break;
                slot = this.add(COMMS_CONNECTIONS_SLOT_NAME, (BValue)new BConnections());
                this.setDisplayName(slot, BFormat.make((String)"%lexicon(knxnetIp:commsConnections)%"), null);
                break;
            }
            case 1: {
                Property slot = this.getProperty(COMMS_CONNECTIONS_SLOT_NAME);
                if (slot != null) {
                    ((BConnections)this.get(slot)).closeConnections();
                    this.remove(slot);
                }
                if ((slot = this.getProperty(PROXY_DEVICE_SLOT_NAME)) != null) break;
                slot = this.add(PROXY_DEVICE_SLOT_NAME, (BValue)new BProxyDeviceRef());
                this.setDisplayName(slot, BFormat.make((String)"%lexicon(knxnetIp:proxyDeviceId)%"), null);
                break;
            }
            case 2: {
                Property slot = this.getProperty(COMMS_CONNECTIONS_SLOT_NAME);
                if (slot != null) {
                    ((BConnections)this.get(slot)).closeConnections();
                    this.remove(slot);
                }
                if ((slot = this.getProperty(PROXY_DEVICE_SLOT_NAME)) == null) break;
                this.remove(slot);
                break;
            }
        }
        ILDataConnection connection = this.getConnection();
        this.getGroupDataManager().checkDataConnection(connection);
        this.updateConfigStatus();
        this.checkConnections();
    }

    public ILDataConnection getConnection() {
        ILDataConnection connection = null;
        switch (this.getConnectionMethod().getOrdinal()) {
            case 0: {
                Property slot = this.getProperty(COMMS_CONNECTIONS_SLOT_NAME);
                if (slot == null) break;
                connection = ((BConnections)this.get(slot)).getTunnelConn();
                break;
            }
            case 1: {
                BConnections connections;
                Property slot = this.getProperty(PROXY_DEVICE_SLOT_NAME);
                if (slot == null) break;
                int deviceId = ((BProxyDeviceRef)this.get(slot)).getProxyDeviceIdEnum().getOrdinal();
                BKnxDevice device = this.getKnxNetwork().getDeviceById(deviceId);
                if (device == null || (connections = (BConnections)device.get(COMMS_CONNECTIONS_SLOT_NAME)) == null) break;
                connection = connections.getTunnelConn();
                break;
            }
            case 2: {
                if (this.getKnxInstallationInstance() == null) break;
                connection = this.getKnxInstallationInstance().getConnection();
            }
        }
        return connection;
    }

    public void checkConnections() {
        try {
            this.updateConfigStatus();
            try {
                Property slot = this.getProperty(COMMS_CONNECTIONS_SLOT_NAME);
                if (slot != null) {
                    ((BConnections)this.get(slot)).checkConnections();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.pingFail(ex.toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.pingFail(ex.toString());
        }
    }

    private void closeDevice() {
        Property slot = this.getProperty(COMMS_CONNECTIONS_SLOT_NAME);
        if (slot != null) {
            ((BConnections)this.get(slot)).closeConnections();
        }
    }

    public InetAddress getDeviceInetAddress() {
        if (this.deviceInetAddress == null) {
            this.setDeviceInetAddress();
        }
        return this.deviceInetAddress;
    }

    private void setDeviceInetAddress() {
        this.updateConfigStatus();
    }

    public void setHardwareAndServicesDIBs(IHardwareAndServicesDIBs dibs) {
        if (this.getDIBs().setHardwareAndServicesDIBs(dibs)) {
            this.setFriendlyName(this.getDIBs().getDeviceInfo().getFriendlyName());
            this.setMacAddress(this.getDIBs().getDeviceInfo().getMacAddress());
        }
    }

    public BKnxInstallation getKnxInstallationInstance() {
        return BKnxInstallation.getKnxInstallationById(this.getKnxInstallation().getKnxInstallationIdEnum().getOrdinal());
    }

    public BKnxNetwork getKnxNetwork() {
        try {
            return (BKnxNetwork)this.getNetwork();
        }
        catch (IllegalStateException ex) {
            if (ex.getCause() == null || !(ex.getCause() instanceof FeatureNotLicensedException)) {
                ex.printStackTrace();
            }
        }
        catch (NotRunningException ex) {
            if (Sys.getStation() != null) {
                for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof BKnxNetwork)) continue;
                    return (BKnxNetwork)parent;
                }
            }
        }
        catch (Throwable t) {
            CatchAll.throwable(t);
        }
        return null;
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        if (!this.isRunning()) {
            return;
        }
        out.startProps();
        out.trTitle((Object)TYPE.getTypeName(), 2);
        out.prop((Object)"deviceInetAddress", (Object)this.deviceInetAddress);
        out.endProps();
    }

    public static void commsTrace(String traceMessage) {
        BKnxNetwork.commsTrace(TYPE, traceMessage);
    }
}

