/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms.frames.parts;

import com.tridiumX.knxnetIp.addresses.BIndividualDeviceAddress;
import com.tridiumX.knxnetIp.comms.KnxInputStream;
import com.tridiumX.knxnetIp.comms.KnxOutputStream;
import com.tridiumX.knxnetIp.comms.frames.parts.ConnectionResponseData;
import com.tridiumX.knxnetIp.knxSpec.BServiceFamilyEnum;
import java.io.IOException;

public final class TunnellingCrd
extends ConnectionResponseData {
    private BIndividualDeviceAddress individualAddress;
    static final BServiceFamilyEnum SERVICE_FAMILY = BServiceFamilyEnum.tunnelling;

    public TunnellingCrd(int length, BServiceFamilyEnum connectionType) {
        super(length, connectionType);
    }

    public TunnellingCrd(BIndividualDeviceAddress individualAddress) {
        super(4, BServiceFamilyEnum.tunnelling);
        this.individualAddress = individualAddress;
    }

    @Override
    protected void fromStream(KnxInputStream in) throws IOException {
        if (this.length != 4) {
            throw new IOException("incorrect structure length for Tunnelling 'Connection Response Data Block'");
        }
        if (!this.connectionType.equals((Object)BServiceFamilyEnum.tunnelling)) {
            throw new IOException("incorrect service type for Tunnelling 'Connection Response Data Block'");
        }
        try {
            this.individualAddress = new BIndividualDeviceAddress(in.readInt());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException(ex.toString());
        }
    }

    @Override
    protected void toOutputStream(KnxOutputStream out) {
        out.writeInt(this.individualAddress.getAddress());
    }

    @Override
    public String getLogString() {
        String s = super.getLogString();
        s = s + ", individualAddress = " + this.individualAddress;
        return s;
    }

    public BIndividualDeviceAddress getIndividualAddress() {
        return this.individualAddress;
    }
}

