/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms.frames.parts;

import com.tridiumX.knxnetIp.comms.KnxInputStream;
import com.tridiumX.knxnetIp.comms.KnxOutputStream;
import com.tridiumX.knxnetIp.knxSpec.BKnxErrorCodesEnum;
import java.io.IOException;

public class ConnectionHeader {
    private int headerSize;
    private int channelId;
    private int sequenceCounter;
    private BKnxErrorCodesEnum status = BKnxErrorCodesEnum.eNoError;

    public ConnectionHeader() {
        this.channelId = 0;
        this.sequenceCounter = 0;
    }

    public ConnectionHeader(KnxInputStream in) throws IOException {
        this.fromStream(in);
    }

    public ConnectionHeader(int channelId, int sequenceNumber) {
        this.channelId = channelId;
        this.sequenceCounter = sequenceNumber;
    }

    public ConnectionHeader(int channelId, int sequenceNumber, BKnxErrorCodesEnum status) {
        this.channelId = channelId;
        this.sequenceCounter = sequenceNumber;
        this.status = status;
    }

    private void fromStream(KnxInputStream in) throws IOException {
        this.headerSize = in.read();
        this.channelId = in.read();
        this.sequenceCounter = in.read();
        this.status = BKnxErrorCodesEnum.make(in.read());
        if (this.headerSize != 4) {
            throw new IOException("WrongTunnellingConnectionHeaderLength - rx = " + this.headerSize + " expected = " + 4);
        }
        if (!this.status.equals((Object)BKnxErrorCodesEnum.eNoError)) {
            throw new IOException("reserved byte in ConnectionHeader is not zero");
        }
    }

    public void toStream(KnxOutputStream out) throws IOException {
        if (this.channelId > 255 || this.channelId < 0) {
            throw new IOException("channel id out of range");
        }
        if (this.sequenceCounter > 255 || this.sequenceCounter < 0) {
            throw new IOException("sequence out of range");
        }
        out.write(4);
        out.write(this.channelId);
        out.write(this.sequenceCounter);
        out.write(this.status.getOrdinal());
    }

    public void toLogString(StringBuffer sb) {
        sb.append("channelId = " + this.channelId);
        sb.append(", sequenceCounter = " + this.sequenceCounter);
        sb.append(", status = " + (Object)((Object)this.status));
    }

    public int getChannelId() {
        return this.channelId;
    }

    public int getSequenceCounter() {
        return this.sequenceCounter;
    }

    public BKnxErrorCodesEnum getStatus() {
        return this.status;
    }
}

