/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms.frames;

import com.tridiumX.knxnetIp.comms.KnxInputStream;
import com.tridiumX.knxnetIp.comms.KnxOutputStream;
import com.tridiumX.knxnetIp.comms.cemi.CemiMessage;
import com.tridiumX.knxnetIp.comms.frames.BKnxIpFrameTypeEnum;
import com.tridiumX.knxnetIp.comms.frames.ConnectedRequestIpFrame;
import com.tridiumX.knxnetIp.comms.frames.EmptyKnxIpFrame;
import java.io.IOException;
import java.util.logging.Level;

public final class RoutingIndication
extends ConnectedRequestIpFrame {
    private CemiMessage cemi;

    public RoutingIndication(EmptyKnxIpFrame inFrame) throws IOException {
        super(inFrame);
        this.fromStream(inFrame.inputStream);
    }

    public RoutingIndication(CemiMessage cemi) {
        this.cemi = cemi;
    }

    @Override
    protected BKnxIpFrameTypeEnum getKnxIpFrameType() {
        return BKnxIpFrameTypeEnum.routingIndication;
    }

    @Override
    protected int getMinimumFrameLength() {
        return 7;
    }

    @Override
    protected void fromStream(KnxInputStream in) throws IOException {
        try {
            this.cemi = new CemiMessage(in);
        }
        catch (Exception ex) {
            if (RoutingIndication.getLogger().isLoggable(Level.FINEST)) {
                ex.printStackTrace();
            }
            throw new IOException(ex.toString());
        }
    }

    @Override
    protected void toStream(KnxOutputStream out) throws IOException {
        this.cemi.toStream(out);
    }

    @Override
    protected void toLogString(StringBuffer sb) {
        sb.append("request = { " + this.cemi + " }");
    }

    @Override
    public CemiMessage getCemi() {
        return this.cemi;
    }
}

