/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms;

import com.tridiumX.knxnetIp.addresses.BGroupAddress;
import com.tridiumX.knxnetIp.addresses.BIndividualDeviceAddress;
import com.tridiumX.knxnetIp.comms.BConnection;
import com.tridiumX.knxnetIp.comms.BConnectionCommsCounters;
import com.tridiumX.knxnetIp.comms.BTunnelConnectionCommsCounters;
import com.tridiumX.knxnetIp.comms.ILDataConnection;
import com.tridiumX.knxnetIp.comms.cemi.CemiApdu;
import com.tridiumX.knxnetIp.comms.cemi.CemiMessage;
import com.tridiumX.knxnetIp.comms.cemi.CemiMessageData;
import com.tridiumX.knxnetIp.comms.cemi.CemiTpdu;
import com.tridiumX.knxnetIp.comms.cemi.GroupValueApdu;
import com.tridiumX.knxnetIp.comms.enums.BSendCemiMessageResultEnum;
import com.tridiumX.knxnetIp.comms.frames.ConnectedAckIpFrame;
import com.tridiumX.knxnetIp.comms.frames.ConnectedRequestIpFrame;
import com.tridiumX.knxnetIp.comms.frames.TunnelAck;
import com.tridiumX.knxnetIp.comms.frames.TunnelRequest;
import com.tridiumX.knxnetIp.comms.frames.parts.ConnectionResponseData;
import com.tridiumX.knxnetIp.comms.frames.parts.TunnellingCrd;
import com.tridiumX.knxnetIp.driver.BKnxDevice;
import com.tridiumX.knxnetIp.knxSpec.BApciCodesEnum;
import com.tridiumX.knxnetIp.knxSpec.BCemiMessageCodesEnum;
import com.tridiumX.knxnetIp.knxSpec.BKnxConnectionTypeEnum;
import com.tridiumX.knxnetIp.knxSpec.BKnxErrorCodesEnum;
import com.tridiumX.knxnetIp.knxSpec.BTpciCodesEnum;
import com.tridiumX.knxnetIp.util.CatchAll;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="individualAddress", type="BIndividualDeviceAddress", defaultValue="new BIndividualDeviceAddress()", flags=3), @NiagaraProperty(name="confirmationTimeout", type="BRelTime", defaultValue="BRelTime.makeSeconds(KnxSpec.DATA_LINK_LAYER_CONFIRMATION_TIMEOUT_SECONDS_DEFAULT)", flags=5, facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.makeSeconds(KnxSpec.DATA_LINK_LAYER_CONFIRMATION_TIMEOUT_SECONDS_MINIMUM))"), @Facet(value="BFacets.make(BFacets.MAX, BRelTime.makeSeconds(KnxSpec.DATA_LINK_LAYER_CONFIRMATION_TIMEOUT_SECONDS_MAXIMUM))")}), @NiagaraProperty(name="commsCounters", type="BConnectionCommsCounters", defaultValue="new BTunnelConnectionCommsCounters()", flags=65540), @NiagaraProperty(name="requestAcknowledgements", type="boolean", defaultValue="true", flags=4)})
public final class BTunnelConnection
extends BConnection
implements ILDataConnection {
    public static final Property individualAddress = BTunnelConnection.newProperty((int)3, (BValue)new BIndividualDeviceAddress(), null);
    public static final Property confirmationTimeout = BTunnelConnection.newProperty((int)5, (BValue)BRelTime.makeSeconds((int)3), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeSeconds((int)60))));
    public static final Property commsCounters = BTunnelConnection.newProperty((int)65540, (BValue)new BTunnelConnectionCommsCounters(), null);
    public static final Property requestAcknowledgements = BTunnelConnection.newProperty((int)4, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BTunnelConnection.class);
    private final Object sendRequestLock = new Object();
    private final Object confirmMonitor = new Object();
    private boolean isConfirmReceived;
    private boolean isConfirmOk;
    private static final Logger logTunnelComms = Logger.getLogger(TYPE.getModule().getModuleName() + ".comms.tunnel");

    @Override
    public BIndividualDeviceAddress getIndividualAddress() {
        return (BIndividualDeviceAddress)this.get(individualAddress);
    }

    public void setIndividualAddress(BIndividualDeviceAddress v) {
        this.set(individualAddress, (BValue)v, null);
    }

    public BRelTime getConfirmationTimeout() {
        return (BRelTime)this.get(confirmationTimeout);
    }

    public void setConfirmationTimeout(BRelTime v) {
        this.set(confirmationTimeout, (BValue)v, null);
    }

    @Override
    public BConnectionCommsCounters getCommsCounters() {
        return (BConnectionCommsCounters)this.get(commsCounters);
    }

    public void setCommsCounters(BConnectionCommsCounters v) {
        this.set(commsCounters, (BValue)v, null);
    }

    public boolean getRequestAcknowledgements() {
        return this.getBoolean(requestAcknowledgements);
    }

    public void setRequestAcknowledgements(boolean v) {
        this.setBoolean(requestAcknowledgements, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connectionClosing() {
        super.connectionClosing();
        try {
            Object object = this.confirmMonitor;
            synchronized (object) {
                this.confirmMonitor.notifyAll();
            }
        }
        catch (Throwable t) {
            CatchAll.throwable(t);
        }
    }

    @Override
    protected void connectionClosed() {
        if (this.device instanceof BKnxDevice) {
            this.getIndividualAddress().setAddress(0);
        }
    }

    @Override
    public ConnectionResponseData getConnectionResponseData() {
        return new TunnellingCrd(this.getIndividualAddress());
    }

    @Override
    protected void handleConnectResponseData(ConnectionResponseData crd) {
        this.setIndividualAddress(((TunnellingCrd)crd).getIndividualAddress());
    }

    @Override
    protected ConnectedRequestIpFrame makeRequestFrame(int sequenceCounter, CemiMessage cemi) {
        return new TunnelRequest(this.getChannelId(), sequenceCounter, cemi);
    }

    @Override
    protected ConnectedAckIpFrame makeAckFrame(int sequenceCounter, BKnxErrorCodesEnum status) {
        return new TunnelAck(this.getChannelId(), sequenceCounter, status);
    }

    @Override
    public BKnxConnectionTypeEnum getTypeCode() {
        return BKnxConnectionTypeEnum.tunnelConnection;
    }

    @Override
    protected int getChannelRequestRetries() {
        return 1;
    }

    @Override
    protected long getChannelAckTimeoutMillis() {
        return 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BSendCemiMessageResultEnum sendRequest(CemiMessage msg) {
        Object object = this.sendRequestLock;
        synchronized (object) {
            return this.sendAckedChannelRequest(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BSendCemiMessageResultEnum sendLDataReadRequest(int hopCount, BGroupAddress destination) {
        Object object = this.sendRequestLock;
        synchronized (object) {
            CemiApdu apdu = GroupValueApdu.make(BApciCodesEnum.A_GroupValue_Read_PDU);
            return this.sendLDataRequest(apdu, hopCount, destination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BSendCemiMessageResultEnum sendLDataWriteRequest(int hopCount, BGroupAddress destination, CemiMessageData msgData) {
        Object object = this.sendRequestLock;
        synchronized (object) {
            CemiApdu apdu = GroupValueApdu.make(BApciCodesEnum.A_GroupValue_Write_PDU, msgData);
            return this.sendLDataRequest(apdu, hopCount, destination);
        }
    }

    private BSendCemiMessageResultEnum sendLDataRequest(CemiApdu apdu, int hopCount, BGroupAddress destination) {
        CemiTpdu tpdu = CemiTpdu.make(BTpciCodesEnum.T_Data_Group_PDU, 0, apdu);
        CemiMessage msg = CemiMessage.make(this.getRequestAcknowledgements(), BCemiMessageCodesEnum.L_Data_req, hopCount, this.getIndividualAddress(), destination, tpdu);
        return this.sendConfirmedChannelRequest(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BSendCemiMessageResultEnum sendConfirmedChannelRequest(CemiMessage req) {
        Object object = this.confirmMonitor;
        synchronized (object) {
            this.isConfirmReceived = false;
            this.isConfirmOk = false;
            if (!this.isConnected()) {
                return BSendCemiMessageResultEnum.notConnected;
            }
            if (this.getMustClose()) {
                return BSendCemiMessageResultEnum.connectionMustClose;
            }
            try {
                BSendCemiMessageResultEnum result = this.sendAckedChannelRequest(req);
                if (result.equals((Object)BSendCemiMessageResultEnum.good)) {
                    if (this.getIncludeInTrace() && BTunnelConnection.getLogger().isLoggable(Level.FINEST)) {
                        BTunnelConnection.getLogger().finest(Thread.currentThread().getName() + " - begin confirm wait");
                    }
                    this.confirmMonitor.wait(this.getConfirmationTimeout().getMillis());
                    if (this.getIncludeInTrace() && BTunnelConnection.getLogger().isLoggable(Level.FINEST)) {
                        BTunnelConnection.getLogger().finest(Thread.currentThread().getName() + " - confirm wait complete, isConfirmReceived?: " + this.isConfirmReceived);
                    }
                    if (this.isConfirmReceived) {
                        if (this.isConfirmOk) {
                            this.getCommsCounters().incCounter(BTunnelConnectionCommsCounters.goodConfirmReceived);
                            return BSendCemiMessageResultEnum.good;
                        }
                        this.getCommsCounters().incCounter(BTunnelConnectionCommsCounters.errorConfirmReceived);
                        return BSendCemiMessageResultEnum.confirmError;
                    }
                    this.getCommsCounters().incCounter(BTunnelConnectionCommsCounters.noConfirmReceived);
                    this.resetTimeOfLastHeartBeat();
                    return BSendCemiMessageResultEnum.confirmTimedOut;
                }
                return result;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                return BSendCemiMessageResultEnum.exception;
            }
            catch (NotRunningException e) {
                e.printStackTrace();
                return BSendCemiMessageResultEnum.exception;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processReceivedRequest(ConnectedRequestIpFrame frame) {
        if (frame == null) {
            BTunnelConnection.getLogger().log(Level.SEVERE, "attempt to process null received Tunnelling frame!");
            return;
        }
        CemiMessage msg = frame.getCemi();
        if (msg == null) {
            BTunnelConnection.getLogger().log(Level.SEVERE, "attempt to process received 'null' Tunnelling message!");
            return;
        }
        if (!msg.isMessageValid()) {
            if (this.getIncludeInTrace() && BTunnelConnection.getLogger().isLoggable(Level.FINE)) {
                BTunnelConnection.getLogger().fine("invalid Tunnelling message received - " + msg);
            }
            return;
        }
        if (msg.getCemiMessageCode().equals((Object)BCemiMessageCodesEnum.L_Data_con)) {
            if (this.getIncludeInTrace() && BTunnelConnection.getLogger().isLoggable(Level.FINE)) {
                BTunnelConnection.getLogger().fine("rx " + msg);
            }
            Object object = this.confirmMonitor;
            synchronized (object) {
                this.isConfirmReceived = true;
                boolean bl = this.isConfirmOk = !msg.isConfirmError();
                if (this.getIncludeInTrace() && BTunnelConnection.getLogger().isLoggable(Level.FINEST)) {
                    BTunnelConnection.getLogger().finest(Thread.currentThread().getName() + " - L_Data_con received inside monitor, isConfirmOk?: " + this.isConfirmOk);
                }
                this.confirmMonitor.notifyAll();
            }
        } else {
            this.processCemiMessage(frame);
        }
    }

    private static Logger getLogger() {
        return logTunnelComms;
    }
}

