/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms;

import com.tridiumX.knxnetIp.comms.BConnectionCommsCounters;
import com.tridiumX.knxnetIp.comms.BEndPoint;
import com.tridiumX.knxnetIp.comms.BKnxHpai;
import com.tridiumX.knxnetIp.comms.BLocalInterface;
import com.tridiumX.knxnetIp.comms.ICommsConnection;
import com.tridiumX.knxnetIp.comms.IConnectionClient;
import com.tridiumX.knxnetIp.comms.IEndPointListener;
import com.tridiumX.knxnetIp.comms.ReceivedFrameWorkers;
import com.tridiumX.knxnetIp.comms.SequenceCounter;
import com.tridiumX.knxnetIp.comms.cemi.CemiMessage;
import com.tridiumX.knxnetIp.comms.enums.BConnectionErrorsEnum;
import com.tridiumX.knxnetIp.comms.enums.BKnxIpFrameValidationResultEnum;
import com.tridiumX.knxnetIp.comms.enums.BSendCemiMessageResultEnum;
import com.tridiumX.knxnetIp.comms.enums.BWrongSequenceNumberReactionEnum;
import com.tridiumX.knxnetIp.comms.frames.BKnxIpFrameTypeEnum;
import com.tridiumX.knxnetIp.comms.frames.ConnectedAckIpFrame;
import com.tridiumX.knxnetIp.comms.frames.ConnectedIpFrame;
import com.tridiumX.knxnetIp.comms.frames.ConnectedRequestIpFrame;
import com.tridiumX.knxnetIp.comms.frames.CoreConnectResponse;
import com.tridiumX.knxnetIp.comms.frames.CoreConnectionStateRequest;
import com.tridiumX.knxnetIp.comms.frames.CoreConnectionStateResponse;
import com.tridiumX.knxnetIp.comms.frames.CoreDisconnectRequest;
import com.tridiumX.knxnetIp.comms.frames.CoreDisconnectResponse;
import com.tridiumX.knxnetIp.comms.frames.KnxIpFrame;
import com.tridiumX.knxnetIp.comms.frames.parts.ConnectionHeader;
import com.tridiumX.knxnetIp.comms.frames.parts.ConnectionResponseData;
import com.tridiumX.knxnetIp.driver.BKnxDevice;
import com.tridiumX.knxnetIp.knxSpec.BKnxConnectionTypeEnum;
import com.tridiumX.knxnetIp.knxSpec.BKnxErrorCodesEnum;
import com.tridiumX.knxnetIp.util.BIIncludeInTrace;
import com.tridiumX.knxnetIp.util.CatchAll;
import com.tridiumX.knxnetIp.util.ThreadPriorityUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceExt;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="maximumReceivedPacketsQueSize", type="int", defaultValue="Constants.DATA_END_POINT_RECEIVE_QUEUE_SIZE_DEFAULT", facets={@Facet(value="BFacets.make(BFacets.MIN, Constants.DATA_END_POINT_RECEIVE_QUEUE_SIZE_MINIMUM)")}), @NiagaraProperty(name="interMessageDelay", type="int", defaultValue="KnxSpec.INTER_MESSAGE_DELAY_MILLIS_DEFAULT", facets={@Facet(value="BFacets.makeInt(BUnit.getUnit(\"millisecond\"), KnxSpec.INTER_MESSAGE_DELAY_MILLIS_MINIMUM, KnxSpec.INTER_MESSAGE_DELAY_MILLIS_MAXIMUM)")}), @NiagaraProperty(name="remoteControlHpai", type="BKnxHpai", defaultValue="new BKnxHpai()", flags=3), @NiagaraProperty(name="dataEndPoint", type="BEndPoint", defaultValue="new BEndPoint()", flags=1), @NiagaraProperty(name="lastConnectError", type="BConnectionErrorsEnum", defaultValue="BConnectionErrorsEnum.DEFAULT", flags=3), @NiagaraProperty(name="channelId", type="int", defaultValue="KnxSpec.NO_CHANNEL_ID", flags=3, facets={@Facet(value="BFacets.makeInt(null, KnxSpec.MIN_CHANNEL_ID, KnxSpec.MAX_CHANNEL_ID, 10)")}), @NiagaraProperty(name="channelStatus", type="String", defaultValue="no connection", flags=3), @NiagaraProperty(name="allwaysSendHeartBeats", type="boolean", defaultValue="true"), @NiagaraProperty(name="wrongSeqNumberReaction", type="BWrongSequenceNumberReactionEnum", defaultValue="BWrongSequenceNumberReactionEnum.sendDisconnectRequest", flags=4), @NiagaraProperty(name="includeInTrace", type="boolean", defaultValue="true", flags=65540)})
public abstract class BConnection
extends BComponent
implements BIIncludeInTrace,
ICommsConnection,
IEndPointListener {
    public static final Property maximumReceivedPacketsQueSize = BConnection.newProperty((int)0, (int)1000, (BFacets)BFacets.make((String)"min", (int)2));
    public static final Property interMessageDelay = BConnection.newProperty((int)0, (int)20, (BFacets)BFacets.makeInt((BUnit)BUnit.getUnit((String)"millisecond"), (int)15, (int)5000));
    public static final Property remoteControlHpai = BConnection.newProperty((int)3, (BValue)new BKnxHpai(), null);
    public static final Property dataEndPoint = BConnection.newProperty((int)1, (BValue)new BEndPoint(), null);
    public static final Property lastConnectError = BConnection.newProperty((int)3, (BValue)BConnectionErrorsEnum.DEFAULT, null);
    public static final Property channelId = BConnection.newProperty((int)3, (int)-1, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)10));
    public static final Property channelStatus = BConnection.newProperty((int)3, (String)"no connection", null);
    public static final Property allwaysSendHeartBeats = BConnection.newProperty((int)0, (boolean)true, null);
    public static final Property wrongSeqNumberReaction = BConnection.newProperty((int)4, (BValue)BWrongSequenceNumberReactionEnum.sendDisconnectRequest, null);
    public static final Property includeInTrace = BConnection.newProperty((int)65540, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BConnection.class);
    private final ReceivedFrameWorkers receivedFrameWorkers = new ReceivedFrameWorkers(this);
    private final AtomicInteger consecutiveBadSeqNo = new AtomicInteger();
    private final Object sendMonitor = new Object();
    private boolean isAckReceived;
    private ConnectionHeader receivedAckHeader;
    private final Object connectionClientsLock = new Object();
    private Vector<IConnectionClient> connectionClients;
    private long timeOfLastHeartBeat;
    protected BDevice device;
    private boolean connected;
    private boolean mustClose;
    private long delayReconnectUntilTicks;
    private final SequenceCounter rxSequenceCounter = new SequenceCounter();
    private final SequenceCounter txSequenceCounter = new SequenceCounter();
    static final Logger log = Logger.getLogger(TYPE.getModule().getModuleName() + ".comms.connection");

    public int getMaximumReceivedPacketsQueSize() {
        return this.getInt(maximumReceivedPacketsQueSize);
    }

    public void setMaximumReceivedPacketsQueSize(int v) {
        this.setInt(maximumReceivedPacketsQueSize, v, null);
    }

    public int getInterMessageDelay() {
        return this.getInt(interMessageDelay);
    }

    public void setInterMessageDelay(int v) {
        this.setInt(interMessageDelay, v, null);
    }

    public BKnxHpai getRemoteControlHpai() {
        return (BKnxHpai)this.get(remoteControlHpai);
    }

    public void setRemoteControlHpai(BKnxHpai v) {
        this.set(remoteControlHpai, (BValue)v, null);
    }

    public BEndPoint getDataEndPoint() {
        return (BEndPoint)this.get(dataEndPoint);
    }

    public void setDataEndPoint(BEndPoint v) {
        this.set(dataEndPoint, (BValue)v, null);
    }

    public BConnectionErrorsEnum getLastConnectError() {
        return (BConnectionErrorsEnum)this.get(lastConnectError);
    }

    public void setLastConnectError(BConnectionErrorsEnum v) {
        this.set(lastConnectError, (BValue)v, null);
    }

    public int getChannelId() {
        return this.getInt(channelId);
    }

    public void setChannelId(int v) {
        this.setInt(channelId, v, null);
    }

    public String getChannelStatus() {
        return this.getString(channelStatus);
    }

    public void setChannelStatus(String v) {
        this.setString(channelStatus, v, null);
    }

    public boolean getAllwaysSendHeartBeats() {
        return this.getBoolean(allwaysSendHeartBeats);
    }

    public void setAllwaysSendHeartBeats(boolean v) {
        this.setBoolean(allwaysSendHeartBeats, v, null);
    }

    public BWrongSequenceNumberReactionEnum getWrongSeqNumberReaction() {
        return (BWrongSequenceNumberReactionEnum)this.get(wrongSeqNumberReaction);
    }

    public void setWrongSeqNumberReaction(BWrongSequenceNumberReactionEnum v) {
        this.set(wrongSeqNumberReaction, (BValue)v, null);
    }

    @Override
    public boolean getIncludeInTrace() {
        return this.getBoolean(includeInTrace);
    }

    @Override
    public void setIncludeInTrace(boolean v) {
        this.setBoolean(includeInTrace, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BDeviceExt;
    }

    public final boolean isChildLegal(BComponent child) {
        return false;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(maximumReceivedPacketsQueSize)) {
            this.getCommsCounters().incCounter(BConnectionCommsCounters.closedBecauseRxPacketQueueSizeChanged);
            this.setMustClose();
        }
    }

    public void spy(SpyWriter out) throws Exception {
        if (!this.isRunning()) {
            return;
        }
        out.startProps();
        out.trTitle((Object)this.getClass().getName(), 2);
        out.prop((Object)"connected", this.connected);
        out.prop((Object)"mustClose", this.mustClose);
        out.prop((Object)"workers", (Object)this.receivedFrameWorkers.spy());
        out.endProps();
    }

    public final boolean isHeartBeatNeeded() {
        return this.timeOfLastHeartBeat + 60000L < Clock.ticks();
    }

    protected final void resetTimeOfLastHeartBeat() {
        this.timeOfLastHeartBeat = 0L;
    }

    protected final void setTimeOfLastHeartBeat() {
        this.timeOfLastHeartBeat = Clock.ticks();
    }

    public final boolean handleConnectResponse(CoreConnectResponse response) throws IOException {
        if (response == null) {
            throw new IllegalArgumentException("handleConnectResponse() called with - response == null");
        }
        int lastRxConnectStatus = response.getStatus();
        if (lastRxConnectStatus == 0) {
            if (response.getCrd().getConnectionType().getOrdinal() != this.getTypeCode().getOrdinal()) {
                throw new IOException("received Connection Type '" + (Object)((Object)response.getCrd().getConnectionType()) + "' does not match the expected '" + (Object)((Object)this.getTypeCode()) + "'");
            }
            if (!response.getHpai().getAddress().equals(this.getDataEndPoint().getRemoteInetAddress())) {
                throw new IOException("received Ip Address  '" + response.getHpai().getAddress() + "' does not match the expected '" + this.getDataEndPoint().getRemoteInetAddress() + "'");
            }
            this.setChannelId(response.getChannelId());
            this.getDataEndPoint().setRemotePort(response.getHpai().getPort());
            this.handleConnectResponseData(response.getCrd());
            this.resetSequenceCounters();
            this.setChannelStatus(BKnxErrorCodesEnum.make(lastRxConnectStatus).getDisplayTag(null));
            return true;
        }
        this.setChannelStatus(BKnxErrorCodesEnum.make(lastRxConnectStatus).getDisplayTag(null));
        return false;
    }

    public final boolean handleConnectionStateRequest(CoreConnectionStateRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("handleDisconnectRequest() called with a NULL request");
        }
        if (!this.isConnected()) {
            return false;
        }
        if (request.getChannelId() != this.getChannelId()) {
            return false;
        }
        this.setTimeOfLastHeartBeat();
        return true;
    }

    public final boolean handleDisconnectRequest(CoreDisconnectRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("handleDisconnectRequest() called with a NULL request");
        }
        if (!this.isConnected() || request.getChannelId() != this.getChannelId()) {
            return false;
        }
        this.mustClose = true;
        this.setConnected(false);
        this.setChannelStatus("DISCONNECT_REQUEST Received");
        this.delayReconnectUntilTicks = Clock.ticks() + 2000L;
        return true;
    }

    public final boolean handleDisconnectResponse(CoreDisconnectResponse response) {
        if (response == null) {
            throw new IllegalArgumentException("handleDisconnectResponse() called with a NULL response");
        }
        if (response.getChannelId() == this.getChannelId()) {
            int lastRxDisconnectStatus = response.getStatus();
            if (lastRxDisconnectStatus == 0) {
                this.setChannelStatus("Disconnected - NO_ERROR");
                return true;
            }
            this.setChannelStatus(BKnxErrorCodesEnum.make(lastRxDisconnectStatus).getDisplayTag(null));
        }
        return false;
    }

    public final boolean handleConnectionStateResponse(CoreConnectionStateResponse response) {
        if (response == null) {
            throw new IllegalArgumentException("handleConnectionStateResponse() called with a NULL response");
        }
        if (!this.isConnected()) {
            return false;
        }
        int channelId = this.getChannelId();
        if (response.getChannelId() != channelId) {
            return false;
        }
        int lastRxConnectionStateStatus = response.getStatus();
        if (lastRxConnectionStateStatus == 0) {
            this.setTimeOfLastHeartBeat();
            return true;
        }
        this.setChannelStatus(BKnxErrorCodesEnum.make(lastRxConnectionStateStatus).getDisplayTag(null));
        this.mustClose = true;
        return false;
    }

    public abstract ConnectionResponseData getConnectionResponseData();

    protected abstract void handleConnectResponseData(ConnectionResponseData var1);

    public void openDataEndPoint(BLocalInterface localInterface, InetAddress remoteIp) throws SocketException {
        this.openDataEndPoint(localInterface, remoteIp, -1, -1);
    }

    public void openDataEndPoint(BLocalInterface localInterface, InetAddress remoteIp, int localPort, int remotePort) throws SocketException {
        if (this.getDataEndPoint().isEndPointOpen()) {
            this.closeDataEndPoint();
        }
        if (localInterface != null) {
            this.getDataEndPoint().openEndPoint(this, localInterface, localInterface.getLocalAddress(), remoteIp, localPort, remotePort);
            if (this.getDataEndPoint().isEndPointOpen()) {
                this.receivedFrameWorkers.start(remoteIp.getHostAddress());
            }
        } else {
            throw new SocketException("No 'Local IP Interface' found for Device in openDataEndPoint().");
        }
    }

    public void closeDataEndPoint() {
        this.receivedFrameWorkers.stop();
        this.getDataEndPoint().closeEndPoint();
    }

    private BDevice getDevice() {
        BComplex parent = this.getParent();
        if (parent instanceof BDeviceExt) {
            return ((BDeviceExt)parent).getDevice();
        }
        return null;
    }

    @Override
    public void receiveFrame(KnxIpFrame frame) {
        this.receivedFrameWorkers.receiveFrame(frame, frameToAck -> this.processRxFrame((KnxIpFrame)frameToAck));
    }

    private void processRxFrame(KnxIpFrame frame) {
        InetAddress srcIp;
        if (!frame.isAcked()) {
            ThreadPriorityUtil.registerThread(this);
        }
        this.getCommsCounters().incCounter(BConnectionCommsCounters.framesReceived);
        if (this.getIncludeInTrace() && BConnection.getLogger().isLoggable(Level.FINE)) {
            BConnection.getLogger().fine("rx frame " + frame.getLogString());
        }
        if (!(srcIp = frame.packet.getAddress()).equals(this.getDataEndPoint().getRemoteInetAddress())) {
            this.getCommsCounters().incCounter(BConnectionCommsCounters.framesReceivedWrongSourceIpAddress);
            if (this.getIncludeInTrace() && BConnection.getLogger().isLoggable(Level.FINE)) {
                BConnection.getLogger().fine(srcIp.getHostAddress() + " does not map to this device " + this.getDataEndPoint().getRemoteInetAddress().getHostAddress());
            }
            return;
        }
        if (!frame.validationResult.equals((Object)BKnxIpFrameValidationResultEnum.packetIsValid)) {
            this.getCommsCounters().incCounter(BConnectionCommsCounters.invalidFramesReceived);
            if (frame.validationResult.getOrdinal() == 3) {
                BConnection.getLogger().log(Level.SEVERE, "Invalid Frame Header Received - " + frame.validationResult.getTag() + " - " + frame.frameHeader.protocolVersion);
            } else {
                BConnection.getLogger().log(Level.SEVERE, "Invalid Frame Header Received - " + frame.validationResult.getTag());
            }
            return;
        }
        if (frame.frameHeader.getServiceType() == this.getTypeCode().getOrdinal()) {
            this.processRxChannelFrame(frame);
        } else if (frame.frameHeader.frameType == BKnxIpFrameTypeEnum.coreConnectionStateResponse) {
            try {
                CoreConnectionStateResponse response = (CoreConnectionStateResponse)BKnxIpFrameTypeEnum.makeTypedFrame(frame);
                BConnection.getLogger().fine("rx " + response.toLogString());
            }
            catch (IOException e) {
                BConnection.getLogger().severe("Malformed connection state response? " + frame.getHexString());
            }
        } else {
            this.getCommsCounters().incCounter(BConnectionCommsCounters.rxWrongServiceTypeFrames);
            if (this.getIncludeInTrace() && BConnection.getLogger().isLoggable(Level.FINE)) {
                BConnection.getLogger().fine("rx " + frame.toLogString() + " - Not Supported on a '" + (Object)((Object)this.getTypeCode()) + "' channel 'Data' EndPoint");
            }
        }
    }

    protected abstract void processReceivedRequest(ConnectedRequestIpFrame var1);

    protected abstract ConnectedRequestIpFrame makeRequestFrame(int var1, CemiMessage var2);

    protected abstract ConnectedAckIpFrame makeAckFrame(int var1, BKnxErrorCodesEnum var2);

    public abstract BKnxConnectionTypeEnum getTypeCode();

    protected abstract int getChannelRequestRetries();

    protected abstract long getChannelAckTimeoutMillis();

    protected abstract void connectionClosed();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BSendCemiMessageResultEnum sendAckedChannelRequest(CemiMessage req) {
        Object object = this.sendMonitor;
        synchronized (object) {
            if (!this.isConnected()) {
                return BSendCemiMessageResultEnum.notConnected;
            }
            if (this.getMustClose()) {
                return BSendCemiMessageResultEnum.connectionMustClose;
            }
            try {
                int count = this.getTxSequenceCounter().get();
                for (int i = 0; i <= this.getChannelRequestRetries(); ++i) {
                    this.isAckReceived = false;
                    this.receivedAckHeader = null;
                    this.sendChannelRequest(req, count);
                    this.sendMonitor.wait(this.getChannelAckTimeoutMillis());
                    if (!this.isAckReceived || this.receivedAckHeader.getSequenceCounter() != count || !this.receivedAckHeader.getStatus().equals((Object)BKnxErrorCodesEnum.eNoError)) continue;
                    this.getTxSequenceCounter().increment();
                    break;
                }
                if (this.isAckReceived && this.receivedAckHeader.getStatus().equals((Object)BKnxErrorCodesEnum.eNoError)) {
                    this.getCommsCounters().incCounter(BConnectionCommsCounters.goodAckReceived);
                    if (!this.getAllwaysSendHeartBeats()) {
                        this.setTimeOfLastHeartBeat();
                    }
                    return BSendCemiMessageResultEnum.good;
                }
                this.setMustClose();
                if (this.isAckReceived) {
                    this.getCommsCounters().incCounter(BConnectionCommsCounters.closedBecauseAckErrorReceived);
                    return BSendCemiMessageResultEnum.ackError;
                }
                this.getCommsCounters().incCounter(BConnectionCommsCounters.closedBecauseNoAckReceived);
                return BSendCemiMessageResultEnum.ackTimedOut;
            }
            catch (IOException e) {
                e.printStackTrace();
                return BSendCemiMessageResultEnum.exception;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                return BSendCemiMessageResultEnum.exception;
            }
            catch (NotRunningException e) {
                e.printStackTrace();
                return BSendCemiMessageResultEnum.exception;
            }
        }
    }

    protected final void sendChannelAck(int sequenceCounter) throws IOException {
        this.sendChannelAck(sequenceCounter, BKnxErrorCodesEnum.eNoError);
    }

    protected final void sendChannelAck(int sequenceCounter, BKnxErrorCodesEnum status) throws IOException {
        if (!this.isConnected()) {
            throw new IOException((Object)((Object)this.getTypeCode()) + " Channel not connected");
        }
        if (this.getMustClose()) {
            throw new IOException((Object)((Object)this.getTypeCode()) + " Channel connection must close");
        }
        try {
            ConnectedAckIpFrame request = this.makeAckFrame(sequenceCounter, status);
            this.getCommsCounters().incCounter(BConnectionCommsCounters.ackFramesSent);
            if (this.getIncludeInTrace() && BConnection.getLogger().isLoggable(Level.FINE)) {
                BConnection.getLogger().fine("tx " + request.toLogString() + KnxIpFrame.getToDeviceLogString(this.getDataEndPoint()));
            }
            this.getDataEndPoint().send(request);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            throw new IOException("unknown host");
        }
    }

    private void sendChannelRequest(CemiMessage cemi, int sequenceCounter) throws IOException {
        if (!this.isConnected()) {
            throw new IOException((Object)((Object)this.getTypeCode()) + " Channel not connected");
        }
        if (this.getMustClose()) {
            throw new IOException((Object)((Object)this.getTypeCode()) + " Channel connection must close");
        }
        try {
            ConnectedRequestIpFrame request = this.makeRequestFrame(sequenceCounter, cemi);
            this.getCommsCounters().incCounter(BConnectionCommsCounters.requestFramesSent);
            if (this.getIncludeInTrace() && BConnection.getLogger().isLoggable(Level.FINE)) {
                BConnection.getLogger().fine("tx " + request.toLogString() + KnxIpFrame.getToDeviceLogString(this.getDataEndPoint()));
            }
            this.getDataEndPoint().transmit(request, (long)this.getInterMessageDelay());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            throw new IOException("unknown host");
        }
    }

    protected final void processRxChannelFrame(KnxIpFrame frame) {
        block22: {
            try {
                ConnectedIpFrame typedFrame = (ConnectedIpFrame)BKnxIpFrameTypeEnum.makeTypedFrame(frame);
                ConnectionHeader connectionHeader = typedFrame.getConnectionHeader();
                if (connectionHeader.getChannelId() != this.getChannelId()) {
                    if (this.getIncludeInTrace() && BConnection.getLogger().isLoggable(Level.FINE)) {
                        if (typedFrame instanceof ConnectedRequestIpFrame) {
                            if (this.getIncludeInTrace() && BConnection.getLogger().isLoggable(Level.FINE)) {
                                BConnection.getLogger().fine("rx " + typedFrame.getLogString() + " with WRONG CHANNEL ID '" + connectionHeader.getChannelId() + "' was expecting '" + this.getChannelId() + "'");
                            }
                        } else if (typedFrame instanceof ConnectedAckIpFrame) {
                            if (this.getIncludeInTrace() && BConnection.getLogger().isLoggable(Level.FINE)) {
                                BConnection.getLogger().fine("rx " + typedFrame.getLogString() + " with WRONG CHANNEL ID '" + connectionHeader.getChannelId() + "' was expecting '" + this.getChannelId() + "'");
                            }
                        } else if (this.getIncludeInTrace() && BConnection.getLogger().isLoggable(Level.FINE)) {
                            BConnection.getLogger().fine("rx UNSUPPORTED " + typedFrame.getLogString() + " with WRONG CHANNEL ID '" + connectionHeader.getChannelId() + "' was expecting '" + this.getChannelId() + "'");
                        }
                    }
                    this.getCommsCounters().incCounter(BConnectionCommsCounters.rxFramesWithWrongChannelId);
                    BConnection.getLogger().log(Level.SEVERE, "rx " + typedFrame.getLogString() + " with WRONG CHANNEL ID '" + connectionHeader.getChannelId() + "' was expecting '" + this.getChannelId() + "'");
                    return;
                }
                if (typedFrame instanceof ConnectedRequestIpFrame) {
                    try {
                        ConnectedRequestIpFrame request = (ConnectedRequestIpFrame)typedFrame;
                        if (this.getIncludeInTrace() && BConnection.getLogger().isLoggable(Level.FINE)) {
                            BConnection.getLogger().fine("rx " + request.toLogString());
                        }
                        if (connectionHeader.getSequenceCounter() == this.getRxSequenceCounter().get()) {
                            this.getCommsCounters().incCounter(BConnectionCommsCounters.rxFramesCorrectSequenceNumber);
                            this.consecutiveBadSeqNo.set(0);
                            this.getRxSequenceCounter().increment();
                            this.processRxChannelRequest(connectionHeader, request);
                            break block22;
                        }
                        if (connectionHeader.getSequenceCounter() == this.getRxSequenceCounter().get() - 1) {
                            this.ackSuspectedDuplicateRxChannelRequest(request, connectionHeader);
                            break block22;
                        }
                        this.handleIncorrectSeqRxChannelRequest(request, connectionHeader);
                    }
                    catch (Exception ex) {
                        BConnection.getLogger().log(Level.SEVERE, "Error processing rx channel request", ex);
                    }
                    break block22;
                }
                if (typedFrame instanceof ConnectedAckIpFrame) {
                    this.getCommsCounters().incCounter(BConnectionCommsCounters.rxAckFrames);
                    try {
                        ConnectedAckIpFrame ack = (ConnectedAckIpFrame)typedFrame;
                        if (this.getIncludeInTrace() && BConnection.getLogger().isLoggable(Level.FINE)) {
                            BConnection.getLogger().fine("rx " + ack.toLogString());
                        }
                        this.processReceivedAck(connectionHeader);
                    }
                    catch (Exception ex) {
                        BConnection.getLogger().log(Level.SEVERE, "Error processing rx ack", ex);
                    }
                } else {
                    this.getCommsCounters().incCounter(BConnectionCommsCounters.rxUnknownChannelSubService);
                    BConnection.getLogger().log(Level.SEVERE, "rx UNSUPPORTED " + typedFrame.getLogString());
                }
            }
            catch (IOException ex) {
                BConnection.getLogger().log(Level.SEVERE, "Error processing rx channel request", ex);
            }
        }
    }

    private void processRxChannelRequest(ConnectionHeader connectionHeader, ConnectedRequestIpFrame request) {
        try {
            this.sendChannelAck(connectionHeader.getSequenceCounter());
            request.setAcked();
            this.receivedFrameWorkers.receiveFrame(request, req -> this.processReceivedRequest((ConnectedRequestIpFrame)req));
        }
        catch (IOException e) {
            BConnection.getLogger().log(Level.SEVERE, "Error acking received frame", e);
        }
    }

    private void ackSuspectedDuplicateRxChannelRequest(ConnectedRequestIpFrame request, ConnectionHeader connectionHeader) {
        this.getCommsCounters().incCounter(BConnectionCommsCounters.rxFramesRepeatedSequenceNumber);
        BConnection.getLogger().info(String.format("incoming seq of %s channel=%s from %s is one less than expected", connectionHeader.getSequenceCounter(), connectionHeader.getChannelId(), request.packet.getAddress().getHostAddress()));
        try {
            this.sendChannelAck(connectionHeader.getSequenceCounter());
        }
        catch (IOException e) {
            BConnection.getLogger().log(Level.SEVERE, "Error acking received frame which is suspected to be a duplicate", e);
        }
    }

    private void handleIncorrectSeqRxChannelRequest(ConnectedRequestIpFrame request, ConnectionHeader connectionHeader) {
        this.getCommsCounters().incCounter(BConnectionCommsCounters.rxFramesWrongSequenceNumber);
        BConnection.getLogger().info(String.format("incoming seq count of %s channel=%s from %s does not equal expected value of %s", connectionHeader.getSequenceCounter(), connectionHeader.getChannelId(), request.packet.getAddress().getHostAddress(), this.getRxSequenceCounter().get()));
        switch (this.getWrongSeqNumberReaction().getOrdinal()) {
            case 0: {
                if (!this.getIncludeInTrace() || !BConnection.getLogger().isLoggable(Level.FINE)) break;
                BConnection.getLogger().fine("Ignoring 'Wrong Incoming Sequence Number.");
                break;
            }
            case 1: {
                if (this.getIncludeInTrace() && BConnection.getLogger().isLoggable(Level.FINE)) {
                    BConnection.getLogger().fine("Sending ???_ACK response with E_SEQUENCE_NUMBER.");
                }
                try {
                    this.sendChannelAck(connectionHeader.getSequenceCounter(), BKnxErrorCodesEnum.eSequenceNumber);
                }
                catch (IOException e) {
                    BConnection.getLogger().log(Level.SEVERE, "Error acking received frame with E_SEQUENCE_NUMBER", e);
                }
                break;
            }
            case 2: {
                this.disconnectDueToInvalidSequence();
                break;
            }
            case 3: {
                this.handleIncorrectSeqRxChannelRequest(request, connectionHeader, false, false);
                break;
            }
            case 4: {
                this.handleIncorrectSeqRxChannelRequest(request, connectionHeader, false, true);
                break;
            }
            case 5: {
                this.handleIncorrectSeqRxChannelRequest(request, connectionHeader, true, false);
                break;
            }
            case 6: {
                this.handleIncorrectSeqRxChannelRequest(request, connectionHeader, true, true);
                break;
            }
            default: {
                BConnection.getLogger().log(Level.SEVERE, "Unknown 'BWrongSequenceNumberReactionEnum' value - \"" + this.getWrongSeqNumberReaction().getOrdinal() + "\"");
            }
        }
    }

    private void handleIncorrectSeqRxChannelRequest(ConnectedRequestIpFrame request, ConnectionHeader connectionHeader, boolean fullLeniency, boolean process) {
        boolean adopt;
        boolean bl = adopt = !fullLeniency && connectionHeader.getSequenceCounter() == this.getRxSequenceCounter().get() + 1 || fullLeniency && this.consecutiveBadSeqNo.incrementAndGet() <= 3;
        if (adopt) {
            int nextSeqNo = connectionHeader.getSequenceCounter() + 1;
            if (this.getIncludeInTrace() && BConnection.getLogger().isLoggable(Level.FINE)) {
                BConnection.getLogger().fine("Assuming a missed packet, will ignore this frame and adopt the new sequence number " + nextSeqNo);
            }
            this.getRxSequenceCounter().set(nextSeqNo);
            if (process) {
                this.processRxChannelRequest(connectionHeader, request);
            }
        } else {
            this.disconnectDueToInvalidSequence();
        }
    }

    private void disconnectDueToInvalidSequence() {
        if (this.getIncludeInTrace() && BConnection.getLogger().isLoggable(Level.FINE)) {
            BConnection.getLogger().fine("Closing the connection due to invalid rx sequence number.");
        }
        this.getCommsCounters().incCounter(BConnectionCommsCounters.closedBecauseDebugRxWrongSequenceNumber);
        this.setMustClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void processReceivedAck(ConnectionHeader header) {
        Object object = this.sendMonitor;
        synchronized (object) {
            this.isAckReceived = true;
            this.receivedAckHeader = header;
            this.sendMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void registerClient(IConnectionClient client) {
        Object object = this.connectionClientsLock;
        synchronized (object) {
            if (this.connectionClients == null) {
                this.connectionClients = new Vector(1, 1);
            }
            if (this.connectionClients != null) {
                if (!this.connectionClients.contains(client)) {
                    this.connectionClients.add(client);
                }
            } else {
                throw new IllegalStateException("connectionClients == null");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unregisterClient(IConnectionClient client) {
        Object object = this.connectionClientsLock;
        synchronized (object) {
            if (this.connectionClients != null) {
                while (this.connectionClients.contains(client)) {
                    this.connectionClients.remove(client);
                }
                if (this.connectionClients.isEmpty()) {
                    this.connectionClients = null;
                    this.getCommsCounters().incCounter(BConnectionCommsCounters.closedBecauseAllClientsUnregistered);
                    this.setMustClose();
                }
            }
        }
    }

    @Override
    public final boolean isConnected() {
        return this.connected;
    }

    public final boolean getMustClose() {
        return this.mustClose;
    }

    public final void setMustClose() {
        if (this.connected) {
            this.mustClose = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isReadyToOpen() {
        if (this.delayReconnectUntilTicks < Clock.ticks()) {
            Object object = this.connectionClientsLock;
            synchronized (object) {
                if (this.connectionClients != null && !this.connectionClients.isEmpty()) {
                    return true;
                }
            }
        }
        return false;
    }

    public final void setConnected(boolean con) {
        this.connected = con;
        if (!this.connected) {
            if (this.device instanceof BKnxDevice) {
                BConnection.getLogger().info("device '" + SlotPath.unescape((String)this.device.getName()) + "' (" + this.getDataEndPoint().getRemoteIPAddress() + ") disconnected from channel " + this.getChannelId());
            }
            this.setChannelId(0);
            this.setChannelStatus("no connection");
            this.connectionClosed();
            this.device = null;
            this.mustClose = false;
        } else {
            IConnectionClient[] clients;
            this.device = this.getDevice();
            if (this.device instanceof BKnxDevice) {
                BConnection.getLogger().info("device '" + SlotPath.unescape((String)this.device.getName()) + "' (" + this.getDataEndPoint().getRemoteIPAddress() + ") is connected on channel " + this.getChannelId());
            }
            for (IConnectionClient client : clients = this.getConnectionClients()) {
                try {
                    client.connectionOpened();
                }
                catch (Throwable t) {
                    CatchAll.throwable(t);
                    if (!(t instanceof ThreadDeath)) continue;
                    throw (ThreadDeath)t;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IConnectionClient[] getConnectionClients() {
        Object object = this.connectionClientsLock;
        synchronized (object) {
            if (this.connectionClients != null) {
                IConnectionClient[] clients = new IConnectionClient[this.connectionClients.size()];
                return this.connectionClients.toArray(clients);
            }
        }
        return new IConnectionClient[0];
    }

    public final void doConnectionClosing() {
        IConnectionClient[] clients;
        this.connectionClosing();
        for (IConnectionClient client : clients = this.getConnectionClients()) {
            try {
                client.connectionClosing();
            }
            catch (Throwable t) {
                CatchAll.throwable(t);
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionClosing() {
        try {
            Object object = this.sendMonitor;
            synchronized (object) {
                this.sendMonitor.notifyAll();
            }
        }
        catch (Throwable t) {
            CatchAll.throwable(t);
        }
    }

    protected final CemiMessage processCemiMessage(ConnectedRequestIpFrame frame) {
        IConnectionClient[] clients;
        for (IConnectionClient client : clients = this.getConnectionClients()) {
            try {
                client.processCemiMessage(this, frame);
            }
            catch (Throwable t) {
                CatchAll.throwable(t);
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
        return null;
    }

    public final SequenceCounter getRxSequenceCounter() {
        return this.rxSequenceCounter;
    }

    public final SequenceCounter getTxSequenceCounter() {
        return this.txSequenceCounter;
    }

    public final void resetSequenceCounters() {
        this.rxSequenceCounter.reset();
        this.txSequenceCounter.reset();
    }

    public abstract BConnectionCommsCounters getCommsCounters();

    private static Logger getLogger() {
        return log;
    }
}

