/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.net;

import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.security.AccessController;
import java.util.logging.Logger;
import javax.baja.net.BHttpProxyService;
import javax.baja.sys.BComponent;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class NiagaraProxyAuthenticator
extends Authenticator {
    private static final Logger log = Logger.getLogger("http.proxy");

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        block4: {
            int port;
            String host;
            BComponent[] proxies;
            block5: {
                log.finest(() -> String.format("password authentication requested from %s(%s):%d", this.getRequestingHost(), this.getRequestingSite(), this.getRequestingPort()));
                if (!"http".equalsIgnoreCase(this.getRequestingProtocol()) && !"https".equalsIgnoreCase(this.getRequestingProtocol()) || Authenticator.RequestorType.PROXY != this.getRequestorType()) break block4;
                try {
                    proxies = Sys.getServices((Type)BHttpProxyService.TYPE);
                }
                catch (ServiceNotFoundException snf) {
                    log.finest("no proxy services configured");
                    return super.getPasswordAuthentication();
                }
                host = this.getRequestingHost();
                port = this.getRequestingPort();
                if (host != null && !host.isEmpty()) break block5;
                InetAddress address = this.getRequestingSite();
                if (address == null) break block4;
                for (BComponent proxy1 : proxies) {
                    BHttpProxyService proxy = (BHttpProxyService)proxy1;
                    InetSocketAddress sockAddr = new InetSocketAddress(proxy.getServer(), proxy.getPort());
                    if (!address.equals(sockAddr.getAddress()) || port != 0 && port != proxy.getPort()) continue;
                    return new PasswordAuthentication(proxy.getUser(), AccessController.doPrivileged(() -> proxy.getPassword().getValue().toCharArray()));
                }
                break block4;
            }
            for (BComponent proxy1 : proxies) {
                BHttpProxyService proxy = (BHttpProxyService)proxy1;
                if (!host.equals(proxy.getServer()) || port != 0 && port != proxy.getPort()) continue;
                return new PasswordAuthentication(proxy.getUser(), AccessController.doPrivileged(() -> proxy.getPassword().getValue().toCharArray()));
            }
        }
        return super.getPasswordAuthentication();
    }
}

