/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.net;

import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.net.BHttpProxyService;

public final class NiagaraHttpProxySelector
extends ProxySelector {
    private static final Logger logger = Logger.getLogger("http.proxy");
    private final ProxySelector fallbackProxySelector;

    public NiagaraHttpProxySelector(ProxySelector fallbackProxySelector) {
        this.fallbackProxySelector = fallbackProxySelector;
    }

    @Override
    public List<Proxy> select(URI uri) {
        try {
            if ("http".equalsIgnoreCase(uri.getScheme()) || "https".equalsIgnoreCase(uri.getScheme())) {
                logger.fine(() -> String.format("select called for %s", uri));
                BHttpProxyService service = BHttpProxyService.get((BHost)new BIpHost(uri.getHost()));
                if (service != null) {
                    logger.fine(() -> String.format("returning proxy host %s", service.getServer()));
                    ArrayList<Proxy> proxies = new ArrayList<Proxy>();
                    proxies.add(service.getProxy());
                    return proxies;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "unable to query a proxy selector", e);
        }
        logger.fine("returning fallback proxy selector response");
        return this.fallbackProxySelector.select(uri);
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        logger.log(Level.SEVERE, String.format("received connectFailed callback for %s for host %s", uri.toString(), sa.toString()), ioe);
        this.fallbackProxySelector.connectFailed(uri, sa, ioe);
    }
}

