/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.net;

import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BPassword;

public final class HttpDigestClient {
    private static final Map<String, String> algorithms = new HashMap<String, String>();
    private final String username;
    private final BPassword password;
    private String method;
    private String uri;
    private String realm;
    private String nonce;
    private String opaque;
    private String algorithm;
    private String qopOptions;
    private String qop;
    private int nc = 0;
    private String cnonce;
    private String digest;

    public HttpDigestClient(String username, BPassword password) {
        this.username = username;
        this.password = password;
    }

    public String getAuthentication(String authenticateHeader, String method, String uri) throws NoSuchAlgorithmException {
        this.method = method;
        this.uri = uri;
        if (authenticateHeader != null && !authenticateHeader.isEmpty()) {
            this.nc = 0;
            this.parseHeader(authenticateHeader);
        } else if (this.nonce == null || this.nonce.isEmpty()) {
            return null;
        }
        this.calculateDigest();
        StringJoiner joiner = new StringJoiner(",");
        joiner.add(String.format("username=\"%s\"", this.username));
        joiner.add(String.format("realm=\"%s\"", this.realm));
        joiner.add(String.format("nonce=\"%s\"", this.nonce));
        joiner.add(String.format("uri=\"%s\"", uri));
        joiner.add(String.format("response=\"%s\"", this.digest));
        if (this.algorithm != null) {
            joiner.add(String.format("algorithm=%s", this.algorithm));
        }
        if (this.qop != null) {
            joiner.add(String.format("cnonce=\"%s\"", this.cnonce));
            joiner.add(String.format("qop=%s", this.qop));
            joiner.add(String.format("nc=%08x", this.nc));
        }
        if (this.opaque != null) {
            joiner.add(String.format("opaque=\"%s\"", this.opaque));
        }
        return "Digest " + joiner.toString();
    }

    private void parseHeader(String authenticateHeader) {
        authenticateHeader = authenticateHeader.trim();
        String attributeString = authenticateHeader.substring(authenticateHeader.indexOf(32) + 1);
        String[] attributesArray = attributeString.split(",");
        HashMap<String, String> attributesMap = new HashMap<String, String>();
        for (String attribute : attributesArray) {
            String key = attribute.substring(0, attribute.indexOf(61)).trim();
            String value = attribute.substring(attribute.indexOf(61) + 1).trim();
            attributesMap.put(key, value);
        }
        this.realm = TextUtil.unquote((String)((String)attributesMap.get("realm")));
        this.nonce = TextUtil.unquote((String)((String)attributesMap.get("nonce")));
        this.opaque = TextUtil.unquote((String)((String)attributesMap.get("opaque")));
        this.algorithm = (String)attributesMap.get("algorithm");
        this.qopOptions = TextUtil.unquote((String)((String)attributesMap.get("qop")));
    }

    private void calculateDigest() throws NoSuchAlgorithmException {
        ++this.nc;
        MessageDigest digest = null;
        String digestAlgorithm = this.algorithm != null ? this.algorithm.toUpperCase() : "MD5";
        if (!algorithms.containsKey(digestAlgorithm)) {
            throw new UnsupportedOperationException("Unsupported algorithm: " + digestAlgorithm);
        }
        digest = MessageDigest.getInstance(algorithms.get(digestAlgorithm));
        byte[] cnonceBytes = new byte[16];
        SecureRandom random = new SecureRandom();
        random.nextBytes(cnonceBytes);
        this.cnonce = ByteArrayUtil.toHexString((byte[])cnonceBytes);
        String password = AccessController.doPrivileged(() -> ((BPassword)this.password).getValue());
        String a1 = this.username + ':' + this.realm + ':' + password;
        if (this.qopOptions != null) {
            String[] qopArray;
            for (String qopOption : qopArray = this.qopOptions.split(",")) {
                if (!"auth".equalsIgnoreCase(qopOption.trim())) continue;
                this.qop = "auth";
            }
            if (this.qop == null) {
                throw new UnsupportedOperationException(String.format("Unsupported qop options '%s'. Only 'auth' supported.", this.qopOptions));
            }
        }
        String a2 = this.method + ':' + this.uri;
        String a1Digest = ByteArrayUtil.toHexString((byte[])digest.digest(a1.getBytes(StandardCharsets.UTF_8)));
        String a2Digest = ByteArrayUtil.toHexString((byte[])digest.digest(a2.getBytes(StandardCharsets.UTF_8)));
        String ncString = String.format("%08x", this.nc);
        String message = null;
        message = this.qop != null ? a1Digest + ':' + this.nonce + ':' + ncString + ':' + this.cnonce + ':' + this.qop + ':' + a2Digest : a1Digest + ':' + this.nonce + ':' + a2Digest;
        this.digest = ByteArrayUtil.toHexString((byte[])digest.digest(message.getBytes(StandardCharsets.UTF_8)));
    }

    static {
        algorithms.put("MD5", "MD5");
        algorithms.put("SHA-256", "SHA-256");
        algorithms.put("SHA-512-256", "SHA-512/256");
        algorithms.put("SHA-512", "SHA-512");
    }
}

