/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.maxpro.util;

import com.tridium.maxpro.nvr.BMaxproNvr;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.fox.BFoxProxySession;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;

public class Helper {
    public static final Logger helperLog = Logger.getLogger("maxpro.Helper");

    public static String getPasswordString(BMaxproNvr nvr, String RPCMethodCall) throws Exception {
        BISession session = null;
        try {
            session = nvr.getSession();
            if (session instanceof BLocalHost) {
                return nvr.getPasswordRpc(session.getSessionContext());
            }
            if (session instanceof BFoxProxySession) {
                try {
                    Optional passwordValue = ((BFoxProxySession)session).rpc(nvr.getNavOrd(), RPCMethodCall, new Object[0]);
                    return (String)passwordValue.get();
                }
                catch (Exception e) {
                    Optional passwordValue = ((BFoxProxySession)session).rpc(nvr.getSlotPathOrd(), RPCMethodCall, new Object[0]);
                    return (String)passwordValue.get();
                }
            }
            throw new Exception("Failed to make remote rpc call");
        }
        catch (Exception ex) {
            helperLog.log(Level.SEVERE, "Failed to make remote rpc call", ex);
            throw ex;
        }
    }
}

