/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.maxpro.messages;

import com.tridium.maxpro.camera.BMaxproCamera;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.rtsp.RtspConnection;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.LocalizableRuntimeException;

public class MaxproRtspVideoStreamRequest
extends NHttpRequest {
    private static final Logger log = Logger.getLogger("maxpro.MaxproRtspVideoStreamRequest");
    BMaxproCamera camera;
    BPlaybackParams playbackParams;
    public RtspConnection videoConnection;
    protected IVideoDestination videoDestination;
    protected BIVideoSource videoSource;

    public MaxproRtspVideoStreamRequest(BIpAddress ipaddress, BMaxproCamera camera, BPlaybackParams playbackParams) {
        super(ipaddress);
        this.camera = camera;
        this.playbackParams = playbackParams;
    }

    public int getResponseTimeOut() {
        return 30000;
    }

    public int getRetryCount() {
        return 0;
    }

    public String getMethod() {
        return "GET";
    }

    public String getUri() {
        if (this.camera.getUseCustomRtspUrl()) {
            return this.camera.getCustomRtspStreamUrl();
        }
        return this.camera.getRtspStreamUrl();
    }

    public boolean processRtspStream(InputStream readStream) {
        return false;
    }

    public IVideoStream makeVideoStream() {
        try {
            if (this.videoConnection != null) {
                this.videoConnection.stop();
                this.videoConnection = null;
            }
            if (this.getUri() != "" && this.camera.getControlPort() != 0 && this.camera.getDataPort() != 0) {
                this.videoConnection = new RtspConnection(this.getUri(), this.camera.getControlPort(), this.camera.getDataPort(), this.camera.getUseTcpTransport());
            }
            if (this.videoConnection == null) {
                throw new LocalizableRuntimeException("maxpro", "Please fill all the credentials");
            }
            this.videoConnection.connect(this.getParameterString());
            this.videoConnection.play();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.ALL)) {
                log.log(Level.SEVERE, "Exception in makeVideoStream()", e);
            }
            return null;
        }
        return new IVideoStream(){

            public void closeVideoStream() throws IOException {
                try {
                    MaxproRtspVideoStreamRequest.this.camera.closeStream(MaxproRtspVideoStreamRequest.this.camera.getRtspStreadId());
                    if (MaxproRtspVideoStreamRequest.this.videoConnection != null) {
                        MaxproRtspVideoStreamRequest.this.videoConnection.stop();
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Failed to close video stream", e);
                    return;
                }
            }

            public InputStream getInputStream() {
                try {
                    return MaxproRtspVideoStreamRequest.this.videoConnection.getInputStream();
                }
                catch (IOException ioe) {
                    log.log(Level.SEVERE, "Failed to get video input stream", ioe);
                    throw new BajaRuntimeException((Throwable)ioe);
                }
            }

            public BPlaybackParams getPlaybackParams() {
                return MaxproRtspVideoStreamRequest.this.playbackParams;
            }
        };
    }

    public void setPlaybackParams(BPlaybackParams playbackParams) {
        this.playbackParams = playbackParams;
    }

    public void setVideoDestination(IVideoDestination videoDestination) {
        this.videoDestination = videoDestination;
    }

    public IVideoDestination getVideoDestination() {
        return this.videoDestination;
    }

    public BIVideoSource getVideoSource() {
        return this.videoSource;
    }

    public void setVideoSource(BIVideoSource videoSource) {
        this.videoSource = videoSource;
    }

    public String getParameterString() {
        return "";
    }
}

