/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.maxpro.camera;

import com.tridium.driver.util.DrUtil;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.maxpro.BMaxproNetwork;
import com.tridium.maxpro.camera.BMaxproCameraDeviceId;
import com.tridium.maxpro.datatypes.BMaxproIpAddress;
import com.tridium.maxpro.datatypes.BMaxproPanTiltZoomSettings;
import com.tridium.maxpro.enums.BMaxproEventTypesEnum;
import com.tridium.maxpro.enums.BMaxproNormalSpeedEnum;
import com.tridium.maxpro.event.BMaxproEventCameraExt;
import com.tridium.maxpro.event.BMaxproEventProxyExt;
import com.tridium.maxpro.event.BMaxproVideoEventRecall;
import com.tridium.maxpro.messages.MaxproRtspVideoStreamRequest;
import com.tridium.maxpro.nvr.BMaxproNvr;
import com.tridium.maxpro.util.Helper;
import com.tridium.maxpro.util.MaxproHttpUtil;
import com.tridium.ndriver.comm.http.HttpComm;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.comm.http.NHttpResponse;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.nvideo.camera.BVideoCamera;
import com.tridium.nvideo.event.BVideoEventStatus;
import com.tridium.videoDriver.alarm.BIVideoAlarmRecorder;
import com.tridium.videoDriver.enums.BPlaybackTypeEnum;
import com.tridium.videoDriver.enums.BVideoPanTiltEnum;
import com.tridium.videoDriver.enums.BVideoZoomEnum;
import com.tridium.videoDriver.event.BIVideoEventProvider;
import com.tridium.videoDriver.event.BVideoEvent;
import com.tridium.videoDriver.event.BVideoEventRecall;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.IVideoStream;
import com.tridium.videoDriver.videoStream.VideoStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BSourceState;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BPassword;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import org.baja.ffmpeg.enums.BCodecIdEnum;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="normalSpeed", type="BMaxproNormalSpeedEnum", defaultValue="BMaxproNormalSpeedEnum.Speed_1", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT_UNSEEN,sf)")}), @NiagaraProperty(name="videoDeviceId", type="BMaxproCameraDeviceId", defaultValue="new BMaxproCameraDeviceId()", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)")}, override=true), @NiagaraProperty(name="fastSpeed", type="int", defaultValue="4", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT_UNSEEN,sf)")}), @NiagaraProperty(name="events", type="BPointDeviceExt", defaultValue="new BMaxproEventCameraExt()"), @NiagaraProperty(name="eventRecaller", type="BVideoEventRecall", defaultValue="new BMaxproVideoEventRecall()", flags=6), @NiagaraProperty(name="compressionCodec", type="BCodecIdEnum", defaultValue="BCodecIdEnum.ffmpeg_CODEC_ID_H264", facets={@Facet(value="BCodecIdEnum.makeFfmpegCodecFacets()")}), @NiagaraProperty(name="panTiltZoomSettings", type="BMaxproPanTiltZoomSettings", defaultValue="new BMaxproPanTiltZoomSettings()"), @NiagaraProperty(name="presetText", type="BEnumRange", defaultValue="BEnumRange.DEFAULT"), @NiagaraProperty(name="isRecording", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="useRtspStream", type="boolean", defaultValue="false", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)")}), @NiagaraProperty(name="rtspStreamUrl", type="String", defaultValue="", flags=1), @NiagaraProperty(name="useCustomRtspUrl", type="boolean", defaultValue="false"), @NiagaraProperty(name="customRtspStreamUrl", type="String", defaultValue=""), @NiagaraProperty(name="controlPort", type="int", defaultValue="554"), @NiagaraProperty(name="dataPort", type="int", defaultValue="9000"), @NiagaraProperty(name="useTcpTransport", type="boolean", defaultValue="false", flags=5)})
@NiagaraActions(value={@NiagaraAction(name="moveToPreset", parameterType="BValue", defaultValue="BDynamicEnum.make(0,(BEnumRange) presetText.getDefaultValue())", flags=20, override=true), @NiagaraAction(name="storePreset", parameterType="BValue", defaultValue="BDynamicEnum.make(0,(BEnumRange) presetText.getDefaultValue())", flags=20, override=true)})
public class BMaxproCamera
extends BVideoCamera
implements BIVideoAlarmRecorder,
BIVideoEventProvider {
    private static BFacets sf = BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)15));
    @Generated
    public static final Property normalSpeed = BMaxproCamera.newProperty((int)0, (BValue)BMaxproNormalSpeedEnum.Speed_1, (BFacets)SfUtil.incl((String)"ed.un", (BFacets)sf));
    @Generated
    public static final Property videoDeviceId = BMaxproCamera.newProperty((int)0, (BValue)new BMaxproCameraDeviceId(), (BFacets)SfUtil.incl((String)"ed"));
    @Generated
    public static final Property fastSpeed = BMaxproCamera.newProperty((int)0, (int)4, (BFacets)SfUtil.incl((String)"ed.un", (BFacets)sf));
    @Generated
    public static final Property events = BMaxproCamera.newProperty((int)0, (BValue)new BMaxproEventCameraExt(), null);
    @Generated
    public static final Property eventRecaller = BMaxproCamera.newProperty((int)6, (BValue)new BMaxproVideoEventRecall(), null);
    @Generated
    public static final Property compressionCodec = BMaxproCamera.newProperty((int)0, (BValue)BCodecIdEnum.ffmpeg_CODEC_ID_H264, (BFacets)BCodecIdEnum.makeFfmpegCodecFacets());
    @Generated
    public static final Property panTiltZoomSettings = BMaxproCamera.newProperty((int)0, (BValue)new BMaxproPanTiltZoomSettings(), null);
    @Generated
    public static final Property presetText = BMaxproCamera.newProperty((int)0, (BValue)BEnumRange.DEFAULT, null);
    @Generated
    public static final Property isRecording = BMaxproCamera.newProperty((int)4, (boolean)false, null);
    @Generated
    public static final Property useRtspStream = BMaxproCamera.newProperty((int)0, (boolean)false, (BFacets)SfUtil.incl((String)"ed"));
    @Generated
    public static final Property rtspStreamUrl = BMaxproCamera.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property useCustomRtspUrl = BMaxproCamera.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property customRtspStreamUrl = BMaxproCamera.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property controlPort = BMaxproCamera.newProperty((int)0, (int)554, null);
    @Generated
    public static final Property dataPort = BMaxproCamera.newProperty((int)0, (int)9000, null);
    @Generated
    public static final Property useTcpTransport = BMaxproCamera.newProperty((int)5, (boolean)false, null);
    @Generated
    public static final Action moveToPreset = BMaxproCamera.newAction((int)20, (BValue)BDynamicEnum.make((int)0, (BEnumRange)((BEnumRange)presetText.getDefaultValue())), null);
    @Generated
    public static final Action storePreset = BMaxproCamera.newAction((int)20, (BValue)BDynamicEnum.make((int)0, (BEnumRange)((BEnumRange)presetText.getDefaultValue())), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BMaxproCamera.class);
    private boolean isStreaming = false;
    private String rtspStreamId = "";
    public Logger logger = Logger.getLogger(BMaxproCamera.class.getName());

    @Generated
    public BMaxproNormalSpeedEnum getNormalSpeed() {
        return (BMaxproNormalSpeedEnum)this.get(normalSpeed);
    }

    @Generated
    public void setNormalSpeed(BMaxproNormalSpeedEnum v) {
        this.set(normalSpeed, (BValue)v, null);
    }

    @Generated
    public int getFastSpeed() {
        return this.getInt(fastSpeed);
    }

    @Generated
    public void setFastSpeed(int v) {
        this.setInt(fastSpeed, v, null);
    }

    @Generated
    public BPointDeviceExt getEvents() {
        return (BPointDeviceExt)this.get(events);
    }

    @Generated
    public void setEvents(BPointDeviceExt v) {
        this.set(events, (BValue)v, null);
    }

    @Generated
    public BVideoEventRecall getEventRecaller() {
        return (BVideoEventRecall)this.get(eventRecaller);
    }

    @Generated
    public void setEventRecaller(BVideoEventRecall v) {
        this.set(eventRecaller, (BValue)v, null);
    }

    @Generated
    public BCodecIdEnum getCompressionCodec() {
        return (BCodecIdEnum)this.get(compressionCodec);
    }

    @Generated
    public void setCompressionCodec(BCodecIdEnum v) {
        this.set(compressionCodec, (BValue)v, null);
    }

    @Generated
    public BMaxproPanTiltZoomSettings getPanTiltZoomSettings() {
        return (BMaxproPanTiltZoomSettings)this.get(panTiltZoomSettings);
    }

    @Generated
    public void setPanTiltZoomSettings(BMaxproPanTiltZoomSettings v) {
        this.set(panTiltZoomSettings, (BValue)v, null);
    }

    @Generated
    public BEnumRange getPresetText() {
        return (BEnumRange)this.get(presetText);
    }

    @Generated
    public void setPresetText(BEnumRange v) {
        this.set(presetText, (BValue)v, null);
    }

    @Generated
    public boolean getIsRecording() {
        return this.getBoolean(isRecording);
    }

    @Generated
    public void setIsRecording(boolean v) {
        this.setBoolean(isRecording, v, null);
    }

    @Generated
    public boolean getUseRtspStream() {
        return this.getBoolean(useRtspStream);
    }

    @Generated
    public void setUseRtspStream(boolean v) {
        this.setBoolean(useRtspStream, v, null);
    }

    @Generated
    public String getRtspStreamUrl() {
        return this.getString(rtspStreamUrl);
    }

    @Generated
    public void setRtspStreamUrl(String v) {
        this.setString(rtspStreamUrl, v, null);
    }

    @Generated
    public boolean getUseCustomRtspUrl() {
        return this.getBoolean(useCustomRtspUrl);
    }

    @Generated
    public void setUseCustomRtspUrl(boolean v) {
        this.setBoolean(useCustomRtspUrl, v, null);
    }

    @Generated
    public String getCustomRtspStreamUrl() {
        return this.getString(customRtspStreamUrl);
    }

    @Generated
    public void setCustomRtspStreamUrl(String v) {
        this.setString(customRtspStreamUrl, v, null);
    }

    @Generated
    public int getControlPort() {
        return this.getInt(controlPort);
    }

    @Generated
    public void setControlPort(int v) {
        this.setInt(controlPort, v, null);
    }

    @Generated
    public int getDataPort() {
        return this.getInt(dataPort);
    }

    @Generated
    public void setDataPort(int v) {
        this.setInt(dataPort, v, null);
    }

    @Generated
    public boolean getUseTcpTransport() {
        return this.getBoolean(useTcpTransport);
    }

    @Generated
    public void setUseTcpTransport(boolean v) {
        this.setBoolean(useTcpTransport, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void videoCameraStarted() throws Exception {
        String cameraLimitFault = (String)this.getNetwork().fw(501, (Object)"camera.limit", null, null, null);
        if (cameraLimitFault != null) {
            this.configFatal(cameraLimitFault);
            return;
        }
        BEnumRange range = this.getPresetText();
        int presetLength = 255;
        int[] nordinals = new int[presetLength];
        String[] strtags = new String[presetLength];
        for (int i = 1; i <= presetLength; ++i) {
            if (!range.get(i).getTag().startsWith("Preset") && !range.get(i).getTag().equalsIgnoreCase("" + i)) {
                nordinals[i - 1] = i;
                strtags[i - 1] = range.get(i).getTag();
                continue;
            }
            nordinals[i - 1] = i;
            strtags[i - 1] = "Preset" + i;
        }
        this.setPresetText(BEnumRange.make((int[])nordinals, (String[])strtags));
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(moveToPreset) || action.equals(storePreset)) {
            return BDynamicEnum.make((BEnumRange)this.getPresetText());
        }
        return super.getActionParameterDefault(action);
    }

    public void doPing() throws Exception {
        try {
            int nCameraId = ((BMaxproCameraDeviceId)this.getVideoDeviceId()).getCameraId();
            if (!MaxproHttpUtil.getCameraState(this.hcomm(), (BMaxproNvr)this.getDvr(), nCameraId)) {
                throw new Exception("No Ping Response for Camera with CameraId : " + nCameraId);
            }
            this.pingOk();
        }
        catch (Exception e) {
            this.pingFail(e.getLocalizedMessage());
        }
    }

    public Type getNetworkType() {
        return BMaxproNetwork.TYPE;
    }

    public Action getMoveToPresetAction() {
        return moveToPreset;
    }

    public Action getStorePresetAction() {
        return storePreset;
    }

    public BAbsTime getCameraTime() {
        try {
            return BAbsTime.now();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void onMove(BVideoPanTiltEnum panTiltAction) {
        if (panTiltAction != BVideoPanTiltEnum.none) {
            try {
                int[] pantilt = MaxproHttpUtil.getPanTiltParams(this.getPanTiltZoomSettings(), panTiltAction);
                String uri = "/UVISOM/ISOM/DeviceMgmt/Cameras/" + ((BMaxproCameraDeviceId)this.getVideoDeviceId()).getCameraId() + "/ptz/discrete/start";
                String bufdata = "{\"panValue\":" + pantilt[0] + ",\"tiltValue\":" + pantilt[1] + "}";
                this.sendPtzCommand(uri, bufdata);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to Plan tilt :" + this.getDisplayName(null), e);
            }
        }
    }

    public void onZoom(BVideoZoomEnum zoomAction) {
        if (zoomAction != BVideoZoomEnum.none) {
            try {
                int zoomIndex = MaxproHttpUtil.getZoomParams(this.getPanTiltZoomSettings(), zoomAction);
                String uri = "/UVISOM/ISOM/DeviceMgmt/Cameras/" + ((BMaxproCameraDeviceId)this.getVideoDeviceId()).getCameraId() + "/ptz/discrete/start";
                String bufdata = "{\"zoomValue\":" + zoomIndex + "}";
                this.sendPtzCommand(uri, bufdata);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to zoom:" + this.getDisplayName(null), e);
            }
        }
    }

    public void doMoveToPreset(BValue presetPosition) {
        try {
            int presetId = ((BDynamicEnum)presetPosition).getOrdinal();
            String uri = "/UVISOM/ISOM/DeviceMgmt/Cameras/" + ((BMaxproCameraDeviceId)this.getVideoDeviceId()).getCameraId() + "/presets/callPreset";
            String bufdata = "{\"id\":" + presetId + "}";
            this.sendPtzCommand(uri, bufdata);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to call preset:" + this.getDisplayName(null), e);
        }
    }

    public void doStorePreset(BValue presetPosition) {
        String presetName = null;
        try {
            int presetId = ((BDynamicEnum)presetPosition).getOrdinal();
            presetName = ((BDynamicEnum)presetPosition).getTag();
            String uri = "/UVISOM/ISOM/DeviceMgmt/Cameras/" + ((BMaxproCameraDeviceId)this.getVideoDeviceId()).getCameraId() + "/presets/setPreset";
            String bufdata = "{\"id\":\"" + presetId + "\",\"name\":\"" + presetName + "\"}";
            this.sendPtzCommand(uri, bufdata);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to set preset " + presetName + " on " + this.getDisplayName(null), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendPtzCommand(String uri, String bufdata) throws Exception {
        String meth = "PUT";
        NHttpRequest rqst = new NHttpRequest(this.httpAddress(), meth, uri);
        rqst.setResponseTimeOut(3000);
        rqst.addBasicAuthorization(this.getMaxproDvr().getCredentials().getUsername(), Helper.getPasswordString(this.getMaxproDvr(), "getPasswordRpc"));
        rqst.setData(bufdata);
        rqst.addHeader("Accept", "*/*");
        rqst.addHeader("Accept-Language", "en-US");
        rqst.addHeader("Content-Length", "" + bufdata.length());
        rqst.addHeader("Accept-Encoding", "identity");
        rqst.addHeader("LocalAccess", "1");
        rqst.addHeader("Content-Type", "application/json");
        rqst.addHeader("Connection", "Keep-Alive");
        rqst.addHeader("Cache-Control", "no-cache");
        BMaxproCamera bMaxproCamera = this;
        synchronized (bMaxproCamera) {
            this.hcomm().sendRequest(rqst);
        }
    }

    @NiagaraRpc(permissions="R", transports={@Transport(type=TransportType.box)})
    public Map<String, String> getConnectionInfo(Context ctx) throws Exception {
        BUser user;
        NiagaraBasicPermission maxProPermission = new NiagaraBasicPermission("MANAGE_MAX_PRO");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)maxProPermission);
        }
        if ((user = BUser.getCurrentAuthenticatedUser()) == null || ctx == null || !ctx.getUser().getUsername().equals(user.getUsername())) {
            throw new SecurityException();
        }
        boolean isSecure = ctx.getFacets().getb("isSecure", false);
        if (!isSecure) {
            throw new Exception("Connection Must be over Https");
        }
        BMaxproNvr nvr = this.getMaxproDvr();
        String username = nvr.getCredentials().getUsername();
        String password = AccessController.doPrivileged(() -> ((BPassword)nvr.getCredentials().getPassword()).getValue());
        BMaxproIpAddress address = (BMaxproIpAddress)nvr.getAddress();
        String host = address.getIpAddress();
        int port = address.getHttpPort();
        int webSocketPort = address.getWebSocketPort();
        int cameraId = ((BMaxproCameraDeviceId)this.getVideoDeviceId()).getCameraId();
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("username", username);
        response.put("password", password);
        response.put("host", host);
        response.put("port", String.valueOf(port));
        response.put("webSocketPort", String.valueOf(webSocketPort));
        response.put("cameraId", String.valueOf(cameraId));
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRecordingAlarm(BAlarmRecord alarmRecord) {
        block9: {
            try {
                if (alarmRecord.getSourceState() != BSourceState.normal) {
                    String uri = "/UVISOM/ISOM/DeviceMgmt/Cameras/" + ((BMaxproCameraDeviceId)this.getVideoDeviceId()).getCameraId() + "/recordingState/user/start";
                    BMaxproCamera bMaxproCamera = this;
                    synchronized (bMaxproCamera) {
                        MaxproHttpUtil.put(this.hcomm(), this.httpAddress(), uri, this.getMaxproDvr(), "{}");
                    }
                    this.setIsRecording(true);
                    break block9;
                }
                if (!this.getIsRecording()) break block9;
                String uri = "/UVISOM/ISOM/DeviceMgmt/Cameras/" + ((BMaxproCameraDeviceId)this.getVideoDeviceId()).getCameraId() + "/recordingState/user/stop";
                BMaxproCamera bMaxproCamera = this;
                synchronized (bMaxproCamera) {
                    MaxproHttpUtil.put(this.hcomm(), this.httpAddress(), uri, this.getMaxproDvr(), "{}");
                }
                this.setIsRecording(false);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Fail to start/stop Recording Alarms " + this.getDisplayName(null), e);
            }
        }
    }

    public void streamToDestination(BPlaybackParams playbackParams, IVideoDestination videoDestination) {
        try {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("MaxproCamera -> streamtoDestination is called for streaming....");
            }
            if (playbackParams.getPlaybackType() == BPlaybackTypeEnum.live && this.getUseRtspStream()) {
                this.rtspStreamId = "";
                String uri = "/UVISOM/ISOM/VideoMgmt/Media/Streams/Config";
                String strdata = "{\"identifiers\": {},\"relation\": [{\"name\": \"StreamRetrievedFromCamera\",\"entityID\": \"" + this.getCameraNbr(this) + "\"}],\"protocol\": \"RTSP/TCP\",\"retrievalType\": \"Live\"}";
                NHttpResponse rsp = MaxproHttpUtil.post(this.hcomm(), this.httpAddress(), uri, (BMaxproNvr)this.getDvr(), strdata);
                JSONObject jsonObject = new JSONObject(new String(rsp.getData()));
                String streamUrl = JSONUtil.getString((JSONObject)jsonObject.getJSONArray("extension").getJSONObject(0), (String)"streamURL");
                streamUrl = streamUrl.substring(7, streamUrl.length());
                this.rtspStreamId = JSONUtil.getString((JSONObject)jsonObject, (String)"id");
                this.setRtspStreamUrl(streamUrl);
                MaxproRtspVideoStreamRequest videoReq = new MaxproRtspVideoStreamRequest(this.httpAddress(), this, playbackParams);
                videoReq.setVideoSource((BIVideoSource)this);
                videoReq.setVideoDestination(videoDestination);
                videoReq.setPlaybackParams(playbackParams);
                videoDestination.receiveVideoStream(videoReq.makeVideoStream());
            } else {
                MaxproVideoStream ivs = new MaxproVideoStream();
                ivs.setPlaybackParams(playbackParams);
                if (ivs != null) {
                    videoDestination.receiveVideoStream((IVideoStream)ivs);
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Fail to stream video " + this.getDisplayName(null), e);
        }
    }

    public int getCameraNbr(BMaxproCamera cam) {
        BMaxproCameraDeviceId deviceId = (BMaxproCameraDeviceId)cam.getVideoDeviceId();
        return deviceId.getCameraId();
    }

    public void closeStream(String streamId) {
        try {
            if (!streamId.equalsIgnoreCase("")) {
                String uri = "/UVISOM/ISOM/VideoMgmt/Media/Streams/" + streamId + "/stop";
                MaxproHttpUtil.put(this.hcomm(), this.httpAddress(), uri, this.getMaxproDvr(), "");
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Maxpro Camera -> Video Stream CLOSED for stream id : " + streamId);
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to stop video stream:" + this.getDisplayName(null), e);
        }
    }

    public void initPlaybackParams(BPlaybackParams playbackParams, IVideoSession videoSession) {
    }

    public BIpAddress httpAddress() {
        BMaxproNvr dvr = (BMaxproNvr)this.getDvr();
        return dvr.httpAddress();
    }

    public BMaxproNvr getMaxproDvr() {
        return (BMaxproNvr)DrUtil.getParent((BComplex)this, (Type)BMaxproNvr.TYPE);
    }

    public HttpComm hcomm() throws Exception {
        return ((BMaxproNetwork)this.vnetwork()).hcomm();
    }

    public boolean getIsStreaming() {
        return this.isStreaming;
    }

    public void setIsStreaming(boolean value) {
        this.isStreaming = value;
    }

    public void doSimulateMD() throws Exception {
        BMaxproEventCameraExt eventExt = (BMaxproEventCameraExt)this.getEvents();
        BControlPoint[] eventPoints = eventExt.getPoints();
        for (int cameraPointIndex = 0; cameraPointIndex < eventPoints.length; ++cameraPointIndex) {
            BMaxproEventProxyExt eventProxy = (BMaxproEventProxyExt)eventPoints[cameraPointIndex].getProxyExt();
            if (eventProxy.getMaxproEventTypeEnum() != BMaxproEventTypesEnum.motionDetected) continue;
            BVideoEvent videoEvent = BVideoEvent.makeMotionStarted();
            videoEvent.setTimestamp(BAbsTime.now());
            eventProxy.readOk((BStatusValue)new BVideoEventStatus(videoEvent));
        }
    }

    public String getRtspStreadId() {
        return this.rtspStreamId;
    }

    @NiagaraRpc(permissions="r", transports={@Transport(type=TransportType.box)})
    public boolean isVideoSourceEnabled(Context cx) {
        return this.getEnabled() && this.getMaxproDvr().getEnabled() && this.vnetwork().getEnabled();
    }

    private class MaxproVideoStream
    extends VideoStream {
        protected BPlaybackParams playbackParams;

        private MaxproVideoStream() {
        }

        public InputStream getInputStream() {
            return null;
        }

        public void setPlaybackParams(BPlaybackParams playbackParams) {
            this.playbackParams = playbackParams;
        }

        public BPlaybackParams getPlaybackParams() {
            return this.playbackParams;
        }
    }
}

