/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.maxpro;

import com.tridium.maxpro.camera.BMaxproCamera;
import com.tridium.maxpro.comm.BMaxproHttpCommConfig;
import com.tridium.maxpro.nvr.BMaxproNvr;
import com.tridium.maxpro.nvr.BMaxproNvrFolder;
import com.tridium.ndriver.comm.http.HttpComm;
import com.tridium.ndriver.poll.BNPollScheduler;
import com.tridium.nvideo.BVideoNetwork;
import com.tridium.util.CompUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.dashboard.BISecurityDashboardProvider;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="poll", type="BNPollScheduler", defaultValue="new BNPollScheduler()"), @NiagaraProperty(name="httpConfig", type="BMaxproHttpCommConfig", defaultValue="new BMaxproHttpCommConfig()")})
public class BMaxproNetwork
extends BVideoNetwork
implements BISecurityDashboardProvider {
    @Generated
    public static final Property poll = BMaxproNetwork.newProperty((int)0, (BValue)new BNPollScheduler(), null);
    @Generated
    public static final Property httpConfig = BMaxproNetwork.newProperty((int)0, (BValue)new BMaxproHttpCommConfig(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BMaxproNetwork.class);
    private static final SecurityDashboardItemBuilder dashboardItemBuilder = new SecurityDashboardItemBuilder(TYPE);
    private static final int VERSION = 0;

    @Generated
    public BNPollScheduler getPoll() {
        return (BNPollScheduler)this.get(poll);
    }

    @Generated
    public void setPoll(BNPollScheduler v) {
        this.set(poll, (BValue)v, null);
    }

    @Generated
    public BMaxproHttpCommConfig getHttpConfig() {
        return (BMaxproHttpCommConfig)this.get(httpConfig);
    }

    @Generated
    public void setHttpConfig(BMaxproHttpCommConfig v) {
        this.set(httpConfig, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public String getNetworkName() {
        return "MaxproNetwork";
    }

    public Type getDeviceFolderType() {
        return BMaxproNvrFolder.TYPE;
    }

    public Type getDeviceType() {
        return BMaxproNvr.TYPE;
    }

    public final Feature getLicenseFeature() {
        BComplex netParent = this.getParent();
        if (netParent != null && netParent.getClass().getName().equals("com.tridium.remoteVideo.BRemoteVideoSource")) {
            return Sys.getLicenseManager().getFeature("tridium", "remoteVideo");
        }
        return Sys.getLicenseManager().getFeature("tridium", "maxpro");
    }

    public HttpComm hcomm() {
        return (HttpComm)this.getHttpConfig().comm();
    }

    public int getSecurityDashboardItemsVersion() {
        return 0;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        BMaxproCamera[] allMaxproCams = (BMaxproCamera[])CompUtil.getDescendants((BComponent)this.getNetwork(), BMaxproCamera.class);
        List camsWithRtspInUse = Arrays.stream(allMaxproCams).filter(cam -> cam.getUseRtspStream()).map(max -> max.getMaxproDvr() == null ? max.getDisplayName(cx) : max.getMaxproDvr().getDisplayName(cx) + "/" + max.getDisplayName(cx)).collect(Collectors.toList());
        if (!camsWithRtspInUse.isEmpty()) {
            items.add(dashboardItemBuilder.makeAlert().withSummary("securityDashboard.maxProRtspConnection.summary", new Object[]{this.getNetwork().getDisplayName(cx), String.join((CharSequence)", ", camsWithRtspInUse)}).withDescription("securityDashboard.maxProRtspConnection.description", new Object[0]));
        } else {
            items.add(dashboardItemBuilder.makeOk().withSummary("securityDashboard.maxProRtspConnection.ok.summary", new Object[]{this.getNetwork().getDisplayName(cx)}).withDescription("securityDashboard.maxProRtspConnection.description", new Object[0]));
        }
        return items;
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.sectionHeader");
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.getNavOrd().relativizeToSession();
    }
}

