/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.baja.log.Log;

public class NdioProperties {
    private static Hashtable<String, NdioProperties> properties = new Hashtable();
    private static final Log log = Log.getLog((String)"ndio");
    public static final NdioProperties DEFAULT = new NdioProperties();
    private int[] aoType = new int[4];
    private int[] aoOverrideMap = new int[4];
    private int[] doOverrideMap = new int[16];
    private int configCode = 0;
    private boolean multipleProcessors = false;
    private int uiCount = 0;
    private int boCount = 0;
    private int aoCount = 0;
    private boolean uiBiEnabled = false;
    private boolean uiHsEnabled = false;
    private boolean uiThEnabled = false;
    private boolean uiPlEnabled = false;
    private boolean uiVEnabled = false;
    private boolean uiMaEnabled = false;

    public static NdioProperties make(int configCode) {
        log.trace("retrieving properties for config code " + configCode);
        if (configCode == 0) {
            return DEFAULT;
        }
        NdioProperties props = properties.get(Integer.toString(configCode));
        if (props == null) {
            try {
                props = new NdioProperties(configCode);
            }
            catch (Exception e) {
                log.error("error reading ndio.properties file", (Throwable)e);
                return DEFAULT;
            }
            properties.put(Integer.toString(configCode), props);
        }
        return props;
    }

    private NdioProperties() {
    }

    private NdioProperties(int configCode) throws Exception {
        this.configCode = configCode;
        this.loadProperties();
    }

    private void loadProperties() throws Exception {
        int i;
        Properties props = new Properties();
        try (InputStream in = this.getClass().getResourceAsStream("/lib/ndio.properties");){
            props.load(in);
        }
        String code = Integer.toString(this.configCode);
        String value = props.getProperty(code + ".multipleProcessors", "0");
        this.multipleProcessors = Integer.parseInt(value) != 0;
        value = props.getProperty(code + ".uicount", "0");
        this.uiCount = Integer.parseInt(value);
        value = props.getProperty(code + ".aocount", "0");
        this.aoCount = Integer.parseInt(value);
        value = props.getProperty(code + ".docount", "0");
        this.boCount = Integer.parseInt(value);
        value = props.getProperty(code + ".uidiEnabled", "0");
        this.uiBiEnabled = Integer.parseInt(value) != 0;
        value = props.getProperty(code + ".uihsEnabled", "0");
        this.uiHsEnabled = Integer.parseInt(value) != 0;
        value = props.getProperty(code + ".uithEnabled", "0");
        this.uiThEnabled = Integer.parseInt(value) != 0;
        value = props.getProperty(code + ".uiplEnabled", "0");
        this.uiPlEnabled = Integer.parseInt(value) != 0;
        value = props.getProperty(code + ".uivEnabled", "0");
        this.uiVEnabled = Integer.parseInt(value) != 0;
        value = props.getProperty(code + ".uimaEnabled", "0");
        this.uiMaEnabled = Integer.parseInt(value) != 0;
        for (i = 0; i < this.aoCount; ++i) {
            value = props.getProperty(code + ".aoType." + String.valueOf(i), String.valueOf(this.aoType[i]));
            this.aoType[i] = Integer.parseInt(value);
            value = props.getProperty(code + ".aoOverrideMap." + String.valueOf(i), String.valueOf(this.aoOverrideMap[i]));
            this.aoOverrideMap[i] = Integer.parseInt(value);
        }
        for (i = 0; i < this.boCount; ++i) {
            value = props.getProperty(code + ".doOverrideMap." + String.valueOf(i), String.valueOf(this.doOverrideMap[i]));
            this.doOverrideMap[i] = Integer.parseInt(value);
        }
    }

    public boolean getMultipleProcessors() {
        return this.multipleProcessors;
    }

    public int getUiCount() {
        return this.uiCount;
    }

    public int getBoCount() {
        return this.boCount;
    }

    public int getAoCount() {
        return this.aoCount;
    }

    public boolean getUiBiEnabled() {
        return this.uiBiEnabled;
    }

    public boolean getUiHsEnabled() {
        return this.uiHsEnabled;
    }

    public boolean getUiThEnabled() {
        return this.uiThEnabled;
    }

    public boolean getUiPlEnabled() {
        return this.uiPlEnabled;
    }

    public boolean getUiVEnabled() {
        return this.uiVEnabled;
    }

    public boolean getUiMaEnabled() {
        return this.uiMaEnabled;
    }

    public int getCount(int type) {
        switch (type) {
            case 0: {
                return this.getUiCount();
            }
            case 2: {
                return this.getAoCount();
            }
            case 3: {
                return this.getBoCount();
            }
        }
        return 0;
    }

    public int getAoType(int index) {
        return this.aoType[index - 1];
    }

    int getAoOverrideMap(int index) {
        return this.aoOverrideMap[index - 1] + 1;
    }

    int getDoOverrideMap(int index) {
        return this.doOverrideMap[index - 1] + 1;
    }
}

