/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio;

import com.tridium.ndio.BINdioRebootable;
import com.tridium.ndio.BNdioNetwork;
import com.tridium.platform.BSystemPlatformService;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.driver.ping.BIPingable;
import javax.baja.driver.ping.BPingMonitor;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="pingFrequency", type="BRelTime", defaultValue="BRelTime.make(10L*1000L)", override=true), @NiagaraProperty(name="startupAlarmDelay", type="BRelTime", defaultValue="BRelTime.make(0)", flags=5, override=true), @NiagaraProperty(name="rebootEnabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="keepAliveTimeout", type="BRelTime", defaultValue="BRelTime.makeSeconds(30)", facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.makeSeconds(30))")}), @NiagaraProperty(name="rebootPeriod", type="BRelTime", defaultValue="BRelTime.makeMinutes(30)"), @NiagaraProperty(name="maxRebootPeriodCount", type="int", defaultValue="3"), @NiagaraProperty(name="rebootPeriodStart", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=69), @NiagaraProperty(name="rebootPeriodCount", type="int", defaultValue="0", flags=69), @NiagaraProperty(name="totalRebootRequests", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="lastRebootRequest", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1)})
public class BNdioPingMonitor
extends BPingMonitor {
    @Generated
    public static final Property pingFrequency = BNdioPingMonitor.newProperty((int)0, (BValue)BRelTime.make((long)10000L), null);
    @Generated
    public static final Property startupAlarmDelay = BNdioPingMonitor.newProperty((int)5, (BValue)BRelTime.make((long)0L), null);
    @Generated
    public static final Property rebootEnabled = BNdioPingMonitor.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property keepAliveTimeout = BNdioPingMonitor.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)30), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)30)));
    @Generated
    public static final Property rebootPeriod = BNdioPingMonitor.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)30), null);
    @Generated
    public static final Property maxRebootPeriodCount = BNdioPingMonitor.newProperty((int)0, (int)3, null);
    @Generated
    public static final Property rebootPeriodStart = BNdioPingMonitor.newProperty((int)69, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property rebootPeriodCount = BNdioPingMonitor.newProperty((int)69, (int)0, null);
    @Generated
    public static final Property totalRebootRequests = BNdioPingMonitor.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property lastRebootRequest = BNdioPingMonitor.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNdioPingMonitor.class);
    static final Log log = Log.getLog((String)"ndio");
    static final String NDIO_REBOOT = "ndioReboot";
    static Lexicon ndioLex = Lexicon.make((String)"ndio");
    private Thread rebootThread = null;

    @Generated
    public boolean getRebootEnabled() {
        return this.getBoolean(rebootEnabled);
    }

    @Generated
    public void setRebootEnabled(boolean v) {
        this.setBoolean(rebootEnabled, v, null);
    }

    @Generated
    public BRelTime getKeepAliveTimeout() {
        return (BRelTime)this.get(keepAliveTimeout);
    }

    @Generated
    public void setKeepAliveTimeout(BRelTime v) {
        this.set(keepAliveTimeout, (BValue)v, null);
    }

    @Generated
    public BRelTime getRebootPeriod() {
        return (BRelTime)this.get(rebootPeriod);
    }

    @Generated
    public void setRebootPeriod(BRelTime v) {
        this.set(rebootPeriod, (BValue)v, null);
    }

    @Generated
    public int getMaxRebootPeriodCount() {
        return this.getInt(maxRebootPeriodCount);
    }

    @Generated
    public void setMaxRebootPeriodCount(int v) {
        this.setInt(maxRebootPeriodCount, v, null);
    }

    @Generated
    public BAbsTime getRebootPeriodStart() {
        return (BAbsTime)this.get(rebootPeriodStart);
    }

    @Generated
    public void setRebootPeriodStart(BAbsTime v) {
        this.set(rebootPeriodStart, (BValue)v, null);
    }

    @Generated
    public int getRebootPeriodCount() {
        return this.getInt(rebootPeriodCount);
    }

    @Generated
    public void setRebootPeriodCount(int v) {
        this.setInt(rebootPeriodCount, v, null);
    }

    @Generated
    public int getTotalRebootRequests() {
        return this.getInt(totalRebootRequests);
    }

    @Generated
    public void setTotalRebootRequests(int v) {
        this.setInt(totalRebootRequests, v, null);
    }

    @Generated
    public BAbsTime getLastRebootRequest() {
        return (BAbsTime)this.get(lastRebootRequest);
    }

    @Generated
    public void setLastRebootRequest(BAbsTime v) {
        this.set(lastRebootRequest, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (this.isRunning() && prop == keepAliveTimeout) {
            BNdioNetwork network = (BNdioNetwork)this.getParent();
            network.updateKeepAliveTimeout(this.getKeepAliveTimeout().getMillis());
        }
    }

    public synchronized void pingFail(BIPingable p) {
        BINdioRebootable node;
        if (this.rebootThread != null) {
            return;
        }
        super.pingFail(p);
        if (this.getRebootEnabled() && p instanceof BINdioRebootable && (node = (BINdioRebootable)p).getRebootConditionMet()) {
            this.alertWithReboot(p);
            return;
        }
    }

    void alertWithReboot(BIPingable p) {
        if (this.rebootThread != null) {
            return;
        }
        boolean exceeded = this.exceededRebootLimit();
        boolean ackRequired = false;
        try {
            AlarmSupport support = (AlarmSupport)((BObject)p).fw(502);
            support.setAlarmClass(p.getAlarmSourceInfo().getAlarmClass());
            ackRequired = support.isAckRequired(BSourceState.offnormal);
            BFacets alarmData = p.getAlarmSourceInfo().makeAlarmData(BSourceState.offnormal);
            String msgText = alarmData.gets("msgText", "");
            msgText = exceeded ? msgText + " (%lexicon(ndio:ndioReboot)%,%lexicon(ndio:ndioDisabled)%)" : msgText + " (%lexicon(ndio:ndioReboot)%)";
            support.newAlert(BFacets.make((BFacets)alarmData, (BFacets)BFacets.make((String)"msgText", (BIDataValue)BString.make((String)msgText), (String)NDIO_REBOOT, (BIDataValue)BBoolean.TRUE)));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        int status = p.getStatus().getBits();
        status |= 8;
        if (ackRequired) {
            status |= 0x80;
        }
        p.setStatus(BStatus.make((int)status));
        if (this.rebootThread == null) {
            this.rebootThread = new RebootThread();
            this.rebootThread.start();
        }
    }

    private void reboot() {
        log.error("ndio driver forcing station save and reboot");
        this.setTotalRebootRequests(this.getTotalRebootRequests() + 1);
        this.setLastRebootRequest(BAbsTime.now());
        try {
            BSystemPlatformService sys = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            sys.checkPropertiesLoaded();
            sys.systemLog(3, "ndio driver forcing station save and reboot");
        }
        catch (Throwable sys) {
            // empty catch block
        }
        try {
            BSystemPlatformService sp = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            sp.checkPropertiesLoaded();
            sp.reboot();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private boolean exceededRebootLimit() {
        BAbsTime now = BAbsTime.now();
        BRelTime delta = this.getRebootPeriodStart().delta(now);
        if (delta.getSeconds() <= this.getRebootPeriod().getSeconds()) {
            this.setRebootPeriodCount(this.getRebootPeriodCount() + 1);
            if (delta.getSeconds() < 0) {
                this.setRebootPeriodStart(now);
            } else {
                if (this.getRebootPeriodCount() >= this.getMaxRebootPeriodCount()) {
                    log.error("maximum number of ndio reboots reached, disabling ndio");
                    this.setRebootPeriodStart(now);
                    this.setRebootPeriodCount(0);
                    try {
                        BSystemPlatformService sys = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
                        sys.checkPropertiesLoaded();
                        sys.systemLog(3, "maximum number of ndio reboots reached, disabling ndio");
                    }
                    catch (Throwable sys) {
                        // empty catch block
                    }
                    BNdioNetwork network = (BNdioNetwork)this.getParent();
                    network.setEnabled(false);
                    return true;
                }
                log.warning("ndio has rebooted " + this.getRebootPeriodCount() + " times since " + this.getRebootPeriodStart());
            }
        } else {
            this.setRebootPeriodStart(now);
            this.setRebootPeriodCount(1);
        }
        return false;
    }

    class RebootThread
    extends Thread {
        public RebootThread() {
            super("NdioRebootThread");
        }

        @Override
        public void run() {
            BNdioPingMonitor.this.reboot();
        }
    }
}

