/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio;

import com.tridium.ndio.BINdioRebootable;
import com.tridium.ndio.BNdioBoard;
import com.tridium.ndio.BNdioBoardFolder;
import com.tridium.ndio.BNdioPingMonitor;
import com.tridium.ndio.BNdioPollScheduler;
import com.tridium.ndio.NdioConstants;
import com.tridium.ndio.NdioProperties;
import com.tridium.ndio.learn.BNdioBoardDiscoveryJob;
import com.tridium.ndio.learn.BNdioBoardEntry;
import com.tridium.platNdio.BNdioPlatformService;
import java.util.ArrayList;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.ping.BPingMonitor;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="monitor", type="BNdioPingMonitor", defaultValue="new BNdioPingMonitor()", override=true), @NiagaraProperty(name="tuningPolicies", type="BTuningPolicyMap", defaultValue="new BTuningPolicyMap()"), @NiagaraProperty(name="pollScheduler", type="BNdioPollScheduler", defaultValue="new BNdioPollScheduler()"), @NiagaraProperty(name="rebootConditionMet", type="boolean", defaultValue="false", flags=71), @NiagaraProperty(name="averageKeepAliveLifetime", type="BRelTime", defaultValue="BRelTime.DEFAULT", flags=3, facets={@Facet(value="BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.make(true))")}), @NiagaraProperty(name="averageKeepAliveRecent", type="BRelTime", defaultValue="BRelTime.DEFAULT", flags=3, facets={@Facet(value="BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.make(true))")}), @NiagaraProperty(name="keepAlivePeak", type="BRelTime", defaultValue="BRelTime.DEFAULT", flags=3, facets={@Facet(value="BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.make(true))")}), @NiagaraProperty(name="totalKeepAlives", type="long", defaultValue="0", flags=3), @NiagaraProperty(name="totalKeepAliveLateStarts", type="long", defaultValue="0", flags=3)})
@NiagaraActions(value={@NiagaraAction(name="submitDiscoveryJob", returnType="BOrd", flags=4), @NiagaraAction(name="keepAlive", flags=4)})
public class BNdioNetwork
extends BDeviceNetwork
implements BINdioRebootable,
NdioConstants,
BIService {
    @Generated
    public static final Property monitor = BNdioNetwork.newProperty((int)0, (BValue)new BNdioPingMonitor(), null);
    @Generated
    public static final Property tuningPolicies = BNdioNetwork.newProperty((int)0, (BValue)new BTuningPolicyMap(), null);
    @Generated
    public static final Property pollScheduler = BNdioNetwork.newProperty((int)0, (BValue)new BNdioPollScheduler(), null);
    @Generated
    public static final Property rebootConditionMet = BNdioNetwork.newProperty((int)71, (boolean)false, null);
    @Generated
    public static final Property averageKeepAliveLifetime = BNdioNetwork.newProperty((int)3, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.make((boolean)true)));
    @Generated
    public static final Property averageKeepAliveRecent = BNdioNetwork.newProperty((int)3, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.make((boolean)true)));
    @Generated
    public static final Property keepAlivePeak = BNdioNetwork.newProperty((int)3, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.make((boolean)true)));
    @Generated
    public static final Property totalKeepAlives = BNdioNetwork.newProperty((int)3, (int)0, null);
    @Generated
    public static final Property totalKeepAliveLateStarts = BNdioNetwork.newProperty((int)3, (int)0, null);
    @Generated
    public static final Action submitDiscoveryJob = BNdioNetwork.newAction((int)4, null);
    @Generated
    public static final Action keepAlive = BNdioNetwork.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNdioNetwork.class);
    private static Type[] serviceTypes = new Type[]{TYPE};
    public static final Log log = Log.getLog((String)"ndio");
    private static BNdioPlatformService platSvc = null;
    public static int NDIOD_KEEP_ALIVE_INTERVAL = 5000;
    public static long NDIOD_KEEP_ALIVE_WINDOW = 30000L;
    public static int PING_OK = 0;
    public static int PING_FAILED_DAEMON = 1;
    public static int PING_FAILED_SERVICE = 2;
    public static int PING_FAILED_EXCEPTION = 3;
    private Clock.Ticket ticket = null;
    private boolean keepAliveStarted = false;
    private long lastKeepAliveTicks = 0L;
    private long startKeepAliveTicks = 0L;
    private long recentKeepAliveTicks = 0L;
    private long keepAliveCount = 0L;
    private long lastDeltaKeepAliveTicks = 0L;
    private long[] keepAliveDeltas = new long[5];
    private int deltaIndex = 0;
    private long keepAlivePeakTicks = 0L;
    private int pingState = PING_OK;
    private boolean hadSuccessfulPing = false;

    @Generated
    public BTuningPolicyMap getTuningPolicies() {
        return (BTuningPolicyMap)this.get(tuningPolicies);
    }

    @Generated
    public void setTuningPolicies(BTuningPolicyMap v) {
        this.set(tuningPolicies, (BValue)v, null);
    }

    @Generated
    public BNdioPollScheduler getPollScheduler() {
        return (BNdioPollScheduler)this.get(pollScheduler);
    }

    @Generated
    public void setPollScheduler(BNdioPollScheduler v) {
        this.set(pollScheduler, (BValue)v, null);
    }

    @Override
    @Generated
    public boolean getRebootConditionMet() {
        return this.getBoolean(rebootConditionMet);
    }

    @Generated
    public void setRebootConditionMet(boolean v) {
        this.setBoolean(rebootConditionMet, v, null);
    }

    @Generated
    public BRelTime getAverageKeepAliveLifetime() {
        return (BRelTime)this.get(averageKeepAliveLifetime);
    }

    @Generated
    public void setAverageKeepAliveLifetime(BRelTime v) {
        this.set(averageKeepAliveLifetime, (BValue)v, null);
    }

    @Generated
    public BRelTime getAverageKeepAliveRecent() {
        return (BRelTime)this.get(averageKeepAliveRecent);
    }

    @Generated
    public void setAverageKeepAliveRecent(BRelTime v) {
        this.set(averageKeepAliveRecent, (BValue)v, null);
    }

    @Generated
    public BRelTime getKeepAlivePeak() {
        return (BRelTime)this.get(keepAlivePeak);
    }

    @Generated
    public void setKeepAlivePeak(BRelTime v) {
        this.set(keepAlivePeak, (BValue)v, null);
    }

    @Generated
    public long getTotalKeepAlives() {
        return this.getLong(totalKeepAlives);
    }

    @Generated
    public void setTotalKeepAlives(long v) {
        this.setLong(totalKeepAlives, v, null);
    }

    @Generated
    public long getTotalKeepAliveLateStarts() {
        return this.getLong(totalKeepAliveLateStarts);
    }

    @Generated
    public void setTotalKeepAliveLateStarts(long v) {
        this.setLong(totalKeepAliveLateStarts, v, null);
    }

    @Generated
    public BOrd submitDiscoveryJob() {
        return (BOrd)this.invoke(submitDiscoveryJob, null, null);
    }

    @Generated
    public void keepAlive() {
        this.invoke(keepAlive, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.getMonitor().getType() != BNdioPingMonitor.TYPE) {
            BPingMonitor oldMonitor = this.getMonitor();
            BNdioPingMonitor newMonitor = new BNdioPingMonitor();
            newMonitor.setPingEnabled(oldMonitor.getPingEnabled());
            newMonitor.setAlarmOnFailure(oldMonitor.getAlarmOnFailure());
            this.setMonitor(newMonitor);
            log.message("Upgraded ping monitor for ndio network");
        }
        try {
            if (Sys.getService((Type)TYPE) != this) {
                log.error("Duplicate NdioNetwork, Only one NdioNetwork allowed per station!");
                this.configFail("Duplicate NdioNetwork, Only one NdioNetwork allowed per station!");
                return;
            }
        }
        catch (ServiceNotFoundException e1) {
            log.error("NdioNetwork not registered as a service!");
            this.configFail("NdioNetwork not registered as a service!");
            return;
        }
        if (BNdioNetwork.getPlatformService() == null) {
            log.error("NdioPlatformService not found!");
            this.configFail("NdioPlatformService not found!");
            return;
        }
        this.startKeepAlive();
    }

    public void atSteadyState() throws Exception {
        this.startKeepAlive();
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = null;
    }

    public void pingOk() {
        super.pingOk();
        this.hadSuccessfulPing = true;
    }

    public Type getDeviceType() {
        return BNdioBoard.TYPE;
    }

    public Type getDeviceFolderType() {
        return BNdioBoardFolder.TYPE;
    }

    public static BNdioPlatformService getPlatformService() {
        if (platSvc == null) {
            try {
                platSvc = (BNdioPlatformService)Sys.getService((Type)BNdioPlatformService.TYPE);
                platSvc.checkPropertiesLoaded();
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                // empty catch block
            }
        }
        return platSvc;
    }

    public BNdioBoard[] getBoards() {
        BDevice[] devices = this.getDevices();
        BNdioBoard[] boards = new BNdioBoard[devices.length];
        System.arraycopy(devices, 0, boards, 0, devices.length);
        return boards;
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if (this.isRunning() && property.getType().is(BNdioBoard.TYPE)) {
            this.handleBoardAdded((BNdioBoard)this.get(property));
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        super.removed(property, oldValue, context);
        if (this.isRunning() && property.getType().is(BNdioBoard.TYPE)) {
            this.handleBoardRemoved((BNdioBoard)oldValue);
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            this.startKeepAlive();
        }
    }

    public void handleBoardChanged(BNdioBoard board) {
        log.trace("handle board changed for " + board.getName());
        if (this.checkInvalidBoard(board, board.getIoPort()) && this.checkDuplicateBoard(board, board.getIoPort())) {
            board.configOk();
            board.initDevice();
        }
    }

    public void handleBoardAdded(BNdioBoard board) {
        log.trace("handle board added for " + board.getName());
        if (this.checkInvalidBoard(board, board.getIoPort()) && this.checkDuplicateBoard(board, board.getIoPort())) {
            board.configOk();
            board.initDevice();
        }
    }

    public void handleBoardRemoved(BNdioBoard board) {
        log.trace("handle board removed for " + board.getName());
        this.checkDuplicateBoardCleared(board, board.getIoPort());
    }

    private boolean checkInvalidBoard(BNdioBoard board, int ioPort) {
        if (ioPort > 4 || ioPort < 1) {
            board.configFail("invalid ioPort provided (1 <= ioPort <= 4)");
            return false;
        }
        return true;
    }

    private boolean checkDuplicateBoard(BNdioBoard board, int ioPort) {
        boolean dupFound = false;
        this.checkDuplicateBoardCleared(board, board.getPreviousIoPort());
        BNdioBoard[] boards = this.getBoards();
        for (int i = 0; i < boards.length; ++i) {
            if (boards[i] == board || boards[i].getIoPort() != ioPort) continue;
            dupFound = true;
            boards[i].configFail("duplicate ioPort: io ports must be unique/type");
        }
        if (dupFound) {
            board.configFail("duplicate ioPort: io ports must be unique/type");
            return false;
        }
        return true;
    }

    private void checkDuplicateBoardCleared(BNdioBoard board, int ioPort) {
        BNdioBoard[] boards = this.getBoards();
        if (ioPort != 0) {
            BNdioBoard iboard;
            ArrayList<BNdioBoard> list = new ArrayList<BNdioBoard>(boards.length);
            for (int i = 0; i < boards.length; ++i) {
                if (boards[i] == board || boards[i].getIoPort() != ioPort) continue;
                list.add(boards[i]);
            }
            if (list.size() == 1 && this.checkInvalidBoard(iboard = (BNdioBoard)list.get(0), iboard.getIoPort())) {
                iboard.configOk();
                iboard.initDevice();
                if (!iboard.isConfigFault()) {
                    try {
                        iboard.doPing();
                    }
                    catch (Exception e) {
                        log.error("deviceChanged: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            list = null;
        }
    }

    public synchronized void doPing() throws Exception {
        block12: {
            if (!Sys.atSteadyState()) {
                return;
            }
            try {
                log.trace("pinging network");
                if (BNdioNetwork.getPlatformService() != null) {
                    if (BNdioNetwork.getPlatformService().isDaemonOk()) {
                        this.pingOk();
                        this.pingState = PING_OK;
                    } else {
                        BNdioNetwork.getPlatformService().reset();
                        if (BNdioNetwork.getPlatformService().isDaemonOk()) {
                            this.pingOk();
                            this.pingState = PING_OK;
                        } else {
                            if (this.hadSuccessfulPing) {
                                this.setRebootConditionMet(true);
                            }
                            this.pingFail("network ping failed because it couldn't find ndio daemon");
                            if (this.pingState != PING_FAILED_DAEMON) {
                                log.error("network ping failed because it couldn't find ndio daemon");
                                this.pingState = PING_FAILED_DAEMON;
                            }
                        }
                    }
                } else {
                    this.pingFail("network ping failed because it couldn't find the platform service");
                    if (this.pingState != PING_FAILED_SERVICE) {
                        log.error("network ping failed because it couldn't find the platform service");
                        this.pingState = PING_FAILED_SERVICE;
                    }
                }
            }
            catch (Exception e) {
                this.pingFail("network ping failed: " + e.getMessage());
                if (this.pingState == PING_FAILED_EXCEPTION) break block12;
                log.error("network ping failed: " + e.getMessage());
                this.pingState = PING_FAILED_EXCEPTION;
            }
        }
    }

    public BOrd doSubmitDiscoveryJob(Context cx) {
        return new BNdioBoardDiscoveryJob(this).submit(cx);
    }

    public synchronized void startKeepAlive() {
        if (!Sys.atSteadyState()) {
            return;
        }
        if (BNdioNetwork.getPlatformService() == null) {
            return;
        }
        if (this.ticket == null && this.getEnabled()) {
            this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.make((long)NDIOD_KEEP_ALIVE_INTERVAL), (Action)keepAlive, null);
            this.doKeepAlive();
        }
    }

    public synchronized void updateKeepAliveTimeout(long millis) {
        if (!this.keepAliveStarted || !this.getEnabled()) {
            return;
        }
        try {
            BNdioNetwork.getPlatformService().setKeepAliveInterval(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.trace("Setting ndiod keep alive interval to " + millis);
    }

    public synchronized void doKeepAlive() {
        if (!this.keepAliveStarted) {
            if (!this.getEnabled()) {
                return;
            }
            this.keepAliveStarted = true;
            long interval = ((BNdioPingMonitor)this.getMonitor()).getKeepAliveTimeout().getMillis();
            this.updateKeepAliveTimeout(interval);
        }
        try {
            log.trace("Sending ndiod keep alive");
            BNdioNetwork.getPlatformService().keepAlive();
            this.setTotalKeepAlives(this.keepAliveCount);
            long keepAliveTicks = Clock.ticks();
            if (this.startKeepAliveTicks != 0L) {
                ++this.keepAliveCount;
                long delta = keepAliveTicks - this.lastKeepAliveTicks;
                if (delta > this.keepAlivePeakTicks) {
                    this.keepAlivePeakTicks = delta;
                    this.setKeepAlivePeak(BRelTime.make((long)this.keepAlivePeakTicks));
                }
                if (delta > 10000L) {
                    this.setTotalKeepAliveLateStarts(this.getTotalKeepAliveLateStarts() + 1L);
                }
                long avg = (keepAliveTicks - this.startKeepAliveTicks) / this.keepAliveCount;
                this.setAverageKeepAliveLifetime(BRelTime.make((long)avg));
                this.recentKeepAliveTicks += delta;
                this.keepAliveDeltas[this.deltaIndex] = delta;
                ++this.deltaIndex;
                if (this.deltaIndex >= 5) {
                    this.deltaIndex = 0;
                }
                if (this.keepAliveCount < 5L) {
                    avg = this.recentKeepAliveTicks / this.keepAliveCount;
                } else {
                    avg = this.recentKeepAliveTicks / 5L;
                    this.recentKeepAliveTicks -= this.keepAliveDeltas[this.deltaIndex];
                }
                this.setAverageKeepAliveRecent(BRelTime.make((long)avg));
            } else {
                this.startKeepAliveTicks = Clock.ticks();
            }
            this.lastKeepAliveTicks = keepAliveTicks;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isKeepAliveStarted() {
        return this.keepAliveStarted;
    }

    public boolean hadSuccessfulPing() {
        return this.hadSuccessfulPing;
    }

    public void spy(SpyWriter out) throws Exception {
        if (platSvc != null) {
            if (platSvc.isDaemonOk()) {
                int i;
                out.startProps();
                out.trTitle((Object)"Ndio Network Extra Properties", 2);
                out.prop((Object)"daemonOk", (Object)"true");
                out.prop((Object)"initTicks", (Object)String.valueOf(platSvc.getInitTicks()));
                out.prop((Object)"heartbeatTicks", (Object)String.valueOf(platSvc.getHeartbeatTicks()));
                out.endProps();
                BNdioBoardEntry[] boards = new BNdioBoardEntry[4];
                for (i = 0; i < 8; i += 2) {
                    try {
                        int ioType = platSvc.readIoType(i);
                        int ioConfigState = platSvc.readIoConfigState(i);
                        if (ioType == 0 || ioConfigState == 0 || ioConfigState == 1) continue;
                        int code = platSvc.readConfigCode(i);
                        NdioProperties props = NdioProperties.make(code);
                        if (props.getMultipleProcessors()) {
                            ioType = platSvc.readIoType(i + 1);
                            ioConfigState = platSvc.readIoConfigState(i + 1);
                            if (ioType == 0 || ioConfigState == 0 || ioConfigState == 1) continue;
                            boards[BNdioNetwork.PROC_TO_IO_PORT[i] - 1] = new BNdioBoardEntry(PROC_TO_IO_PORT[i]);
                            continue;
                        }
                        boards[BNdioNetwork.PROC_TO_IO_PORT[i] - 1] = new BNdioBoardEntry(PROC_TO_IO_PORT[i]);
                        continue;
                    }
                    catch (Exception props) {
                        // empty catch block
                    }
                }
                out.startTable(true);
                out.trTitle((Object)"Ndio Boards", 9);
                out.w((Object)"<tr>");
                out.w((Object)"<th align='center' nowrap='true' bgcolor='#d0d0d0'>ioPort</th>");
                out.w((Object)"<th align='center' nowrap='true' bgcolor='#d0d0d0'>calibrated</th>");
                out.w((Object)"<th align='center' nowrap='true' bgcolor='#d0d0d0'>multiProcessor</th>");
                out.w((Object)"<th align='center' nowrap='true' bgcolor='#d0d0d0'>firmwareVersion</th>");
                out.w((Object)"<th align='center' nowrap='true' bgcolor='#d0d0d0'>configCode</th>");
                out.w((Object)"<th align='center' nowrap='true' bgcolor='#d0d0d0'>uiCount</th>");
                out.w((Object)"<th align='center' nowrap='true' bgcolor='#d0d0d0'>boCount</th>");
                out.w((Object)"<th align='center' nowrap='true' bgcolor='#d0d0d0'>aoCount</th>");
                out.w((Object)"<th align='center' nowrap='true' bgcolor='#d0d0d0'>totalCount</th>");
                out.w((Object)"</tr>");
                for (i = 0; i < boards.length; ++i) {
                    if (boards[i] == null) {
                        out.w((Object)"<tr>");
                        out.w((Object)"<td nowrap='true' align='center'><i>board ").safe((Object)(i + 1)).w((Object)"</i></td>");
                        out.w((Object)"<td nowrap='true' colspan='8' align='center'><i>not found</i></td>");
                        out.w((Object)"</tr>\n");
                        continue;
                    }
                    out.w((Object)"<tr>");
                    BNdioBoard[] boardComps = (BNdioBoard[])this.getChildren(BNdioBoard.class);
                    String url = null;
                    int index = -1;
                    for (int j = 0; j < boardComps.length; ++j) {
                        if (boardComps[j].getIoPort() != i + 1) continue;
                        url = boardComps[j].getName();
                        break;
                    }
                    if (url == null) {
                        out.w((Object)"<td align='center' nowrap='true'><b>board ").safe((Object)(i + 1)).w((Object)"</b></td>");
                    } else {
                        out.w((Object)"<td align='center' nowrap='true'><b>").a(url, (Object)("board " + (i + 1))).w((Object)"</b></td>");
                    }
                    out.w((Object)"<td align='center' nowrap='true'>").safe((Object)(platSvc.isProcessorCalibrated(IO_PORT_TO_PROC_0[i + 1]) ? "true" : "false")).w((Object)"</td>");
                    out.w((Object)"<td align='center' nowrap='true'>").safe((Object)(boards[i].getMultipleProcessors() ? "true" : "false")).w((Object)"</td>");
                    out.w((Object)"<td align='center' nowrap='true'>").safe((Object)boards[i].getFirmwareVersion()).w((Object)"</td>");
                    out.w((Object)"<td align='center' nowrap='true'>").safe((Object)boards[i].getConfigCode()).w((Object)"</td>");
                    out.w((Object)"<td align='center' nowrap='true'>").safe((Object)boards[i].getUiCount()).w((Object)"</td>");
                    out.w((Object)"<td align='center' nowrap='true'>").safe((Object)boards[i].getBoCount()).w((Object)"</td>");
                    out.w((Object)"<td align='center' nowrap='true'>").safe((Object)boards[i].getAoCount()).w((Object)"</td>");
                    int totalCount = boards[i].getUiCount() + boards[i].getBoCount() + boards[i].getAoCount();
                    out.w((Object)"<td align='center' nowrap='true'><b>").safe((Object)totalCount).w((Object)"</b></td>");
                    out.w((Object)"</tr>");
                }
                out.endTable();
            } else {
                out.startProps();
                out.trTitle((Object)"Ndio Network", 2);
                out.prop((Object)"daemonOk", (Object)"false");
                out.endProps();
            }
        }
        super.spy(out);
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "ndio");
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public final void serviceStarted() {
    }

    public final void serviceStopped() {
    }
}

