/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.client;

import com.tridium.cloud.client.BConnectionState;
import com.tridium.cloud.client.BConnectorImpl;
import com.tridium.cloud.client.BICloudConnector;
import com.tridium.cloud.client.BNullConnectorImpl;
import com.tridium.cloud.client.ConnectCallback;
import com.tridium.cloud.client.MessageCallback;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.license.Feature;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.ExecutorUtil;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="connectorImpl", type="BConnectorImpl", defaultValue="new BNullConnectorImpl()"), @NiagaraProperty(name="id", type="BString", defaultValue="BString.DEFAULT", flags=65), @NiagaraProperty(name="connectionState", type="BConnectionState", defaultValue="BConnectionState.disconnected", flags=3), @NiagaraProperty(name="connectRetryInterval", type="BRelTime", defaultValue="BRelTime.makeSeconds(20)", flags=3), @NiagaraProperty(name="maxRetries", type="int", defaultValue="BInteger.make(NORMAL_RETRIES_COUNT)", flags=259), @NiagaraProperty(name="backoffMode", type="boolean", defaultValue="false", flags=259), @NiagaraProperty(name="normalRetriesCount", type="int", defaultValue="BInteger.make(NORMAL_RETRIES_COUNT)", flags=4), @NiagaraProperty(name="normalRetryDelay", type="BRelTime", defaultValue="BRelTime.makeMinutes(NORMAL_RETRY_DELAY_MINUTES)", flags=4, facets={@Facet(name="BFacets.MIN", value="MIN_NORMAL_RETRY_DELAY")}), @NiagaraProperty(name="backoffRetriesCount", type="int", defaultValue="BInteger.make(BACKOFF_RETRIES_COUNT)", flags=4), @NiagaraProperty(name="backoffRetryDelay", type="BRelTime", defaultValue="BRelTime.makeHours(BACKOFF_RETRY_DELAY_HOURS)", flags=4, facets={@Facet(name="BFacets.MIN", value="BRelTime.makeHours(1)")}), @NiagaraProperty(name="initialConnectDelay", type="BRelTime", defaultValue="BRelTime.make(5)"), @NiagaraProperty(name="alarmSourceInfo", type="BAlarmSourceInfo", defaultValue="initAlarmSourceInfo()"), @NiagaraProperty(name="lastOkTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=65601), @NiagaraProperty(name="lastFailTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=65), @NiagaraProperty(name="lastFailCause", type="BString", defaultValue="BString.DEFAULT", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)"), @Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")})})
@NiagaraActions(value={@NiagaraAction(name="reconnect"), @NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=5)})
public final class BCloudConnector
extends BAbstractService
implements BICloudConnector,
BIAlarmSource,
BIRestrictedComponent {
    public static final int INITIAL_CONNECT_DELAY_MINUTES = 5;
    public static final int NORMAL_RETRIES_COUNT = 24;
    public static final int NORMAL_RETRY_DELAY_MINUTES = 5;
    public static final int BACKOFF_RETRIES_COUNT = Integer.MAX_VALUE;
    public static final int BACKOFF_RETRY_DELAY_HOURS = 24;
    public static final BRelTime MIN_NORMAL_RETRY_DELAY = BRelTime.makeMinutes((int)1);
    public static final Property connectorImpl = BCloudConnector.newProperty((int)0, (BValue)new BNullConnectorImpl(), null);
    public static final Property id = BCloudConnector.newProperty((int)65, (BValue)BString.DEFAULT, null);
    public static final Property connectionState = BCloudConnector.newProperty((int)3, (BValue)BConnectionState.disconnected, null);
    public static final Property connectRetryInterval = BCloudConnector.newProperty((int)3, (BValue)BRelTime.makeSeconds((int)20), null);
    public static final Property maxRetries = BCloudConnector.newProperty((int)259, (BValue)BInteger.make((int)24), null);
    public static final Property backoffMode = BCloudConnector.newProperty((int)259, (boolean)false, null);
    public static final Property normalRetriesCount = BCloudConnector.newProperty((int)4, (BValue)BInteger.make((int)24), null);
    public static final Property normalRetryDelay = BCloudConnector.newProperty((int)4, (BValue)BRelTime.makeMinutes((int)5), (BFacets)BFacets.make((String)"min", (BIDataValue)MIN_NORMAL_RETRY_DELAY));
    public static final Property backoffRetriesCount = BCloudConnector.newProperty((int)4, (BValue)BInteger.make((int)Integer.MAX_VALUE), null);
    public static final Property backoffRetryDelay = BCloudConnector.newProperty((int)4, (BValue)BRelTime.makeHours((int)24), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeHours((int)1)));
    public static final Property initialConnectDelay = BCloudConnector.newProperty((int)0, (BValue)BRelTime.make((long)5L), null);
    public static final Property alarmSourceInfo = BCloudConnector.newProperty((int)0, (BValue)BCloudConnector.initAlarmSourceInfo(), null);
    public static final Property lastOkTime = BCloudConnector.newProperty((int)65601, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastFailTime = BCloudConnector.newProperty((int)65, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastFailCause = BCloudConnector.newProperty((int)65, (BValue)BString.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE)));
    public static final Action reconnect = BCloudConnector.newAction((int)0, null);
    public static final Action ackAlarm = BCloudConnector.newAction((int)5, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType(BCloudConnector.class);
    private static final boolean useLocalHost = Boolean.getBoolean("niagara.cloud.useLocalHost");
    private BConnectorImpl originalConnectorImpl;
    private volatile boolean inAlarm;
    private final AtomicInteger alarmBits = new AtomicInteger(0);
    private final Object connectRetryMonitor = new Object();
    private ScheduledFuture<BConnectionState> connectRetryFuture;
    private int failCount;
    private ScheduledExecutorService executor;
    private AlarmSupport alarmSupport;
    private static final Lexicon lex = Lexicon.make(BCloudConnector.class);
    private static final Logger log = Logger.getLogger("cloud.connector");
    private static final Logger dbg = Logger.getLogger("debug.cloud.connector");
    private static final BIcon icon = BIcon.std((String)"cloud.png");
    private final CompletableFuture<Void> whenStarted = new CompletableFuture();
    private final List<ConnectCallback> connectCallbacks = new CopyOnWriteArrayList<ConnectCallback>();
    public static final String HOST_NAME = "hostName";
    public static final String ID = "id";
    public static final String TOKEN = "token";

    @Override
    public BConnectorImpl getConnectorImpl() {
        return (BConnectorImpl)this.get(connectorImpl);
    }

    @Override
    public void setConnectorImpl(BConnectorImpl v) {
        this.set(connectorImpl, (BValue)v, null);
    }

    @Override
    public String getId() {
        return this.getString(id);
    }

    public void setId(String v) {
        this.setString(id, v, null);
    }

    public BConnectionState getConnectionState() {
        return (BConnectionState)this.get(connectionState);
    }

    public void setConnectionState(BConnectionState v) {
        this.set(connectionState, (BValue)v, null);
    }

    public BRelTime getConnectRetryInterval() {
        return (BRelTime)this.get(connectRetryInterval);
    }

    public void setConnectRetryInterval(BRelTime v) {
        this.set(connectRetryInterval, (BValue)v, null);
    }

    public int getMaxRetries() {
        return this.getInt(maxRetries);
    }

    public void setMaxRetries(int v) {
        this.setInt(maxRetries, v, null);
    }

    public boolean getBackoffMode() {
        return this.getBoolean(backoffMode);
    }

    public void setBackoffMode(boolean v) {
        this.setBoolean(backoffMode, v, null);
    }

    public int getNormalRetriesCount() {
        return this.getInt(normalRetriesCount);
    }

    public void setNormalRetriesCount(int v) {
        this.setInt(normalRetriesCount, v, null);
    }

    public BRelTime getNormalRetryDelay() {
        return (BRelTime)this.get(normalRetryDelay);
    }

    public void setNormalRetryDelay(BRelTime v) {
        this.set(normalRetryDelay, (BValue)v, null);
    }

    public int getBackoffRetriesCount() {
        return this.getInt(backoffRetriesCount);
    }

    public void setBackoffRetriesCount(int v) {
        this.setInt(backoffRetriesCount, v, null);
    }

    public BRelTime getBackoffRetryDelay() {
        return (BRelTime)this.get(backoffRetryDelay);
    }

    public void setBackoffRetryDelay(BRelTime v) {
        this.set(backoffRetryDelay, (BValue)v, null);
    }

    public BRelTime getInitialConnectDelay() {
        return (BRelTime)this.get(initialConnectDelay);
    }

    public void setInitialConnectDelay(BRelTime v) {
        this.set(initialConnectDelay, (BValue)v, null);
    }

    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    public BAbsTime getLastOkTime() {
        return (BAbsTime)this.get(lastOkTime);
    }

    public void setLastOkTime(BAbsTime v) {
        this.set(lastOkTime, (BValue)v, null);
    }

    public BAbsTime getLastFailTime() {
        return (BAbsTime)this.get(lastFailTime);
    }

    public void setLastFailTime(BAbsTime v) {
        this.set(lastFailTime, (BValue)v, null);
    }

    public String getLastFailCause() {
        return this.getString(lastFailCause);
    }

    public void setLastFailCause(String v) {
        this.setString(lastFailCause, v, null);
    }

    public void reconnect() {
        this.invoke(reconnect, null, null);
    }

    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    private static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo info = new BAlarmSourceInfo();
        info.setToOffnormalText(BFormat.make((String)"%lexicon(cloudConnector:connectFail)%"));
        info.setToNormalText(BFormat.make((String)"%lexicon(cloudConnector:connectSuccess)%"));
        return info;
    }

    public void serviceStarted() throws Exception {
        log.finest(() -> String.format("System property niagara.cloud.useLocalHost = %s; useLocalHost = %s", Boolean.getBoolean("niagara.cloud.useLocalHost"), useLocalHost));
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmSourceInfo());
        this.executor = ExecutorUtil.newSingleThreadBackgroundScheduledExecutor((String)"cloudConnector.connector", (long)2L, (TimeUnit)TimeUnit.MINUTES);
        if (this.originalConnectorImpl == null) {
            this.originalConnectorImpl = this.getConnectorImpl();
        }
        this.setConnectRetryInterval(BRelTime.makeMinutes((int)5));
        this.failCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void descendantsStarted() throws Exception {
        block6: {
            try {
                if (this.getId().isEmpty()) {
                    log.info(() -> String.format("Delaying initial connection attempt for new connector by %s to allow for registration", this.getInitialConnectDelay()));
                    Object object = this.connectRetryMonitor;
                    synchronized (object) {
                        this.connectRetryFuture = this.scheduleExec("descStart", this::reconnectSync, this.getInitialConnectDelay().getMillis(), TimeUnit.MILLISECONDS);
                        dbg.finer(() -> String.format("CloudConnector.descendantsStarted(): reconnectSync scheduled in %s msec with executor; future: %s ", this.getInitialConnectDelay().getMillis(), this.connectRetryFuture));
                        break block6;
                    }
                }
                log.fine("Existing Cloud Connector, initiating connection immediately");
                this.reconnectAsync("CloudConnector.descStarted()");
            }
            catch (Exception e) {
                this.whenStarted.completeExceptionally(e);
                throw e;
            }
        }
    }

    public <V> ScheduledFuture<V> scheduleExec(String caller, Callable<V> callable, long delay, TimeUnit unit) {
        dbg.log(Level.FINE, dbg.isLoggable(Level.FINEST) ? new Throwable() : null, () -> String.format("Schedule execution for %s of %s in %s %s", new Object[]{caller, callable, delay, unit}));
        return this.executor.schedule(callable, delay, unit);
    }

    public boolean completesStarted() {
        return true;
    }

    public CompletableFuture<Void> whenServiceStarted() {
        return this.whenStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStopped() throws Exception {
        this.disconnect();
        Object object = this.connectRetryMonitor;
        synchronized (object) {
            if (this.connectRetryFuture != null) {
                this.connectRetryFuture.cancel(true);
            }
            this.connectRetryFuture = null;
        }
        this.executor.shutdown();
        this.stopping();
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public BIcon getIcon() {
        return icon;
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(BAbstractService.enabled)) {
            if (this.getEnabled()) {
                this.failCount = 0;
                this.setMaxRetries(this.getNormalRetriesCount());
                this.setConnectRetryInterval(this.getNormalRetryDelay());
                this.setBackoffMode(false);
            }
            if (this.executor != null) {
                dbg.finer("CloudConnector.changed(enabled): calling reconnectAsync()");
                this.reconnectAsync("CloudConnector.changed(enabled)");
            }
        }
    }

    public AgentList getAgents(Context cx) {
        return this.getConnectorImpl().filterCloudConnectorAgents(super.getAgents(cx), cx);
    }

    @NiagaraRpc(permissions="W", transports={@Transport(type=TransportType.box)})
    public boolean reconnect(Context cx) throws Throwable {
        try {
            dbg.finer("CloudConnector.reconnect() RPC: reconnectAsync() and get() for immediate response");
            this.disconnect();
            try {
                Thread.sleep(500L);
                return this.reconnectAsync("CloudConnector.reconnect() RPC").get().isConnected();
            }
            catch (InterruptedException interrupted) {
                return false;
            }
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<BConnectionState> reconnectAsync(String caller) {
        dbg.finer(() -> String.format("CloudConnector.reconnectAsync(%s): submitting reconnectSync(); queue size: %s", caller, ((ScheduledThreadPoolExecutor)this.executor).getQueue().size()));
        Object object = this.connectRetryMonitor;
        synchronized (object) {
            this.connectRetryFuture = this.scheduleExec("reconnectAsync-" + caller, this::reconnectSync, 0L, TimeUnit.NANOSECONDS);
            return this.connectRetryFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BConnectionState reconnectSync() {
        this.disconnect();
        if (this.canConnect()) {
            this.setConnectionState(BConnectionState.pendingConnect);
            try {
                this.getConnectorImpl().connect();
                this.failCount = 0;
                this.setBackoffMode(false);
                this.setMaxRetries(this.getNormalRetriesCount());
                this.setConnectRetryInterval(this.getNormalRetryDelay());
            }
            catch (Exception error) {
                String message = MessageFormat.format(lex.getText("connectFail.cannotConnect"), error.getMessage());
                log.log(Level.WARNING, message);
                this.connectFail(message);
                log.fine(() -> String.format("Cloud Connector reconnectSync exception:%s; connectRetryFuture:%s; isConnected? %s; failCount:%s, maxRetries:%s", error, this.connectRetryFuture, this.isConnected(), this.failCount, this.getMaxRetries()));
                if (++this.failCount > this.getMaxRetries()) {
                    if (this.getBackoffMode()) {
                        log.warning("Cloud Connector failed too many connection attempts, disabling connector.");
                        this.setEnabled(false);
                    } else {
                        this.setBackoffMode(true);
                        this.setMaxRetries(this.getBackoffRetriesCount());
                        this.setConnectRetryInterval(this.getBackoffRetryDelay());
                        this.failCount = 0;
                    }
                }
                Object object = this.connectRetryMonitor;
                synchronized (object) {
                    log.fine(() -> String.format("Cloud Connector reconnectSync exception:%s; connectRetryFuture:%s; isConnected? %s; failCount:%s, maxRetries:%s", error, this.connectRetryFuture, this.isConnected(), this.failCount, this.getMaxRetries()));
                    if (this.connectRetryFuture != null && this.isConnected()) {
                        this.connectRetryFuture.cancel(true);
                    }
                    if (this.canConnect()) {
                        this.connectRetryFuture = this.scheduleExec("reconnectSync fail", this::reconnectSync, this.getConnectRetryInterval().getMillis(), TimeUnit.MILLISECONDS);
                        dbg.finer(() -> String.format("CloudConnector.reconnectSync() failed, scheduled new connect in %s msec; future=%s", this.getConnectRetryInterval().getMillis(), this.connectRetryFuture));
                    } else {
                        this.connectRetryFuture = null;
                    }
                }
            }
        } else {
            this.pingFail(lex.getText("cannotConnect"));
        }
        if (!this.whenStarted.isDone()) {
            this.whenStarted.complete(null);
        }
        return this.getConnectionState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doReconnect() {
        dbg.finer("CloudConnector.doReconnect() action impl; disconnect then schedule reconnectSync in 500ms");
        this.disconnect();
        Object object = this.connectRetryMonitor;
        synchronized (object) {
            this.connectRetryFuture = this.scheduleExec("CloudConnector.doReconnect() action", this::reconnectSync, 500L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        try {
            if (this.isConnected()) {
                this.getConnectorImpl().disconnect();
            }
            ((ScheduledThreadPoolExecutor)this.executor).getQueue().clear();
            this.connectCallbacks.forEach(ConnectCallback::onDisconnect);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, Objects.toString(e.getMessage(), "Failed to disconnect"));
        }
        finally {
            Object object = this.connectRetryMonitor;
            synchronized (object) {
                if (this.connectRetryFuture != null && this.isConnected()) {
                    this.connectRetryFuture.cancel(true);
                }
                this.connectRetryFuture = null;
            }
            this.setConnectionState(BConnectionState.disconnected);
        }
    }

    private void stopping() {
        this.connectCallbacks.forEach(ConnectCallback::onStopped);
    }

    private boolean canConnect() {
        return this.executor != null && !this.executor.isShutdown() && this.getEnabled() && !this.isFatalFault() && this.getConnectorImpl().canConnect();
    }

    public void connectOk() {
        this.connectOk(true);
    }

    private void connectOk(boolean updateLastOkTimeRequired) {
        this.setConnectionState(BConnectionState.connected);
        if (updateLastOkTimeRequired) {
            this.updateLastOkTime();
            updateLastOkTimeRequired = false;
        }
        this.configOk();
        this.connectCallbacks.forEach(ConnectCallback::onConnect);
        log.fine(() -> "Connection ok");
        this.pingOk(updateLastOkTimeRequired);
    }

    private void updateLastOkTime() {
        long now = System.currentTimeMillis();
        long truncated = now - now % 60000L;
        BAbsTime t = BAbsTime.make((long)(truncated <= this.getLastFailTime().getMillis() ? now : truncated));
        this.setLastOkTime(t);
    }

    public void connectFail(Throwable cause) {
        this.doConnectFail(cause.getMessage());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Connection fail", cause);
        }
    }

    public void connectFail(String cause) {
        this.doConnectFail(cause);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Connection fail: " + cause);
        }
    }

    private void doConnectFail(String cause) {
        this.setConnectionState(BConnectionState.disconnected);
        this.connectCallbacks.forEach(ConnectCallback::onDisconnect);
        cause = Objects.toString(cause, "Unknown");
        long now = System.currentTimeMillis();
        long truncated = now - now % 60000L;
        BAbsTime absTime = BAbsTime.make((long)(truncated <= this.getLastOkTime().getMillis() ? now : truncated));
        this.setLastFailTime(absTime);
        this.setLastFailCause(cause);
        this.pingFail(cause);
    }

    public void updateStatus() {
        super.updateStatus();
        if (this.alarmSupport == null) {
            return;
        }
        BStatus status = this.getStatus();
        if (!this.inAlarm && status.isFault()) {
            this.inAlarm = true;
            this.alarmBits.set(8);
            if (this.alarmSupport.isAckRequired(BSourceState.fault)) {
                this.alarmBits.updateAndGet(bits -> bits | 0x80);
            }
            try {
                this.alarmSupport.newFaultAlarm(BFacets.DEFAULT);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Unable to create fault alarm", e);
            }
        } else if (this.inAlarm && !status.isFault()) {
            this.inAlarm = false;
            this.alarmBits.set(0);
            if (this.alarmSupport.isAckRequired(BSourceState.normal)) {
                this.alarmBits.updateAndGet(bits -> bits | 0x80);
            }
            try {
                this.alarmSupport.toNormal(null);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Unable to create normal alarm", e);
            }
        }
        this.setStatus(BStatus.make((int)(status.getBits() | this.alarmBits.get())));
    }

    @Override
    public void ping() throws Exception {
        this.getConnectorImpl().ping();
    }

    @Override
    public void pingOk() {
        this.pingOk(true);
    }

    private void pingOk(boolean updateLastOkTimeRequired) {
        if (!this.isConnected()) {
            this.connectOk(!updateLastOkTimeRequired);
        }
        if (updateLastOkTimeRequired) {
            this.updateLastOkTime();
        }
        dbg.fine("Ping ok");
        this.connectCallbacks.forEach(ConnectCallback::pingOk);
    }

    @Override
    public void pingFail(String cause) {
        log.finest(() -> String.format("BCloudConnector.pingFail(%s), notifying connectCallbacks", cause));
        for (ConnectCallback connectCallback : this.connectCallbacks) {
            connectCallback.pingFail(cause);
        }
    }

    public BBoolean doAckAlarm(BAlarmRecord record) {
        if (!this.isRunning() || this.alarmSupport == null) {
            return BBoolean.FALSE;
        }
        BBoolean res = BBoolean.FALSE;
        try {
            res = BBoolean.make((boolean)this.alarmSupport.ackAlarm(record));
            if (res.getBoolean()) {
                this.alarmBits.updateAndGet(bits -> bits & 0xFFFFFF7F);
                this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)128, (boolean)false));
            }
        }
        catch (Exception exception) {
            log.log(Level.WARNING, String.format("Could not ack the alarm: %s", exception), log.isLoggable(Level.FINE) ? exception : null);
        }
        return res;
    }

    public Feature getLicenseFeature() {
        return this.getConnectorImpl().getLicenseFeature();
    }

    @Override
    public CompletableFuture<String> sendMessage(byte[] payload, Map<String, String> props) {
        CompletableFuture<String> completableFuture = new CompletableFuture<String>();
        if (!this.isConnected()) {
            completableFuture.completeExceptionally(new IOException("Cloud connector not connected!"));
        } else {
            this.getConnectorImpl().sendMessage(payload, props, completableFuture);
        }
        return completableFuture;
    }

    @Override
    public CompletableFuture<String> sendMessage(String payload, Map<String, String> props) {
        return this.sendMessage(payload.getBytes(StandardCharsets.UTF_8), props);
    }

    @Override
    public void addMessageCallback(MessageCallback callback) {
        this.getConnectorImpl().addMessageCallback(callback);
    }

    @Override
    public void removeMessageCallback(MessageCallback callback) {
        this.getConnectorImpl().removeMessageCallback(callback);
    }

    public Set<MessageCallback> getMessageCallbacks() {
        return this.getConnectorImpl().getMessageCallbacks();
    }

    @Override
    public void addConnectCallback(ConnectCallback callback) {
        this.connectCallbacks.add(callback);
    }

    @Override
    public void removeConnectCallback(ConnectCallback callback) {
        this.connectCallbacks.remove(callback);
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    public boolean isConnected() {
        return this.getConnectionState().isConnected();
    }

    public boolean isDisconnected() {
        return this.getConnectionState().isDisconnected();
    }

    public boolean isConnectionPending() {
        return this.getConnectionState().isConnectionPending();
    }

    boolean isOriginalConnectorImpl(BConnectorImpl impl) {
        Objects.requireNonNull(this.originalConnectorImpl);
        Objects.requireNonNull(impl);
        return this.originalConnectorImpl == impl;
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentIsServiceContainer((BComponent)parent, (BIRestrictedComponent)this);
        BIRestrictedComponent.checkContextForSuperUser((BIRestrictedComponent)this, (Context)cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BICloudConnector", 2);
        out.prop((Object)"useLocalHost", useLocalHost);
        Object object = this.connectRetryMonitor;
        synchronized (object) {
            out.prop((Object)"connectRetryFuture", this.connectRetryFuture);
        }
        out.prop((Object)"executor", (Object)this.executor);
        if (dbg.isLoggable(Level.FINE)) {
            ScheduledThreadPoolExecutor stpe = (ScheduledThreadPoolExecutor)this.executor;
            int queueSize = stpe.getQueue().size();
            out.prop((Object)"queue size:", queueSize);
            if (queueSize <= 100) {
                stpe.getQueue().forEach(r -> out.prop((Object)"runnable", r));
            } else {
                Runnable[] runnables = stpe.getQueue().toArray(new Runnable[0]);
                out.prop((Object)"showing runnables for first", (Object)"100");
                for (int i = 0; i < 100; ++i) {
                    out.prop((Object)"runnable", runnables[i]);
                }
            }
        }
        out.prop((Object)"fatalFault", this.isFatalFault());
        out.prop((Object)"failCount", this.failCount);
        out.endProps();
    }
}

