/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jx.browser;

import com.teamdev.jxbrowser.VersionInfo;
import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.AlertCallback;
import com.teamdev.jxbrowser.browser.callback.BeforeFormRepostCallback;
import com.teamdev.jxbrowser.browser.callback.BeforeUnloadCallback;
import com.teamdev.jxbrowser.browser.callback.ConfirmCallback;
import com.teamdev.jxbrowser.browser.callback.CreatePopupCallback;
import com.teamdev.jxbrowser.browser.callback.InjectJsCallback;
import com.teamdev.jxbrowser.browser.callback.OpenFileCallback;
import com.teamdev.jxbrowser.browser.callback.OpenFilesCallback;
import com.teamdev.jxbrowser.browser.callback.PromptCallback;
import com.teamdev.jxbrowser.browser.callback.SelectClientCertificateCallback;
import com.teamdev.jxbrowser.browser.callback.SelectColorCallback;
import com.teamdev.jxbrowser.browser.callback.StartDownloadCallback;
import com.teamdev.jxbrowser.browser.callback.input.MoveMouseCallback;
import com.teamdev.jxbrowser.browser.callback.input.PressKeyCallback;
import com.teamdev.jxbrowser.browser.event.BrowserBecameUnresponsive;
import com.teamdev.jxbrowser.browser.event.ConsoleMessageReceived;
import com.teamdev.jxbrowser.browser.event.RenderProcessTerminated;
import com.teamdev.jxbrowser.browser.event.StatusChanged;
import com.teamdev.jxbrowser.browser.event.TitleChanged;
import com.teamdev.jxbrowser.browser.internal.RenderProcess;
import com.teamdev.jxbrowser.browser.internal.rpc.RenderProcessTerminatedOrBuilder;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.cookie.Cookie;
import com.teamdev.jxbrowser.cookie.CookieStore;
import com.teamdev.jxbrowser.download.Download;
import com.teamdev.jxbrowser.download.event.DownloadUpdated;
import com.teamdev.jxbrowser.engine.Engine;
import com.teamdev.jxbrowser.engine.EngineOptions;
import com.teamdev.jxbrowser.engine.Language;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.engine.UserDataDirectoryAlreadyInUseException;
import com.teamdev.jxbrowser.engine.event.EngineCrashed;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.frame.Frame;
import com.teamdev.jxbrowser.js.ConsoleMessage;
import com.teamdev.jxbrowser.js.ConsoleMessageLevel;
import com.teamdev.jxbrowser.js.JsAccessible;
import com.teamdev.jxbrowser.js.JsObject;
import com.teamdev.jxbrowser.navigation.TimeoutException;
import com.teamdev.jxbrowser.navigation.callback.ShowNetErrorPageCallback;
import com.teamdev.jxbrowser.navigation.callback.StartNavigationCallback;
import com.teamdev.jxbrowser.navigation.event.FrameLoadFailed;
import com.teamdev.jxbrowser.navigation.event.FrameLoadFinished;
import com.teamdev.jxbrowser.navigation.event.NavigationFinished;
import com.teamdev.jxbrowser.navigation.event.NavigationStarted;
import com.teamdev.jxbrowser.net.NetError;
import com.teamdev.jxbrowser.net.Network;
import com.teamdev.jxbrowser.net.Scheme;
import com.teamdev.jxbrowser.net.callback.VerifyCertificateCallback;
import com.teamdev.jxbrowser.net.tls.CertVerificationStatus;
import com.teamdev.jxbrowser.net.tls.Certificate;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Bitmap;
import com.teamdev.jxbrowser.ui.Color;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.view.swing.BrowserView;
import com.teamdev.jxbrowser.view.swing.graphics.BitmapImage;
import com.tridium.crypto.core.cert.CertValidationResult;
import com.tridium.crypto.core.cert.DefaultExemptionApprover;
import com.tridium.crypto.core.cert.NHostExemption;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.TridiumCertValidator;
import com.tridium.crypto.core.io.CoreClientTrustManager;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.ICoreExemptionStore;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.jx.browser.JxBrowserUtil;
import com.tridium.jx.browser.JxJs;
import com.tridium.jx.browser.WbJxBrowserUtil;
import com.tridium.jx.browser.WebLauncherUtil;
import com.tridium.jx.browser.interop.JxBroadcastChannel;
import com.tridium.net.BHttpObject;
import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.pdf.PdfException;
import com.tridium.pdf.gx.PdfDocument;
import com.tridium.pdf.gx.PdfGraphics;
import com.tridium.pdf.gx.PdfPage;
import com.tridium.platcrypto.ui.WbExemptionApprover;
import com.tridium.security.UrlWhitelist;
import com.tridium.sys.Nre;
import com.tridium.sys.spy.CacheSpy;
import com.tridium.ui.awt.AwtShellManager;
import com.tridium.ui.swing.BSwingWidget;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.util.ObjectUtil;
import com.tridium.web.servlets.WbServlet;
import com.tridium.workbench.colorchooser.BColorChooser;
import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import com.tridium.workbench.shell.BFontSize;
import com.tridium.workbench.shell.BGeneralOptions;
import com.tridium.workbench.shell.NHyperlinkInfo;
import com.tridium.workbench.util.WbUtil;
import com.tridium.workbench.web.browser.BIWebBrowserImpl;
import com.tridium.workbench.web.browser.BNullWebBrowserImpl;
import com.tridium.workbench.web.browser.BWebBrowser;
import com.tridium.workbench.web.browser.BWebBrowserOptions;
import com.tridium.workbench.web.browser.BWebWidget;
import com.tridium.workbench.web.browser.BrowserUtil;
import com.tridium.workbench.web.browser.IJs;
import com.tridium.workbench.web.browser.audio.AudioPlayer;
import com.tridium.workbench.web.browser.interop.BroadcastChannel;
import com.tridium.workbench.web.browser.interop.ConsoleEventHandler;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.naming.BISession;
import javax.baja.naming.BIpHost;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.IX509Certificate;
import javax.baja.nre.util.FileUtil;
import javax.baja.pdf.PdfOp;
import javax.baja.spy.BSpy;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BLabel;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.transfer.Clipboard;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.util.ExecutorUtil;
import javax.baja.util.Lexicon;
import javax.baja.web.BWebService;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbView;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

@NiagaraType
public final class BJxWebBrowserImpl
extends BSwingWidget
implements BIWebBrowserImpl {
    @Generated
    public static final Type TYPE = Sys.loadType(BJxWebBrowserImpl.class);
    static final Logger log;
    private static Level JXBROWSER_LOG_LEVEL;
    private BWebBrowser.IWebBrowserDropHandler dropHandler;
    private Browser jx;
    private static Engine engine;
    private static EngineOptions.Builder engineOptionsBuilder;
    private BrowserView jxView;
    private final AtomicBoolean contentLoaded = new AtomicBoolean();
    private final AtomicBoolean crashDetected = new AtomicBoolean();
    private BObject content;
    private Context context;
    private Runnable onRegisterFunctions;
    private Runnable onLoaded;
    private Set<ConsoleEventHandler> consoleEventHandlers = new HashSet<ConsoleEventHandler>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private volatile boolean fromLoad;
    private volatile boolean showProgress;
    private volatile int progressOff;
    private static final double progressHeight = 20.0;
    private static final BBrush progressWndBg;
    private static final BBrush progressBorder;
    private static final BBrush progressFg;
    private static final BBrush progressBg;
    private static final AtomicBoolean preInit;
    private static Throwable preInitError;
    private static final List<BrowserView> browserCache;
    private static final int INITIAL_BROWSER_CACHE_SIZE;
    private static final int INITIAL_STATION_BROWSER_CACHE_SIZE;
    private static final int MAX_BROWSER_CACHE_SIZE;
    private static final Set<BrowserView> browserInstances;
    private final Map<String, MethodNameSupplier> browserRegisteredFunctions = Collections.synchronizedMap(new HashMap());
    private List<Subscription> onEvents = Collections.synchronizedList(new ArrayList());
    private static final Object executorMon;
    private static volatile ExecutorService executorSrv;
    private final AtomicBoolean webEngInit = new AtomicBoolean();
    private static final BroadcastChannel BROADCAST_CHANNEL_INTEROP;
    private static final boolean WEBBROWSER_CONSOLE;
    private static final boolean HEAVYWEIGHT_MODE;
    private static final boolean DISABLE_GPU;
    private static final boolean DISABLE_LOCAL_WB_RESOURCES;
    private static final boolean DISABLE_CERT_DIALOG;
    private static final int PDF_RESIZE_DELAY;
    private UrlWhitelist whitelist;
    private String whitelistError;
    private String certificateError;
    private String sslProtocolError;
    private String mainFrameUrl;
    private final List<CertApprovalInfo> pendingCertApprovals = Collections.synchronizedList(new ArrayList());
    private static boolean allowDialogs;
    private static final Object CERT_DIALOG_MONITOR;
    static final Map<Browser, String> HTML_MAP;
    static final Map<Browser, Context> FILE_LOAD_CONTEXT_MAP;
    static final String LOAD_HTML_URL = "https://workbench/index.html";
    static final String BLANK_HTML_CONTENT = "<html><head><title></title></head><body></body></html>";
    static final String BLANK_HTML_URL = "https://workbench/blank.html";
    static final String LOAD_FILE_URL = "https://workbench/file.html";
    private static String lastDebugUrlPrinted;
    private static final X509Certificate[] NO_CERTS;
    private static final String[] EMPTY_STRING_ARRAY;
    private static final CertApprovalInfo[] EMPTY_CERT_APPROVALS;
    public static final String CHROMIUM_VERSION = "139.0.7258.139";
    public static final String CHROME_USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36";
    public static final String JX_BROWSER_VERSION = "7.43.9";
    public static final String SCHEMA_VERSION = "7.31";
    static final String LICENSE_KEY = "4UNGTNAE2D0G7EKZXHH8SMCQ5D4IGPK01JFBY2GPIUOUOQ1O2U5G5979DM37UHPSUHO4S8PIM7Z0041EVDV5KN9NTWCBY3RKFNMKQ9PF2D4FE38Y88JW17G6BYBFG45TUODH276HAE7JD6LYKXS";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public JComponent createContent() {
        this.initBrowser();
        return this.jxView;
    }

    public boolean preInitialize(Map<String, String> options) {
        block14: {
            if (!options.getOrDefault("forceStationBrowserInit", "").equals(Boolean.TRUE.toString()) && Sys.isStation()) {
                return false;
            }
            if (WbServlet.disableJxBrowser || preInitError != null) {
                return false;
            }
            try {
                String sysLang;
                if (preInit.getAndSet(true) && options.get("interrupted") == null) break block14;
                engineOptionsBuilder = AccessController.doPrivileged(() -> EngineOptions.newBuilder((RenderingMode)(HEAVYWEIGHT_MODE ? RenderingMode.HARDWARE_ACCELERATED : RenderingMode.OFF_SCREEN)));
                engineOptionsBuilder.licenseKey(WbJxBrowserUtil.getLicenseKey());
                if (BWidget.getApplication() != null && BWebBrowserOptions.get().getWebDevelopmentTools()) {
                    JxBrowserUtil.enableDebug(engineOptionsBuilder);
                }
                engineOptionsBuilder.addSwitch("--disable-features=OptimizationGuideModelDownloading,OptimizationHintsFetching,OptimizationTargetPrediction,OptimizationHints,AutofillServerCommunication");
                engineOptionsBuilder.addSwitch("--do-not-de-elevate");
                if (DISABLE_GPU) {
                    log.fine("GPU disable");
                    engineOptionsBuilder.disableGpu();
                }
                if (null != (sysLang = this.lookupLanguageCode(Context.getLanguageTag((Context)this.context)))) {
                    Locale browserLocale = Locale.forLanguageTag(sysLang);
                    Optional language = Language.of((Locale)browserLocale);
                    language.ifPresent(value -> {
                        log.fine("Setting language:" + value);
                        engineOptionsBuilder.language(value);
                    });
                }
                AccessController.doPrivileged(() -> {
                    engineOptionsBuilder.addScheme(Scheme.HTTPS, params -> WbJxBrowserUtil.loadModuleResource(params));
                    engineOptionsBuilder.addScheme(Scheme.of((String)"module"), params -> WbJxBrowserUtil.loadModuleResource(params));
                    return null;
                });
                BJxWebBrowserImpl.setChromiumDir();
                Path defaultDataDir = AccessController.doPrivileged(() -> Environment.defaultChromiumDir().resolve("data"));
                BrowserView primaryBrowserView = null;
                int i = 0;
                while (primaryBrowserView == null) {
                    block15: {
                        String suffix = i == 0 ? "" : String.valueOf(i);
                        engineOptionsBuilder.userDataDir(Paths.get(defaultDataDir.toString() + suffix, new String[0]));
                        try {
                            primaryBrowserView = BJxWebBrowserImpl.makeBrowserView();
                        }
                        catch (UserDataDirectoryAlreadyInUseException e) {
                            if (i < 1000) break block15;
                            throw e;
                        }
                    }
                    ++i;
                }
                if (BWebBrowserOptions.get().getClearCacheOnStartup()) {
                    this.clearCache();
                }
                int initialCacheSize = Math.max(Sys.isStation() ? INITIAL_STATION_BROWSER_CACHE_SIZE : INITIAL_BROWSER_CACHE_SIZE, 1);
                for (int i2 = 0; i2 < initialCacheSize; ++i2) {
                    if (i2 == 0) {
                        browserCache.add(primaryBrowserView);
                        continue;
                    }
                    browserCache.add(BJxWebBrowserImpl.makeBrowserView());
                }
            }
            catch (Throwable e) {
                if ((e instanceof InterruptedException || e.getCause() instanceof InterruptedException) && options.get("interrupted") == null) {
                    log.log(Level.SEVERE, "JxBrowser failed to initialize due to Interruption, trying again", e);
                    HashMap<String, String> map = new HashMap<String, String>(options);
                    map.put("interrupted", "interrupted");
                    return this.preInitialize(map);
                }
                log.log(Level.SEVERE, "Cannot pre-initialize JxBrowser", e);
                preInitError = e;
            }
        }
        return preInitError == null;
    }

    private static void setChromiumDir() {
        if (OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.windows) && !BWebWidget.IS_WEB_LAUNCHER) {
            engineOptionsBuilder.chromiumDir(BJxWebBrowserImpl.getJxBrowserDirPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBrowser() {
        if (this.jx == null || this.jxView == null) {
            String debugUrl;
            List<BrowserView> list = browserCache;
            synchronized (list) {
                if (!browserCache.isEmpty()) {
                    this.jxView = browserCache.remove(0);
                    this.jx = this.jxView.getBrowser();
                    if (BJxWebBrowserImpl.fineLoggable()) {
                        this.logFine("JxBrowser from cache");
                    }
                }
            }
            if (this.jxView == null) {
                this.jxView = BJxWebBrowserImpl.makeBrowserView();
                this.jx = this.jxView.getBrowser();
                if (BJxWebBrowserImpl.fineLoggable()) {
                    this.logFine("JxBrowser new");
                }
            }
            if (BWebWidget.DEBUG_DELAY && (debugUrl = this.getDebugUrl()) != null && !debugUrl.equals(lastDebugUrlPrinted)) {
                Clipboard.getDefault().setContents(TransferEnvelope.make((String)debugUrl));
                System.out.println("debug URL Copied to Clipboard:");
                System.out.println(debugUrl);
                lastDebugUrlPrinted = debugUrl;
            }
            this.initializeBrowserHandlers();
        }
    }

    private static synchronized Engine getEngine() {
        return AccessController.doPrivileged(() -> {
            if (engine == null) {
                engine = Engine.newInstance((EngineOptions)engineOptionsBuilder.build());
                try {
                    engine.profiles().defaultProfile().preferences().disableAutofill();
                }
                catch (Throwable e) {
                    log.log(Level.FINE, "Cannot disable auto fill", e);
                }
            }
            return engine;
        });
    }

    private static synchronized BrowserView makeBrowserView() {
        BrowserView view = AccessController.doPrivileged(() -> BrowserView.newInstance((Browser)BJxWebBrowserImpl.getEngine().newBrowser()));
        browserInstances.add(view);
        return view;
    }

    private void initializeBrowserHandlers() {
        AccessController.doPrivileged(() -> {
            BWebBrowser browser = this.getBrowser();
            browser.setFlags((Slot)BWebBrowser.contextMenuEnabled, browser.getFlags((Slot)BWebBrowser.contextMenuEnabled) | 4);
            browser.setFlags((Slot)BWebBrowser.showProgressIndicator, browser.getFlags((Slot)BWebBrowser.showProgressIndicator) | 4);
            if (this.jx == null || this.jx.isClosed()) {
                this.initBrowser();
            }
            this.onEvents.add(this.jx.on(ConsoleMessageReceived.class, event -> this.handleConsoleEvent((ConsoleMessageReceived)event)));
            Network network = this.jx.engine().network();
            JxBrowserUtil.registerReceiveHeadersCallback(network);
            network.set(VerifyCertificateCallback.class, (Callback)((VerifyCertificateCallback)params -> {
                Certificate certificate = params.certificate();
                List chainCerts = params.intermediateCertificates();
                ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
                chainCerts.add(0, certificate);
                NX509Certificate nxCert = null;
                try {
                    URL mainUrl;
                    String mainHost;
                    for (Certificate chainCert : chainCerts) {
                        X509Certificate cert = (X509Certificate)chainCert.toX509Certificate().orElseThrow(CertificateParsingException::new);
                        if (nxCert == null) {
                            nxCert = NX509Certificate.make((X509Certificate)cert);
                        }
                        certs.add(cert);
                    }
                    String hostName = params.host().value();
                    hostName = BrowserUtil.getHostForBrowserURI((String)hostName);
                    URI uri = new URI("https://" + hostName);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("certificate check starting: " + uri);
                    }
                    boolean isMainHost = false;
                    String host = hostName + ':' + 443;
                    if (this.mainFrameUrl != null && host.equals(mainHost = (mainUrl = new URL(this.mainFrameUrl)).getHost() + ':' + 443)) {
                        isMainHost = true;
                        if (Sys.isStation() && BrowserUtil.isLocalHost((String)hostName)) {
                            int mainPort = mainUrl.getPort();
                            if (mainPort == -1) {
                                mainPort = 443;
                            }
                            try {
                                BWebService webService = BWebService.getMainService();
                                if (webService.getHttpsEnabled() && webService.getHttpsPort().getPublicServerPort() == mainPort) {
                                    if (log.isLoggable(Level.FINE)) {
                                        log.fine("station side localhost with matching port auto-approved.");
                                    }
                                    return VerifyCertificateCallback.Response.valid();
                                }
                            }
                            catch (ServiceNotFoundException webService) {
                                // empty catch block
                            }
                        }
                    }
                    if (BWebWidget.IS_WEB_LAUNCHER) {
                        boolean result = WebLauncherUtil.checkCert(certs.toArray(NO_CERTS), uri, this.mainFrameUrl, false);
                        if (result) {
                            return VerifyCertificateCallback.Response.valid();
                        }
                        this.pendingCertApprovals.add(new CertApprovalInfo(nxCert, certs.toArray(NO_CERTS), uri, this.mainFrameUrl));
                        if (isMainHost) {
                            this.certificateError = BWebBrowser.getCertificateBlockedMessage((Context)this.context);
                        }
                        return VerifyCertificateCallback.Response.invalid((CertVerificationStatus[])new CertVerificationStatus[0]);
                    }
                    CoreCryptoManager mgr = CoreCryptoManager.get();
                    CoreClientTrustManager trustManager = CoreClientTrustManager.make((CoreCryptoManager)mgr, DefaultExemptionApprover::new);
                    try {
                        trustManager.checkServerTrusted(certs.toArray(NO_CERTS), "UNKNOWN", hostName, 443);
                        return VerifyCertificateCallback.Response.valid();
                    }
                    catch (CertificateException mainPort) {
                        ICoreExemptionStore exemptionStore = mgr.getExemptionStore();
                        if (Sys.isStation() || DISABLE_CERT_DIALOG) {
                            if (isMainHost) {
                                log.warning("The main web resource will not load due to certificate warning: " + host);
                                this.certificateError = BWebBrowser.getCertificateBlockedMessage((Context)this.context);
                            } else {
                                log.warning("Web resource will not load due to certificate warning: " + host);
                            }
                            BJxWebBrowserImpl.addToExceptionStore(nxCert, host, false, exemptionStore);
                            return VerifyCertificateCallback.Response.invalid((CertVerificationStatus[])new CertVerificationStatus[0]);
                        }
                        boolean exemptionApproved = false;
                        if (isMainHost) {
                            BJxWebBrowserImpl.addToExceptionStore(nxCert, host, false, exemptionStore);
                            this.pendingCertApprovals.add(new CertApprovalInfo(nxCert, certs.toArray(NO_CERTS), uri, this.mainFrameUrl));
                        } else {
                            log.warning("Web resource will not load due to certificate warning: " + host);
                            BJxWebBrowserImpl.addToExceptionStore(nxCert, host, false, exemptionStore);
                        }
                        if (exemptionApproved) {
                            return VerifyCertificateCallback.Response.valid();
                        }
                        if (isMainHost) {
                            this.certificateError = BWebBrowser.getCertificateBlockedMessage((Context)this.context);
                        }
                        return VerifyCertificateCallback.Response.invalid((CertVerificationStatus[])new CertVerificationStatus[0]);
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error parsing SSL Certificate", e);
                    this.certificateError = BWebBrowser.getCertificateBlockedMessage((Context)this.context);
                    return VerifyCertificateCallback.Response.invalid((CertVerificationStatus[])new CertVerificationStatus[0]);
                }
            }));
            this.jx.set(AlertCallback.class, (Callback)((AlertCallback)(params, tell) -> {
                BDialog.info((BWidget)browser, (Object)params.message());
                tell.ok();
            }));
            this.jx.set(ConfirmCallback.class, (Callback)((ConfirmCallback)(params, tell) -> {
                if (BDialog.confirm((BWidget)browser, (Object)params.message()) == 4) {
                    tell.ok();
                }
                tell.cancel();
            }));
            this.jx.set(PromptCallback.class, (Callback)((PromptCallback)(params, tell) -> {
                if (BDialog.prompt((BWidget)browser, (String)"", (String)params.message(), (int)20) != null) {
                    tell.ok(params.text());
                }
                tell.cancel();
            }));
            this.jx.set(OpenFileCallback.class, (Callback)((OpenFileCallback)(params, tell) -> {
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        Path[] paths = WbJxBrowserUtil.openFiles((BWidget)this, params.acceptableExtensions(), params.filterDescription(), false, this.context);
                        if (paths.length > 0) {
                            tell.open(paths[0]);
                        }
                        tell.cancel();
                    });
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    // empty catch block
                }
            }));
            this.jx.set(OpenFilesCallback.class, (Callback)((OpenFilesCallback)(params, tell) -> {
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        Path[] paths = WbJxBrowserUtil.openFiles((BWidget)this, params.acceptableExtensions(), params.filterDescription(), true, this.context);
                        if (paths.length > 0) {
                            tell.open(paths);
                        }
                        tell.cancel();
                    });
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    // empty catch block
                }
            }));
            this.jx.set(SelectClientCertificateCallback.class, (Callback)((SelectClientCertificateCallback)(params, tell) -> {
                try {
                    if (this.showSelectCertificateDialog((SelectClientCertificateCallback.Params)params)) {
                        List certificates = params.certificates();
                        BDynamicEnum dynamicEnum = BJxWebBrowserImpl.getCertificateEnum(certificates);
                        String hostPort = params.hostPort().host().value() + ':' + params.hostPort().port().value();
                        String title = this.getLexicon().getText("selectCert", new Object[]{hostPort});
                        dynamicEnum = (BDynamicEnum)BWbFieldEditor.dialog((BWidget)this, (String)title, (BObject)dynamicEnum, (Context)BFacets.make((String)"fieldEditor", (String)BFrozenEnumFE.TYPE.toString()));
                        if (dynamicEnum == null) {
                            tell.cancel();
                        }
                        tell.select(dynamicEnum.getOrdinal());
                        this.logFine("Certificate selected: " + SlotPath.unescape((String)dynamicEnum.getTag()));
                    } else {
                        tell.cancel();
                    }
                }
                catch (Exception e) {
                    tell.cancel();
                    throw new BajaRuntimeException((Throwable)e);
                }
            }));
            this.jx.set(BeforeUnloadCallback.class, (Callback)((BeforeUnloadCallback)(params, tell) -> tell.leave()));
            this.jx.set(PressKeyCallback.class, (Callback)((PressKeyCallback)params -> {
                AwtShellManager shellManager;
                int mod = 0;
                if (params.event().keyModifiers().isShiftDown()) {
                    mod = 64;
                }
                if (params.event().keyModifiers().isAltDown()) {
                    mod |= 0x200;
                }
                if (params.event().keyModifiers().isControlDown()) {
                    mod |= 0x80;
                }
                if (params.event().keyModifiers().isAltGraphDown()) {
                    mod |= 0x2000;
                }
                if (params.event().keyModifiers().isMetaDown()) {
                    mod |= 0x100;
                }
                if ((shellManager = this.getAwtShellManager()) != null) {
                    if (mod != 0) {
                        KeyEvent event = new KeyEvent((Component)this.jxView, 401, System.currentTimeMillis(), mod, params.event().keyCode().getNumber(), params.event().keyChar());
                        BWidget.invokeLater(() -> shellManager.processKeyEvent(event));
                    } else {
                        shellManager.userActivity();
                    }
                }
                return PressKeyCallback.Response.proceed();
            }));
            this.jx.set(MoveMouseCallback.class, (Callback)((MoveMouseCallback)params -> {
                AwtShellManager shellManager = this.getAwtShellManager();
                if (shellManager != null) {
                    shellManager.userActivity();
                }
                return MoveMouseCallback.Response.proceed();
            }));
            this.jx.set(BeforeFormRepostCallback.class, (Callback)((BeforeFormRepostCallback)(params, tell) -> {
                if (BDialog.confirm((BWidget)browser, (String)params.title(), (Object)params.message(), (int)12) == 4) {
                    tell.repost();
                }
                tell.cancel();
            }));
            this.jx.set(SelectColorCallback.class, (Callback)((SelectColorCallback)(params, tell) -> {
                Color defaultColor = params.defaultColor();
                BColor selected = BColorChooser.openInDialog((BWidget)browser, (BColor)BColor.make((int)((int)defaultColor.red()), (int)((int)defaultColor.blue()), (int)((int)defaultColor.green()), (int)((int)defaultColor.alpha())));
                if (selected != null) {
                    Color selectedColor = Color.newBuilder().red((float)((double)selected.getRed() / 255.0)).green((float)((double)selected.getGreen() / 255.0)).blue((float)((double)selected.getBlue() / 255.0)).alpha((float)((double)selected.getAlpha() / 255.0)).build();
                    tell.select(selectedColor);
                }
                tell.cancel();
            }));
            this.jx.set(CreatePopupCallback.class, (Callback)((CreatePopupCallback)params -> {
                BWidget.invokeLater(() -> {
                    BWbShell shell = BrowserUtil.findWbShell((BComplex)this);
                    if (shell != null) {
                        shell.hyperlink(new HyperlinkInfo(BOrd.make((String)params.targetUrl()), BHyperlinkMode.newTab));
                    }
                });
                return CreatePopupCallback.Response.suppress();
            }));
            this.jx.set(InjectJsCallback.class, (Callback)((InjectJsCallback)params -> {
                if (!params.frame().isMain()) {
                    return InjectJsCallback.Response.proceed();
                }
                JsObject window = (JsObject)params.frame().executeJavaScript("window");
                Map<String, MethodNameSupplier> map = this.browserRegisteredFunctions;
                synchronized (map) {
                    for (String functionName : this.browserRegisteredFunctions.keySet()) {
                        MethodNameSupplier callbackFunction = this.browserRegisteredFunctions.get(functionName);
                        String functionObjectName = functionName + "_CallbackObj";
                        window.putProperty(functionObjectName, (Object)callbackFunction);
                        JsObject acceptFunc = (JsObject)params.frame().executeJavaScript("window." + functionObjectName + '.' + callbackFunction.getMethodName());
                        window.putProperty(functionName, (Object)acceptFunc);
                        window.removeProperty(functionObjectName);
                    }
                }
                return InjectJsCallback.Response.proceed();
            }));
            this.onEvents.add(this.jx.on(StatusChanged.class, event -> {
                String msg = event.statusText();
                if (msg != null && !msg.isEmpty()) {
                    BWidget.invokeLater(() -> browser.fireStatusMsg(BString.make((String)msg)));
                }
            }));
            this.jx.navigation().set(ShowNetErrorPageCallback.class, (Callback)((ShowNetErrorPageCallback)params -> {
                try {
                    URL url = new URL(params.url());
                    if (url.getPort() != -1 && params.error().getNumber() == NetError.SSL_PROTOCOL_ERROR.getNumber()) {
                        url = new URL(url.getProtocol(), url.getHost(), url.getPort(), "/");
                        this.sslProtocolError = this.getLexicon().getText("sslProtocolErrorMessageForNonStandardPort", new Object[]{url});
                        this.repaint();
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "JxBrowser unable to customize error page", e);
                }
                return ShowNetErrorPageCallback.Response.showDefault();
            }));
            this.jx.navigation().set(StartNavigationCallback.class, (Callback)((StartNavigationCallback)params -> {
                if (BJxWebBrowserImpl.fineLoggable()) {
                    this.logFine("StartNavigationCallback called for URL " + params.url());
                }
                if (params.isMainFrame()) {
                    this.mainFrameUrl = params.url();
                }
                if (params.url().equals(this.mainFrameUrl) && !this.isWhitelisted(params.url())) {
                    if (BJxWebBrowserImpl.fineLoggable()) {
                        this.logFine("URL not allowed by whitelist; canceling load");
                    }
                    this.whitelistError = BWebBrowser.getWhitelistBlockedMessage((Context)this.context);
                    browser.setLocation(params.url());
                    browser.fireAppendHistory(BOrd.make((String)params.url()));
                    return StartNavigationCallback.Response.ignore();
                }
                if (!params.isMainFrame() && !this.isWhitelisted(params.url())) {
                    if (BJxWebBrowserImpl.fineLoggable()) {
                        this.logFine("URL not allowed by whitelist; canceling load for non-mainFrame");
                    }
                    return StartNavigationCallback.Response.ignore();
                }
                this.whitelistError = null;
                this.sslProtocolError = null;
                return StartNavigationCallback.Response.start();
            }));
            this.onEvents.add(this.jx.navigation().on(NavigationFinished.class, event -> {
                if (BJxWebBrowserImpl.fineLoggable()) {
                    this.logFine("NavigationFinished called for URL " + event.url());
                }
                try {
                    if (!event.frame().isMain() || event.isSameDocument()) {
                        return;
                    }
                }
                catch (IllegalStateException ignore) {
                    return;
                }
                BWidget.invokeLater(() -> {
                    String url = event.url();
                    if (JxBrowserUtil.isEmptyLocation(url)) {
                        url = "";
                    }
                    if (!url.isEmpty()) {
                        browser.setLocation(url);
                    }
                    if (!this.fromLoad && !url.isEmpty()) {
                        browser.fireAppendHistory(BOrd.make((String)event.url()));
                    }
                    this.fromLoad = false;
                });
            }));
            this.onEvents.add(this.jx.navigation().on(com.teamdev.jxbrowser.navigation.internal.rpc.FrameLoadFinished.class, event -> {
                if (BJxWebBrowserImpl.fineLoggable()) {
                    this.logFine("FrameLoadFinished called for URL " + event.url());
                }
                try {
                    if (!event.frame().isMain()) {
                        return;
                    }
                }
                catch (IllegalStateException ise) {
                    return;
                }
                try {
                    if (!Sys.isStation() && BGeneralOptions.make().getFontSize() == BFontSize.large) {
                        this.jx.zoom().reset();
                        this.jx.zoom().in();
                    }
                    this.post(() -> {
                        try {
                            String debugUrl;
                            String url = event.url();
                            if (url.startsWith("chrome-error://") || JxBrowserUtil.isEmptyLocation(url)) {
                                url = "";
                            }
                            if (!url.isEmpty()) {
                                browser.setLocation(url);
                            }
                            if (this.onLoaded != null) {
                                this.onLoaded.run();
                            }
                            this.injectInterop();
                            if (BWidget.getApplication() != null && BWebBrowserOptions.get().getWebDevelopmentTools() && (debugUrl = AccessController.doPrivileged(() -> JxBrowserUtil.getRemoteDebuggingUrl(this.jx))) != null && !debugUrl.equals(lastDebugUrlPrinted)) {
                                System.out.println("*** Chromium debug URL: " + debugUrl);
                                lastDebugUrlPrinted = debugUrl;
                            }
                            this.showProgress = false;
                            browser.fireLoaded(BBoolean.TRUE);
                            this.relayout();
                            this.repaint();
                        }
                        catch (Exception e) {
                            this.showProgress = false;
                            BWebBrowser.log.log(Level.WARNING, "Failed to load browser content", e);
                        }
                    });
                }
                catch (Exception e) {
                    this.showProgress = false;
                    BWebBrowser.log.log(Level.WARNING, "Failed to load browser content", e);
                }
            }));
            this.onEvents.add(this.jx.navigation().on(FrameLoadFailed.class, event -> {
                if (BJxWebBrowserImpl.fineLoggable()) {
                    this.logFine("FrameLoadFailed called for URL " + event.url());
                }
                try {
                    if (!event.frame().isMain()) {
                        return;
                    }
                }
                catch (IllegalStateException ise) {
                    return;
                }
                NetError errorCode = event.error();
                if (errorCode == NetError.ABORTED) {
                    if (BJxWebBrowserImpl.fineLoggable()) {
                        this.logFine("skipping FrameLoadFailed for aborted " + event.url());
                    }
                    return;
                }
                BWidget.invokeLater(() -> {
                    browser.fireError(BString.make((String)event.error().toString()));
                    browser.fireLoaded(BBoolean.FALSE);
                });
            }));
            this.onEvents.add(this.jx.on(TitleChanged.class, event -> BWidget.invokeLater(() -> browser.setTitle(event.title()))));
            this.onEvents.add(this.jx.engine().on(EngineCrashed.class, event -> BWidget.invokeLater(() -> {
                this.crashDetected.set(true);
                this.pendingCertApprovals.clear();
                BJxWebBrowserImpl.disposeAll();
                String errorMessage = "Web Browser crash detected: " + event;
                log.severe(errorMessage);
                BWbShell shell = BrowserUtil.findWbShell((BComplex)browser);
                if (shell != null) {
                    int result = BDialog.open((BWidget)shell, (String)BDialog.TITLE_ERROR, (Object)this.getLexicon().get("crashMessage"), (int)12, (BImage)BDialog.ERROR_ICON, (Throwable)new IOException(errorMessage));
                    BWbView view = shell.getActiveView();
                    if (view != null) {
                        NHyperlinkInfo.clearCache((BWbView)view);
                        view.clearModified();
                    }
                    if (result == 4) {
                        shell.getRefreshCommand().invoke();
                    }
                }
            })));
            this.onEvents.add(this.jx.on(BrowserBecameUnresponsive.class, event -> {
                log.severe("Browser Became Unresponsive");
                event.browser().close();
                this.pendingCertApprovals.clear();
            }));
            this.onEvents.add(this.jx.on(RenderProcessTerminated.class, event -> {
                if (BJxWebBrowserImpl.fineLoggable()) {
                    this.logFine("RenderProcessTerminated called");
                }
                BWidget.invokeLater(() -> {
                    boolean isMainFrame = this.isMainFrame((RenderProcessTerminated)event);
                    if (this.certificateError != null) {
                        if (BJxWebBrowserImpl.fineLoggable()) {
                            this.logFine("RenderProcessTerminated: result of certificateError error. Disposing BrowserView instance:" + this.certificateError);
                        }
                        this.crashDetected.set(true);
                        this.close();
                        CertApprovalInfo[] certApprovalInfoArray = this.pendingCertApprovals;
                        synchronized (this.pendingCertApprovals) {
                            CertApprovalInfo[] currentCertApprovals = this.pendingCertApprovals.toArray(EMPTY_CERT_APPROVALS);
                            this.pendingCertApprovals.clear();
                            // ** MonitorExit[var5_4] (shouldn't be in output)
                            for (CertApprovalInfo certApprovalInfo : currentCertApprovals) {
                                this.post(() -> {
                                    try {
                                        Object object = CERT_DIALOG_MONITOR;
                                        synchronized (object) {
                                            if (BWebWidget.IS_WEB_LAUNCHER) {
                                                WebLauncherUtil.checkCert(certApprovalInfo.certs, certApprovalInfo.uri, certApprovalInfo.mainFrameUrl, true);
                                            } else {
                                                CoreCryptoManager mgr = CoreCryptoManager.get();
                                                ICoreExemptionStore exemptionStore = mgr.getExemptionStore();
                                                String hostName = certApprovalInfo.uri.getHost();
                                                String host = hostName + ':' + 443;
                                                CertValidationResult result = TridiumCertValidator.validateCertificate((ICoreCryptoManager)mgr, (X509Certificate[])certApprovalInfo.certs, (String)hostName, (String)host);
                                                if (result.isHostnameVerified() && !result.isCertExpired() && result.isValidCertChain() || result.isApproved()) {
                                                    return;
                                                }
                                                boolean approved = new WbExemptionApprover().approveExemption(result);
                                                BJxWebBrowserImpl.addToExceptionStore(certApprovalInfo.nxCert, host, approved, exemptionStore);
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        log.log(Level.SEVERE, "JxBrowser failed to add Certificate to Exception Store", e);
                                    }
                                });
                            }
                            return;
                        }
                    }
                    if (this.whitelistError != null) {
                        if (isMainFrame) {
                            if (BJxWebBrowserImpl.fineLoggable()) {
                                this.logFine("RenderProcessTerminated: result of whitelist error. Disposing BrowserView instance.");
                            }
                            this.crashDetected.set(true);
                            this.close();
                        } else if (BJxWebBrowserImpl.fineLoggable()) {
                            this.logFine("RenderProcessTerminated: result of whitelist error for iframe");
                        }
                        return;
                    }
                    if (event.exitCode() == 0) {
                        if (this.isMainFrame((RenderProcessTerminated)event)) {
                            this.logFine("RenderProcessTerminated: main frame has exited normally" + event);
                            this.crashDetected.set(true);
                            this.close();
                        } else {
                            this.logFine("RenderProcessTerminated: non-main frame has exited normally: " + event);
                        }
                        return;
                    }
                    if (BJxWebBrowserImpl.fineLoggable()) {
                        this.logFine("RenderProcessTerminated callback: crash detected. Disposing all BrowserViews and alerting user.");
                    }
                    this.crashDetected.set(true);
                    BJxWebBrowserImpl.disposeAll();
                    String errorMessage = "Web Browser crash detected: " + event;
                    BWbShell shell = BrowserUtil.findWbShell((BComplex)browser);
                    if (shell != null) {
                        int result = BDialog.open((BWidget)shell, (String)BDialog.TITLE_ERROR, (Object)this.getLexicon().get("crashMessage"), (int)12, (BImage)BDialog.ERROR_ICON, (Throwable)new IOException(errorMessage));
                        BWbView view = shell.getActiveView();
                        if (view != null) {
                            NHyperlinkInfo.clearCache((BWbView)view);
                            view.clearModified();
                        }
                        if (result == 4) {
                            shell.getRefreshCommand().invoke();
                        }
                    }
                });
            }));
            JxBrowserUtil.configureStoredPasswordSupport(this.jx);
            this.jx.set(StartDownloadCallback.class, (Callback)((StartDownloadCallback)(params, tell) -> {
                AtomicBoolean retVal = new AtomicBoolean(false);
                final Download download = params.download();
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        BFileChooser chooser = BFileChooser.makeSave((BWidget)this);
                        chooser.setDefaultFileName(download.target().suggestedFileName());
                        BOrd[] ords = chooser.show(false);
                        if (ords.length > 0) {
                            BIFile bfile = (BIFile)ords[0].get();
                            tell.download(BFileSystem.INSTANCE.pathToLocalFile(bfile.getFilePath()).toPath());
                            retVal.set(true);
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    // empty catch block
                }
                if (retVal.get()) {
                    SwingUtilities.invokeLater(() -> {
                        final Lexicon lex = Lexicon.make(BJxWebBrowserImpl.class);
                        BProgressDialog.open((BWidget)this, (String)lex.get("download"), (BProgressDialog.Worker)new BProgressDialog.Worker(){

                            public void doRun() throws Exception {
                                BJxWebBrowserImpl.this.onEvents.add(download.on(DownloadUpdated.class, event -> event.progress().ifPresent(progress -> this.updateProgress((int)progress.value(), lex.getText("downloading", new Object[]{event.download().target().suggestedFileName()})))));
                            }

                            public void doCancel() throws Exception {
                                download.cancel();
                            }
                        });
                    });
                }
            }));
            this.onEvents.add(this.jx.navigation().on(NavigationStarted.class, event -> {
                if (!event.isSameDocument()) {
                    return;
                }
                String url = event.url();
                if (BJxWebBrowserImpl.fineLoggable()) {
                    this.logFine("onLoad called for URL " + url);
                }
                if (url.startsWith("module://")) {
                    BWidget.invokeLater(() -> {
                        BWbShell shell = BrowserUtil.findWbShell((BComplex)browser);
                        if (shell != null) {
                            shell.hyperlink(BOrd.make((String)event.url()));
                        }
                    });
                }
            }));
            return null;
        });
    }

    private boolean showSelectCertificateDialog(SelectClientCertificateCallback.Params params) {
        List certificates;
        if (Sys.isStation()) {
            this.logFine("Skipping browser dialog - running in station");
            return false;
        }
        List list = certificates = params != null ? params.certificates() : null;
        if (certificates == null || certificates.isEmpty()) {
            this.logFine("Skipping browser dialog - no certificates provided");
            return false;
        }
        BISession session = WbUtil.findSession((BComplex)this);
        if (!(session instanceof BFoxSession)) {
            this.logFine("No fox connection found. Skipping cert selection dialog.");
            return false;
        }
        BFoxSession foxSession = (BFoxSession)session;
        BComponent details = BWebWidget.getHttpConnectionDetails((BISession)session);
        BLocalHost host = BLocalHost.INSTANCE;
        boolean isSecure = true;
        if (foxSession != null) {
            isSecure = foxSession.getUseFoxs();
            host = foxSession.getHost();
        } else if (Sys.isStation()) {
            isSecure = ((BBoolean)details.get("httpsEnabled")).getBoolean();
        }
        int port = BWebWidget.getPort((BComponent)details, (boolean)isSecure);
        port = port == -1 ? (isSecure ? 443 : 80) : port;
        String dialogHost = params.hostPort().host().value();
        String sessionHost = host.getHostname();
        if (host instanceof BIpHost) {
            try {
                sessionHost = ((BIpHost)host).getInetAddress().getHostAddress();
            }
            catch (IOException e) {
                log.fine("Could not get IP address from BIPHost for client certificate selection. Using hostname.");
            }
        }
        if (sessionHost.equals(dialogHost) && port == params.hostPort().port().value()) {
            this.logFine("Connecting to station. Skipping cert selection dialog.");
            return false;
        }
        if (!allowDialogs) {
            this.logFine("Skipping browser dialog - dialogs not allowed");
            return false;
        }
        return true;
    }

    private static BDynamicEnum getCertificateEnum(List<Certificate> certificates) {
        ObjectUtil.NameContainerList tags = new ObjectUtil.NameContainerList();
        for (Certificate cert : certificates) {
            Optional o = cert.toX509Certificate();
            o.ifPresent(x509Certificate -> {
                String tag = SlotPath.escape((String)x509Certificate.getSubjectX500Principal().getName());
                tag = ObjectUtil.generateUniqueName((String)tag, (ObjectUtil.NameContainer)tags);
                tags.add((Object)tag);
            });
        }
        BEnumRange range = BEnumRange.make((String[])((String[])tags.toArray((Object[])EMPTY_STRING_ARRAY)));
        return BDynamicEnum.make((int)0, (BEnumRange)range);
    }

    private static void addToExceptionStore(NX509Certificate nxCert, String host, boolean approved, ICoreExemptionStore exemptionStore) {
        try {
            NHostExemption exemption = NHostExemption.make((IX509Certificate)nxCert, (String)host, (boolean)approved);
            exemptionStore.setExemption(exemption);
            exemptionStore.save();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Problem adding exemption for " + host + " to exemption store", e);
        }
    }

    private boolean isMainFrame(RenderProcessTerminated event) {
        int processId = ((RenderProcessTerminatedOrBuilder)event).getRenderProcessId().getValue();
        Optional o = this.jx.mainFrame();
        if (o.isPresent()) {
            int mainProcessId = ((RenderProcess)((Frame)o.get()).renderProcess()).id().getValue();
            return processId == mainProcessId;
        }
        return false;
    }

    private static Path getJxBrowserDirPath() {
        return Paths.get(Nre.getNiagaraHome().toString() + File.separator + "JxBrowser" + File.separator + VersionInfo.version(), new String[0]);
    }

    private String lookupLanguageCode(String code) {
        return AccessController.doPrivileged(() -> {
            File[] localeFiles;
            File match;
            Path chromiumDir = BJxWebBrowserImpl.getJxBrowserDirPath();
            File localeDir = new File(chromiumDir.toFile(), "locales");
            if (localeDir.exists() && localeDir.isDirectory() && null != (match = (File)Arrays.stream(localeFiles = localeDir.listFiles((dir, name) -> name.endsWith(".pak"))).filter(file -> {
                String fileName = file.getName();
                fileName = fileName.substring(0, fileName.indexOf(".pak"));
                return fileName.equalsIgnoreCase(code);
            }).findFirst().orElse(null))) {
                return match.getName().substring(0, match.getName().indexOf(".pak"));
            }
            if (code.split("-").length >= 2) {
                return this.lookupLanguageCode(code.substring(0, code.lastIndexOf("-")));
            }
            return null;
        });
    }

    protected void doInitialize() {
        this.initBrowser();
        if (!this.webEngInit.getAndSet(true)) {
            this.load();
        }
    }

    protected void removeFromShell() {
        if (this.getBrowser().isCloseOnStop()) {
            this.close();
        }
        super.removeFromShell();
    }

    public void close() {
        AccessController.doPrivileged(() -> {
            if (BJxWebBrowserImpl.fineLoggable()) {
                this.logFine("close called");
            }
            if (this.closed.getAndSet(true)) {
                if (BJxWebBrowserImpl.fineLoggable()) {
                    this.logFine("already closed");
                }
                return null;
            }
            if (this.jx == null) {
                if (BJxWebBrowserImpl.fineLoggable()) {
                    this.logFine("no browser instance present");
                }
                return null;
            }
            int count = 0;
            while (!this.crashDetected.get() && !this.jx.isClosed() && this.jx.navigation().isLoading()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (++count <= 5) continue;
            }
            if (count == 0) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.detachInterop();
            HTML_MAP.remove(this.jx);
            this.consoleEventHandlers.clear();
            this.browserRegisteredFunctions.clear();
            for (Subscription onEvent : this.onEvents) {
                onEvent.unsubscribe();
            }
            this.onEvents.clear();
            this.jx.navigation().stop();
            if (!this.crashDetected.get() && browserCache.size() < MAX_BROWSER_CACHE_SIZE) {
                if (!browserCache.contains(this.jxView)) {
                    if (!this.jx.isClosed()) {
                        try {
                            BJxWebBrowserImpl.navigateToUnloadUrl(this.jx);
                        }
                        catch (Exception e) {
                            if (BJxWebBrowserImpl.fineLoggable()) {
                                this.logFine("JxBrowser navigation exception on unload", e);
                            }
                            this.jx.close();
                            if (BJxWebBrowserImpl.fineLoggable()) {
                                this.logFine("JxBrowser disposed");
                            }
                            this.webEngInit.set(false);
                            this.contentLoaded.set(false);
                            return null;
                        }
                    }
                    browserCache.add(this.jxView);
                    if (BJxWebBrowserImpl.fineLoggable()) {
                        this.logFine("JxBrowser to cache");
                    }
                }
            } else {
                browserInstances.remove(this.jxView);
                this.jx.close();
                if (BJxWebBrowserImpl.fineLoggable()) {
                    this.logFine("JxBrowser disposed");
                }
            }
            this.webEngInit.set(false);
            this.contentLoaded.set(false);
            return null;
        });
    }

    public static void navigateToUnloadUrl(Browser browser) {
        CountDownLatch latch = new CountDownLatch(1);
        Subscription loadFinished = browser.navigation().on(FrameLoadFinished.class, e -> {
            if (e.frame().isMain() && e.url().contains(BLANK_HTML_URL)) {
                latch.countDown();
            }
        });
        browser.navigation().loadUrl(BLANK_HTML_URL);
        try {
            long timeoutDuration = WbJxBrowserUtil.getDefaultTimeout();
            if (!latch.await(timeoutDuration, TimeUnit.SECONDS)) {
                throw new TimeoutException("Failed to navigate to unload url within " + timeoutDuration + " seconds.");
            }
        }
        catch (InterruptedException e2) {
            throw new RuntimeException("Failed to navigate to unload url.", e2);
        }
        finally {
            loadFinished.unsubscribe();
        }
    }

    private static void waitForResize(Browser browser, int width, int height) {
        browser.resize(width, height);
        try {
            Thread.sleep(PDF_RESIZE_DELAY);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        if (this.whitelistError != null || this.certificateError != null || this.sslProtocolError != null) {
            BLabel label = new BLabel(this.whitelistError != null ? this.whitelistError : (this.certificateError != null ? this.certificateError : this.sslProtocolError));
            label.setPadding(BInsets.make((double)3.0));
            label.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            label.setValign(BValign.top);
            label.setHalign(BHalign.left);
            label.setWordWrapEnabled(true);
            label.layout();
            StyleUtils.addStyleClass((IStylable)label, (String)"error");
            label.setForeground(Theme.label().getTextBrush((IStylable)label));
            label.setBackground(Theme.label().getControlBackground((IStylable)label));
            label.paint(g);
            return;
        }
        if (g instanceof PdfGraphics) {
            try {
                BJxWebBrowserImpl.waitForResize(this.jx, (int)this.getWidth(), (int)this.getHeight());
                Bitmap bitmap = BJxWebBrowserImpl.createBitmap(this.jx);
                BufferedImage bufferedImage = BitmapImage.toToolkit((Bitmap)bitmap);
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    ImageIO.write((RenderedImage)bufferedImage, "PNG", out);
                    g.drawImage(BImage.make((byte[])out.toByteArray()), 0.0, 0.0);
                }
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Failed to render WebBrowser to PDF", e);
            }
        } else if (this.showProgress) {
            g.push();
            try {
                double ww = this.getWidth();
                double wh = this.getHeight();
                g.setBrush(progressWndBg);
                g.fillRect(0.0, 0.0, ww, wh);
                double w = ww / 2.0;
                double h = 20.0;
                double xOffset = Math.ceil(ww / 2.0 - w / 2.0);
                double yOffset = Math.ceil(wh / 2.0 - h / 2.0);
                g.clip(xOffset, yOffset, w, h);
                g.translate(xOffset, yOffset);
                g.setBrush(progressBg);
                g.fillRect(0.0, 0.0, w, h);
                g.setBrush(progressFg);
                int i = -((int)(h + 16.0));
                while ((double)i < w) {
                    int x = i + this.progressOff;
                    g.strokeLine((double)x, h, (double)x + h, 0.0);
                    g.strokeLine((double)(x + 1), h, (double)x + h + 1.0, 0.0);
                    g.strokeLine((double)(x + 2), h, (double)x + h + 2.0, 0.0);
                    g.strokeLine((double)(x + 3), h, (double)x + h + 3.0, 0.0);
                    g.strokeLine((double)(x + 4), h, (double)x + h + 4.0, 0.0);
                    g.strokeLine((double)(x + 5), h, (double)x + h + 5.0, 0.0);
                    g.strokeLine((double)(x + 6), h, (double)x + h + 6.0, 0.0);
                    g.strokeLine((double)(x + 7), h, (double)x + h + 7.0, 0.0);
                    g.strokeLine((double)(x + 8), h, (double)x + h + 8.0, 0.0);
                    i += 16;
                }
                g.setBrush(progressBorder);
                g.strokeRect(0.0, 0.0, w - 1.0, h - 1.0);
            }
            finally {
                g.pop();
            }
        } else if (!HEAVYWEIGHT_MODE) {
            super.paint(g);
        }
    }

    public void doLayout(BWidget[] children) {
        super.doLayout(children);
        BrowserView view = this.jxView;
        if (view != null && view.getComponentCount() > 0) {
            try {
                Component c = view.getComponent(0);
                c.setBounds(new Rectangle((int)this.getWidth(), (int)this.getHeight()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void animate() {
        if (this.showProgress) {
            this.progressOff += 4;
            if (this.progressOff >= 16) {
                this.progressOff = 0;
            }
            this.repaint();
        }
    }

    public int doDragOver(TransferContext cx) {
        boolean enabled = AccessController.doPrivileged(() -> this.jx != null && !this.jx.isClosed());
        if (enabled && cx.isCopy() && cx.getEnvelope().supports(TransferFormat.mark) && this.dropHandler != null) {
            return this.dropHandler.doDragOver(cx);
        }
        return 0;
    }

    public CommandArtifact doDrop(TransferContext cx) throws Exception {
        boolean enabled = AccessController.doPrivileged(() -> this.jx != null && !this.jx.isClosed());
        if (enabled && cx.isCopy() && cx.getEnvelope().supports(TransferFormat.mark) && this.dropHandler != null) {
            return this.dropHandler.doDrop(cx);
        }
        return null;
    }

    private BOrd getActiveOrd() {
        String location = this.getBrowser().getLocation();
        if (JxBrowserUtil.isEmptyLocation(location)) {
            return BrowserUtil.getActiveOrd((Context)this.context);
        }
        return BOrd.make((String)location);
    }

    public String getScheme() {
        BOrd ord = this.getActiveOrd();
        String scheme = BrowserUtil.getScheme((BOrd)this.getActiveOrd());
        if (scheme != null) {
            return scheme;
        }
        throw new IllegalStateException("Could not determine scheme from activeOrd " + ord);
    }

    public String getHostname() {
        BOrd ord = this.getActiveOrd();
        String hostname = BrowserUtil.getHostname((BOrd)ord);
        if (hostname != null) {
            return hostname;
        }
        throw new IllegalStateException("Could not determine hostname from activeOrd " + ord);
    }

    public int getPort() {
        BOrd ord = this.getActiveOrd();
        Integer port = BrowserUtil.getPort((BOrd)ord);
        if (port != null) {
            return port;
        }
        throw new IllegalStateException("Could not determine port from activeOrd " + ord);
    }

    public void browserChanged(Property prop, Context cx) {
        if (prop == BWebBrowser.ord) {
            this.load((BObject)this.getBrowser().getOrd(), cx);
        }
    }

    public void browserReload() {
        if (this.jx != null) {
            AccessController.doPrivileged(() -> {
                this.jx.navigation().reload();
                return null;
            });
        }
    }

    public void setDropHandler(BWebBrowser.IWebBrowserDropHandler dropHandler) {
        this.dropHandler = dropHandler;
    }

    public IJs executeScript(String script) {
        this.initBrowser();
        return AccessController.doPrivileged(() -> JxJs.make(((Frame)this.jx.mainFrame().get()).executeJavaScript(script)));
    }

    public void executeScriptAsync(String script) {
        this.initBrowser();
        AccessController.doPrivileged(() -> {
            ((Frame)this.jx.mainFrame().get()).executeJavaScript(script, result -> {});
            return null;
        });
    }

    public boolean canUseLocalWbResources() {
        return !DISABLE_LOCAL_WB_RESOURCES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(BObject object, Context cx) {
        this.mainFrameUrl = null;
        if (object instanceof BOrd && object.isNull()) {
            return;
        }
        this.content = object;
        this.context = cx;
        if (this.jx == null) {
            return;
        }
        try {
            if (this.onRegisterFunctions != null) {
                this.onRegisterFunctions.run();
            }
            this.attachInterop();
            if (object instanceof BOrd) {
                object = ((BOrd)object).get();
            }
            if (object instanceof BIFile) {
                BIFile file = (BIFile)object;
                try (InputStreamReader reader = new InputStreamReader(file.getInputStream());){
                    object = BString.make((String)FileUtil.readString((Reader)reader));
                }
            }
            this.fromLoad = true;
            if (this.getBrowser().getShowProgressIndicator()) {
                this.showProgress = true;
                this.repaint();
            }
            BObject loadObj = object;
            BWbShell shell = BrowserUtil.findWbShell((BComplex)this);
            try {
                if (shell != null) {
                    shell.enterBusy();
                }
                AccessController.doPrivileged(() -> {
                    if (this.jx.isClosed()) {
                        this.initBrowser();
                    }
                    if (loadObj instanceof BHttpObject) {
                        String uri = BrowserUtil.getURIForBrowser((String)((BHttpObject)loadObj).getUri());
                        if (!this.jx.navigation().isLoading() || !uri.equals(this.jx.url())) {
                            if (uri.startsWith("file:")) {
                                this.jx.mainFrame().ifPresent(frame -> {
                                    try {
                                        if (this.context == null) {
                                            this.context = new BasicContext();
                                        }
                                        FILE_LOAD_CONTEXT_MAP.put(this.jx, this.context);
                                        frame.loadUrl("https://workbench/file.html?" + URLEncoder.encode(uri, "UTF-8"));
                                    }
                                    catch (Exception e) {
                                        HTML_MAP.put(this.jx, this.getLexicon().get("loadFailedMessage", e.getLocalizedMessage()));
                                        frame.loadUrl(LOAD_HTML_URL);
                                    }
                                });
                            } else {
                                this.mainFrameUrl = uri;
                                this.jx.mainFrame().ifPresent(frame -> frame.loadUrl(uri));
                            }
                        }
                    } else if (loadObj instanceof BSpy) {
                        try {
                            this.jx.mainFrame().ifPresent(frame -> {
                                try {
                                    HTML_MAP.put(this.jx, BrowserUtil.createSpyHtml((BSpy)((BSpy)loadObj), (Context)this.context));
                                    frame.loadUrl(LOAD_HTML_URL);
                                }
                                catch (Exception e) {
                                    HTML_MAP.put(this.jx, this.getLexicon().get("loadFailedMessage", e.getLocalizedMessage()));
                                    frame.loadUrl(LOAD_HTML_URL);
                                }
                            });
                        }
                        catch (RuntimeException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        HTML_MAP.put(this.jx, loadObj.toString());
                        this.jx.mainFrame().ifPresent(frame -> frame.loadUrl(LOAD_HTML_URL));
                    }
                    this.closed.set(false);
                    this.contentLoaded.set(true);
                    return null;
                });
            }
            finally {
                if (shell != null) {
                    shell.exitBusy();
                }
            }
        }
        catch (Exception e) {
            BWebBrowser.log.log(Level.WARNING, "Failed to load browser content", e);
        }
    }

    public void setWhitelist(UrlWhitelist whitelist) {
        this.whitelist = whitelist;
    }

    private boolean isWhitelisted(String url) {
        if (JxBrowserUtil.isEmptyLocation(url)) {
            return true;
        }
        return this.whitelist == null || this.whitelist.test(url);
    }

    public void setOnLoaded(Runnable onLoaded) {
        this.onLoaded = onLoaded;
    }

    public void setOnRegisterFunctions(Runnable onRegisterFunctions) {
        this.browserRegisteredFunctions.clear();
        this.onRegisterFunctions = onRegisterFunctions;
    }

    public void setUserAgentStyleSheetLocation(String location) {
    }

    public boolean isInitialized() {
        return this.webEngInit.get() && this.contentLoaded.get();
    }

    public Optional<String> fromJsToString(Object o) {
        if (o == null) {
            return Optional.empty();
        }
        if (o instanceof IJs) {
            return Optional.of(o.toString());
        }
        try {
            IJs js = JxJs.make(o);
            if (js.isNull()) {
                return Optional.empty();
            }
            return Optional.of(js.toString());
        }
        catch (IllegalArgumentException e) {
            return Optional.of(o.toString());
        }
    }

    public boolean isCookiePresent(URI uri, String name, String value, String path) {
        this.initBrowser();
        return AccessController.doPrivileged(() -> this.jx.engine().cookieStore().cookies(uri.toASCIIString()).stream().anyMatch(cookie -> cookie.name().equals(name) && cookie.path().equals(path) && cookie.value().equals(value)));
    }

    public Optional<String> getCookieValue(URI uri, String name, String path) {
        this.initBrowser();
        return AccessController.doPrivileged(() -> this.jx.engine().cookieStore().cookies(uri.toASCIIString()).stream().filter(cookie -> cookie.name().equals(name) && cookie.path().equals(path)).map(Cookie::value).findFirst());
    }

    public void removeCookie(URI uri, String name, String path) {
        this.initBrowser();
        AccessController.doPrivileged(() -> {
            CookieStore storage = this.jx.engine().cookieStore();
            this.jx.engine().cookieStore().cookies(uri.toASCIIString()).stream().filter(cookie -> cookie.name().equals(name) && cookie.path().equals(path)).findFirst().ifPresent(cookie -> WbJxBrowserUtil.removeCookie(cookie, this.jx.engine().cookieStore()));
            return null;
        });
    }

    public void addCookie(URI uri, String name, String value, String path) throws IOException {
        this.initBrowser();
        AccessController.doPrivileged(() -> {
            WbJxBrowserUtil.addCookie(uri, name, value, path, this.jx.engine().cookieStore());
            return null;
        });
    }

    public void register(String name, Runnable func) {
        this.registerCallbackInBrowser(name, new RunnableReflectionWrapper(func));
    }

    public <T, R> void registerFunction(String name, Function<T, R> func) {
        this.registerCallbackInBrowser(name, new FunctionReflectionWrapper(func));
    }

    public <T, U> void registerBiConsumer(String name, BiConsumer<T, U> func) {
        this.registerCallbackInBrowser(name, new BiConsumerReflectionWrapper(func));
    }

    public <T, U, R> void registerBiFunction(String name, BiFunction<T, U, R> func) {
        this.registerCallbackInBrowser(name, new BiFunctionReflectionWrapper(func));
    }

    public <T> void registerConsumer(String name, Consumer<T> func) {
        this.registerCallbackInBrowser(name, new ConsumerReflectionWrapper(func));
    }

    public <R> void registerSupplier(String name, Supplier<R> func) {
        this.registerCallbackInBrowser(name, new SupplierReflectionWrapper(func));
    }

    private void registerCallbackInBrowser(String name, MethodNameSupplier func) {
        this.browserRegisteredFunctions.put(name, func);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(Runnable todo) {
        Object object = executorMon;
        synchronized (object) {
            if (executorSrv == null) {
                executorSrv = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "JxBackgroundThread"));
            }
        }
        executorSrv.submit(todo);
    }

    private void load() {
        this.load((BObject)(this.content != null ? this.content : this.getBrowser().getOrd()), this.context);
    }

    private BWebBrowser getBrowser() {
        return (BWebBrowser)this.getParent();
    }

    private void attachInterop() {
        BROADCAST_CHANNEL_INTEROP.attach((BIWebBrowserImpl)this);
    }

    private void detachInterop() {
        BROADCAST_CHANNEL_INTEROP.detach((BIWebBrowserImpl)this);
    }

    private void injectInterop() {
        try {
            BROADCAST_CHANNEL_INTEROP.injectBroadcastJs((BIWebBrowserImpl)this);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Injecting Broadcast Interop", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void disposeAll() {
        List<BrowserView> list = browserCache;
        synchronized (list) {
            AccessController.doPrivileged(() -> {
                try {
                    for (BrowserView browserView : browserCache) {
                        browserView.getBrowser().close();
                    }
                }
                finally {
                    browserCache.clear();
                }
                return null;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeAllAndShutdown() {
        log.info("start disposeAllAndShutdown");
        try {
            BJxWebBrowserImpl.disposeAll();
        }
        finally {
            Object object = executorMon;
            synchronized (object) {
                if (executorSrv != null) {
                    ExecutorUtil.shutdown((ExecutorService)executorSrv);
                    executorSrv = null;
                }
            }
            if (engine != null && !engine.isClosed()) {
                engine.close();
                engine = null;
            }
        }
        log.info("disposeAllAndShutdown complete");
    }

    public void registerConsoleEventHandler(ConsoleEventHandler listener) {
        this.consoleEventHandlers.add(listener);
    }

    public void removeConsoleEventHandler(ConsoleEventHandler eventHandler) {
        this.consoleEventHandlers.remove(eventHandler);
    }

    private void handleConsoleEvent(ConsoleMessageReceived event) {
        if (WEBBROWSER_CONSOLE) {
            BWebBrowser.consoleLog.info(event.toString());
        }
        JxConsoleEvent jxEvent = new JxConsoleEvent(event);
        for (ConsoleEventHandler handler : this.consoleEventHandlers) {
            handler.onEvent((ConsoleEventHandler.ConsoleEvent)jxEvent);
        }
    }

    public String getFragmentScrollReadyJs() {
        return "return document.body.clientWidth && document.body.clientHeight;";
    }

    private static boolean isWebDevMode() {
        return BWidget.getApplication() != null && BWebBrowserOptions.get().getWebDevelopmentTools();
    }

    public String getDebugUrl() {
        if (!BJxWebBrowserImpl.isWebDevMode() || this.jx == null) {
            return null;
        }
        return AccessController.doPrivileged(() -> JxBrowserUtil.getRemoteDebuggingUrl(this.jx));
    }

    public void clearCache() {
        try {
            BJxWebBrowserImpl.getEngine().httpCache().clear().get(60L, TimeUnit.SECONDS);
            log.log(Level.INFO, "Clear Browser Cache");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unable to Clear Browser Cache", e);
        }
    }

    private static Bitmap createBitmap(Browser browser) throws IOException {
        Bitmap bitmap = browser.bitmap();
        for (int timeout = 0; bitmap.size().isEmpty() && timeout < 10; ++timeout) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            bitmap = browser.bitmap();
        }
        if (bitmap.size().isEmpty()) {
            throw new IOException("Unable to get rendered bitmap from Browser");
        }
        return bitmap;
    }

    public String getDebugId() {
        return this.jxView == null ? "inactive" : BJxWebBrowserImpl.getDebugId(this.jxView);
    }

    private static String getDebugId(BrowserView view) {
        return Integer.toHexString(System.identityHashCode(view));
    }

    public boolean supportsNativePdfExport() {
        return true;
    }

    public void exportToNativePdf(PdfOp op) throws Exception {
        SwingUtilities.invokeAndWait(() -> {
            try {
                this.exportToNativePdfAsync(op);
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportToNativePdfAsync(PdfOp op) throws Exception {
        Bitmap bitmap;
        float heightRatio;
        Size originalSize = this.jx.size();
        float widthRatio = (float)op.getWidth() / (float)originalSize.width();
        float scale = widthRatio > (heightRatio = (float)op.getHeight() / (float)originalSize.height()) ? heightRatio : widthRatio;
        int resizedWidth = (int)((float)originalSize.width() * scale);
        int resizedHeight = (int)((float)originalSize.height() * scale);
        this.setVisible(false);
        try {
            BJxWebBrowserImpl.waitForResize(this.jx, resizedWidth, resizedHeight);
            bitmap = BJxWebBrowserImpl.createBitmap(this.jx);
            this.jx.resize(originalSize);
            this.logFine("Native PDF Export paper size from export: " + originalSize);
        }
        finally {
            this.setVisible(true);
        }
        if (bitmap == null) {
            throw new PdfException("Unable to render Web Widget to PDF");
        }
        BufferedImage bufferedImage = BitmapImage.toToolkit((Bitmap)bitmap);
        PdfDocument doc = new PdfDocument(op.getOutputStream(), op.getWidth(), op.getHeight());
        doc.start();
        PdfPage page = doc.addNewPage();
        PdfGraphics g = doc.getGraphics();
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)bufferedImage, "PNG", out);
            double y = (doc.getPageSize().height() - (double)resizedHeight) / 2.0;
            double x = (doc.getPageSize().width() - (double)resizedWidth) / 2.0;
            g.drawImage(BImage.make((byte[])out.toByteArray()), x, y);
        }
        doc.end();
    }

    public void playSound(BOrd sound) {
        AudioPlayer.getInstance().play(sound);
    }

    public void stopSound(BOrd sound) {
        AudioPlayer.getInstance().stop(sound);
    }

    private static boolean fineLoggable() {
        return log.isLoggable(Level.FINE);
    }

    private void logFine(String message) {
        this.logFine(message, null);
    }

    private void logFine(String message, Exception exception) {
        String prefix = "(BrowserView: " + (this.jxView == null ? "null" : Integer.valueOf(this.jxView.hashCode())) + ") ";
        if (exception == null) {
            log.fine(prefix + message);
        } else {
            log.log(Level.FINE, prefix + message, exception);
        }
    }

    static {
        Spy.ROOT.add("jxBrowser", (Spy)new JxBrowserSpy());
        log = Logger.getLogger("webBrowser");
        JXBROWSER_LOG_LEVEL = Level.OFF;
        try {
            JXBROWSER_LOG_LEVEL = Level.parse(AccessController.doPrivileged(() -> System.getProperty("niagara.jxbrowser.log", "OFF")));
            Logger logger = Logger.getLogger("com.teamdev.jxbrowser");
            logger.setLevel(JXBROWSER_LOG_LEVEL);
        }
        catch (Exception exception) {
            // empty catch block
        }
        progressWndBg = BColor.white.toBrush();
        progressBorder = BColor.grey.toBrush();
        progressFg = BColor.make((int)0, (int)136, (int)206).toBrush();
        progressBg = BColor.make((int)201, (int)237, (int)255).toBrush();
        preInit = new AtomicBoolean();
        browserCache = Collections.synchronizedList(new ArrayList());
        INITIAL_BROWSER_CACHE_SIZE = Math.max(AccessController.doPrivileged(() -> Integer.getInteger("niagara.jxbrowser.initialCacheSize", 1)), 1);
        INITIAL_STATION_BROWSER_CACHE_SIZE = Math.max(AccessController.doPrivileged(() -> Integer.getInteger("niagara.jxbrowser.initialStationCacheSize", 1)), 1);
        MAX_BROWSER_CACHE_SIZE = Math.max(AccessController.doPrivileged(() -> Integer.getInteger("niagara.jxbrowser.maxCacheSize", 10)), 1);
        browserInstances = Collections.newSetFromMap(new WeakHashMap());
        executorMon = new Object();
        BROADCAST_CHANNEL_INTEROP = new JxBroadcastChannel();
        WEBBROWSER_CONSOLE = AccessController.doPrivileged(() -> Boolean.getBoolean("webBrowser.console"));
        HEAVYWEIGHT_MODE = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.jxbrowser.heavyweight"));
        DISABLE_GPU = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.jxbrowser.disableGPU"));
        DISABLE_LOCAL_WB_RESOURCES = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.jxbrowser.disableLocalWbResources"));
        DISABLE_CERT_DIALOG = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.browser.disableCertDialog"));
        PDF_RESIZE_DELAY = AccessController.doPrivileged(() -> Integer.getInteger("niagara.jxbrowser.pdf.resize.delay", 750));
        allowDialogs = true;
        CERT_DIALOG_MONITOR = new Object();
        HTML_MAP = Collections.synchronizedMap(new WeakHashMap());
        FILE_LOAD_CONTEXT_MAP = Collections.synchronizedMap(new WeakHashMap());
        NO_CERTS = new X509Certificate[0];
        EMPTY_STRING_ARRAY = new String[0];
        EMPTY_CERT_APPROVALS = new CertApprovalInfo[0];
    }

    private static class CertApprovalInfo {
        private final NX509Certificate nxCert;
        private final X509Certificate[] certs;
        private final URI uri;
        private final String mainFrameUrl;

        private CertApprovalInfo(NX509Certificate nxCert, X509Certificate[] certs, URI uri, String mainFrameUrl) {
            this.nxCert = nxCert;
            this.certs = certs;
            this.uri = uri;
            this.mainFrameUrl = mainFrameUrl;
        }
    }

    private static class JxBrowserSpy
    extends CacheSpy {
        JxBrowserSpy() {
            super("Jx Browser", "/jxBrowser");
        }

        public void clearCache() {
            System.gc();
            browserInstances.forEach(view -> view.getBrowser().engine().httpCache().clear().thenRun(() -> log.info("Cleared browser cache for " + view.getBrowser())));
        }

        public void write(SpyWriter out) throws Exception {
            out.w((Object)"<h3>JxBrowser</h3>");
            out.w((Object)"<h4>Commands</h4>");
            super.write(out);
            out.w((Object)"<h4>System Properties</h4>");
            out.startProps();
            out.prop((Object)"niagara.jxbrowser.disable", WbServlet.disableJxBrowser);
            if (Sys.isStation()) {
                out.prop((Object)"niagara.jxbrowser.initialStationCacheSize", INITIAL_STATION_BROWSER_CACHE_SIZE);
            } else {
                out.prop((Object)"niagara.jxbrowser.initialCacheSize", INITIAL_BROWSER_CACHE_SIZE);
            }
            out.prop((Object)"niagara.jxbrowser.maxCacheSize", MAX_BROWSER_CACHE_SIZE);
            out.prop((Object)"niagara.jxbrowser.log", (Object)JXBROWSER_LOG_LEVEL);
            out.prop((Object)"niagara.jxbrowser.heavyweight", HEAVYWEIGHT_MODE);
            out.prop((Object)"niagara.jxbrowser.disableLocalWbResources", DISABLE_LOCAL_WB_RESOURCES);
            out.prop((Object)"niagara.jxbrowser.disableGPU", DISABLE_GPU);
            out.endProps();
            out.w((Object)"<h4>Options</h4>");
            out.startProps();
            boolean webDevMode = BWidget.getApplication() != null && BWebBrowserOptions.get().getWebDevelopmentTools();
            out.prop((Object)"Web Development Mode", (Object)(webDevMode ? "Enabled" : "Disabled"));
            out.endProps();
            out.w((Object)"<h4>Preferences</h4>");
            out.startProps();
            Type impl = new BWebBrowser().get("impl").getType();
            out.prop((Object)"Web Browser Impl", (Object)impl);
            if (engine != null) {
                if (impl.equals(BNullWebBrowserImpl.TYPE)) {
                    out.prop((Object)"Loaded Browser Impl", (Object)TYPE);
                }
                AccessController.doPrivileged(() -> {
                    if (!BJxWebBrowserImpl.JX_BROWSER_VERSION.equals(WbJxBrowserUtil.LOADED_JX_BROWSER_VERSION)) {
                        out.prop((Object)"Loaded JxBrowser Version", (Object)WbJxBrowserUtil.LOADED_JX_BROWSER_VERSION);
                        out.prop((Object)"Module JxBrowser Version", (Object)BJxWebBrowserImpl.JX_BROWSER_VERSION);
                    } else {
                        out.prop((Object)"JxBrowser Version", (Object)WbJxBrowserUtil.LOADED_JX_BROWSER_VERSION);
                    }
                    if (!BJxWebBrowserImpl.SCHEMA_VERSION.equals(WbJxBrowserUtil.LOADED_SCHEMA_VERSION)) {
                        out.prop((Object)"Loaded Schema Version", (Object)WbJxBrowserUtil.LOADED_SCHEMA_VERSION);
                        out.prop((Object)"Module Schema JxBrowser Version", (Object)BJxWebBrowserImpl.SCHEMA_VERSION);
                    } else {
                        out.prop((Object)"Schema Version", (Object)BJxWebBrowserImpl.SCHEMA_VERSION);
                    }
                    if (!BJxWebBrowserImpl.CHROMIUM_VERSION.equals(WbJxBrowserUtil.LOADED_CHROMIUM_VERSION)) {
                        out.prop((Object)"Loaded Chromium Version", (Object)WbJxBrowserUtil.LOADED_CHROMIUM_VERSION);
                        out.prop((Object)"Module Chromium Version", (Object)BJxWebBrowserImpl.CHROMIUM_VERSION);
                    } else {
                        out.prop((Object)"Chromium Version", (Object)WbJxBrowserUtil.LOADED_CHROMIUM_VERSION);
                    }
                    String userAgent = BJxWebBrowserImpl.CHROME_USER_AGENT;
                    if (engine.options().userAgent().isPresent()) {
                        userAgent = (String)engine.options().userAgent().get();
                    }
                    out.prop((Object)"Chromium Dir", (Object)engine.options().chromiumDir());
                    out.prop((Object)"Default Accept Language", (Object)engine.network().acceptLanguage());
                    out.prop((Object)"Data Dir", (Object)engine.options().userDataDir());
                    out.prop((Object)"Crash Directory", (Object)WbJxBrowserUtil.getCrashDirectory());
                    out.prop((Object)"Crashes", (Object)WbJxBrowserUtil.getCrashSummary());
                    out.prop((Object)"Rendering Mode", (Object)engine.options().renderingMode());
                    out.prop((Object)"User Agent", (Object)userAgent);
                    return null;
                });
            }
            out.endProps();
            if (preInitError != null) {
                out.w((Object)"<h4>Pre-initialization Error</h4>");
                StringWriter strWtr = new StringWriter();
                preInitError.printStackTrace(new PrintWriter(strWtr));
                out.w((Object)"<pre><code>").safe((Object)strWtr.toString()).w((Object)"</code></pre>");
            }
            if (engine != null) {
                HashMap<String, BrowserViewInfo> browserInfo = new HashMap<String, BrowserViewInfo>();
                for (FoxSession session : Fox.getSessions()) {
                    Optional cache = session.getFromCache("hyperlinkViewCache");
                    if (!cache.isPresent()) continue;
                    for (BWebWidget webWidget : (Set)cache.get()) {
                        BWebBrowser browser = webWidget.getBrowser();
                        if (browser == null || browser.isStub()) continue;
                        browserInfo.put(browser.getDebugId(), new BrowserViewInfo(webWidget, session));
                    }
                }
                out.w((Object)"<h4>Browser Instances</h4>");
                out.startTable(true);
                out.w((Object)"<tr>").thTitle((Object)"ID").thTitle((Object)"Loading").thTitle((Object)"Closed").thTitle((Object)"In use").thTitle((Object)"URL").thTitle((Object)"Debug URL").w((Object)"</tr>");
                System.gc();
                browserInstances.forEach(view -> {
                    boolean inUse;
                    Browser b = view.getBrowser();
                    String debugId = BJxWebBrowserImpl.getDebugId(view);
                    String debugUrl = JxBrowserUtil.getRemoteDebuggingUrl(b);
                    BrowserViewInfo info = (BrowserViewInfo)browserInfo.get(debugId);
                    String url = b.url();
                    boolean bl = inUse = !browserCache.contains(view);
                    if (info != null) {
                        url = info.getUrl();
                        if (BWbShell.getWbShell((BWidget)info.webWidget) == null) {
                            inUse = false;
                        }
                    }
                    boolean closed = b.isClosed();
                    out.w((Object)"<tr>");
                    out.w((Object)"<td align='left' nowrap='true'>").safe((Object)BJxWebBrowserImpl.getDebugId(view)).w((Object)"</td>");
                    out.w((Object)"<td align='left' nowrap='true'>").w((Object)(!closed && b.navigation().isLoading() ? "Yes" : "No")).w((Object)"</td>");
                    out.w((Object)"<td align='left' nowrap='true'>").w((Object)(closed ? "Yes" : "No")).w((Object)"</td>");
                    out.w((Object)"<td align='left' nowrap='true'>").w((Object)(inUse ? "Yes" : "No")).w((Object)"</td>");
                    out.w((Object)"<td align='left' nowrap='true'>").safe((Object)url).w((Object)"</td>");
                    out.w((Object)"<td align='left' nowrap='true'><input onClick='this.select();' size='125' value='").safe((Object)debugUrl).w((Object)"'/></td>");
                    out.w((Object)"</tr>\n");
                });
                out.endTable();
                out.w((Object)"<h4>Web Widget Instances</h4>");
                out.startTable(true);
                out.w((Object)"<tr>").thTitle((Object)"Browser ID").thTitle((Object)"In Shell").thTitle((Object)"Reuse Count").thTitle((Object)"URL").thTitle((Object)"Debug URL").w((Object)"</tr>");
                browserInfo.forEach((debugId, info) -> {
                    BWebWidget webWidget = ((BrowserViewInfo)info).webWidget;
                    BWebBrowser browser = webWidget.getBrowser();
                    String debugUrl = "";
                    if (!webWidget.getBrowser().isStub() && browser.getDebugUrl() != null) {
                        debugUrl = browser.getDebugUrl();
                    }
                    String ord = info.getUrl();
                    boolean inShell = BWbShell.getWbShell((BWidget)((BrowserViewInfo)info).webWidget) != null;
                    out.w((Object)"<tr>");
                    out.w((Object)"<td align='left' nowrap='true'>").safe(debugId).w((Object)"</td>");
                    out.w((Object)"<td align='left' nowrap='true'>").w((Object)(inShell ? "Yes" : "No")).w((Object)"</td>");
                    out.w((Object)"<td align='left' nowrap='true'>").w(webWidget.getReuseCount()).w((Object)"</td>");
                    out.w((Object)"<td align='left' nowrap='true'>").safe((Object)ord).w((Object)"</td>");
                    out.w((Object)"<td align='left' nowrap='true'><input onClick='this.select();' size='125' value='").safe((Object)debugUrl).w((Object)"'/></td>");
                    out.w((Object)"</tr>\n");
                });
                out.endTable();
            }
        }

        private static class BrowserViewInfo {
            private final BWebWidget webWidget;
            private final FoxSession foxSession;

            BrowserViewInfo(BWebWidget webWidget, FoxSession foxSession) {
                this.webWidget = webWidget;
                this.foxSession = foxSession;
            }

            String getUrl() {
                BOrd base = BOrd.make((String)"");
                if (this.webWidget.getCurrentValue() != null) {
                    base = this.webWidget.findOrd(this.webWidget.getCurrentValue());
                }
                return "ip:" + this.foxSession.getRemoteHost() + "|" + BOrd.make((BOrd)base, (BOrd)this.webWidget.getJs()).toString();
            }
        }
    }

    private static final class JxConsoleEvent
    implements ConsoleEventHandler.ConsoleEvent {
        private final String message;
        private final boolean isError;

        private JxConsoleEvent(ConsoleMessageReceived event) {
            ConsoleMessage consoleMessage = event.consoleMessage();
            this.message = consoleMessage.message();
            this.isError = consoleMessage.level().ordinal() >= ConsoleMessageLevel.WARNING.ordinal();
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isError() {
            return this.isError;
        }
    }

    public static final class SupplierReflectionWrapper<R>
    implements Supplier<R>,
    MethodNameSupplier {
        private Supplier<R> s;

        private SupplierReflectionWrapper(Supplier<R> s) {
            this.s = s;
        }

        @Override
        @JsAccessible
        public R get() {
            return this.s.get();
        }

        @Override
        public String getMethodName() {
            return "get";
        }
    }

    public static final class BiFunctionReflectionWrapper<T, U, R>
    implements BiFunction<T, U, R>,
    MethodNameSupplier {
        private BiFunction<T, U, R> f;

        private BiFunctionReflectionWrapper(BiFunction<T, U, R> f) {
            this.f = f;
        }

        @Override
        @JsAccessible
        public R apply(T t, U u) {
            return this.f.apply(t, u);
        }

        @Override
        public String getMethodName() {
            return "apply";
        }
    }

    public static final class FunctionReflectionWrapper<T, R>
    implements Function<T, R>,
    MethodNameSupplier {
        private Function<T, R> f;

        private FunctionReflectionWrapper(Function<T, R> f) {
            this.f = f;
        }

        @Override
        @JsAccessible
        public R apply(T t) {
            return this.f.apply(t);
        }

        @Override
        public String getMethodName() {
            return "apply";
        }
    }

    public static final class BiConsumerReflectionWrapper<T, U>
    implements BiConsumer<T, U>,
    MethodNameSupplier {
        private BiConsumer<T, U> c;

        private BiConsumerReflectionWrapper(BiConsumer<T, U> c) {
            this.c = c;
        }

        @Override
        @JsAccessible
        public void accept(T t, U u) {
            this.c.accept(t, u);
        }

        @Override
        public String getMethodName() {
            return "accept";
        }
    }

    public static final class ConsumerReflectionWrapper<T>
    implements Consumer<T>,
    MethodNameSupplier {
        private Consumer<T> c;

        private ConsumerReflectionWrapper(Consumer<T> c) {
            this.c = c;
        }

        @Override
        @JsAccessible
        public void accept(T t) {
            this.c.accept(t);
        }

        @Override
        public String getMethodName() {
            return "accept";
        }
    }

    public static final class RunnableReflectionWrapper
    implements Runnable,
    MethodNameSupplier {
        private Runnable r;

        private RunnableReflectionWrapper(Runnable r) {
            this.r = r;
        }

        @Override
        @JsAccessible
        public void run() {
            this.r.run();
        }

        @Override
        public String getMethodName() {
            return "run";
        }
    }

    static interface MethodNameSupplier {
        public String getMethodName();
    }
}

