/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi;

import com.tridium.nre.security.PBEDecryptingInputStream;
import com.tridium.nre.security.PBEEncodingKey;
import com.tridium.nre.util.IPAddressUtil;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonClientEncodingInfo;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BCachedDaemonFileSpace;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.ByteArrayFileTransferElement;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.daemon.message.GetFileMessage;
import com.tridium.platform.tcpip.dhcpd.BDhcpdAdapterSettings;
import com.tridium.platform.tcpip.dhcpd.BDhcpdHostSettings;
import com.tridium.platform.tcpip.dhcpd.BDhcpdServerType;
import com.tridium.platform.tcpip.dhcpd.DhcpdUtil;
import com.tridium.platwifi.BHapdHwModeEnum;
import com.tridium.platwifi.BHtCapabilityEnum;
import com.tridium.platwifi.BSupplicantNetBlock;
import com.tridium.platwifi.BSupplicantNetBlockVector;
import com.tridium.platwifi.BWifiChannelListEntry;
import com.tridium.platwifi.BWifiChannelListVector;
import com.tridium.platwifi.BWifiClientListEntry;
import com.tridium.platwifi.BWifiClientListVector;
import com.tridium.platwifi.BWifiFreqBandEnum;
import com.tridium.platwifi.BWifiMacAddress;
import com.tridium.platwifi.BWifiMacAddressVector;
import com.tridium.platwifi.BWifiMonitorData;
import com.tridium.platwifi.BWifiNetwork;
import com.tridium.platwifi.BWifiNetworkVector;
import com.tridium.platwifi.BWifiSettings;
import com.tridium.platwifi.daemon.message.ConnectNetworkMessage;
import com.tridium.platwifi.daemon.message.DisconnectNetworkMessage;
import com.tridium.platwifi.daemon.message.GetChannelListMessage;
import com.tridium.platwifi.daemon.message.GetClientListMessage;
import com.tridium.platwifi.daemon.message.GetCountryCodeMessage;
import com.tridium.platwifi.daemon.message.GetCountryListMessage;
import com.tridium.platwifi.daemon.message.GetWiFiSettingsMessage;
import com.tridium.platwifi.daemon.message.GetWiFiStatusMessage;
import com.tridium.platwifi.daemon.message.GetWifiSkuMessage;
import com.tridium.platwifi.daemon.message.MonitorDataMessage;
import com.tridium.platwifi.daemon.message.ReconfigureNetworksMessage;
import com.tridium.platwifi.daemon.message.ScanMessage;
import com.tridium.platwifi.daemon.message.ScanResultsMessage;
import com.tridium.platwifi.daemon.message.SetCountryCodeMessage;
import com.tridium.platwifi.daemon.message.SetSapTimeoutMessage;
import com.tridium.platwifi.status.BWifiSupplicantStateEnum;
import com.tridium.platwifi.status.BWifiSwitchEnum;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.FileUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class WifiUtil {
    private static String WPA_SUPPLICANT_FILE_PATH = "/opt/niagara/platform/wifi/wpa_supplicant_ti18xx.conf";
    private static String HOSTAPD_FILE_PATH = "/opt/niagara/platform/wifi/hostapd_ti18xx.conf";
    private static String WHITELIST_PATH = "/opt/niagara/platform/wifi/hostapd.accept";
    private static String WNET_CFG_FILE_PATH = "/opt/niagara/platform/wifi/wifi_net.cfg";
    private static String ENET_CFG_FILE_PATH = "/etc/net.cfg";

    public static void monitorDataFromSession(BWifiMonitorData data, BDaemonSession session) throws Exception {
        InputStream stream = session.getInputStream((DaemonMessage)new MonitorDataMessage());
        XElem wifiSettingsElem = XParser.make((InputStream)stream).parse();
        data.setWifiSwitchPosition(BWifiSwitchEnum.make(wifiSettingsElem.geti("wifiSwitch", 0)));
        data.setWifimonState(wifiSettingsElem.get("wifimonState"));
        data.setWifiEnabled(wifiSettingsElem.getb("wifiEnabled", false));
    }

    public static void loadFromSession(BWifiSettings wifiSettings, BDaemonSession session) throws Exception {
        BasicContext saveContext;
        BFacets saveFacets;
        InputStream stream = session.getInputStream((DaemonMessage)new GetWiFiSettingsMessage());
        BDhcpdHostSettings dhcpdHostSettings = wifiSettings.getDhcpdHostSettings();
        XElem wifiSettingsElem = XParser.make((InputStream)stream).parse();
        wifiSettings.setWifiEnabled(wifiSettingsElem.getb("wifiEnabled", false));
        XElem stationSettings = wifiSettingsElem.elem("stationSettings");
        if (stationSettings == null) {
            throw new Exception("Missing stationSettings element");
        }
        wifiSettings.setStaAdapterName(stationSettings.get("staAdapter"));
        wifiSettings.setStaWpaSupplicantState(BWifiSupplicantStateEnum.make(stationSettings.geti("wpa_state", 0)));
        wifiSettings.setStaCurrentNetworkSsid(stationSettings.get("ssid", ""));
        wifiSettings.setStaCurrentNetworkAddress(stationSettings.get("address", ""));
        wifiSettings.setStaCurrentNetworkIpAddress(stationSettings.get("ip_address", ""));
        wifiSettings.setStaSwitchDefaultGateway(stationSettings.getb("gwswitch", false));
        XElem accessPointSettings = wifiSettingsElem.elem("accessPointSettings");
        if (accessPointSettings == null) {
            throw new Exception("Missing accessPointSettings element");
        }
        wifiSettings.setSapTimeout(accessPointSettings.geti("sap_to", 0));
        try (PBEEncodingKey encodingKey = PBEEncodingKey.random();
             BCachedDaemonFileSpace space = BCachedDaemonFileSpace.make((BDaemonSession)session, (PBEEncodingKey)encodingKey);){
            PBEDecryptingInputStream decrypted = new PBEDecryptingInputStream(space.findFile(new FilePath(WPA_SUPPLICANT_FILE_PATH)).getInputStream(), encodingKey);
            BSupplicantNetBlockVector blocks = wifiSettings.getSupplicantNetworkBlocks();
            WifiUtil.wpaSupplicantConfToSettings(blocks, (InputStream)decrypted);
            decrypted = new PBEDecryptingInputStream(space.findFile(new FilePath(HOSTAPD_FILE_PATH)).getInputStream(), encodingKey);
            WifiUtil.hostapdConfToSettings(wifiSettings, (InputStream)decrypted);
            BIFile file = space.findFile(new FilePath(WNET_CFG_FILE_PATH));
            if (file == null) {
                throw new NullPointerException("Missing wifi_net.cfg file");
            }
            decrypted = new PBEDecryptingInputStream(file.getInputStream(), encodingKey);
            WifiUtil.wifiNetCfgToSettings(wifiSettings, (InputStream)decrypted);
            WifiUtil.netCfgFromSession(wifiSettings, session);
            if (session.getHostProperties().supportsServlet("dhcpd")) {
                DhcpdUtil.loadFromSessionWifi((BDhcpdHostSettings)dhcpdHostSettings, (BDaemonSession)session);
            } else {
                decrypted = new PBEDecryptingInputStream(space.findFile(new FilePath("/opt/niagara/platform/wifi/dhcpd_ti18xx.conf")).getInputStream(), encodingKey);
                String propName = SlotPath.escape((String)"tiw_sap0");
                BDhcpdAdapterSettings dhcpdSetting = new BDhcpdAdapterSettings();
                dhcpdHostSettings.getDhcpdSubnets().add(propName, (BValue)dhcpdSetting);
                dhcpdSetting.setIsDhcpdIpv4Supported(true);
                dhcpdSetting.setIsDhcpdIpv4Enabled(true);
                dhcpdHostSettings.setDhcpdServerType(BDhcpdServerType.dhcpd);
                dhcpdHostSettings.setDhcpdConfPath("/opt/niagara/platform/wifi/dhcpd_ti18xx.conf");
                WifiUtil.dhcpdConfToSettings(dhcpdHostSettings, (InputStream)decrypted);
            }
        }
        String sap0Ip = wifiSettings.getSapAdapterIp().trim();
        String sap0Mask = wifiSettings.getSapAdapterNetmask().trim();
        WifiUtil.netCfgFromSession(wifiSettings, session);
        BDhcpdAdapterSettings dhcpSettings = (BDhcpdAdapterSettings)dhcpdHostSettings.getDhcpdSubnets().get("tiw_sap0");
        String dhcpNet = dhcpSettings.getSubnet();
        String dhcpMask = dhcpSettings.getSubnetMask();
        String dhcpStart = dhcpSettings.getStartClientAddress();
        String dhcpEnd = DhcpdUtil.getEndIpAddress((String)dhcpStart, (int)dhcpSettings.getRange());
        if (!IPAddressUtil.isIpv4Address((String)sap0Ip)) {
            if (IPAddressUtil.isIpv4Address((String)dhcpSettings.getSubnet())) {
                byte[] ipBytes = IPAddressUtil.numericStringToByteArray((String)dhcpNet);
                ipBytes[3] = (byte)((ipBytes[3] & 0xFF) + 1);
                String sapAddr = WifiUtil.ipBytesToString(ipBytes);
                wifiSettings.setSapAdapterIp(sapAddr);
                wifiSettings.setSapAdapterNetmask(dhcpMask);
            } else {
                wifiSettings.setSapAdapterIp("192.168.11.1");
                wifiSettings.setSapAdapterNetmask("255.255.255.0");
            }
            saveFacets = BFacets.make((String)"savetype", (String)"netcfg");
            saveContext = new BasicContext((Context)null, saveFacets);
            WifiUtil.saveToSession(wifiSettings, session, (Context)saveContext);
        }
        if (WifiUtil.fixDhcpSettings(wifiSettings)) {
            saveFacets = BFacets.make((String)"savetype", (String)"dhcpd");
            saveContext = new BasicContext((Context)null, saveFacets);
            WifiUtil.saveToSession(wifiSettings, session, (Context)saveContext);
        }
    }

    public static boolean fixDhcpSettings(BWifiSettings wifiSettings) {
        try {
            int fixRange;
            int range;
            boolean needToUpdateDhcpdConf = false;
            BDhcpdHostSettings dhcpdHostSettings = wifiSettings.getDhcpdHostSettings();
            BDhcpdAdapterSettings dhcpdSettings = (BDhcpdAdapterSettings)dhcpdHostSettings.getDhcpdSubnets().get("tiw_sap0");
            String net = IPAddressUtil.getIPv4NetworkPrefix((String)wifiSettings.getSapAdapterIp(), (String)wifiSettings.getSapAdapterNetmask());
            if (IPAddressUtil.compare((Object)net, (Object)dhcpdSettings.getSubnet()) != 0) {
                dhcpdSettings.setSubnet(net);
                needToUpdateDhcpdConf = true;
            }
            if (IPAddressUtil.compare((Object)wifiSettings.getSapAdapterNetmask(), (Object)dhcpdSettings.getSubnetMask()) != 0) {
                dhcpdSettings.setSubnetMask(wifiSettings.getSapAdapterNetmask());
                needToUpdateDhcpdConf = true;
            }
            if ((range = dhcpdSettings.getRange()) != (fixRange = DhcpdUtil.fixDhcpdAdapterSettingsRange((int)range, (int)1, (int)16))) {
                dhcpdSettings.setRange(fixRange);
                needToUpdateDhcpdConf = true;
            }
            byte[] startaddr = IPAddressUtil.numericStringToByteArray((String)dhcpdSettings.getStartClientAddress());
            byte[] mask = IPAddressUtil.numericStringToByteArray((String)dhcpdSettings.getSubnetMask());
            byte[] netbytes = IPAddressUtil.numericStringToByteArray((String)net);
            StringBuilder startAsString = new StringBuilder();
            for (int i = 0; i < 4; ++i) {
                int startquartet = (startaddr[i] & ~mask[i] | netbytes[i]) & 0xFF;
                startAsString.append(startquartet);
                if (i == 3) continue;
                startAsString.append('.');
            }
            dhcpdSettings.setStartClientAddress(startAsString.toString());
            return needToUpdateDhcpdConf;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    private static String ipBytesToString(byte[] bytes) {
        StringBuilder startAsString = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            int startquartet = bytes[i] & 0xFF;
            startAsString.append(startquartet);
            if (i == 3) continue;
            startAsString.append('.');
        }
        return startAsString.toString();
    }

    public static void saveToSession(BWifiSettings settings, BDaemonSession session, Context cx) throws Exception {
        boolean writenetcfg = false;
        boolean writehostapd = false;
        boolean writedhcpd = false;
        boolean writesupplicant = false;
        String savetype = "none";
        if (settings == null) {
            return;
        }
        if (cx != null && cx.getFacet("savetype") != null) {
            savetype = ((BString)cx.getFacet("savetype")).getString();
        }
        if (savetype.equals("netcfg")) {
            writenetcfg = true;
            writedhcpd = true;
        }
        if (savetype.equals("dhcpd")) {
            writedhcpd = true;
        } else if (savetype.equals("supplicant")) {
            writesupplicant = true;
        } else {
            writenetcfg = true;
            writehostapd = true;
            writedhcpd = true;
        }
        InputStream stream = session.getInputStream((DaemonMessage)new GetWiFiSettingsMessage());
        XElem settingsAsXml = XParser.make((InputStream)stream).parse();
        boolean stationEnabled = settingsAsXml.geti("mode", 0) == 1;
        boolean accessPointEnabled = settingsAsXml.geti("mode", 0) == 2;
        try (PBEEncodingKey encodingKey = PBEEncodingKey.random();){
            FileTransferMessage fileTransferMessage = DaemonClientEncodingInfo.makeMessage((BDaemonSession)session, (PBEEncodingKey)encodingKey);
            if (writesupplicant) {
                String wpaSupplicantConf = WifiUtil.settingsToWpaSupplicantConf(settings);
                ByteArrayInputStream supplicantInputStream = new ByteArrayInputStream(wpaSupplicantConf.getBytes());
                fileTransferMessage.addPBEEncryptedElement((InputStream)supplicantInputStream, new FilePath(WPA_SUPPLICANT_FILE_PATH));
            }
            if (writehostapd) {
                String hostapdConf = WifiUtil.settingsToHostapdConf(settings);
                ByteArrayInputStream hostapdInputStream = new ByteArrayInputStream(hostapdConf.getBytes());
                fileTransferMessage.addPBEEncryptedElement((InputStream)hostapdInputStream, new FilePath(HOSTAPD_FILE_PATH));
            }
            if (writedhcpd) {
                BDhcpdHostSettings dhcpdHostSettings = settings.getDhcpdHostSettings();
                DhcpdUtil.saveToSessionNoTransfer((BDhcpdHostSettings)dhcpdHostSettings, (BDaemonSession)session, (FileTransferMessage)fileTransferMessage);
            }
            if (writenetcfg) {
                String netcfg = WifiUtil.settingsToWifiNetcfg(settings);
                ByteArrayInputStream dhcpdInputStream = new ByteArrayInputStream(netcfg.getBytes());
                fileTransferMessage.addPBEEncryptedElement((InputStream)dhcpdInputStream, new FilePath(WNET_CFG_FILE_PATH));
            }
            if (!DaemonFileUtil.transfer((BDaemonSession)session, (FileTransferMessage)fileTransferMessage, null)) {
                throw new BajaRuntimeException("Failed to save WiFi settings");
            }
        }
        if (stationEnabled && writesupplicant && !session.sendMessage((DaemonMessage)new ReconfigureNetworksMessage())) {
            throw new BajaRuntimeException("Failed to reconfigure WiFi Host Settings");
        }
        SetSapTimeoutMessage sapmsg = new SetSapTimeoutMessage(settings.getSapTimeout());
        if (!session.sendMessage((DaemonMessage)sapmsg)) {
            throw new BajaRuntimeException("Failed to update sapTimeout");
        }
    }

    public static Properties statusFromSession(String adapter, BDaemonSession session) throws Exception {
        XElem[] statusPropertyElems;
        Properties statusProperties = new Properties();
        InputStream stream = session.getInputStream((DaemonMessage)new GetWiFiStatusMessage(adapter));
        XElem statusAsXml = XParser.make((InputStream)stream).parse();
        for (XElem statusElement : statusPropertyElems = statusAsXml.elems("statusProperty")) {
            statusProperties.put(statusElement.get("key"), statusElement.get("value"));
        }
        return statusProperties;
    }

    public static String wifiSkuFromSession(BDaemonSession session) throws Exception {
        InputStream stream = session.getInputStream((DaemonMessage)new GetWifiSkuMessage());
        XElem countryElem = XParser.make((InputStream)stream).parse();
        return countryElem.get("sku");
    }

    public static String countryCodeFromSession(BDaemonSession session) throws Exception {
        InputStream stream = session.getInputStream((DaemonMessage)new GetCountryCodeMessage());
        XElem countryElem = XParser.make((InputStream)stream).parse();
        return countryElem.get("cc");
    }

    public static void sessionToCountryCode(String cc, BDaemonSession session) throws Exception {
        SetCountryCodeMessage sccmsg = new SetCountryCodeMessage(cc);
        if (!session.sendMessage((DaemonMessage)sccmsg)) {
            throw new BajaRuntimeException("Failed to update country code");
        }
    }

    public static BWifiMacAddressVector whitelistFromSession(BWifiMacAddressVector macs, BDaemonSession session) throws Exception {
        try (PBEEncodingKey encodingKey = PBEEncodingKey.random();
             BCachedDaemonFileSpace space = BCachedDaemonFileSpace.make((BDaemonSession)session, (PBEEncodingKey)encodingKey);){
            PBEDecryptingInputStream decrypted = new PBEDecryptingInputStream(space.findFile(new FilePath(WHITELIST_PATH)).getInputStream(), encodingKey);
            if (decrypted == null) {
                BWifiMacAddressVector bWifiMacAddressVector = macs;
                return bWifiMacAddressVector;
            }
            macs.removeAll();
            String[] whitelistLines = FileUtil.readLines((Reader)new InputStreamReader((InputStream)decrypted));
            for (int i = 0; i < whitelistLines.length; ++i) {
                macs.add("mac" + i, (BValue)new BWifiMacAddress(whitelistLines[i].trim()));
            }
        }
        return macs;
    }

    public static void sessionToWhitelist(BWifiMacAddressVector whitelist, BDaemonSession session) throws Exception {
        StringBuilder whitelistContents = new StringBuilder();
        BWifiMacAddress[] macs = (BWifiMacAddress[])whitelist.getChildren(BWifiMacAddress.class);
        for (int i = 0; i < macs.length; ++i) {
            whitelistContents.append(macs[i].getMac()).append("\n");
        }
        String fileContents = whitelistContents.toString();
        FileTransferMessage msg = new FileTransferMessage((BDaemonFileSpace)session.getFileSpace());
        msg.addElement((FileTransferMessageElement)new ByteArrayFileTransferElement(new FilePath(WHITELIST_PATH), fileContents.getBytes(), (BDaemonFileSpace)session.getFileSpace()));
        if (!DaemonFileUtil.transfer((BDaemonSession)session, (FileTransferMessage)msg, null)) {
            throw new BajaRuntimeException("Failed to save new wifi whitelist");
        }
    }

    public static void countryListFromSession(ArrayList<BString> countries, BDaemonSession session) {
        countries.clear();
        GetCountryListMessage msg = new GetCountryListMessage();
        try (InputStream in = session.getInputStream((DaemonMessage)msg);){
            XElem[] countryElems;
            if (in == null) {
                return;
            }
            XElem results = XParser.make((InputStream)in).parse();
            boolean i = false;
            for (XElem countryElem : countryElems = results.elems("country")) {
                String cc = countryElem.get("code");
                String name = countryElem.get("name");
                StringBuilder sb = new StringBuilder();
                sb.append(cc).append("-").append(name);
                countries.add(BString.make((String)sb.toString()));
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public static BWifiChannelListVector channelListFromSession(BWifiChannelListVector channelListVector, BDaemonSession session, String countryCode) throws Exception {
        GetChannelListMessage msg = new GetChannelListMessage(countryCode);
        return WifiUtil.getChannelListFromSession(channelListVector, session, msg);
    }

    public static BWifiChannelListVector channelListFromSession(BWifiChannelListVector channelListVector, BDaemonSession session) throws Exception {
        GetChannelListMessage msg = new GetChannelListMessage();
        return WifiUtil.getChannelListFromSession(channelListVector, session, msg);
    }

    private static BWifiChannelListVector getChannelListFromSession(BWifiChannelListVector channelListVector, BDaemonSession session, GetChannelListMessage msg) throws Exception {
        channelListVector.removeAll();
        try (InputStream in = session.getInputStream((DaemonMessage)msg);){
            XElem[] entryElems;
            if (in == null) {
                BWifiChannelListVector bWifiChannelListVector = channelListVector;
                return bWifiChannelListVector;
            }
            XElem results = XParser.make((InputStream)in).parse();
            int i = 0;
            String cc = results.get("countryCode");
            for (XElem entryElem : entryElems = results.elems("entry")) {
                String line = entryElem.get("bandConfig");
                StringTokenizer tokenizer = new StringTokenizer(line);
                int tokenCount = tokenizer.countTokens();
                if (tokenCount != 20) continue;
                String region = "NONE";
                int band = 0;
                int dbm = 0;
                boolean dfs = false;
                int numChannels = 0;
                block20: for (i = 0; i < tokenCount; ++i) {
                    String token = tokenizer.nextToken();
                    switch (i) {
                        case 0: {
                            if (token.equals("1")) {
                                region = "FCC";
                                continue block20;
                            }
                            if (token.equals("2")) {
                                region = "ETSI";
                                continue block20;
                            }
                            if (!token.equals("3")) continue block20;
                            region = "JP";
                            continue block20;
                        }
                        case 1: {
                            if (token.equals("0")) {
                                band = 0;
                                continue block20;
                            }
                            if (token.equals("1")) {
                                band = 1;
                                continue block20;
                            }
                            if (!token.equals("2")) continue block20;
                            band = 2;
                            continue block20;
                        }
                        case 2: {
                            dbm = Integer.parseInt(token);
                            continue block20;
                        }
                        case 3: {
                            dfs = token.equals("1");
                            continue block20;
                        }
                        case 4: {
                            numChannels = Integer.parseInt(token);
                            for (int j = 0; j < numChannels; ++j) {
                                token = tokenizer.nextToken();
                                int channel = Integer.parseInt(token);
                                BWifiChannelListEntry entry = new BWifiChannelListEntry();
                                entry.setCountryCode(cc);
                                entry.setBand(BWifiFreqBandEnum.make(band));
                                entry.setTxPower(dbm);
                                entry.setDynamicFrequencySelection(dfs);
                                entry.setRegion(region);
                                entry.setChannel(channel);
                                channelListVector.add("b_" + band + "c_" + channel, (BValue)entry);
                            }
                            i = 20;
                            continue block20;
                        }
                    }
                }
            }
        }
        return channelListVector;
    }

    public static BWifiClientListVector clientListFromSession(BWifiClientListVector clientListVector, BDaemonSession session) throws Exception {
        clientListVector.removeAll();
        try (InputStream in = session.getInputStream((DaemonMessage)new GetClientListMessage());){
            XElem[] clientElems;
            if (in == null) {
                BWifiClientListVector bWifiClientListVector = clientListVector;
                return bWifiClientListVector;
            }
            XElem results = XParser.make((InputStream)in).parse();
            int i = 0;
            for (XElem clientElem : clientElems = results.elems("client")) {
                String mac = clientElem.get("mac");
                String timeStr = clientElem.get("time");
                BWifiClientListEntry entry = new BWifiClientListEntry(clientElem.get("mac"), clientElem.get("time"));
                clientListVector.add("mac" + i++, (BValue)entry);
            }
        }
        return clientListVector;
    }

    public static BWifiNetworkVector discoverFromSession(String adapter, BDaemonSession session) throws Exception {
        XElem[] elems;
        InputStream stream = session.getInputStream((DaemonMessage)new ScanMessage(adapter));
        XElem scanOK = XParser.make((InputStream)stream).parse();
        if (scanOK.geti("statusCode", 0) != 200) {
            return new BWifiNetworkVector();
        }
        Thread.sleep(8000L);
        stream = session.getInputStream((DaemonMessage)new ScanResultsMessage(adapter));
        XElem results = XParser.make((InputStream)stream).parse();
        BWifiNetworkVector resultVector = new BWifiNetworkVector();
        if (results.geti("wifiNetworks", 0) == 0) {
            return resultVector;
        }
        for (XElem elem : elems = results.elems("wifiNetwork")) {
            BWifiNetwork temp = BWifiNetwork.makeNetwork(elem.get("description"));
            try {
                resultVector.add(SlotPath.escape((String)temp.getBssid()), (BValue)temp, 3, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiNetworkEditor")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return resultVector;
    }

    public static boolean disconnectFromSession(String adapter, BDaemonSession session) throws Exception {
        InputStream stream = session.getInputStream((DaemonMessage)new DisconnectNetworkMessage(adapter));
        XElem results = XParser.make((InputStream)stream).parse();
        return results.geti("statusCode", 0) == 200;
    }

    public static boolean connectFromSession(String adapter, String networkId, BDaemonSession session) throws Exception {
        InputStream stream = session.getInputStream((DaemonMessage)new ConnectNetworkMessage(adapter, networkId));
        XElem results = XParser.make((InputStream)stream).parse();
        return results.geti("statusCode", 0) == 200;
    }

    public static void wpaSupplicantConfToSettings(BSupplicantNetBlockVector confBlocks, InputStream in) throws Exception {
        confBlocks.removeAll();
        String[] wpaSupplicantLines = FileUtil.readLines((Reader)new InputStreamReader(in));
        int blockCount = 1;
        for (int i = 0; i < wpaSupplicantLines.length; ++i) {
            if (!wpaSupplicantLines[i].startsWith("network={")) continue;
            BSupplicantNetBlock newBlock = new BSupplicantNetBlock();
            ++i;
            while (!wpaSupplicantLines[i].startsWith("}")) {
                if (wpaSupplicantLines[i].indexOf(61) > 0) {
                    String[] keyValuePair = TextUtil.split((String)wpaSupplicantLines[i].trim(), (char)'=');
                    switch (keyValuePair[0]) {
                        case "ssid": {
                            newBlock.setSsid(WifiUtil.unquote(keyValuePair[1]));
                            break;
                        }
                        case "proto": {
                            newBlock.setProto(keyValuePair[1]);
                            break;
                        }
                        case "key_mgmt": {
                            newBlock.setKey_mgmt(keyValuePair[1]);
                            break;
                        }
                        case "pairwise": {
                            newBlock.setPairwise(keyValuePair[1]);
                            break;
                        }
                        case "group": {
                            newBlock.setGroup(keyValuePair[1]);
                            break;
                        }
                        case "psk": {
                            newBlock.setPsk(WifiUtil.unquote(keyValuePair[1]));
                            break;
                        }
                        case "scan_ssid": {
                            newBlock.setScan_ssid(Integer.parseInt(keyValuePair[1]));
                            break;
                        }
                        case "priority": {
                            newBlock.setPriority(Integer.parseInt(keyValuePair[1]));
                        }
                    }
                }
                ++i;
            }
            if (confBlocks.get(SlotPath.escape((String)newBlock.getSsid())) != null) continue;
            confBlocks.add(SlotPath.escape((String)newBlock.getSsid()), (BValue)newBlock, 3, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiNetworkEditor")));
            ++blockCount;
        }
    }

    public static String settingsToWpaSupplicantConf(BWifiSettings settings) {
        StringBuilder wpaSupplicantContents = new StringBuilder();
        wpaSupplicantContents.append("ctrl_interface=/var/run/wpa_supplicant\n");
        wpaSupplicantContents.append("update_config=1\n");
        wpaSupplicantContents.append("device_name=TI_Wilink8\n");
        wpaSupplicantContents.append("manufacturer=TexasInstruments\n");
        wpaSupplicantContents.append("model_name=TI_Connectivity_module\n");
        wpaSupplicantContents.append("model_number=tiwlan_drv\n");
        wpaSupplicantContents.append("serial_number=12345\n");
        wpaSupplicantContents.append("p2p_disabled=1\n");
        wpaSupplicantContents.append("\n");
        BSupplicantNetBlockVector blocksvector = settings.getSupplicantNetworkBlocks();
        BSupplicantNetBlock[] blocks = (BSupplicantNetBlock[])blocksvector.getChildren(BSupplicantNetBlock.class);
        for (int i = 0; i < blocks.length; ++i) {
            wpaSupplicantContents.append("network={\n");
            WifiUtil.writeLineQuoted(wpaSupplicantContents, "ssid", blocks[i].getSsid());
            WifiUtil.writeLineUnquoted(wpaSupplicantContents, "proto", blocks[i].getProto());
            WifiUtil.writeLineUnquoted(wpaSupplicantContents, "key_mgmt", blocks[i].getKey_mgmt());
            WifiUtil.writeLineUnquoted(wpaSupplicantContents, "pairwise", blocks[i].getPairwise());
            WifiUtil.writeLineUnquoted(wpaSupplicantContents, "group", blocks[i].getGroup());
            WifiUtil.writeLineQuoted(wpaSupplicantContents, "psk", blocks[i].getPsk());
            WifiUtil.writeLineUnquoted(wpaSupplicantContents, "scan_ssid", String.valueOf(blocks[i].getScan_ssid()));
            WifiUtil.writeLineUnquoted(wpaSupplicantContents, "priority", String.valueOf(blocks[i].getPriority()));
            WifiUtil.writeLineUnquoted(wpaSupplicantContents, "auth_alg", "OPEN");
            wpaSupplicantContents.append("}\n");
            wpaSupplicantContents.append("\n");
        }
        String result = wpaSupplicantContents.toString();
        return result;
    }

    public static String settingsToHostapdConf(BWifiSettings settings) {
        StringBuilder hostapdContents = new StringBuilder();
        hostapdContents.append("ctrl_interface=/var/run/hostapd\n");
        hostapdContents.append("ctrl_interface_group=0\n");
        hostapdContents.append("interface=tiw_sap0\n");
        hostapdContents.append("driver=wilink\n");
        hostapdContents.append("\n");
        hostapdContents.append("### IEEE 802.11\n");
        hostapdContents.append("ssid=").append(settings.getSapSsid()).append("\n");
        hostapdContents.append("channel=").append(settings.getSapChannel()).append("\n");
        hostapdContents.append(settings.getSapHwMode().makeConfFileLine(settings.getSapFreqBand()));
        hostapdContents.append("max_num_sta=16\n");
        hostapdContents.append("auth_algs=1\n");
        hostapdContents.append("disassoc_low_ack=0\n");
        hostapdContents.append("ignore_broadcast_ssid=").append(settings.getIgnoreBroadcastSsid()).append("\n");
        hostapdContents.append("preamble=1\n");
        hostapdContents.append("dtim_period=2\n");
        hostapdContents.append("beacon_int=100\n");
        hostapdContents.append("\n");
        hostapdContents.append("### DFS\n");
        hostapdContents.append("ieee80211d=1\n");
        hostapdContents.append("ieee80211h=1\n");
        hostapdContents.append("country_code=").append(settings.getCountryCode()).append("\n");
        hostapdContents.append("\n");
        hostapdContents.append("### IEEE 802.11n\n");
        if (settings.getSapHwMode().equals((Object)BHapdHwModeEnum.ieee802_11a)) {
            hostapdContents.append("ieee80211n=0\n");
        } else if (settings.getSapHwMode().equals((Object)BHapdHwModeEnum.ieee802_11b)) {
            hostapdContents.append("ieee80211n=0\n");
        } else if (settings.getSapHwMode().equals((Object)BHapdHwModeEnum.ieee802_11g)) {
            hostapdContents.append("ieee80211n=0\n");
        } else if (settings.getSapHwMode().equals((Object)BHapdHwModeEnum.ieee802_11n)) {
            hostapdContents.append("ieee80211n=1\n");
            hostapdContents.append("basic_rates=60 120 240\n");
            hostapdContents.append("supported_rates=60 90 120 180 240 360 480 540\n");
        } else {
            hostapdContents.append("ieee80211n=0\n");
        }
        hostapdContents.append(settings.getSapHtCapab().makeConfFileLine());
        hostapdContents.append("\n");
        hostapdContents.append("### IEEE 802.11i\n");
        hostapdContents.append("wpa=").append(settings.getSapWpa()).append("\n");
        String key_mgmt = settings.getSapWpaKeyMgmt();
        if (key_mgmt.equals("wpaPsk")) {
            hostapdContents.append("wpa_key_mgmt=WPA-PSK\n");
        } else if (key_mgmt.equals("wpaEap")) {
            hostapdContents.append("wpa_key_mgmt=WPA-EAP\n");
        } else {
            hostapdContents.append("wpa_key_mgmt=WPA-PSK WPA-EAP\n");
        }
        hostapdContents.append("wpa_pairwise=").append(settings.getSapWpaPairwise()).append("\n");
        hostapdContents.append("wpa_group_rekey=0\n");
        hostapdContents.append("wpa_strict_rekey=0\n");
        hostapdContents.append("wpa_gmk_rekey=0\n");
        hostapdContents.append("wpa_ptk_rekey=0\n");
        if (!settings.getSapWpaPsk().isEmpty()) {
            hostapdContents.append("wpa_psk=").append(settings.getSapWpaPsk());
        }
        if (!settings.getSapWpaPassphrase().isEmpty()) {
            hostapdContents.append("wpa_passphrase=").append(settings.getSapWpaPassphrase()).append("\n");
        }
        hostapdContents.append("\n");
        hostapdContents.append("### hostapd event logger configuration\n");
        hostapdContents.append("logger_syslog=-1\n");
        hostapdContents.append("logger_syslog_level=2\n");
        hostapdContents.append("logger_stdout=-1\n");
        hostapdContents.append("logger_stdout_level=2\n");
        hostapdContents.append("dump_file=/tmp/hostapd.dump\n");
        hostapdContents.append("\n");
        hostapdContents.append("### WMM\n");
        hostapdContents.append("wmm_enabled=1\n");
        hostapdContents.append("uapsd_advertisement_enabled=1\n");
        hostapdContents.append("\n");
        hostapdContents.append("### white list/black list\n");
        if (settings.getUseWhitelist()) {
            hostapdContents.append("macaddr_acl=1\n");
            hostapdContents.append("accept_mac_file=/opt/niagara/platform/wifi/hostapd.accept\n");
        } else {
            hostapdContents.append("macaddr_acl=0\n");
            hostapdContents.append("#accept_mac_file=/opt/niagara/platform/wifi/hostapd.accept\n");
        }
        hostapdContents.append("\n");
        String result = hostapdContents.toString();
        return result;
    }

    public static void hostapdConfToSettings(BWifiSettings settings, InputStream in) throws Exception {
        boolean ieee80211n = false;
        String hw_mode_str = "g";
        String[] hostapdLines = FileUtil.readLines((Reader)new InputStreamReader(in));
        int i = 0;
        String hostapdLine = "";
        settings.setIgnoreBroadcastSsid(0);
        while (i < hostapdLines.length) {
            hostapdLine = hostapdLines[i].trim();
            if (hostapdLine.length() == 0 || hostapdLine.startsWith("#")) {
                ++i;
                continue;
            }
            if (hostapdLine.endsWith("=")) {
                ++i;
                continue;
            }
            if (hostapdLine.startsWith("interface=")) {
                settings.setSapAdapterName(hostapdLine.split("=")[1]);
                ++i;
                continue;
            }
            if (hostapdLine.startsWith("ssid=")) {
                settings.setSapSsid(hostapdLine.split("=")[1]);
                ++i;
                continue;
            }
            if (hostapdLine.startsWith("ignore_broadcast_ssid=")) {
                String rhs = hostapdLine.split("=")[1];
                if (rhs.equals("1")) {
                    settings.setIgnoreBroadcastSsid(1);
                }
                if (rhs.equals("2")) {
                    settings.setIgnoreBroadcastSsid(2);
                }
                ++i;
                continue;
            }
            if (hostapdLine.startsWith("wpa_psk=")) {
                settings.setSapWpaPsk(hostapdLine.split("=")[1]);
                ++i;
                continue;
            }
            if (hostapdLine.startsWith("wpa_passphrase=")) {
                settings.setSapWpaPassphrase(hostapdLine.split("=")[1]);
                ++i;
                continue;
            }
            if (hostapdLine.startsWith("channel=")) {
                settings.setSapChannel(Integer.parseInt(hostapdLine.split("=")[1]));
                ++i;
                continue;
            }
            if (hostapdLine.startsWith("hw_mode=")) {
                hw_mode_str = hostapdLine.split("=")[1].trim();
                ++i;
                continue;
            }
            if (hostapdLine.startsWith("wpa=")) {
                settings.setSapWpa(Integer.parseInt(hostapdLine.split("=")[1]));
                ++i;
                continue;
            }
            if (hostapdLine.startsWith("wpa_key_mgmt=")) {
                String tag = hostapdLine.split("=")[1];
                if (tag.equals("WPA-PSK")) {
                    settings.setSapWpaKeyMgmt("wpaPsk");
                } else if (tag.equals("WPA-EAP")) {
                    settings.setSapWpaKeyMgmt("wpaEap");
                } else {
                    settings.setSapWpaKeyMgmt("wpaPsk_wpaEap");
                }
                ++i;
                continue;
            }
            if (hostapdLine.startsWith("wpa_pairwise=")) {
                settings.setSapWpaPairwise(hostapdLine.split("=")[1]);
                ++i;
                continue;
            }
            if (hostapdLine.startsWith("country+code=")) {
                settings.setCountryCode(hostapdLine.split("=")[1]);
                ++i;
                continue;
            }
            if (hostapdLine.startsWith("macaddr_acl=")) {
                settings.setUseWhitelist(hostapdLine.equals("macaddr_acl=1"));
                ++i;
                continue;
            }
            if (hostapdLine.startsWith("ht_capab=")) {
                boolean ht40;
                boolean ht20 = hostapdLine.contains("[HT20]");
                if (ht20 & (ht40 = hostapdLine.contains("[HT40-]"))) {
                    settings.setSapHtCapab(BHtCapabilityEnum.ht20ht40);
                } else if (ht40) {
                    settings.setSapHtCapab(BHtCapabilityEnum.ht40);
                } else {
                    settings.setSapHtCapab(BHtCapabilityEnum.ht20);
                }
                ++i;
                continue;
            }
            if (hostapdLine.startsWith("ieee80211n=0")) {
                ieee80211n = false;
            }
            if (hostapdLine.startsWith("ieee80211n=1")) {
                ieee80211n = true;
            }
            ++i;
        }
        if (ieee80211n) {
            settings.setSapHwMode(BHapdHwModeEnum.ieee802_11n);
            if (hw_mode_str.equalsIgnoreCase("a")) {
                if (settings.getSapChannel() >= 184) {
                    settings.setSapFreqBand(BWifiFreqBandEnum.band49);
                } else {
                    settings.setSapFreqBand(BWifiFreqBandEnum.band50);
                }
            } else {
                settings.setSapFreqBand(BWifiFreqBandEnum.band24);
            }
        } else if (hw_mode_str.equalsIgnoreCase("a")) {
            settings.setSapHwMode(BHapdHwModeEnum.ieee802_11a);
            if (settings.getSapChannel() >= 184) {
                settings.setSapFreqBand(BWifiFreqBandEnum.band49);
            } else {
                settings.setSapFreqBand(BWifiFreqBandEnum.band50);
            }
        } else if (hw_mode_str.equalsIgnoreCase("b")) {
            settings.setSapHwMode(BHapdHwModeEnum.ieee802_11b);
            settings.setSapFreqBand(BWifiFreqBandEnum.band24);
        } else {
            settings.setSapHwMode(BHapdHwModeEnum.ieee802_11g);
            settings.setSapFreqBand(BWifiFreqBandEnum.band24);
        }
    }

    public static void wifiNetCfgToSettings(BWifiSettings settings, InputStream in) throws Exception {
        String[] sections;
        String[] netcfgLines = FileUtil.readLines((Reader)new InputStreamReader(in));
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < netcfgLines.length; ++i) {
            sb.append(netcfgLines[i]).append("\n");
        }
        String netCfgFile = sb.toString();
        for (String section : sections = netCfgFile.split("\\[\\S+\\]")) {
            String[] lines;
            if (section.indexOf("tiw_sap0") <= 0) continue;
            for (String line : lines = section.split("\n")) {
                if (line.startsWith("manual_ip")) {
                    settings.setSapAdapterIp(line.split(" ")[1]);
                }
                if (line.startsWith("manual_netmask")) {
                    settings.setSapAdapterNetmask(line.split(" ")[1]);
                }
                if (!line.equalsIgnoreCase("mode auto")) continue;
                settings.setSapAdapterIp(line.split(" ")[1]);
                settings.setSapAdapterNetmask(line.split(" ")[1]);
            }
        }
    }

    public static void netCfgFromSession(BWifiSettings settings, BDaemonSession session) throws Exception {
        FilePath netCfgFilePath = new FilePath(ENET_CFG_FILE_PATH);
        String netCfgFile = "";
        try (InputStream in = session.getInputStream((DaemonMessage)new GetFileMessage(netCfgFilePath, (BDaemonFileSpace)session.getFileSpace()));){
            String[] sections;
            netCfgFile = FileUtil.readString((Reader)new InputStreamReader(in));
            for (String section : sections = netCfgFile.split("\\[\\S+\\]")) {
                String[] lines;
                if (section.indexOf("osname dm0") > 0) {
                    for (String line : lines = section.split("\n")) {
                        if (line.startsWith("manual_ip")) {
                            settings.setEn0AdapterIp(line.split(" ")[1]);
                        }
                        if (line.startsWith("manual_netmask")) {
                            settings.setEn0AdapterNetmask(line.split(" ")[1]);
                        }
                        if (!line.equalsIgnoreCase("mode auto")) continue;
                        settings.setEn0AdapterIp(line.split(" ")[1]);
                        settings.setEn0AdapterNetmask(line.split(" ")[1]);
                    }
                }
                if (section.indexOf("osname dm1") <= 0) continue;
                for (String line : lines = section.split("\n")) {
                    if (line.startsWith("manual_ip")) {
                        settings.setEn1AdapterIp(line.split(" ")[1]);
                    }
                    if (line.startsWith("manual_netmask")) {
                        settings.setEn1AdapterNetmask(line.split(" ")[1]);
                    }
                    if (!line.equalsIgnoreCase("mode auto")) continue;
                    settings.setEn1AdapterIp(line.split(" ")[1]);
                    settings.setEn1AdapterNetmask(line.split(" ")[1]);
                }
            }
        }
    }

    public static void dhcpdConfToSettings(BDhcpdHostSettings dhcpdHostSettings, InputStream in) throws Exception {
        String[] dhcpdLines = FileUtil.readLines((Reader)new InputStreamReader(in));
        BDhcpdAdapterSettings dhcpSettings = (BDhcpdAdapterSettings)dhcpdHostSettings.getDhcpdSubnets().get("tiw_sap0");
        for (int i = 0; i < dhcpdLines.length; ++i) {
            String intStr;
            String tmpStr;
            String line = dhcpdLines[i].trim();
            if (line.startsWith("default-lease-time") && line.endsWith(";")) {
                tmpStr = line.substring(0, line.indexOf(";"));
                intStr = tmpStr.split(" ")[1];
                dhcpSettings.setDefaultLeaseTime(BRelTime.makeSeconds((int)Integer.parseInt(intStr)));
            }
            if (line.startsWith("max-lease-time")) {
                tmpStr = line.substring(0, line.indexOf(";"));
                intStr = tmpStr.split(" ")[1];
                dhcpSettings.setMaxLeaseTime(BRelTime.makeSeconds((int)Integer.parseInt(intStr)));
            }
            if (!line.startsWith("subnet ") || !line.endsWith("{")) continue;
            i = DhcpdUtil.stringToDhcpdSettingsDhcpdSubnet((BDhcpdAdapterSettings)dhcpSettings, (String[])dhcpdLines, (String)line, (int)i);
            ++i;
        }
    }

    public static String settingsToWifiNetcfg(BWifiSettings settings) {
        boolean sectionStart = false;
        StringBuilder newNetCfg = new StringBuilder();
        newNetCfg.append("[en2]\n").append("type wifi\n").append("osname tiw_sta0\n").append("mode dhcp\n").append("mode6 auto\n").append("\n").append("[en3]\n").append("type wifi\n").append("osname tiw_sap0\n").append("mode manual\n").append("manual_ip ").append(settings.getSapAdapterIp()).append("\n").append("manual_netmask ").append(settings.getSapAdapterNetmask()).append("\n").append("mode6 auto\n").append("\n");
        return newNetCfg.toString();
    }

    public static void whitelistToSettings(BWifiMacAddressVector macAddressVector, InputStream in) throws Exception {
        macAddressVector.removeAll();
        String[] whitelistLines = FileUtil.readLines((Reader)new InputStreamReader(in));
        for (int i = 0; i < whitelistLines.length; ++i) {
            macAddressVector.add("mac" + i, (BValue)new BWifiMacAddress(whitelistLines[i].trim()));
        }
    }

    private static void writeLineUnquoted(StringBuilder wpaSupplicantContents, String key, String value) {
        wpaSupplicantContents.append("\t").append(key).append("=").append(value).append("\n");
    }

    private static void writeLineQuoted(StringBuilder wpaSupplicantContents, String key, String value) {
        wpaSupplicantContents.append("\t").append(key).append("=\"").append(value).append("\"\n");
    }

    private static String unquote(String value) {
        return TextUtil.replace((String)value, (String)"\"", (String)"");
    }
}

