/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi;

import com.tridium.platform.BPlatformService;
import com.tridium.platwifi.BSupplicantNetBlock;
import com.tridium.platwifi.BSupplicantNetBlockVector;
import com.tridium.platwifi.BWifiNetwork;
import com.tridium.platwifi.BWifiNetworkVector;
import com.tridium.platwifi.BWifiSettings;
import com.tridium.platwifi.WifiPlatformLibrary;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="settings", type="BWifiSettings", defaultValue="new BWifiSettings()", flags=3)
@NiagaraAction(name="discoverNetworks", parameterType="BString", defaultValue="BString.make(\"Enter wireless adapter\")", returnType="BWifiNetworkVector", flags=4)
public class BWifiPlatformService
extends BPlatformService {
    @Generated
    public static final Property settings = BWifiPlatformService.newProperty((int)3, (BValue)new BWifiSettings(), null);
    @Generated
    public static final Action discoverNetworks = BWifiPlatformService.newAction((int)4, (BValue)BString.make((String)"Enter wireless adapter"), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWifiPlatformService.class);
    private static final BIcon icon = BIcon.std((String)"wireless.png");
    private final boolean refreshRequired = true;
    protected static final Logger log = Logger.getLogger("wifi.service");

    @Generated
    public BWifiSettings getSettings() {
        return (BWifiSettings)this.get(settings);
    }

    @Generated
    public void setSettings(BWifiSettings v) {
        this.set(settings, (BValue)v, null);
    }

    @Generated
    public BWifiNetworkVector discoverNetworks(BString parameter) {
        return (BWifiNetworkVector)this.invoke(discoverNetworks, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWifiPlatformService() {
        this.setPlatformServiceDescription(this.getLexicon().getText("WifiPlatformService.description"));
    }

    public BRelTime getPollFrequency() {
        return BRelTime.makeSeconds((int)5);
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        log.fine("wifi service started");
    }

    public void serviceStopped() throws Exception {
        super.serviceStopped();
        if (!WifiPlatformLibrary.load()) {
            return;
        }
        BWifiPlatformService.unloadWifiSettings0();
        log.fine("wifi service stopped");
    }

    protected boolean startPollTimerOnSubscribe() {
        return true;
    }

    public boolean isValidPlatform() {
        return false;
    }

    public int getSlotFlags() {
        return 0;
    }

    public void doSavePlatformServiceProperties() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        if (!WifiPlatformLibrary.load()) {
            return;
        }
        super.doSavePlatformServiceProperties();
        String staAdapter = this.getSettings().getStaAdapterName();
        BSupplicantNetBlockVector networkDatabase = this.getSettings().getSupplicantNetworkBlocks();
        SlotCursor c = networkDatabase.loadSlots().getProperties();
        while (c.next(BWifiNetwork.class)) {
            BSupplicantNetBlock netBlock = (BSupplicantNetBlock)c.get();
            BWifiPlatformService.setSsidBroadcasted0(staAdapter, netBlock.getSsid(), netBlock.getScan_ssid() == 0);
            BWifiPlatformService.setPriority0(staAdapter, netBlock.getSsid(), netBlock.getPriority());
            BWifiPlatformService.setPreSharedKey0(staAdapter, netBlock.getSsid(), netBlock.getPsk());
        }
        BWifiPlatformService.saveHostSettings0();
        log.fine("wifi network settings saved");
    }

    public void loadPlatformServiceProperties() {
        super.loadPlatformServiceProperties();
        if (!WifiPlatformLibrary.load()) {
            return;
        }
        this.refreshProperties();
    }

    protected synchronized void refreshProperties() {
    }

    public void doPoll(Context cx) {
        if (!this.isRunning()) {
            return;
        }
        super.doPoll(cx);
        this.refreshProperties();
    }

    public BWifiNetworkVector doDiscoverNetworks(BString adapter) {
        if (!WifiPlatformLibrary.load()) {
            return null;
        }
        String[] newNetworks = BWifiPlatformService.discoverNetworks0(adapter.toString());
        BWifiNetworkVector resultVector = new BWifiNetworkVector();
        if (newNetworks != null) {
            for (String newNetwork : newNetworks) {
                BWifiNetwork temp = BWifiNetwork.makeNetwork(newNetwork);
                if (temp.getSsid() == null || temp.getSsid().length() == 0) continue;
                try {
                    resultVector.add(SlotPath.escape((String)temp.getSsid()), (BValue)temp, 3, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiNetworkEditor")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        log.fine("discovered " + resultVector.getSlotCount() + " 802.11 networks");
        return resultVector;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public boolean hasNavChildren() {
        return false;
    }

    public BIcon getIcon() {
        return icon;
    }

    private static native String[] discoverNetworks0(String var0);

    private static native boolean connectToNetwork0(String var0, String var1);

    private static native boolean disconnectFromNetwork0(String var0, String var1);

    private static native boolean saveHostSettings0();

    private static native boolean unloadWifiSettings0();

    private static native String[] getWifiAdapters0();

    private static native boolean isWifiEnabled0(String var0);

    private static native int getDaemonStatus0(String var0);

    private static native int getNetworkStatus0(String var0, String var1);

    private static native String getCurrentNetwork0(String var0);

    private static native String[] getNetworkDatabaseSsids0(String var0);

    private static native String getBssid0(String var0, String var1);

    private static native boolean getSsidBroadcasted0(String var0, String var1);

    private static native int getStrength0(String var0, String var1);

    private static native int getPriority0(String var0, String var1);

    private static native int getChannel0(String var0, String var1);

    private static native int getNetworkMode0(String var0, String var1);

    private static native int getProtocol0(String var0, String var1);

    private static native int getKeyManagement0(String var0, String var1);

    private static native int getAuthentication0(String var0, String var1);

    private static native int getSupportedEncryptionMethods0(String var0, String var1);

    private static native String getPreSharedKey0(String var0, String var1);

    private static native boolean setEncryption0(String var0, String var1, int var2);

    private static native boolean setAuthentication0(String var0, String var1, int var2);

    private static native boolean setKeyManagement0(String var0, String var1, int var2);

    private static native boolean setProtocol0(String var0, String var1, int var2);

    private static native boolean setPreferredBssid0(String var0, String var1, String var2);

    private static native boolean setSsidBroadcasted0(String var0, String var1, boolean var2);

    private static native boolean setSignalStrength0(String var0, String var1, int var2);

    private static native boolean setPriority0(String var0, String var1, int var2);

    private static native boolean setNetworkStatus0(String var0, String var1, int var2);

    private static native boolean setNetworkMode0(String var0, String var1, int var2);

    private static native boolean setPreSharedKey0(String var0, String var1, String var2);
}

