/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi;

import com.tridium.platwifi.BWifiNetworkMode;
import com.tridium.platwifi.security.BWifiSecurityPolicy;
import com.tridium.platwifi.security.BWifiWPAPSKSettings;
import com.tridium.platwifi.status.BWifiNetworkStateEnum;
import java.util.StringTokenizer;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="bssid", type="String", defaultValue="00:00:00:00:00:00", flags=1), @NiagaraProperty(name="ssid", type="String", defaultValue="New_Wireless_Network", flags=1), @NiagaraProperty(name="ssidBroadcasted", type="boolean", defaultValue="true", flags=1), @NiagaraProperty(name="priority", type="int", defaultValue="1", flags=1, facets={@Facet(value="BFacets.make(new String[] { BFacets.MIN, BFacets.MAX, BFacets.FIELD_WIDTH }, new BIDataValue[] { BInteger.make(1), BInteger.make(10), BInteger.make(3) })")}), @NiagaraProperty(name="scanResultFlags", type="String", defaultValue="", flags=3), @NiagaraProperty(name="mode", type="BWifiNetworkMode", defaultValue="BWifiNetworkMode.managed", flags=1), @NiagaraProperty(name="frequency", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="channel", type="int", defaultValue="0", flags=3, facets={@Facet(value="BFacets.make(new String[] { BFacets.MIN, BFacets.MAX, BFacets.FIELD_WIDTH }, new BIDataValue[] { BInteger.make(1), BInteger.make(11), BInteger.make(3) })")}), @NiagaraProperty(name="protocols", type="String", defaultValue="WPA RSN", flags=1), @NiagaraProperty(name="securityPolicies", type="BWifiSecurityPolicy", defaultValue="BWifiSecurityPolicy.DEFAULT", flags=1), @NiagaraProperty(name="securitySettings", type="BWifiWPAPSKSettings", defaultValue="new BWifiWPAPSKSettings()", flags=1), @NiagaraProperty(name="networkState", type="BWifiNetworkStateEnum", defaultValue="BWifiNetworkStateEnum.unknown", flags=3), @NiagaraProperty(name="signalStrength", type="int", defaultValue="0", flags=3, facets={@Facet(value="BFacets.make(new String[] { BFacets.MIN, BFacets.MAX, BFacets.FIELD_WIDTH, BFacets.UNITS }, new BIDataValue[] { BInteger.make(0), BInteger.make(100), BInteger.make(3), BUnit.getUnit(\"percent\") })")})})
public class BWifiNetwork
extends BComponent {
    @Generated
    public static final Property bssid = BWifiNetwork.newProperty((int)1, (String)"00:00:00:00:00:00", null);
    @Generated
    public static final Property ssid = BWifiNetwork.newProperty((int)1, (String)"New_Wireless_Network", null);
    @Generated
    public static final Property ssidBroadcasted = BWifiNetwork.newProperty((int)1, (boolean)true, null);
    @Generated
    public static final Property priority = BWifiNetwork.newProperty((int)1, (int)1, (BFacets)BFacets.make((String[])new String[]{"min", "max", "fieldWidth"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)1), BInteger.make((int)10), BInteger.make((int)3)}));
    @Generated
    public static final Property scanResultFlags = BWifiNetwork.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property mode = BWifiNetwork.newProperty((int)1, (BValue)BWifiNetworkMode.managed, null);
    @Generated
    public static final Property frequency = BWifiNetwork.newProperty((int)3, (int)0, null);
    @Generated
    public static final Property channel = BWifiNetwork.newProperty((int)3, (int)0, (BFacets)BFacets.make((String[])new String[]{"min", "max", "fieldWidth"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)1), BInteger.make((int)11), BInteger.make((int)3)}));
    @Generated
    public static final Property protocols = BWifiNetwork.newProperty((int)1, (String)"WPA RSN", null);
    @Generated
    public static final Property securityPolicies = BWifiNetwork.newProperty((int)1, (BValue)BWifiSecurityPolicy.DEFAULT, null);
    @Generated
    public static final Property securitySettings = BWifiNetwork.newProperty((int)1, (BValue)new BWifiWPAPSKSettings(), null);
    @Generated
    public static final Property networkState = BWifiNetwork.newProperty((int)3, (BValue)BWifiNetworkStateEnum.unknown, null);
    @Generated
    public static final Property signalStrength = BWifiNetwork.newProperty((int)3, (int)0, (BFacets)BFacets.make((String[])new String[]{"min", "max", "fieldWidth", "units"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)0), BInteger.make((int)100), BInteger.make((int)3), BUnit.getUnit((String)"percent")}));
    @Generated
    public static final Type TYPE = Sys.loadType(BWifiNetwork.class);

    @Generated
    public String getBssid() {
        return this.getString(bssid);
    }

    @Generated
    public void setBssid(String v) {
        this.setString(bssid, v, null);
    }

    @Generated
    public String getSsid() {
        return this.getString(ssid);
    }

    @Generated
    public void setSsid(String v) {
        this.setString(ssid, v, null);
    }

    @Generated
    public boolean getSsidBroadcasted() {
        return this.getBoolean(ssidBroadcasted);
    }

    @Generated
    public void setSsidBroadcasted(boolean v) {
        this.setBoolean(ssidBroadcasted, v, null);
    }

    @Generated
    public int getPriority() {
        return this.getInt(priority);
    }

    @Generated
    public void setPriority(int v) {
        this.setInt(priority, v, null);
    }

    @Generated
    public String getScanResultFlags() {
        return this.getString(scanResultFlags);
    }

    @Generated
    public void setScanResultFlags(String v) {
        this.setString(scanResultFlags, v, null);
    }

    @Generated
    public BWifiNetworkMode getMode() {
        return (BWifiNetworkMode)this.get(mode);
    }

    @Generated
    public void setMode(BWifiNetworkMode v) {
        this.set(mode, (BValue)v, null);
    }

    @Generated
    public int getFrequency() {
        return this.getInt(frequency);
    }

    @Generated
    public void setFrequency(int v) {
        this.setInt(frequency, v, null);
    }

    @Generated
    public int getChannel() {
        return this.getInt(channel);
    }

    @Generated
    public void setChannel(int v) {
        this.setInt(channel, v, null);
    }

    @Generated
    public String getProtocols() {
        return this.getString(protocols);
    }

    @Generated
    public void setProtocols(String v) {
        this.setString(protocols, v, null);
    }

    @Generated
    public BWifiSecurityPolicy getSecurityPolicies() {
        return (BWifiSecurityPolicy)this.get(securityPolicies);
    }

    @Generated
    public void setSecurityPolicies(BWifiSecurityPolicy v) {
        this.set(securityPolicies, (BValue)v, null);
    }

    @Generated
    public BWifiWPAPSKSettings getSecuritySettings() {
        return (BWifiWPAPSKSettings)this.get(securitySettings);
    }

    @Generated
    public void setSecuritySettings(BWifiWPAPSKSettings v) {
        this.set(securitySettings, (BValue)v, null);
    }

    @Generated
    public BWifiNetworkStateEnum getNetworkState() {
        return (BWifiNetworkStateEnum)this.get(networkState);
    }

    @Generated
    public void setNetworkState(BWifiNetworkStateEnum v) {
        this.set(networkState, (BValue)v, null);
    }

    @Generated
    public int getSignalStrength() {
        return this.getInt(signalStrength);
    }

    @Generated
    public void setSignalStrength(int v) {
        this.setInt(signalStrength, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWifiNetwork() {
    }

    private BWifiNetwork(String networkAsString) {
        this.updateNetworkFromScanResultsLine(networkAsString);
    }

    public static BWifiNetwork makeNetwork(String networkAsString) {
        return new BWifiNetwork(networkAsString);
    }

    public void updateNetworkFromScanResultsLine(String scanResultsLine) {
        StringTokenizer tokenizer = new StringTokenizer(scanResultsLine);
        this.setBssid(tokenizer.nextToken());
        int freq = Integer.valueOf(tokenizer.nextToken());
        this.setFrequency(freq);
        switch (freq) {
            case 2412: {
                this.setChannel(1);
                break;
            }
            case 2417: {
                this.setChannel(2);
                break;
            }
            case 2422: {
                this.setChannel(3);
                break;
            }
            case 2427: {
                this.setChannel(4);
                break;
            }
            case 2432: {
                this.setChannel(5);
                break;
            }
            case 2437: {
                this.setChannel(6);
                break;
            }
            case 2442: {
                this.setChannel(7);
                break;
            }
            case 2447: {
                this.setChannel(8);
                break;
            }
            case 2452: {
                this.setChannel(9);
                break;
            }
            case 2457: {
                this.setChannel(10);
                break;
            }
            case 2462: {
                this.setChannel(11);
                break;
            }
            case 2467: {
                this.setChannel(12);
                break;
            }
            case 2472: {
                this.setChannel(13);
                break;
            }
            case 2484: {
                this.setChannel(14);
                break;
            }
            case 4915: {
                this.setChannel(183);
                break;
            }
            case 4920: {
                this.setChannel(184);
                break;
            }
            case 4925: {
                this.setChannel(185);
                break;
            }
            case 4935: {
                this.setChannel(187);
                break;
            }
            case 4940: {
                this.setChannel(188);
                break;
            }
            case 4945: {
                this.setChannel(189);
                break;
            }
            case 4960: {
                this.setChannel(192);
                break;
            }
            case 4980: {
                this.setChannel(196);
                break;
            }
            case 5035: {
                this.setChannel(7);
                break;
            }
            case 5040: {
                this.setChannel(8);
                break;
            }
            case 5045: {
                this.setChannel(9);
                break;
            }
            case 5055: {
                this.setChannel(11);
                break;
            }
            case 5170: {
                this.setChannel(34);
                break;
            }
            case 5180: {
                this.setChannel(36);
                break;
            }
            case 5190: {
                this.setChannel(38);
                break;
            }
            case 5200: {
                this.setChannel(40);
                break;
            }
            case 5210: {
                this.setChannel(42);
                break;
            }
            case 5220: {
                this.setChannel(44);
                break;
            }
            case 5230: {
                this.setChannel(46);
                break;
            }
            case 5240: {
                this.setChannel(48);
                break;
            }
            case 5260: {
                this.setChannel(52);
                break;
            }
            case 5280: {
                this.setChannel(56);
                break;
            }
            case 5300: {
                this.setChannel(60);
                break;
            }
            case 5320: {
                this.setChannel(64);
                break;
            }
            case 5500: {
                this.setChannel(100);
                break;
            }
            case 5520: {
                this.setChannel(104);
                break;
            }
            case 5540: {
                this.setChannel(108);
                break;
            }
            case 5560: {
                this.setChannel(112);
                break;
            }
            case 5580: {
                this.setChannel(116);
                break;
            }
            case 5600: {
                this.setChannel(120);
                break;
            }
            case 5620: {
                this.setChannel(124);
                break;
            }
            case 5640: {
                this.setChannel(128);
                break;
            }
            case 5660: {
                this.setChannel(132);
                break;
            }
            case 5680: {
                this.setChannel(136);
                break;
            }
            case 5700: {
                this.setChannel(140);
                break;
            }
            case 5745: {
                this.setChannel(149);
                break;
            }
            case 5765: {
                this.setChannel(153);
                break;
            }
            case 5785: {
                this.setChannel(157);
                break;
            }
            case 5805: {
                this.setChannel(161);
                break;
            }
            case 5825: {
                this.setChannel(165);
                break;
            }
            default: {
                this.setChannel(0);
            }
        }
        double RSSI = Double.valueOf(tokenizer.nextToken());
        int signalQuality = RSSI < 0.0 ? (RSSI <= -100.0 ? 0 : (RSSI >= -50.0 ? 100 : (int)(2.0 * (RSSI + 100.0)))) : ((RSSI -= 160.0) > 210.0 ? 100 : (RSSI < 160.0 ? 0 : (int)(2.0 * RSSI - 160.0)));
        this.setSignalStrength(signalQuality);
        boolean disableNetwork = true;
        String nextToken = null;
        if (tokenizer.hasMoreElements()) {
            nextToken = tokenizer.nextToken();
        }
        if (nextToken != null && nextToken.indexOf(91) != -1 && nextToken.indexOf(93) != -1) {
            this.setScanResultFlags(nextToken);
            if (nextToken.contains("[WPA-PSK") && nextToken.contains("[WPA2-PSK")) {
                this.setProtocols("WPA RSN");
                this.setSecurityPolicies(BWifiSecurityPolicy.wpapsk_wpa2psk);
                disableNetwork = false;
            } else if (nextToken.contains("[WPA-PSK")) {
                this.setProtocols("WPA");
                this.setSecurityPolicies(BWifiSecurityPolicy.wpa_psk);
                disableNetwork = false;
            } else if (nextToken.contains("[WPA2-PSK")) {
                this.setProtocols("RSN");
                this.setSecurityPolicies(BWifiSecurityPolicy.wpa_2_psk);
                disableNetwork = false;
            } else if (nextToken.contains("[WPA2-EAP")) {
                this.setProtocols("");
                this.setSecurityPolicies(BWifiSecurityPolicy.unsupported);
            } else {
                this.setProtocols("");
                this.setSecurityPolicies(BWifiSecurityPolicy.none);
            }
        }
        if (tokenizer.hasMoreElements()) {
            nextToken = tokenizer.nextToken();
            StringBuilder buffer = new StringBuilder(nextToken);
            while (tokenizer.hasMoreTokens()) {
                buffer.append(" ").append(tokenizer.nextToken());
            }
            this.setSsid(buffer.toString());
            this.setSsidBroadcasted(!buffer.toString().startsWith("\\x00"));
        } else {
            this.setSsid("hidden");
            this.setSsidBroadcasted(false);
        }
        BWifiNetworkStateEnum status = disableNetwork ? BWifiNetworkStateEnum.disabled : BWifiNetworkStateEnum.disconnected;
        this.setNetworkState(status);
    }

    public boolean isNetworkSupported() {
        return this.getSecurityPolicies().getOrdinal() == 6 || this.getSecurityPolicies().getOrdinal() == 5 || this.getSecurityPolicies().getOrdinal() == 3;
    }
}

